// Code generated by execgen; DO NOT EDIT.
// Copyright 2019 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexec

import (
	"context"

	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/sql/colexec/colexecutils"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecop"
	"github.com/cockroachdb/cockroach/pkg/sql/colmem"
	"github.com/cockroachdb/cockroach/pkg/sql/execinfra/execopnode"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/errors"
)

func NewAndProjOp(
	allocator *colmem.Allocator,
	input, leftProjOpChain, rightProjOpChain colexecop.Operator,
	leftFeedOp, rightFeedOp *colexecop.FeedOperator,
	leftInputType, rightInputType *types.T,
	leftIdx, rightIdx, outputIdx int,
) (colexecop.Operator, error) {
	leftFamily := leftInputType.Family()
	leftIsBool := leftFamily == types.BoolFamily
	leftIsNull := leftFamily == types.UnknownFamily
	rightFamily := rightInputType.Family()
	rightIsBool := rightFamily == types.BoolFamily
	rightIsNull := rightFamily == types.UnknownFamily
	if (!leftIsBool && !leftIsNull && !rightIsBool && !rightIsNull) ||
		(leftIsNull && rightIsNull) {
		// Either one of the families are neither Bool nor Unknown (which is
		// unexpected because the logical operations can be applied only to
		// bools or NULLs) or both families are Unknown (which is unexpected
		// because we assume that the optimizer is smart enough to reduce such
		// cases), so we return an assertion failure.
		return nil, errors.AssertionFailedf(
			"unexpected input families for And logical operation: %s, %s", leftFamily, rightFamily,
		)
	}
	if leftIsNull {
		return newAndLeftNullProjOp(
			allocator, input, leftProjOpChain, rightProjOpChain,
			leftFeedOp, rightFeedOp, leftIdx, rightIdx, outputIdx,
		), nil
	} else if rightIsNull {
		return newAndRightNullProjOp(
			allocator, input, leftProjOpChain, rightProjOpChain,
			leftFeedOp, rightFeedOp, leftIdx, rightIdx, outputIdx,
		), nil
	} else {
		return newAndProjOp(
			allocator, input, leftProjOpChain, rightProjOpChain,
			leftFeedOp, rightFeedOp, leftIdx, rightIdx, outputIdx,
		), nil
	}
}

func NewOrProjOp(
	allocator *colmem.Allocator,
	input, leftProjOpChain, rightProjOpChain colexecop.Operator,
	leftFeedOp, rightFeedOp *colexecop.FeedOperator,
	leftInputType, rightInputType *types.T,
	leftIdx, rightIdx, outputIdx int,
) (colexecop.Operator, error) {
	leftFamily := leftInputType.Family()
	leftIsBool := leftFamily == types.BoolFamily
	leftIsNull := leftFamily == types.UnknownFamily
	rightFamily := rightInputType.Family()
	rightIsBool := rightFamily == types.BoolFamily
	rightIsNull := rightFamily == types.UnknownFamily
	if (!leftIsBool && !leftIsNull && !rightIsBool && !rightIsNull) ||
		(leftIsNull && rightIsNull) {
		// Either one of the families are neither Bool nor Unknown (which is
		// unexpected because the logical operations can be applied only to
		// bools or NULLs) or both families are Unknown (which is unexpected
		// because we assume that the optimizer is smart enough to reduce such
		// cases), so we return an assertion failure.
		return nil, errors.AssertionFailedf(
			"unexpected input families for Or logical operation: %s, %s", leftFamily, rightFamily,
		)
	}
	if leftIsNull {
		return newOrLeftNullProjOp(
			allocator, input, leftProjOpChain, rightProjOpChain,
			leftFeedOp, rightFeedOp, leftIdx, rightIdx, outputIdx,
		), nil
	} else if rightIsNull {
		return newOrRightNullProjOp(
			allocator, input, leftProjOpChain, rightProjOpChain,
			leftFeedOp, rightFeedOp, leftIdx, rightIdx, outputIdx,
		), nil
	} else {
		return newOrProjOp(
			allocator, input, leftProjOpChain, rightProjOpChain,
			leftFeedOp, rightFeedOp, leftIdx, rightIdx, outputIdx,
		), nil
	}
}

type andProjOp struct {
	colexecop.InitHelper

	allocator *colmem.Allocator
	input     colexecop.Operator

	leftProjOpChain  colexecop.Operator
	rightProjOpChain colexecop.Operator
	leftFeedOp       *colexecop.FeedOperator
	rightFeedOp      *colexecop.FeedOperator

	leftIdx   int
	rightIdx  int
	outputIdx int

	// origSel is a buffer used to keep track of the original selection vector of
	// the input batch. We need to do this because we're going to modify the
	// selection vector in order to do the short-circuiting of logical operators.
	origSel []int
}

// newAndProjOp returns a new projection operator that logical-And's
// the boolean columns at leftIdx and rightIdx, returning the result in
// outputIdx.
func newAndProjOp(
	allocator *colmem.Allocator,
	input, leftProjOpChain, rightProjOpChain colexecop.Operator,
	leftFeedOp, rightFeedOp *colexecop.FeedOperator,
	leftIdx, rightIdx, outputIdx int,
) colexecop.Operator {
	return &andProjOp{
		allocator:        allocator,
		input:            input,
		leftProjOpChain:  leftProjOpChain,
		rightProjOpChain: rightProjOpChain,
		leftFeedOp:       leftFeedOp,
		rightFeedOp:      rightFeedOp,
		leftIdx:          leftIdx,
		rightIdx:         rightIdx,
		outputIdx:        outputIdx,
	}
}

func (o *andProjOp) ChildCount(verbose bool) int {
	return 3
}

func (o *andProjOp) Child(nth int, verbose bool) execopnode.OpNode {
	switch nth {
	case 0:
		return o.input
	case 1:
		return o.leftProjOpChain
	case 2:
		return o.rightProjOpChain
	default:
		colexecerror.InternalError(errors.AssertionFailedf("invalid idx %d", nth))
		// This code is unreachable, but the compiler cannot infer that.
		return nil
	}
}

// Init is part of the colexecop.Operator interface.
func (o *andProjOp) Init(ctx context.Context) {
	if !o.InitHelper.Init(ctx) {
		return
	}
	o.input.Init(o.Ctx)
	o.leftProjOpChain.Init(o.Ctx)
	o.rightProjOpChain.Init(o.Ctx)
}

// Next is part of the colexecop.Operator interface.
// The idea to handle the short-circuiting logic is similar to what caseOp
// does: a logical operator has an input and two projection chains. First,
// it runs the left chain on the input batch. Then, it "subtracts" the
// tuples for which we know the result of logical operation based only on
// the left side projection (e.g. if the left side is false and we're
// doing AND operation, then the result is also false) and runs the right
// side projection only on the remaining tuples (i.e. those that were not
// "subtracted"). Next, it restores the original selection vector and
// populates the result of the logical operation.
func (o *andProjOp) Next() coldata.Batch {
	batch := o.input.Next()
	origLen := batch.Length()
	if origLen == 0 {
		return coldata.ZeroBatch
	}
	usesSel := false
	if sel := batch.Selection(); sel != nil {
		o.origSel = colexecutils.EnsureSelectionVectorLength(o.origSel, origLen)
		copy(o.origSel, sel)
		usesSel = true
	}

	// In order to support the short-circuiting logic, we need to be quite tricky
	// here. First, we set the input batch for the left projection to run and
	// actually run the projection.
	o.leftFeedOp.SetBatch(batch)
	batch = o.leftProjOpChain.Next()

	// Now we need to populate a selection vector on the batch in such a way that
	// those tuples that we already know the result of logical operation for do
	// not get the projection for the right side.
	// knownResult indicates the boolean value which if present on the left side
	// fully determines the result of the logical operation.
	var (
		knownResult                   bool
		leftVec, rightVec             *coldata.Vec
		leftValIsNull, rightValIsNull bool
		leftVal, rightVal             bool
	)

	leftVec = batch.ColVec(o.leftIdx)
	var curIdx int
	leftVals := leftVec.Bool()
	if usesSel {
		sel := batch.Selection()
		origSel := o.origSel[:origLen]
		if leftVec.MaybeHasNulls() {
			leftNulls := leftVec.Nulls()
			for _, i := range origSel {
				leftValIsNull = leftNulls.NullAt(i)
				if leftValIsNull || leftVals[i] != knownResult {
					// We add the tuple into the selection vector if the left value is NULL or
					// it is different from knownResult.
					sel[curIdx] = i
					curIdx++
				}
			}
		} else {
			for _, i := range origSel {
				leftValIsNull = false
				if leftValIsNull || leftVals[i] != knownResult {
					// We add the tuple into the selection vector if the left value is NULL or
					// it is different from knownResult.
					sel[curIdx] = i
					curIdx++
				}
			}
		}
	} else {
		batch.SetSelection(true)
		sel := batch.Selection()
		if leftVec.MaybeHasNulls() {
			leftNulls := leftVec.Nulls()
			for i := 0; i < origLen; i++ {
				leftValIsNull = leftNulls.NullAt(i)
				if leftValIsNull || leftVals[i] != knownResult {
					// We add the tuple into the selection vector if the left value is NULL or
					// it is different from knownResult.
					sel[curIdx] = i
					curIdx++
				}
			}
		} else {
			for i := 0; i < origLen; i++ {
				leftValIsNull = false
				if leftValIsNull || leftVals[i] != knownResult {
					// We add the tuple into the selection vector if the left value is NULL or
					// it is different from knownResult.
					sel[curIdx] = i
					curIdx++
				}
			}
		}
	}

	var rightVals []bool
	if curIdx > 0 {
		// We only run the right-side projection if there are non-zero number of
		// remaining tuples.
		batch.SetLength(curIdx)
		o.rightFeedOp.SetBatch(batch)
		batch = o.rightProjOpChain.Next()
		rightVec = batch.ColVec(o.rightIdx)
		rightVals = rightVec.Bool()
	}

	// Now we need to restore the original selection vector and length.
	colexecutils.UpdateBatchState(batch, origLen, usesSel, o.origSel)

	outputCol := batch.ColVec(o.outputIdx)
	outputVals := outputCol.Bool()
	outputNulls := outputCol.Nulls()
	// This is where we populate the output - do the actual evaluation of the
	// logical operation.
	if leftVec.MaybeHasNulls() {
		leftNulls := leftVec.Nulls()
		if rightVec != nil && rightVec.MaybeHasNulls() {
			rightNulls := rightVec.Nulls()
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = leftNulls.NullAt(idx)
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = rightNulls.NullAt(idx)
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				_ = leftVals[origLen-1]
				if rightVals != nil {
					_ = rightVals[origLen-1]
				}
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = leftNulls.NullAt(idx)
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = rightNulls.NullAt(idx)
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = leftNulls.NullAt(idx)
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = false
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				_ = leftVals[origLen-1]
				if rightVals != nil {
					_ = rightVals[origLen-1]
				}
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = leftNulls.NullAt(idx)
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = false
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		}
	} else {
		if rightVec != nil && rightVec.MaybeHasNulls() {
			rightNulls := rightVec.Nulls()
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = false
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = rightNulls.NullAt(idx)
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				_ = leftVals[origLen-1]
				if rightVals != nil {
					_ = rightVals[origLen-1]
				}
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = false
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = rightNulls.NullAt(idx)
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = false
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = false
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				_ = leftVals[origLen-1]
				if rightVals != nil {
					_ = rightVals[origLen-1]
				}
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = false
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = false
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		}
	}

	return batch
}

type andRightNullProjOp struct {
	colexecop.InitHelper

	allocator *colmem.Allocator
	input     colexecop.Operator

	leftProjOpChain  colexecop.Operator
	rightProjOpChain colexecop.Operator
	leftFeedOp       *colexecop.FeedOperator
	rightFeedOp      *colexecop.FeedOperator

	leftIdx   int
	rightIdx  int
	outputIdx int

	// origSel is a buffer used to keep track of the original selection vector of
	// the input batch. We need to do this because we're going to modify the
	// selection vector in order to do the short-circuiting of logical operators.
	origSel []int
}

// newAndRightNullProjOp returns a new projection operator that logical-AndRightNull's
// the boolean columns at leftIdx and rightIdx, returning the result in
// outputIdx.
func newAndRightNullProjOp(
	allocator *colmem.Allocator,
	input, leftProjOpChain, rightProjOpChain colexecop.Operator,
	leftFeedOp, rightFeedOp *colexecop.FeedOperator,
	leftIdx, rightIdx, outputIdx int,
) colexecop.Operator {
	return &andRightNullProjOp{
		allocator:        allocator,
		input:            input,
		leftProjOpChain:  leftProjOpChain,
		rightProjOpChain: rightProjOpChain,
		leftFeedOp:       leftFeedOp,
		rightFeedOp:      rightFeedOp,
		leftIdx:          leftIdx,
		rightIdx:         rightIdx,
		outputIdx:        outputIdx,
	}
}

func (o *andRightNullProjOp) ChildCount(verbose bool) int {
	return 3
}

func (o *andRightNullProjOp) Child(nth int, verbose bool) execopnode.OpNode {
	switch nth {
	case 0:
		return o.input
	case 1:
		return o.leftProjOpChain
	case 2:
		return o.rightProjOpChain
	default:
		colexecerror.InternalError(errors.AssertionFailedf("invalid idx %d", nth))
		// This code is unreachable, but the compiler cannot infer that.
		return nil
	}
}

// Init is part of the colexecop.Operator interface.
func (o *andRightNullProjOp) Init(ctx context.Context) {
	if !o.InitHelper.Init(ctx) {
		return
	}
	o.input.Init(o.Ctx)
	o.leftProjOpChain.Init(o.Ctx)
	o.rightProjOpChain.Init(o.Ctx)
}

// Next is part of the colexecop.Operator interface.
// The idea to handle the short-circuiting logic is similar to what caseOp
// does: a logical operator has an input and two projection chains. First,
// it runs the left chain on the input batch. Then, it "subtracts" the
// tuples for which we know the result of logical operation based only on
// the left side projection (e.g. if the left side is false and we're
// doing AND operation, then the result is also false) and runs the right
// side projection only on the remaining tuples (i.e. those that were not
// "subtracted"). Next, it restores the original selection vector and
// populates the result of the logical operation.
func (o *andRightNullProjOp) Next() coldata.Batch {
	batch := o.input.Next()
	origLen := batch.Length()
	if origLen == 0 {
		return coldata.ZeroBatch
	}
	usesSel := false
	if sel := batch.Selection(); sel != nil {
		o.origSel = colexecutils.EnsureSelectionVectorLength(o.origSel, origLen)
		copy(o.origSel, sel)
		usesSel = true
	}

	// In order to support the short-circuiting logic, we need to be quite tricky
	// here. First, we set the input batch for the left projection to run and
	// actually run the projection.
	o.leftFeedOp.SetBatch(batch)
	batch = o.leftProjOpChain.Next()

	// Now we need to populate a selection vector on the batch in such a way that
	// those tuples that we already know the result of logical operation for do
	// not get the projection for the right side.
	// knownResult indicates the boolean value which if present on the left side
	// fully determines the result of the logical operation.
	var (
		knownResult                   bool
		leftVec, rightVec             *coldata.Vec
		leftValIsNull, rightValIsNull bool
		leftVal, rightVal             bool
	)

	leftVec = batch.ColVec(o.leftIdx)
	var curIdx int
	leftVals := leftVec.Bool()
	if usesSel {
		sel := batch.Selection()
		origSel := o.origSel[:origLen]
		if leftVec.MaybeHasNulls() {
			leftNulls := leftVec.Nulls()
			for _, i := range origSel {
				leftValIsNull = leftNulls.NullAt(i)
				if leftValIsNull || leftVals[i] != knownResult {
					// We add the tuple into the selection vector if the left value is NULL or
					// it is different from knownResult.
					sel[curIdx] = i
					curIdx++
				}
			}
		} else {
			for _, i := range origSel {
				leftValIsNull = false
				if leftValIsNull || leftVals[i] != knownResult {
					// We add the tuple into the selection vector if the left value is NULL or
					// it is different from knownResult.
					sel[curIdx] = i
					curIdx++
				}
			}
		}
	} else {
		batch.SetSelection(true)
		sel := batch.Selection()
		if leftVec.MaybeHasNulls() {
			leftNulls := leftVec.Nulls()
			for i := 0; i < origLen; i++ {
				leftValIsNull = leftNulls.NullAt(i)
				if leftValIsNull || leftVals[i] != knownResult {
					// We add the tuple into the selection vector if the left value is NULL or
					// it is different from knownResult.
					sel[curIdx] = i
					curIdx++
				}
			}
		} else {
			for i := 0; i < origLen; i++ {
				leftValIsNull = false
				if leftValIsNull || leftVals[i] != knownResult {
					// We add the tuple into the selection vector if the left value is NULL or
					// it is different from knownResult.
					sel[curIdx] = i
					curIdx++
				}
			}
		}
	}

	// Now we need to restore the original selection vector and length.
	colexecutils.UpdateBatchState(batch, origLen, usesSel, o.origSel)

	outputCol := batch.ColVec(o.outputIdx)
	outputVals := outputCol.Bool()
	outputNulls := outputCol.Nulls()
	// This is where we populate the output - do the actual evaluation of the
	// logical operation.
	if leftVec.MaybeHasNulls() {
		leftNulls := leftVec.Nulls()
		if rightVec != nil && rightVec.MaybeHasNulls() {
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = leftNulls.NullAt(idx)
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = true
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				_ = leftVals[origLen-1]
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = leftNulls.NullAt(idx)
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = true
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = leftNulls.NullAt(idx)
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = true
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				_ = leftVals[origLen-1]
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = leftNulls.NullAt(idx)
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = true
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		}
	} else {
		if rightVec != nil && rightVec.MaybeHasNulls() {
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = false
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = true
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				_ = leftVals[origLen-1]
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = false
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = true
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = false
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = true
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				_ = leftVals[origLen-1]
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = false
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = true
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		}
	}

	return batch
}

type andLeftNullProjOp struct {
	colexecop.InitHelper

	allocator *colmem.Allocator
	input     colexecop.Operator

	leftProjOpChain  colexecop.Operator
	rightProjOpChain colexecop.Operator
	leftFeedOp       *colexecop.FeedOperator
	rightFeedOp      *colexecop.FeedOperator

	leftIdx   int
	rightIdx  int
	outputIdx int

	// origSel is a buffer used to keep track of the original selection vector of
	// the input batch. We need to do this because we're going to modify the
	// selection vector in order to do the short-circuiting of logical operators.
	origSel []int
}

// newAndLeftNullProjOp returns a new projection operator that logical-AndLeftNull's
// the boolean columns at leftIdx and rightIdx, returning the result in
// outputIdx.
func newAndLeftNullProjOp(
	allocator *colmem.Allocator,
	input, leftProjOpChain, rightProjOpChain colexecop.Operator,
	leftFeedOp, rightFeedOp *colexecop.FeedOperator,
	leftIdx, rightIdx, outputIdx int,
) colexecop.Operator {
	return &andLeftNullProjOp{
		allocator:        allocator,
		input:            input,
		leftProjOpChain:  leftProjOpChain,
		rightProjOpChain: rightProjOpChain,
		leftFeedOp:       leftFeedOp,
		rightFeedOp:      rightFeedOp,
		leftIdx:          leftIdx,
		rightIdx:         rightIdx,
		outputIdx:        outputIdx,
	}
}

func (o *andLeftNullProjOp) ChildCount(verbose bool) int {
	return 3
}

func (o *andLeftNullProjOp) Child(nth int, verbose bool) execopnode.OpNode {
	switch nth {
	case 0:
		return o.input
	case 1:
		return o.leftProjOpChain
	case 2:
		return o.rightProjOpChain
	default:
		colexecerror.InternalError(errors.AssertionFailedf("invalid idx %d", nth))
		// This code is unreachable, but the compiler cannot infer that.
		return nil
	}
}

// Init is part of the colexecop.Operator interface.
func (o *andLeftNullProjOp) Init(ctx context.Context) {
	if !o.InitHelper.Init(ctx) {
		return
	}
	o.input.Init(o.Ctx)
	o.leftProjOpChain.Init(o.Ctx)
	o.rightProjOpChain.Init(o.Ctx)
}

// Next is part of the colexecop.Operator interface.
// The idea to handle the short-circuiting logic is similar to what caseOp
// does: a logical operator has an input and two projection chains. First,
// it runs the left chain on the input batch. Then, it "subtracts" the
// tuples for which we know the result of logical operation based only on
// the left side projection (e.g. if the left side is false and we're
// doing AND operation, then the result is also false) and runs the right
// side projection only on the remaining tuples (i.e. those that were not
// "subtracted"). Next, it restores the original selection vector and
// populates the result of the logical operation.
func (o *andLeftNullProjOp) Next() coldata.Batch {
	batch := o.input.Next()
	origLen := batch.Length()
	if origLen == 0 {
		return coldata.ZeroBatch
	}
	usesSel := false
	if sel := batch.Selection(); sel != nil {
		o.origSel = colexecutils.EnsureSelectionVectorLength(o.origSel, origLen)
		copy(o.origSel, sel)
		usesSel = true
	}

	// In order to support the short-circuiting logic, we need to be quite tricky
	// here. First, we set the input batch for the left projection to run and
	// actually run the projection.
	o.leftFeedOp.SetBatch(batch)
	batch = o.leftProjOpChain.Next()

	// Now we need to populate a selection vector on the batch in such a way that
	// those tuples that we already know the result of logical operation for do
	// not get the projection for the right side.
	// knownResult indicates the boolean value which if present on the left side
	// fully determines the result of the logical operation.
	var (
		knownResult                   bool
		leftVec, rightVec             *coldata.Vec
		leftValIsNull, rightValIsNull bool
		leftVal, rightVal             bool
	)

	leftVec = batch.ColVec(o.leftIdx)
	var curIdx int
	// Left vector represents a constant NULL value, so we need to include
	// all of the tuples in the batch for the right side to be evaluated.
	if usesSel {
		sel := batch.Selection()
		copy(sel[:origLen], o.origSel[:origLen])
	} else {
		batch.SetSelection(true)
		sel := batch.Selection()
		for i := 0; i < origLen; i++ {
			sel[i] = i
		}
	}
	curIdx = origLen

	var rightVals []bool
	if curIdx > 0 {
		// We only run the right-side projection if there are non-zero number of
		// remaining tuples.
		batch.SetLength(curIdx)
		o.rightFeedOp.SetBatch(batch)
		batch = o.rightProjOpChain.Next()
		rightVec = batch.ColVec(o.rightIdx)
		rightVals = rightVec.Bool()
	}

	// Now we need to restore the original selection vector and length.
	colexecutils.UpdateBatchState(batch, origLen, usesSel, o.origSel)

	outputCol := batch.ColVec(o.outputIdx)
	outputVals := outputCol.Bool()
	outputNulls := outputCol.Nulls()
	// This is where we populate the output - do the actual evaluation of the
	// logical operation.
	if leftVec.MaybeHasNulls() {
		if rightVec != nil && rightVec.MaybeHasNulls() {
			rightNulls := rightVec.Nulls()
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = true
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = rightNulls.NullAt(idx)
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				if rightVals != nil {
					_ = rightVals[origLen-1]
				}
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = true
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = rightNulls.NullAt(idx)
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = true
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = false
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				if rightVals != nil {
					_ = rightVals[origLen-1]
				}
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = true
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = false
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		}
	} else {
		if rightVec != nil && rightVec.MaybeHasNulls() {
			rightNulls := rightVec.Nulls()
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = true
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = rightNulls.NullAt(idx)
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				if rightVals != nil {
					_ = rightVals[origLen-1]
				}
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = true
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = rightNulls.NullAt(idx)
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = true
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = false
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				if rightVals != nil {
					_ = rightVals[origLen-1]
				}
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = true
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = false
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		}
	}

	return batch
}

type orProjOp struct {
	colexecop.InitHelper

	allocator *colmem.Allocator
	input     colexecop.Operator

	leftProjOpChain  colexecop.Operator
	rightProjOpChain colexecop.Operator
	leftFeedOp       *colexecop.FeedOperator
	rightFeedOp      *colexecop.FeedOperator

	leftIdx   int
	rightIdx  int
	outputIdx int

	// origSel is a buffer used to keep track of the original selection vector of
	// the input batch. We need to do this because we're going to modify the
	// selection vector in order to do the short-circuiting of logical operators.
	origSel []int
}

// newOrProjOp returns a new projection operator that logical-Or's
// the boolean columns at leftIdx and rightIdx, returning the result in
// outputIdx.
func newOrProjOp(
	allocator *colmem.Allocator,
	input, leftProjOpChain, rightProjOpChain colexecop.Operator,
	leftFeedOp, rightFeedOp *colexecop.FeedOperator,
	leftIdx, rightIdx, outputIdx int,
) colexecop.Operator {
	return &orProjOp{
		allocator:        allocator,
		input:            input,
		leftProjOpChain:  leftProjOpChain,
		rightProjOpChain: rightProjOpChain,
		leftFeedOp:       leftFeedOp,
		rightFeedOp:      rightFeedOp,
		leftIdx:          leftIdx,
		rightIdx:         rightIdx,
		outputIdx:        outputIdx,
	}
}

func (o *orProjOp) ChildCount(verbose bool) int {
	return 3
}

func (o *orProjOp) Child(nth int, verbose bool) execopnode.OpNode {
	switch nth {
	case 0:
		return o.input
	case 1:
		return o.leftProjOpChain
	case 2:
		return o.rightProjOpChain
	default:
		colexecerror.InternalError(errors.AssertionFailedf("invalid idx %d", nth))
		// This code is unreachable, but the compiler cannot infer that.
		return nil
	}
}

// Init is part of the colexecop.Operator interface.
func (o *orProjOp) Init(ctx context.Context) {
	if !o.InitHelper.Init(ctx) {
		return
	}
	o.input.Init(o.Ctx)
	o.leftProjOpChain.Init(o.Ctx)
	o.rightProjOpChain.Init(o.Ctx)
}

// Next is part of the colexecop.Operator interface.
// The idea to handle the short-circuiting logic is similar to what caseOp
// does: a logical operator has an input and two projection chains. First,
// it runs the left chain on the input batch. Then, it "subtracts" the
// tuples for which we know the result of logical operation based only on
// the left side projection (e.g. if the left side is false and we're
// doing AND operation, then the result is also false) and runs the right
// side projection only on the remaining tuples (i.e. those that were not
// "subtracted"). Next, it restores the original selection vector and
// populates the result of the logical operation.
func (o *orProjOp) Next() coldata.Batch {
	batch := o.input.Next()
	origLen := batch.Length()
	if origLen == 0 {
		return coldata.ZeroBatch
	}
	usesSel := false
	if sel := batch.Selection(); sel != nil {
		o.origSel = colexecutils.EnsureSelectionVectorLength(o.origSel, origLen)
		copy(o.origSel, sel)
		usesSel = true
	}

	// In order to support the short-circuiting logic, we need to be quite tricky
	// here. First, we set the input batch for the left projection to run and
	// actually run the projection.
	o.leftFeedOp.SetBatch(batch)
	batch = o.leftProjOpChain.Next()

	// Now we need to populate a selection vector on the batch in such a way that
	// those tuples that we already know the result of logical operation for do
	// not get the projection for the right side.
	// knownResult indicates the boolean value which if present on the left side
	// fully determines the result of the logical operation.
	var (
		knownResult                   bool
		leftVec, rightVec             *coldata.Vec
		leftValIsNull, rightValIsNull bool
		leftVal, rightVal             bool
	)
	knownResult = true

	leftVec = batch.ColVec(o.leftIdx)
	var curIdx int
	leftVals := leftVec.Bool()
	if usesSel {
		sel := batch.Selection()
		origSel := o.origSel[:origLen]
		if leftVec.MaybeHasNulls() {
			leftNulls := leftVec.Nulls()
			for _, i := range origSel {
				leftValIsNull = leftNulls.NullAt(i)
				if leftValIsNull || leftVals[i] != knownResult {
					// We add the tuple into the selection vector if the left value is NULL or
					// it is different from knownResult.
					sel[curIdx] = i
					curIdx++
				}
			}
		} else {
			for _, i := range origSel {
				leftValIsNull = false
				if leftValIsNull || leftVals[i] != knownResult {
					// We add the tuple into the selection vector if the left value is NULL or
					// it is different from knownResult.
					sel[curIdx] = i
					curIdx++
				}
			}
		}
	} else {
		batch.SetSelection(true)
		sel := batch.Selection()
		if leftVec.MaybeHasNulls() {
			leftNulls := leftVec.Nulls()
			for i := 0; i < origLen; i++ {
				leftValIsNull = leftNulls.NullAt(i)
				if leftValIsNull || leftVals[i] != knownResult {
					// We add the tuple into the selection vector if the left value is NULL or
					// it is different from knownResult.
					sel[curIdx] = i
					curIdx++
				}
			}
		} else {
			for i := 0; i < origLen; i++ {
				leftValIsNull = false
				if leftValIsNull || leftVals[i] != knownResult {
					// We add the tuple into the selection vector if the left value is NULL or
					// it is different from knownResult.
					sel[curIdx] = i
					curIdx++
				}
			}
		}
	}

	var rightVals []bool
	if curIdx > 0 {
		// We only run the right-side projection if there are non-zero number of
		// remaining tuples.
		batch.SetLength(curIdx)
		o.rightFeedOp.SetBatch(batch)
		batch = o.rightProjOpChain.Next()
		rightVec = batch.ColVec(o.rightIdx)
		rightVals = rightVec.Bool()
	}

	// Now we need to restore the original selection vector and length.
	colexecutils.UpdateBatchState(batch, origLen, usesSel, o.origSel)

	outputCol := batch.ColVec(o.outputIdx)
	outputVals := outputCol.Bool()
	outputNulls := outputCol.Nulls()
	// This is where we populate the output - do the actual evaluation of the
	// logical operation.
	if leftVec.MaybeHasNulls() {
		leftNulls := leftVec.Nulls()
		if rightVec != nil && rightVec.MaybeHasNulls() {
			rightNulls := rightVec.Nulls()
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = leftNulls.NullAt(idx)
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = rightNulls.NullAt(idx)
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				_ = leftVals[origLen-1]
				if rightVals != nil {
					_ = rightVals[origLen-1]
				}
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = leftNulls.NullAt(idx)
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = rightNulls.NullAt(idx)
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = leftNulls.NullAt(idx)
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = false
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				_ = leftVals[origLen-1]
				if rightVals != nil {
					_ = rightVals[origLen-1]
				}
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = leftNulls.NullAt(idx)
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = false
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		}
	} else {
		if rightVec != nil && rightVec.MaybeHasNulls() {
			rightNulls := rightVec.Nulls()
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = false
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = rightNulls.NullAt(idx)
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				_ = leftVals[origLen-1]
				if rightVals != nil {
					_ = rightVals[origLen-1]
				}
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = false
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = rightNulls.NullAt(idx)
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = false
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = false
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				_ = leftVals[origLen-1]
				if rightVals != nil {
					_ = rightVals[origLen-1]
				}
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = false
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = false
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		}
	}

	return batch
}

type orRightNullProjOp struct {
	colexecop.InitHelper

	allocator *colmem.Allocator
	input     colexecop.Operator

	leftProjOpChain  colexecop.Operator
	rightProjOpChain colexecop.Operator
	leftFeedOp       *colexecop.FeedOperator
	rightFeedOp      *colexecop.FeedOperator

	leftIdx   int
	rightIdx  int
	outputIdx int

	// origSel is a buffer used to keep track of the original selection vector of
	// the input batch. We need to do this because we're going to modify the
	// selection vector in order to do the short-circuiting of logical operators.
	origSel []int
}

// newOrRightNullProjOp returns a new projection operator that logical-OrRightNull's
// the boolean columns at leftIdx and rightIdx, returning the result in
// outputIdx.
func newOrRightNullProjOp(
	allocator *colmem.Allocator,
	input, leftProjOpChain, rightProjOpChain colexecop.Operator,
	leftFeedOp, rightFeedOp *colexecop.FeedOperator,
	leftIdx, rightIdx, outputIdx int,
) colexecop.Operator {
	return &orRightNullProjOp{
		allocator:        allocator,
		input:            input,
		leftProjOpChain:  leftProjOpChain,
		rightProjOpChain: rightProjOpChain,
		leftFeedOp:       leftFeedOp,
		rightFeedOp:      rightFeedOp,
		leftIdx:          leftIdx,
		rightIdx:         rightIdx,
		outputIdx:        outputIdx,
	}
}

func (o *orRightNullProjOp) ChildCount(verbose bool) int {
	return 3
}

func (o *orRightNullProjOp) Child(nth int, verbose bool) execopnode.OpNode {
	switch nth {
	case 0:
		return o.input
	case 1:
		return o.leftProjOpChain
	case 2:
		return o.rightProjOpChain
	default:
		colexecerror.InternalError(errors.AssertionFailedf("invalid idx %d", nth))
		// This code is unreachable, but the compiler cannot infer that.
		return nil
	}
}

// Init is part of the colexecop.Operator interface.
func (o *orRightNullProjOp) Init(ctx context.Context) {
	if !o.InitHelper.Init(ctx) {
		return
	}
	o.input.Init(o.Ctx)
	o.leftProjOpChain.Init(o.Ctx)
	o.rightProjOpChain.Init(o.Ctx)
}

// Next is part of the colexecop.Operator interface.
// The idea to handle the short-circuiting logic is similar to what caseOp
// does: a logical operator has an input and two projection chains. First,
// it runs the left chain on the input batch. Then, it "subtracts" the
// tuples for which we know the result of logical operation based only on
// the left side projection (e.g. if the left side is false and we're
// doing AND operation, then the result is also false) and runs the right
// side projection only on the remaining tuples (i.e. those that were not
// "subtracted"). Next, it restores the original selection vector and
// populates the result of the logical operation.
func (o *orRightNullProjOp) Next() coldata.Batch {
	batch := o.input.Next()
	origLen := batch.Length()
	if origLen == 0 {
		return coldata.ZeroBatch
	}
	usesSel := false
	if sel := batch.Selection(); sel != nil {
		o.origSel = colexecutils.EnsureSelectionVectorLength(o.origSel, origLen)
		copy(o.origSel, sel)
		usesSel = true
	}

	// In order to support the short-circuiting logic, we need to be quite tricky
	// here. First, we set the input batch for the left projection to run and
	// actually run the projection.
	o.leftFeedOp.SetBatch(batch)
	batch = o.leftProjOpChain.Next()

	// Now we need to populate a selection vector on the batch in such a way that
	// those tuples that we already know the result of logical operation for do
	// not get the projection for the right side.
	// knownResult indicates the boolean value which if present on the left side
	// fully determines the result of the logical operation.
	var (
		knownResult                   bool
		leftVec, rightVec             *coldata.Vec
		leftValIsNull, rightValIsNull bool
		leftVal, rightVal             bool
	)
	knownResult = true

	leftVec = batch.ColVec(o.leftIdx)
	var curIdx int
	leftVals := leftVec.Bool()
	if usesSel {
		sel := batch.Selection()
		origSel := o.origSel[:origLen]
		if leftVec.MaybeHasNulls() {
			leftNulls := leftVec.Nulls()
			for _, i := range origSel {
				leftValIsNull = leftNulls.NullAt(i)
				if leftValIsNull || leftVals[i] != knownResult {
					// We add the tuple into the selection vector if the left value is NULL or
					// it is different from knownResult.
					sel[curIdx] = i
					curIdx++
				}
			}
		} else {
			for _, i := range origSel {
				leftValIsNull = false
				if leftValIsNull || leftVals[i] != knownResult {
					// We add the tuple into the selection vector if the left value is NULL or
					// it is different from knownResult.
					sel[curIdx] = i
					curIdx++
				}
			}
		}
	} else {
		batch.SetSelection(true)
		sel := batch.Selection()
		if leftVec.MaybeHasNulls() {
			leftNulls := leftVec.Nulls()
			for i := 0; i < origLen; i++ {
				leftValIsNull = leftNulls.NullAt(i)
				if leftValIsNull || leftVals[i] != knownResult {
					// We add the tuple into the selection vector if the left value is NULL or
					// it is different from knownResult.
					sel[curIdx] = i
					curIdx++
				}
			}
		} else {
			for i := 0; i < origLen; i++ {
				leftValIsNull = false
				if leftValIsNull || leftVals[i] != knownResult {
					// We add the tuple into the selection vector if the left value is NULL or
					// it is different from knownResult.
					sel[curIdx] = i
					curIdx++
				}
			}
		}
	}

	// Now we need to restore the original selection vector and length.
	colexecutils.UpdateBatchState(batch, origLen, usesSel, o.origSel)

	outputCol := batch.ColVec(o.outputIdx)
	outputVals := outputCol.Bool()
	outputNulls := outputCol.Nulls()
	// This is where we populate the output - do the actual evaluation of the
	// logical operation.
	if leftVec.MaybeHasNulls() {
		leftNulls := leftVec.Nulls()
		if rightVec != nil && rightVec.MaybeHasNulls() {
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = leftNulls.NullAt(idx)
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = true
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				_ = leftVals[origLen-1]
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = leftNulls.NullAt(idx)
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = true
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = leftNulls.NullAt(idx)
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = true
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				_ = leftVals[origLen-1]
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = leftNulls.NullAt(idx)
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = true
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		}
	} else {
		if rightVec != nil && rightVec.MaybeHasNulls() {
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = false
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = true
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				_ = leftVals[origLen-1]
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = false
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = true
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = false
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = true
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				_ = leftVals[origLen-1]
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = false
					leftVal = leftVals[idx]
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = true
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		}
	}

	return batch
}

type orLeftNullProjOp struct {
	colexecop.InitHelper

	allocator *colmem.Allocator
	input     colexecop.Operator

	leftProjOpChain  colexecop.Operator
	rightProjOpChain colexecop.Operator
	leftFeedOp       *colexecop.FeedOperator
	rightFeedOp      *colexecop.FeedOperator

	leftIdx   int
	rightIdx  int
	outputIdx int

	// origSel is a buffer used to keep track of the original selection vector of
	// the input batch. We need to do this because we're going to modify the
	// selection vector in order to do the short-circuiting of logical operators.
	origSel []int
}

// newOrLeftNullProjOp returns a new projection operator that logical-OrLeftNull's
// the boolean columns at leftIdx and rightIdx, returning the result in
// outputIdx.
func newOrLeftNullProjOp(
	allocator *colmem.Allocator,
	input, leftProjOpChain, rightProjOpChain colexecop.Operator,
	leftFeedOp, rightFeedOp *colexecop.FeedOperator,
	leftIdx, rightIdx, outputIdx int,
) colexecop.Operator {
	return &orLeftNullProjOp{
		allocator:        allocator,
		input:            input,
		leftProjOpChain:  leftProjOpChain,
		rightProjOpChain: rightProjOpChain,
		leftFeedOp:       leftFeedOp,
		rightFeedOp:      rightFeedOp,
		leftIdx:          leftIdx,
		rightIdx:         rightIdx,
		outputIdx:        outputIdx,
	}
}

func (o *orLeftNullProjOp) ChildCount(verbose bool) int {
	return 3
}

func (o *orLeftNullProjOp) Child(nth int, verbose bool) execopnode.OpNode {
	switch nth {
	case 0:
		return o.input
	case 1:
		return o.leftProjOpChain
	case 2:
		return o.rightProjOpChain
	default:
		colexecerror.InternalError(errors.AssertionFailedf("invalid idx %d", nth))
		// This code is unreachable, but the compiler cannot infer that.
		return nil
	}
}

// Init is part of the colexecop.Operator interface.
func (o *orLeftNullProjOp) Init(ctx context.Context) {
	if !o.InitHelper.Init(ctx) {
		return
	}
	o.input.Init(o.Ctx)
	o.leftProjOpChain.Init(o.Ctx)
	o.rightProjOpChain.Init(o.Ctx)
}

// Next is part of the colexecop.Operator interface.
// The idea to handle the short-circuiting logic is similar to what caseOp
// does: a logical operator has an input and two projection chains. First,
// it runs the left chain on the input batch. Then, it "subtracts" the
// tuples for which we know the result of logical operation based only on
// the left side projection (e.g. if the left side is false and we're
// doing AND operation, then the result is also false) and runs the right
// side projection only on the remaining tuples (i.e. those that were not
// "subtracted"). Next, it restores the original selection vector and
// populates the result of the logical operation.
func (o *orLeftNullProjOp) Next() coldata.Batch {
	batch := o.input.Next()
	origLen := batch.Length()
	if origLen == 0 {
		return coldata.ZeroBatch
	}
	usesSel := false
	if sel := batch.Selection(); sel != nil {
		o.origSel = colexecutils.EnsureSelectionVectorLength(o.origSel, origLen)
		copy(o.origSel, sel)
		usesSel = true
	}

	// In order to support the short-circuiting logic, we need to be quite tricky
	// here. First, we set the input batch for the left projection to run and
	// actually run the projection.
	o.leftFeedOp.SetBatch(batch)
	batch = o.leftProjOpChain.Next()

	// Now we need to populate a selection vector on the batch in such a way that
	// those tuples that we already know the result of logical operation for do
	// not get the projection for the right side.
	// knownResult indicates the boolean value which if present on the left side
	// fully determines the result of the logical operation.
	var (
		knownResult                   bool
		leftVec, rightVec             *coldata.Vec
		leftValIsNull, rightValIsNull bool
		leftVal, rightVal             bool
	)
	knownResult = true

	leftVec = batch.ColVec(o.leftIdx)
	var curIdx int
	// Left vector represents a constant NULL value, so we need to include
	// all of the tuples in the batch for the right side to be evaluated.
	if usesSel {
		sel := batch.Selection()
		copy(sel[:origLen], o.origSel[:origLen])
	} else {
		batch.SetSelection(true)
		sel := batch.Selection()
		for i := 0; i < origLen; i++ {
			sel[i] = i
		}
	}
	curIdx = origLen

	var rightVals []bool
	if curIdx > 0 {
		// We only run the right-side projection if there are non-zero number of
		// remaining tuples.
		batch.SetLength(curIdx)
		o.rightFeedOp.SetBatch(batch)
		batch = o.rightProjOpChain.Next()
		rightVec = batch.ColVec(o.rightIdx)
		rightVals = rightVec.Bool()
	}

	// Now we need to restore the original selection vector and length.
	colexecutils.UpdateBatchState(batch, origLen, usesSel, o.origSel)

	outputCol := batch.ColVec(o.outputIdx)
	outputVals := outputCol.Bool()
	outputNulls := outputCol.Nulls()
	// This is where we populate the output - do the actual evaluation of the
	// logical operation.
	if leftVec.MaybeHasNulls() {
		if rightVec != nil && rightVec.MaybeHasNulls() {
			rightNulls := rightVec.Nulls()
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = true
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = rightNulls.NullAt(idx)
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				if rightVals != nil {
					_ = rightVals[origLen-1]
				}
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = true
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = rightNulls.NullAt(idx)
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = true
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = false
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				if rightVals != nil {
					_ = rightVals[origLen-1]
				}
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = true
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = false
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		}
	} else {
		if rightVec != nil && rightVec.MaybeHasNulls() {
			rightNulls := rightVec.Nulls()
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = true
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = rightNulls.NullAt(idx)
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				if rightVals != nil {
					_ = rightVals[origLen-1]
				}
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = true
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = rightNulls.NullAt(idx)
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				for _, idx := range sel[:origLen] {
					leftValIsNull = true
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = false
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			} else {
				if rightVals != nil {
					_ = rightVals[origLen-1]
				}
				_ = outputVals[origLen-1]
				for idx := 0; idx < origLen; idx++ {
					leftValIsNull = true
					if !leftValIsNull && leftVal == knownResult {
						// In this case, the result is fully determined by the left argument,
						// so the right argument wasn't even evaluated.
						outputVals[idx] = leftVal
					} else {
						rightValIsNull = false
						rightVal = rightVals[idx]
						// The rules for performing a logical operation on two booleans are:
						// 1. if at least one of the values is "knownResult", then the result
						// is also "knownResult"
						// 2. if both values are the opposite of "knownResult", then the result
						// is also the opposite of "knownResult"
						// 3. in all other cases, the result is NULL.
						if (!leftValIsNull && leftVal == knownResult) || (!rightValIsNull && rightVal == knownResult) {
							outputVals[idx] = knownResult
						} else if (!leftValIsNull && leftVal != knownResult) && (!rightValIsNull && rightVal != knownResult) {
							outputVals[idx] = !knownResult
						} else {
							outputNulls.SetNull(idx)
						}
					}
				}
			}
		}
	}

	return batch
}
