// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package catpb

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[InitialVersion-0]
	_ = x[OwnerVersion-1]
	_ = x[Version21_2-2]
	_ = x[Version23_2-3]
}

func (i PrivilegeDescVersion) String() string {
	switch i {
	case InitialVersion:
		return "InitialVersion"
	case OwnerVersion:
		return "OwnerVersion"
	case Version21_2:
		return "Version21_2"
	case Version23_2:
		return "Version23_2"
	default:
		return "PrivilegeDescVersion(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
