// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package catalogkeys

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[DatabaseCommentType-0]
	_ = x[TableCommentType-1]
	_ = x[ColumnCommentType-2]
	_ = x[IndexCommentType-3]
	_ = x[SchemaCommentType-4]
	_ = x[ConstraintCommentType-5]
	_ = x[FunctionCommentType-6]
	_ = x[TypeCommentType-7]
	_ = x[MaxCommentTypeValue-7]
}

func (i CommentType) String() string {
	switch i {
	case DatabaseCommentType:
		return "DatabaseCommentType"
	case TableCommentType:
		return "TableCommentType"
	case ColumnCommentType:
		return "ColumnCommentType"
	case IndexCommentType:
		return "IndexCommentType"
	case SchemaCommentType:
		return "SchemaCommentType"
	case ConstraintCommentType:
		return "ConstraintCommentType"
	case FunctionCommentType:
		return "FunctionCommentType"
	case TypeCommentType:
		return "TypeCommentType"
	default:
		return "CommentType(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
