// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package sql

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[advanceUnknown-0]
	_ = x[stayInPlace-1]
	_ = x[advanceOne-2]
	_ = x[skipBatch-3]
	_ = x[rewind-4]
}

func (i advanceCode) String() string {
	switch i {
	case advanceUnknown:
		return "advanceUnknown"
	case stayInPlace:
		return "stayInPlace"
	case advanceOne:
		return "advanceOne"
	case skipBatch:
		return "skipBatch"
	case rewind:
		return "rewind"
	default:
		return "advanceCode(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
