// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package license

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[LicTypeNone-0]
	_ = x[LicTypeTrial-1]
	_ = x[LicTypeFree-2]
	_ = x[LicTypeEnterprise-3]
	_ = x[LicTypeEvaluation-4]
}

func (i LicType) String() string {
	switch i {
	case LicTypeNone:
		return "none"
	case LicTypeTrial:
		return "trial"
	case LicTypeFree:
		return "free"
	case LicTypeEnterprise:
		return "enterprise"
	case LicTypeEvaluation:
		return "evaluation"
	default:
		return "LicType(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
