// Copyright 2024 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package opentelemetry

// cockroachdbMetrics is a mapping of CockroachDB metric names to cockroachdb
// Datadog integration metric names. This allows CockroachDB metrics to comply
// with the naming requirements for the cockroachdb Datadog integration listed
// in its metadata.csv.
// - https://github.com/DataDog/integrations-core/blob/master/cockroachdb/metadata.csv
// Only metrics whose name matches a key in this map will have its
// corresponding value exported from the OpenTelemetry Collector.
var cockroachdbMetrics = map[string]string{
	"abortspanbytes":                                                      "abortspanbytes",
	"addsstable_applications":                                             "addsstable.applications",
	"addsstable_aswrites":                                                 "addsstable.aswrites",
	"addsstable_copies":                                                   "addsstable.copies",
	"addsstable_delay_enginebackpressure":                                 "addsstable.delay.enginebackpressure",
	"addsstable_delay_total":                                              "addsstable.delay.total",
	"addsstable_proposals":                                                "addsstable.proposals",
	"admission_admitted_elastic_cpu":                                      "admission.admitted.elastic_cpu",
	"admission_admitted_elastic_cpu_bulk_normal_pri":                      "admission.admitted.elastic_cpu.bulk_normal_pri",
	"admission_admitted_elastic_cpu_normal_pri":                           "admission.admitted.elastic_cpu.normal_pri",
	"admission_admitted_elastic_stores":                                   "admission.admitted.elastic_stores",
	"admission_admitted_elastic_stores_bulk_normal_pri":                   "admission.admitted.elastic_stores.bulk_normal_pri",
	"admission_admitted_elastic_stores_ttl_low_pri":                       "admission.admitted.elastic_stores.ttl_low_pri",
	"admission_admitted_kv":                                               "admission.admitted.kv",
	"admission_admitted_kv_bulk_normal_pri":                               "admission.admitted.kv.bulk_normal_pri",
	"admission_admitted_kv_high_pri":                                      "admission.admitted.kv.high_pri",
	"admission_admitted_kv_locking_normal_pri":                            "admission.admitted.kv.locking_normal_pri",
	"admission_admitted_kv_normal_pri":                                    "admission.admitted.kv.normal_pri",
	"admission_admitted_kv_stores":                                        "admission.admitted.kv_stores",
	"admission_admitted_kv_stores_bulk_normal_pri":                        "admission.admitted.kv_stores.bulk_normal_pri",
	"admission_admitted_kv_stores_high_pri":                               "admission.admitted.kv_stores.high_pri",
	"admission_admitted_kv_stores_locking_normal_pri":                     "admission.admitted.kv_stores.locking_normal_pri",
	"admission_admitted_kv_stores_normal_pri":                             "admission.admitted.kv_stores.normal_pri",
	"admission_admitted_kv_stores_ttl_low_pri":                            "admission.admitted.kv_stores.ttl_low_pri",
	"admission_admitted_sql_kv_response":                                  "admission.admitted.sql_kv.response",
	"admission_admitted_sql_kv_response_locking_normal_pri":               "admission.admitted.sql_kv_response.locking_normal_pri",
	"admission_admitted_sql_kv_response_normal_pri":                       "admission.admitted.sql_kv_response.normal_pri",
	"admission_admitted_sql_leaf_start":                                   "admission.admitted.sql.leaf.start",
	"admission_admitted_sql_leaf_start_locking_normal_pri":                "admission.admitted.sql_leaf_start.locking_normal_pri",
	"admission_admitted_sql_leaf_start_normal_pri":                        "admission.admitted.sql_leaf_start.normal_pri",
	"admission_admitted_sql_root_start":                                   "admission.admitted.sql.root.start",
	"admission_admitted_sql_root_start_locking_normal_pri":                "admission.admitted.sql_root_start.locking_normal_pri",
	"admission_admitted_sql_root_start_normal_pri":                        "admission.admitted.sql_root_start.normal_pri",
	"admission_admitted_sql_sql_response":                                 "admission.admitted.sql_sql.response",
	"admission_admitted_sql_sql_response_locking_normal_pri":              "admission.admitted.sql_sql_response.locking_normal_pri",
	"admission_admitted_sql_sql_response_normal_pri":                      "admission.admitted.sql_sql_response.normal_pri",
	"admission_elastic_cpu_acquired_nanos":                                "admission.elastic_cpu.acquired_nanos",
	"admission_elastic_cpu_available_nanos":                               "admission.elastic_cpu.available_nanos",
	"admission_elastic_cpu_max_available_nanos":                           "admission.elastic_cpu.max_available_nanos",
	"admission_elastic_cpu_nanos_exhausted_duration":                      "admission.elastic_cpu.nanos_exhausted_duration",
	"admission_elastic_cpu_over_limit_durations":                          "admission.elastic_cpu.over_limit_durations",
	"admission_elastic_cpu_over_limit_durations_bucket":                   "admission.elastic_cpu.over_limit_durations.bucket",
	"admission_elastic_cpu_over_limit_durations_count":                    "admission.elastic_cpu.over_limit_durations.count",
	"admission_elastic_cpu_over_limit_durations_sum":                      "admission.elastic_cpu.over_limit_durations.sum",
	"admission_elastic_cpu_pre_work_nanos":                                "admission.elastic_cpu.pre_work_nanos",
	"admission_elastic_cpu_returned_nanos":                                "admission.elastic_cpu.returned_nanos",
	"admission_elastic_cpu_utilization":                                   "admission.elastic_cpu.utilization",
	"admission_elastic_cpu_utilization_limit":                             "admission.elastic_cpu.utilization_limit",
	"admission_errored_elastic_cpu":                                       "admission.errored.elastic_cpu",
	"admission_errored_elastic_cpu_bulk_normal_pri":                       "admission.errored.elastic_cpu.bulk_normal_pri",
	"admission_errored_elastic_cpu_normal_pri":                            "admission.errored.elastic_cpu.normal_pri",
	"admission_errored_elastic_stores":                                    "admission.errored.elastic_stores",
	"admission_errored_elastic_stores_bulk_normal_pri":                    "admission.errored.elastic_stores.bulk_normal_pri",
	"admission_errored_elastic_stores_ttl_low_pri":                        "admission.errored.elastic_stores.ttl_low_pri",
	"admission_errored_kv":                                                "admission.errored.kv",
	"admission_errored_kv_bulk_normal_pri":                                "admission.errored.kv.bulk_normal_pri",
	"admission_errored_kv_high_pri":                                       "admission.errored.kv.high_pri",
	"admission_errored_kv_locking_normal_pri":                             "admission.errored.kv.locking_normal_pri",
	"admission_errored_kv_normal_pri":                                     "admission.errored.kv.normal_pri",
	"admission_errored_kv_stores":                                         "admission.errored.kv_stores",
	"admission_errored_kv_stores_bulk_normal_pri":                         "admission.errored.kv_stores.bulk_normal_pri",
	"admission_errored_kv_stores_high_pri":                                "admission.errored.kv_stores.high_pri",
	"admission_errored_kv_stores_locking_normal_pri":                      "admission.errored.kv_stores.locking_normal_pri",
	"admission_errored_kv_stores_normal_pri":                              "admission.errored.kv_stores.normal_pri",
	"admission_errored_kv_stores_ttl_low_pri":                             "admission.errored.kv_stores.ttl_low_pri",
	"admission_errored_sql_kv_response":                                   "admission.errored.sql_kv.response",
	"admission_errored_sql_kv_response_locking_normal_pri":                "admission.errored.sql_kv_response.locking_normal_pri",
	"admission_errored_sql_kv_response_normal_pri":                        "admission.errored.sql_kv_response.normal_pri",
	"admission_errored_sql_leaf_start":                                    "admission.errored.sql.leaf.start",
	"admission_errored_sql_leaf_start_locking_normal_pri":                 "admission.errored.sql_leaf_start.locking_normal_pri",
	"admission_errored_sql_leaf_start_normal_pri":                         "admission.errored.sql_leaf_start.normal_pri",
	"admission_errored_sql_root_start":                                    "admission.errored.sql.root.start",
	"admission_errored_sql_root_start_locking_normal_pri":                 "admission.errored.sql_root_start.locking_normal_pri",
	"admission_errored_sql_root_start_normal_pri":                         "admission.errored.sql_root_start.normal_pri",
	"admission_errored_sql_sql_response":                                  "admission.errored.sql_sql.response",
	"admission_errored_sql_sql_response_locking_normal_pri":               "admission.errored.sql_sql_response.locking_normal_pri",
	"admission_errored_sql_sql_response_normal_pri":                       "admission.errored.sql_sql_response.normal_pri",
	"admission_granter_cpu_load_long_period_duration_kv":                  "admission.granter.cpu_load_long_period_duration.kv",
	"admission_granter_cpu_load_short_period_duration_kv":                 "admission.granter.cpu_load_short_period_duration.kv",
	"admission_granter_elastic_io_tokens_available_kv":                    "admission.granter.elastic_io_tokens_available.kv",
	"admission_granter_elastic_io_tokens_exhausted_duration_kv":           "admission.granter.elastic_io_tokens_exhausted_duration.kv",
	"admission_granter_io_tokens_available_kv":                            "admission.granter.io_tokens_available.kv",
	"admission_granter_io_tokens_bypassed_kv":                             "admission.granter.io_tokens_bypassed.kv",
	"admission_granter_io_tokens_exhausted_duration_kv":                   "admission.granter.io.tokens.exhausted.duration.kv",
	"admission_granter_io_tokens_returned_kv":                             "admission.granter.io_tokens_returned.kv",
	"admission_granter_io_tokens_taken_kv":                                "admission.granter.io_tokens_taken.kv",
	"admission_granter_slot_adjuster_decrements_kv":                       "admission.granter.slot_adjuster_decrements.kv",
	"admission_granter_slot_adjuster_increments_kv":                       "admission.granter.slot_adjuster_increments.kv",
	"admission_granter_slots_exhausted_duration_kv":                       "admission.granter.slots_exhausted_duration.kv",
	"admission_granter_total_slots_kv":                                    "admission.granter.total.slots.kv",
	"admission_granter_used_slots_kv":                                     "admission.granter.used.slots.kv",
	"admission_granter_used_slots_sql_leaf_start":                         "admission.granter.used.slots.sql.leaf.start",
	"admission_granter_used_slots_sql_root_start":                         "admission.granter.used.slots.sql.root.start",
	"admission_io_overload":                                               "admission.io.overload",
	"admission_l0_compacted_bytes_kv":                                     "admission.l0_compacted_bytes.kv",
	"admission_l0_tokens_produced_kv":                                     "admission.l0_tokens_produced.kv",
	"admission_raft_paused_replicas":                                      "admission.raft.paused_replicas",
	"admission_raft_paused_replicas_dropped_msgs":                         "admission.raft.paused_replicas_dropped_msgs",
	"admission_requested_elastic_cpu":                                     "admission.requested.elastic_cpu",
	"admission_requested_elastic_cpu_bulk_normal_pri":                     "admission.requested.elastic_cpu.bulk_normal_pri",
	"admission_requested_elastic_cpu_normal_pri":                          "admission.requested.elastic_cpu.normal_pri",
	"admission_requested_elastic_stores":                                  "admission.requested.elastic_stores",
	"admission_requested_elastic_stores_bulk_normal_pri":                  "admission.requested.elastic_stores.bulk_normal_pri",
	"admission_requested_elastic_stores_ttl_low_pri":                      "admission.requested.elastic_stores.ttl_low_pri",
	"admission_requested_kv":                                              "admission.requested.kv",
	"admission_requested_kv_bulk_normal_pri":                              "admission.requested.kv.bulk_normal_pri",
	"admission_requested_kv_high_pri":                                     "admission.requested.kv.high_pri",
	"admission_requested_kv_locking_normal_pri":                           "admission.requested.kv.locking_normal_pri",
	"admission_requested_kv_normal_pri":                                   "admission.requested.kv.normal_pri",
	"admission_requested_kv_stores":                                       "admission.requested.kv_stores",
	"admission_requested_kv_stores_bulk_normal_pri":                       "admission.requested.kv_stores.bulk_normal_pri",
	"admission_requested_kv_stores_high_pri":                              "admission.requested.kv_stores.high_pri",
	"admission_requested_kv_stores_locking_normal_pri":                    "admission.requested.kv_stores.locking_normal_pri",
	"admission_requested_kv_stores_normal_pri":                            "admission.requested.kv_stores.normal_pri",
	"admission_requested_kv_stores_ttl_low_pri":                           "admission.requested.kv_stores.ttl_low_pri",
	"admission_requested_sql_kv_response":                                 "admission.requested.sql_kv.response",
	"admission_requested_sql_kv_response_locking_normal_pri":              "admission.requested.sql_kv_response.locking_normal_pri",
	"admission_requested_sql_kv_response_normal_pri":                      "admission.requested.sql_kv_response.normal_pri",
	"admission_requested_sql_leaf_start":                                  "admission.requested.sql.leaf.start",
	"admission_requested_sql_leaf_start_locking_normal_pri":               "admission.requested.sql_leaf_start.locking_normal_pri",
	"admission_requested_sql_leaf_start_normal_pri":                       "admission.requested.sql_leaf_start.normal_pri",
	"admission_requested_sql_root_start":                                  "admission.requested.sql.root.start",
	"admission_requested_sql_root_start_locking_normal_pri":               "admission.requested.sql_root_start.locking_normal_pri",
	"admission_requested_sql_root_start_normal_pri":                       "admission.requested.sql_root_start.normal_pri",
	"admission_requested_sql_sql_response":                                "admission.requested.sql_sql.response",
	"admission_requested_sql_sql_response_locking_normal_pri":             "admission.requested.sql_sql_response.locking_normal_pri",
	"admission_requested_sql_sql_response_normal_pri":                     "admission.requested.sql_sql_response.normal_pri",
	"admission_scheduler_latency_listener_p99_nanos":                      "admission.scheduler_latency_listener.p99_nanos",
	"admission_wait_durations_elastic_cpu":                                "admission.wait_durations.elastic_cpu",
	"admission_wait_durations_elastic_cpu_bucket":                         "admission.wait_durations.elastic_cpu.bucket",
	"admission_wait_durations_elastic_cpu_bulk_normal_pri":                "admission.wait_durations.elastic_cpu.bulk_normal_pri",
	"admission_wait_durations_elastic_cpu_bulk_normal_pri_bucket":         "admission.wait_durations.elastic_cpu.bulk_normal_pri.bucket",
	"admission_wait_durations_elastic_cpu_bulk_normal_pri_count":          "admission.wait_durations.elastic_cpu.bulk_normal_pri.count",
	"admission_wait_durations_elastic_cpu_bulk_normal_pri_sum":            "admission.wait_durations.elastic_cpu.bulk_normal_pri.sum",
	"admission_wait_durations_elastic_cpu_count":                          "admission.wait_durations.elastic_cpu.count",
	"admission_wait_durations_elastic_cpu_normal_pri":                     "admission.wait_durations.elastic_cpu.normal_pri",
	"admission_wait_durations_elastic_cpu_normal_pri_bucket":              "admission.wait_durations.elastic_cpu.normal_pri.bucket",
	"admission_wait_durations_elastic_cpu_normal_pri_count":               "admission.wait_durations.elastic_cpu.normal_pri.count",
	"admission_wait_durations_elastic_cpu_normal_pri_sum":                 "admission.wait_durations.elastic_cpu.normal_pri.sum",
	"admission_wait_durations_elastic_cpu_sum":                            "admission.wait_durations.elastic_cpu.sum",
	"admission_wait_durations_elastic_stores":                             "admission.wait_durations.elastic_stores",
	"admission_wait_durations_elastic_stores_bucket":                      "admission.wait_durations.elastic_stores.bucket",
	"admission_wait_durations_elastic_stores_bulk_normal_pri":             "admission.wait_durations.elastic_stores.bulk_normal_pri",
	"admission_wait_durations_elastic_stores_bulk_normal_pri_bucket":      "admission.wait_durations.elastic_stores.bulk_normal_pri.bucket",
	"admission_wait_durations_elastic_stores_bulk_normal_pri_count":       "admission.wait_durations.elastic_stores.bulk_normal_pri.count",
	"admission_wait_durations_elastic_stores_bulk_normal_pri_sum":         "admission.wait_durations.elastic_stores.bulk_normal_pri.sum",
	"admission_wait_durations_elastic_stores_count":                       "admission.wait_durations.elastic_stores.count",
	"admission_wait_durations_elastic_stores_sum":                         "admission.wait_durations.elastic_stores.sum",
	"admission_wait_durations_elastic_stores_ttl_low_pri":                 "admission.wait_durations.elastic_stores.ttl_low_pri",
	"admission_wait_durations_elastic_stores_ttl_low_pri_bucket":          "admission.wait_durations.elastic_stores.ttl_low_pri.bucket",
	"admission_wait_durations_elastic_stores_ttl_low_pri_count":           "admission.wait_durations.elastic_stores.ttl_low_pri.count",
	"admission_wait_durations_elastic_stores_ttl_low_pri_sum":             "admission.wait_durations.elastic_stores.ttl_low_pri.sum",
	"admission_wait_durations_kv":                                         "admission.wait.durations.kv",
	"admission_wait_durations_kv_bucket":                                  "admission.wait_durations.kv.bucket",
	"admission_wait_durations_kv_bulk_normal_pri":                         "admission.wait_durations.kv.bulk_normal_pri",
	"admission_wait_durations_kv_count":                                   "admission.wait_durations.kv.count",
	"admission_wait_durations_kv_high_pri":                                "admission.wait_durations.kv.high_pri",
	"admission_wait_durations_kv_high_pri_bucket":                         "admission.wait_durations.kv.high_pri.bucket",
	"admission_wait_durations_kv_high_pri_count":                          "admission.wait_durations.kv.high_pri.count",
	"admission_wait_durations_kv_high_pri_sum":                            "admission.wait_durations.kv.high_pri.sum",
	"admission_wait_durations_kv_locking_normal_pri":                      "admission.wait_durations.kv.locking_normal_pri",
	"admission_wait_durations_kv_locking_normal_pri_bucket":               "admission.wait_durations.kv.locking_normal_pri.bucket",
	"admission_wait_durations_kv_locking_normal_pri_count":                "admission.wait_durations.kv.locking_normal_pri.count",
	"admission_wait_durations_kv_locking_normal_pri_sum":                  "admission.wait_durations.kv.locking_normal_pri.sum",
	"admission_wait_durations_kv_normal_pri":                              "admission.wait_durations.kv.normal_pri",
	"admission_wait_durations_kv_normal_pri_bucket":                       "admission.wait_durations.kv.normal_pri.bucket",
	"admission_wait_durations_kv_normal_pri_count":                        "admission.wait_durations.kv.normal_pri.count",
	"admission_wait_durations_kv_normal_pri_sum":                          "admission.wait_durations.kv.normal_pri.sum",
	"admission_wait_durations_kv_stores":                                  "admission.wait.durations.kv_stores",
	"admission_wait_durations_kv_stores_bucket":                           "admission.wait_durations.kv_stores.bucket",
	"admission_wait_durations_kv_stores_bulk_normal_pri":                  "admission.wait_durations.kv_stores.bulk_normal_pri",
	"admission_wait_durations_kv_stores_count":                            "admission.wait_durations.kv_stores.count",
	"admission_wait_durations_kv_stores_high_pri":                         "admission.wait_durations.kv_stores.high_pri",
	"admission_wait_durations_kv_stores_high_pri_bucket":                  "admission.wait_durations.kv_stores.high_pri.bucket",
	"admission_wait_durations_kv_stores_high_pri_count":                   "admission.wait_durations.kv_stores.high_pri.count",
	"admission_wait_durations_kv_stores_high_pri_sum":                     "admission.wait_durations.kv_stores.high_pri.sum",
	"admission_wait_durations_kv_stores_locking_normal_pri":               "admission.wait_durations.kv_stores.locking_normal_pri",
	"admission_wait_durations_kv_stores_locking_normal_pri_bucket":        "admission.wait_durations.kv_stores.locking_normal_pri.bucket",
	"admission_wait_durations_kv_stores_locking_normal_pri_count":         "admission.wait_durations.kv_stores.locking_normal_pri.count",
	"admission_wait_durations_kv_stores_locking_normal_pri_sum":           "admission.wait_durations.kv_stores.locking_normal_pri.sum",
	"admission_wait_durations_kv_stores_normal_pri":                       "admission.wait_durations.kv_stores.normal_pri",
	"admission_wait_durations_kv_stores_normal_pri_bucket":                "admission.wait_durations.kv_stores.normal_pri.bucket",
	"admission_wait_durations_kv_stores_normal_pri_count":                 "admission.wait_durations.kv_stores.normal_pri.count",
	"admission_wait_durations_kv_stores_normal_pri_sum":                   "admission.wait_durations.kv_stores.normal_pri.sum",
	"admission_wait_durations_kv_stores_sum":                              "admission.wait_durations.kv_stores.sum",
	"admission_wait_durations_kv_stores_ttl_low_pri":                      "admission.wait_durations.kv_stores.ttl_low_pri",
	"admission_wait_durations_kv_sum":                                     "admission.wait_durations.kv.sum",
	"admission_wait_durations_sql_kv_response":                            "admission.wait.durations.sql_kv.response",
	"admission_wait_durations_sql_kv_response_bucket":                     "admission.wait_durations.sql_kv_response.bucket",
	"admission_wait_durations_sql_kv_response_count":                      "admission.wait_durations.sql_kv_response.count",
	"admission_wait_durations_sql_kv_response_locking_normal_pri":         "admission.wait_durations.sql_kv_response.locking_normal_pri",
	"admission_wait_durations_sql_kv_response_locking_normal_pri_bucket":  "admission.wait_durations.sql_kv_response.locking_normal_pri.bucket",
	"admission_wait_durations_sql_kv_response_locking_normal_pri_count":   "admission.wait_durations.sql_kv_response.locking_normal_pri.count",
	"admission_wait_durations_sql_kv_response_locking_normal_pri_sum":     "admission.wait_durations.sql_kv_response.locking_normal_pri.sum",
	"admission_wait_durations_sql_kv_response_normal_pri":                 "admission.wait_durations.sql_kv_response.normal_pri",
	"admission_wait_durations_sql_kv_response_normal_pri_bucket":          "admission.wait_durations.sql_kv_response.normal_pri.bucket",
	"admission_wait_durations_sql_kv_response_normal_pri_count":           "admission.wait_durations.sql_kv_response.normal_pri.count",
	"admission_wait_durations_sql_kv_response_normal_pri_sum":             "admission.wait_durations.sql_kv_response.normal_pri.sum",
	"admission_wait_durations_sql_kv_response_sum":                        "admission.wait_durations.sql_kv_response.sum",
	"admission_wait_durations_sql_leaf_start":                             "admission.wait.durations.sql.leaf.start",
	"admission_wait_durations_sql_leaf_start_bucket":                      "admission.wait_durations.sql_leaf_start.bucket",
	"admission_wait_durations_sql_leaf_start_count":                       "admission.wait_durations.sql_leaf_start.count",
	"admission_wait_durations_sql_leaf_start_locking_normal_pri":          "admission.wait_durations.sql_leaf_start.locking_normal_pri",
	"admission_wait_durations_sql_leaf_start_locking_normal_pri_bucket":   "admission.wait_durations.sql_leaf_start.locking_normal_pri.bucket",
	"admission_wait_durations_sql_leaf_start_locking_normal_pri_count":    "admission.wait_durations.sql_leaf_start.locking_normal_pri.count",
	"admission_wait_durations_sql_leaf_start_locking_normal_pri_sum":      "admission.wait_durations.sql_leaf_start.locking_normal_pri.sum",
	"admission_wait_durations_sql_leaf_start_normal_pri":                  "admission.wait_durations.sql_leaf_start.normal_pri",
	"admission_wait_durations_sql_leaf_start_normal_pri_bucket":           "admission.wait_durations.sql_leaf_start.normal_pri.bucket",
	"admission_wait_durations_sql_leaf_start_normal_pri_count":            "admission.wait_durations.sql_leaf_start.normal_pri.count",
	"admission_wait_durations_sql_leaf_start_normal_pri_sum":              "admission.wait_durations.sql_leaf_start.normal_pri.sum",
	"admission_wait_durations_sql_leaf_start_sum":                         "admission.wait_durations.sql_leaf_start.sum",
	"admission_wait_durations_sql_root_start":                             "admission.wait_durations.sql_root_start",
	"admission_wait_durations_sql_root_start_bucket":                      "admission.wait_durations.sql_root_start.bucket",
	"admission_wait_durations_sql_root_start_count":                       "admission.wait_durations.sql_root_start.count",
	"admission_wait_durations_sql_root_start_locking_normal_pri":          "admission.wait_durations.sql_root_start.locking_normal_pri",
	"admission_wait_durations_sql_root_start_locking_normal_pri_bucket":   "admission.wait_durations.sql_root_start.locking_normal_pri.bucket",
	"admission_wait_durations_sql_root_start_locking_normal_pri_count":    "admission.wait_durations.sql_root_start.locking_normal_pri.count",
	"admission_wait_durations_sql_root_start_locking_normal_pri_sum":      "admission.wait_durations.sql_root_start.locking_normal_pri.sum",
	"admission_wait_durations_sql_root_start_normal_pri":                  "admission.wait_durations.sql_root_start.normal_pri",
	"admission_wait_durations_sql_root_start_normal_pri_bucket":           "admission.wait_durations.sql_root_start.normal_pri.bucket",
	"admission_wait_durations_sql_root_start_normal_pri_count":            "admission.wait_durations.sql_root_start.normal_pri.count",
	"admission_wait_durations_sql_root_start_normal_pri_sum":              "admission.wait_durations.sql_root_start.normal_pri.sum",
	"admission_wait_durations_sql_root_start_sum":                         "admission.wait_durations.sql_root_start.sum",
	"admission_wait_durations_sql_sql_response":                           "admission.wait.durations.sql_sql.response",
	"admission_wait_durations_sql_sql_response_bucket":                    "admission.wait_durations.sql_sql_response.bucket",
	"admission_wait_durations_sql_sql_response_count":                     "admission.wait_durations.sql_sql_response.count",
	"admission_wait_durations_sql_sql_response_locking_normal_pri":        "admission.wait_durations.sql_sql_response.locking_normal_pri",
	"admission_wait_durations_sql_sql_response_locking_normal_pri_bucket": "admission.wait_durations.sql_sql_response.locking_normal_pri.bucket",
	"admission_wait_durations_sql_sql_response_locking_normal_pri_count":  "admission.wait_durations.sql_sql_response.locking_normal_pri.count",
	"admission_wait_durations_sql_sql_response_locking_normal_pri_sum":    "admission.wait_durations.sql_sql_response.locking_normal_pri.sum",
	"admission_wait_durations_sql_sql_response_normal_pri":                "admission.wait_durations.sql_sql_response.normal_pri",
	"admission_wait_durations_sql_sql_response_normal_pri_bucket":         "admission.wait_durations.sql_sql_response.normal_pri.bucket",
	"admission_wait_durations_sql_sql_response_normal_pri_count":          "admission.wait_durations.sql_sql_response.normal_pri.count",
	"admission_wait_durations_sql_sql_response_normal_pri_sum":            "admission.wait_durations.sql_sql_response.normal_pri.sum",
	"admission_wait_durations_sql_sql_response_sum":                       "admission.wait_durations.sql_sql_response.sum",
	"admission_wait_queue_length_elastic_cpu":                             "admission.wait_queue_length.elastic_cpu",
	"admission_wait_queue_length_elastic_cpu_bulk_normal_pri":             "admission.wait_queue_length.elastic_cpu.bulk_normal_pri",
	"admission_wait_queue_length_elastic_cpu_normal_pri":                  "admission.wait_queue_length.elastic_cpu.normal_pri",
	"admission_wait_queue_length_elastic_stores":                          "admission.wait_queue_length.elastic_stores",
	"admission_wait_queue_length_elastic_stores_bulk_normal_pri":          "admission.wait_queue_length.elastic_stores.bulk_normal_pri",
	"admission_wait_queue_length_elastic_stores_ttl_low_pri":              "admission.wait_queue_length.elastic_stores.ttl_low_pri",
	"admission_wait_queue_length_kv":                                      "admission.wait.queue.length.kv",
	"admission_wait_queue_length_kv_bulk_normal_pri":                      "admission.wait_queue_length.kv.bulk_normal_pri",
	"admission_wait_queue_length_kv_high_pri":                             "admission.wait_queue_length.kv.high_pri",
	"admission_wait_queue_length_kv_locking_normal_pri":                   "admission.wait_queue_length.kv.locking_normal_pri",
	"admission_wait_queue_length_kv_normal_pri":                           "admission.wait_queue_length.kv.normal_pri",
	"admission_wait_queue_length_kv_stores":                               "admission.wait.queue.length.kv_stores",
	"admission_wait_queue_length_kv_stores_bulk_normal_pri":               "admission.wait_queue_length.kv_stores.bulk_normal_pri",
	"admission_wait_queue_length_kv_stores_high_pri":                      "admission.wait_queue_length.kv_stores.high_pri",
	"admission_wait_queue_length_kv_stores_locking_normal_pri":            "admission.wait_queue_length.kv_stores.locking_normal_pri",
	"admission_wait_queue_length_kv_stores_normal_pri":                    "admission.wait_queue_length.kv_stores.normal_pri",
	"admission_wait_queue_length_kv_stores_ttl_low_pri":                   "admission.wait_queue_length.kv_stores.ttl_low_pri",
	"admission_wait_queue_length_sql_kv_response":                         "admission.wait.queue.length.sql_kv.response",
	"admission_wait_queue_length_sql_kv_response_locking_normal_pri":      "admission.wait_queue_length.sql_kv_response.locking_normal_pri",
	"admission_wait_queue_length_sql_kv_response_normal_pri":              "admission.wait_queue_length.sql_kv_response.normal_pri",
	"admission_wait_queue_length_sql_leaf_start":                          "admission.wait.queue.length.sql.leaf.start",
	"admission_wait_queue_length_sql_leaf_start_locking_normal_pri":       "admission.wait_queue_length.sql_leaf_start.locking_normal_pri",
	"admission_wait_queue_length_sql_leaf_start_normal_pri":               "admission.wait_queue_length.sql_leaf_start.normal_pri",
	"admission_wait_queue_length_sql_root_start":                          "admission.wait.queue.lengths.sql.root.start",
	"admission_wait_queue_length_sql_root_start_locking_normal_pri":       "admission.wait_queue_length.sql_root_start.locking_normal_pri",
	"admission_wait_queue_length_sql_root_start_normal_pri":               "admission.wait_queue_length.sql_root_start.normal_pri",
	"admission_wait_queue_length_sql_sql_response":                        "admission.wait.queue.length.sql_sql.response",
	"admission_wait_queue_length_sql_sql_response_locking_normal_pri":     "admission.wait_queue_length.sql_sql_response.locking_normal_pri",
	"admission_wait_queue_length_sql_sql_response_normal_pri":             "admission.wait_queue_length.sql_sql_response.normal_pri",
	"admission_wait_sum_kv":                                               "admission.wait.sum.kv",
	"admission_wait_sum_kv_stores":                                        "admission.wait.sum.kv_stores",
	"admission_wait_sum_sql_kv_response":                                  "admission.wait.sum.sql_kv.response",
	"admission_wait_sum_sql_root_start":                                   "admission.wait.sum.sql.root.start",
	"admission_wait_sum_sql_sql_response":                                 "admission.wait.sum.sql_sql.response",
	"auth_cert_conn_latency":                                              "auth.cert.conn.latency",
	"auth_gss_conn_latency":                                               "auth.gss.conn.latency",
	"auth_jwt_conn_latency":                                               "auth.jwt.conn.latency",
	"auth_ldap_conn_latency":                                              "auth.ldap.conn.latency",
	"auth_password_conn_latency":                                          "auth.password.conn.latency",
	"auth_scram_conn_latency":                                             "auth.scram.conn.latency",
	"backup_last_failed_time_kms_inaccessible":                            "backup.last_failed_time.kms_inaccessible",
	"batch_requests_bytes":                                                "batch_requests.bytes",
	"batch_requests_cross_region_bytes":                                   "batch_requests.cross_region.bytes",
	"batch_requests_cross_zone_bytes":                                     "batch_requests.cross_zone.bytes",
	"batch_responses_bytes":                                               "batch_responses.bytes",
	"batch_responses_cross_region_bytes":                                  "batch_responses.cross_region.bytes",
	"batch_responses_cross_zone_bytes":                                    "batch_responses.cross_zone.bytes",
	"build_timestamp":                                                     "build.timestamp",
	"capacity":                                                            "capacity.total",
	"capacity_available":                                                  "capacity.available",
	"capacity_reserved":                                                   "capacity.reserved",
	"capacity_used":                                                       "capacity.used",
	"changefeed_admit_latency":                                            "changefeed.admit.latency",
	"changefeed_admit_latency_bucket":                                     "changefeed.admit_latency.bucket",
	"changefeed_admit_latency_count":                                      "changefeed.admit_latency.count",
	"changefeed_admit_latency_sum":                                        "changefeed.admit_latency.sum",
	"changefeed_aggregator_progress":                                      "changefeed.aggregator_progress",
	"changefeed_backfill_count":                                           "changefeed.backfill",
	"changefeed_backfill_pending_ranges":                                  "changefeed.backfill.pending.ranges",
	"changefeed_batch_reduction_count":                                    "changefeed.batch_reduction_count",
	"changefeed_buffer_entries_allocated_mem":                             "changefeed.buffer_entries.allocated_mem",
	"changefeed_buffer_entries_allocated_mem_aggregator":                  "changefeed.buffer_entries.allocated_mem.aggregator",
	"changefeed_buffer_entries_allocated_mem_rangefeed":                   "changefeed.buffer_entries.allocated_mem.rangefeed",
	"changefeed_buffer_entries_flush":                                     "changefeed.buffer_entries.flush",
	"changefeed_buffer_entries_in":                                        "changefeed.buffer_entries.in",
	"changefeed_buffer_entries_in_aggregator":                             "changefeed.buffer_entries.in.aggregator",
	"changefeed_buffer_entries_in_rangefeed":                              "changefeed.buffer_entries.in.rangefeed",
	"changefeed_buffer_entries_kv":                                        "changefeed.buffer_entries.kv",
	"changefeed_buffer_entries_mem_acquired":                              "changefeed.buffer_entries_mem.acquired",
	"changefeed_buffer_entries_mem_acquired_aggregator":                   "changefeed.buffer_entries_mem.acquired.aggregator",
	"changefeed_buffer_entries_mem_acquired_rangefeed":                    "changefeed.buffer_entries_mem.acquired.rangefeed",
	"changefeed_buffer_entries_mem_released":                              "changefeed.buffer_entries_mem.released",
	"changefeed_buffer_entries_mem_released_aggregator":                   "changefeed.buffer_entries_mem.released.aggregator",
	"changefeed_buffer_entries_mem_released_rangefeed":                    "changefeed.buffer_entries_mem.released.rangefeed",
	"changefeed_buffer_entries_out":                                       "changefeed.buffer_entries.out",
	"changefeed_buffer_entries_out_aggregator":                            "changefeed.buffer_entries.out.aggregator",
	"changefeed_buffer_entries_out_rangefeed":                             "changefeed.buffer_entries.out.rangefeed",
	"changefeed_buffer_entries_released":                                  "changefeed.buffer_entries.released",
	"changefeed_buffer_entries_released_aggregator":                       "changefeed.buffer_entries.released.aggregator",
	"changefeed_buffer_entries_released_rangefeed":                        "changefeed.buffer_entries.released.rangefeed",
	"changefeed_buffer_entries_resolved":                                  "changefeed.buffer_entries.resolved",
	"changefeed_buffer_pushback_nanos":                                    "changefeed.buffer_pushback",
	"changefeed_buffer_pushback_nanos_aggregator":                         "changefeed.buffer_pushback_nanos.aggregator",
	"changefeed_buffer_pushback_nanos_rangefeed":                          "changefeed.buffer_pushback_nanos.rangefeed",
	"changefeed_bytes_messages_pushback_nanos":                            "changefeed.bytes.messages_pushback",
	"changefeed_checkpoint_hist_nanos":                                    "changefeed.checkpoint_hist",
	"changefeed_checkpoint_hist_nanos_bucket":                             "changefeed.checkpoint_hist_nanos.bucket",
	"changefeed_checkpoint_hist_nanos_count":                              "changefeed.checkpoint_hist_nanos.count",
	"changefeed_checkpoint_hist_nanos_sum":                                "changefeed.checkpoint_hist_nanos.sum",
	"changefeed_checkpoint_progress":                                      "changefeed.checkpoint_progress",
	"changefeed_cloudstorage_buffered_bytes":                              "changefeed.cloudstorage_buffered_bytes",
	"changefeed_commit_latency":                                           "changefeed.commit.latency",
	"changefeed_commit_latency_bucket":                                    "changefeed.commit_latency.bucket",
	"changefeed_commit_latency_count":                                     "changefeed.commit_latency.count",
	"changefeed_commit_latency_sum":                                       "changefeed.commit_latency.sum",
	"changefeed_emitted_batch_sizes":                                      "changefeed.emitted_batch_sizes",
	"changefeed_emitted_batch_sizes_bucket":                               "changefeed.emitted_batch_sizes.bucket",
	"changefeed_emitted_batch_sizes_count":                                "changefeed.emitted_batch_sizes.count",
	"changefeed_emitted_batch_sizes_sum":                                  "changefeed.emitted_batch_sizes.sum",
	"changefeed_emitted_bytes":                                            "changefeed.emitted_bytes",
	"changefeed_emitted_messages":                                         "changefeed.emitted.messages",
	"changefeed_error_retries":                                            "changefeed.error.retries",
	"changefeed_failures":                                                 "changefeed.failures",
	"changefeed_filtered_messages":                                        "changefeed.filtered_messages",
	"changefeed_flush_hist_nanos":                                         "changefeed.flush_hist",
	"changefeed_flush_hist_nanos_bucket":                                  "changefeed.flush_hist_nanos.bucket",
	"changefeed_flush_hist_nanos_count":                                   "changefeed.flush_hist_nanos.count",
	"changefeed_flush_hist_nanos_sum":                                     "changefeed.flush_hist_nanos.sum",
	"changefeed_flush_messages_pushback_nanos":                            "changefeed.flush.messages_pushback",
	"changefeed_flushed_bytes":                                            "changefeed.flushed_bytes",
	"changefeed_flushes":                                                  "changefeed.flushes",
	"changefeed_forwarded_resolved_messages":                              "changefeed.forwarded_resolved_messages",
	"changefeed_frontier_updates":                                         "changefeed.frontier_updates",
	"changefeed_internal_retry_message_count":                             "changefeed.internal_retry_message",
	"changefeed_kafka_throttling_hist_nanos":                              "changefeed.kafka_throttling_hist_nanos",
	"changefeed_kafka_throttling_hist_nanos_bucket":                       "changefeed.kafka_throttling_hist_nanos.bucket",
	"changefeed_kafka_throttling_hist_nanos_count":                        "changefeed.kafka_throttling_hist_nanos.count",
	"changefeed_kafka_throttling_hist_nanos_sum":                          "changefeed.kafka_throttling_hist_nanos.sum",
	"changefeed_lagging_ranges":                                           "changefeed.lagging_ranges",
	"changefeed_max_behind_nanos":                                         "changefeed.max.behind.nanos",
	"changefeed_message_size_hist":                                        "changefeed.message.size.hist",
	"changefeed_message_size_hist_bucket":                                 "changefeed.message_size_hist.bucket",
	"changefeed_message_size_hist_count":                                  "changefeed.message_size_hist.count",
	"changefeed_message_size_hist_sum":                                    "changefeed.message_size_hist.sum",
	"changefeed_messages_messages_pushback_nanos":                         "changefeed.messages.messages_pushback",
	"changefeed_nprocs_consume_event_nanos":                               "changefeed.nprocs_consume_event",
	"changefeed_nprocs_consume_event_nanos_bucket":                        "changefeed.nprocs_consume_event_nanos.bucket",
	"changefeed_nprocs_consume_event_nanos_count":                         "changefeed.nprocs_consume_event_nanos.count",
	"changefeed_nprocs_consume_event_nanos_sum":                           "changefeed.nprocs_consume_event_nanos.sum",
	"changefeed_nprocs_flush_nanos":                                       "changefeed.nprocs_flush",
	"changefeed_nprocs_flush_nanos_bucket":                                "changefeed.nprocs_flush_nanos.bucket",
	"changefeed_nprocs_flush_nanos_count":                                 "changefeed.nprocs_flush_nanos.count",
	"changefeed_nprocs_flush_nanos_sum":                                   "changefeed.nprocs_flush_nanos.sum",
	"changefeed_nprocs_in_flight_count":                                   "changefeed.nprocs_in_flight",
	"changefeed_parallel_io_in_flight_keys":                               "changefeed.parallel_io_in_flight_keys",
	"changefeed_parallel_io_pending_rows":                                 "changefeed.parallel_io_pending_rows",
	"changefeed_parallel_io_queue_nanos":                                  "changefeed.parallel_io_queue",
	"changefeed_parallel_io_queue_nanos_bucket":                           "changefeed.parallel_io_queue_nanos.bucket",
	"changefeed_parallel_io_queue_nanos_count":                            "changefeed.parallel_io_queue_nanos.count",
	"changefeed_parallel_io_queue_nanos_sum":                              "changefeed.parallel_io_queue_nanos.sum",
	"changefeed_parallel_io_result_queue_nanos":                           "changefeed.parallel_io_result_queue_nanos",
	"changefeed_parallel_io_result_queue_nanos_bucket":                    "changefeed.parallel_io_result_queue_nanos.bucket",
	"changefeed_parallel_io_result_queue_nanos_count":                     "changefeed.parallel_io_result_queue_nanos.count",
	"changefeed_parallel_io_result_queue_nanos_sum":                       "changefeed.parallel_io_result_queue_nanos.sum",
	"changefeed_queue_time_nanos":                                         "changefeed.queue_time",
	"changefeed_running":                                                  "changefeed.running",
	"changefeed_schema_registry_registrations":                            "changefeed.schema_registry.registrations",
	"changefeed_schema_registry_retry_count":                              "changefeed.schema_registry.retry",
	"changefeed_schemafeed_table_history_scans":                           "changefeed.schemafeed.table_history_scans",
	"changefeed_schemafeed_table_metadata_nanos":                          "changefeed.schemafeed.table_metadata",
	"changefeed_sink_batch_hist_nanos":                                    "changefeed.sink_batch_hist",
	"changefeed_sink_batch_hist_nanos_bucket":                             "changefeed.sink_batch_hist_nanos.bucket",
	"changefeed_sink_batch_hist_nanos_count":                              "changefeed.sink_batch_hist_nanos.count",
	"changefeed_sink_batch_hist_nanos_sum":                                "changefeed.sink_batch_hist_nanos.sum",
	"changefeed_sink_io_inflight":                                         "changefeed.sink_io_inflight",
	"changefeed_size_based_flushes":                                       "changefeed.size_based_flushes",
	"clock_offset_meannanos":                                              "clock.offset.meannanos",
	"clock_offset_stddevnanos":                                            "clock.offset.stddevnanos",
	"cloud_conns_opened":                                                  "cloud.conns_opened",
	"cloud_conns_reused":                                                  "cloud.conns_reused",
	"cloud_listing_results":                                               "cloud.listing_results",
	"cloud_listings":                                                      "cloud.listings",
	"cloud_open_readers":                                                  "cloud.open_readers",
	"cloud_open_writers":                                                  "cloud.open_writers",
	"cloud_read_bytes":                                                    "cloud.read_bytes",
	"cloud_readers_opened":                                                "cloud.readers_opened",
	"cloud_tls_handshakes":                                                "cloud.tls_handshakes",
	"cloud_write_bytes":                                                   "cloud.write_bytes",
	"cloud_writers_opened":                                                "cloud.writers_opened",
	"cluster_preserve_downgrade_option_last_updated":                      "cluster.preserve_downgrade_option.last_updated",
	"compactor_compactingnanos":                                           "compactor.compactingnanos",
	"compactor_compactions_failure":                                       "compactor.compactions.failure",
	"compactor_compactions_success":                                       "compactor.compactions.success",
	"compactor_suggestionbytes_compacted":                                 "compactor.suggestionbytes.compacted",
	"compactor_suggestionbytes_queued":                                    "compactor.suggestionbytes.queued",
	"compactor_suggestionbytes_skipped":                                   "compactor.suggestionbytes.skipped",
	"distsender_batch_requests_cross_region_bytes":                        "distsender.batch_requests.cross_region.bytes",
	"distsender_batch_requests_cross_zone_bytes":                          "distsender.batch_requests.cross_zone.bytes",
	"distsender_batch_requests_replica_addressed_bytes":                   "distsender.batch_requests.replica_addressed.bytes",
	"distsender_batch_responses_cross_region_bytes":                       "distsender.batch_responses.cross_region.bytes",
	"distsender_batch_responses_cross_zone_bytes":                         "distsender.batch_responses.cross_zone.bytes",
	"distsender_batch_responses_replica_addressed_bytes":                  "distsender.batch_responses.replica_addressed.bytes",
	"distsender_batches":                                                  "distsender.batches.total",
	"distsender_batches_async_in_progress":                                "distsender.batches.async.in_progress",
	"distsender_batches_async_sent":                                       "distsender.batches.async.sent",
	"distsender_batches_async_throttled":                                  "distsender.batches.async.throttled",
	"distsender_batches_async_throttled_cumulative_duration_nanos":        "distsender.batches.async.throttled_cumulative_duration_nanos",
	"distsender_batches_partial":                                          "distsender.batches.partial",
	"distsender_circuit_breaker_replicas_count":                           "distsender.circuit_breaker.replicas.count",
	"distsender_circuit_breaker_replicas_probes_failure":                  "distsender.circuit_breaker.replicas.probes.failure",
	"distsender_circuit_breaker_replicas_probes_running":                  "distsender.circuit_breaker.replicas.probes.running",
	"distsender_circuit_breaker_replicas_probes_success":                  "distsender.circuit_breaker.replicas.probes.success",
	"distsender_circuit_breaker_replicas_requests_cancelled":              "distsender.circuit_breaker.replicas.requests.cancelled",
	"distsender_circuit_breaker_replicas_requests_rejected":               "distsender.circuit_breaker.replicas.requests.rejected",
	"distsender_circuit_breaker_replicas_tripped":                         "distsender.circuit_breaker.replicas.tripped",
	"distsender_circuit_breaker_replicas_tripped_events":                  "distsender.circuit_breaker.replicas.tripped_events",
	"distsender_errors_inleasetransferbackoffs":                           "distsender.errors.inleasetransferbackoffs",
	"distsender_errors_notleaseholder":                                    "distsender.errors.notleaseholder",
	"distsender_rangefeed_catchup_ranges":                                 "distsender.rangefeed.catchup_ranges",
	"distsender_rangefeed_error_catchup_ranges":                           "distsender.rangefeed.error_catchup_ranges",
	"distsender_rangefeed_local_ranges":                                   "distsender.rangefeed.local_ranges",
	"distsender_rangefeed_restart_ranges":                                 "distsender.rangefeed.restart_ranges",
	"distsender_rangefeed_retry_logical_ops_missing":                      "distsender.rangefeed.retry.logical_ops_missing",
	"distsender_rangefeed_retry_manual_range_split":                       "distsender.rangefeed.retry.manual_range_split",
	"distsender_rangefeed_retry_no_leaseholder":                           "distsender.rangefeed.retry.no_leaseholder",
	"distsender_rangefeed_retry_node_not_found":                           "distsender.rangefeed.retry.node_not_found",
	"distsender_rangefeed_retry_raft_snapshot":                            "distsender.rangefeed.retry.raft_snapshot",
	"distsender_rangefeed_retry_range_key_mismatch":                       "distsender.rangefeed.retry.range_key_mismatch",
	"distsender_rangefeed_retry_range_merged":                             "distsender.rangefeed.retry.range_merged",
	"distsender_rangefeed_retry_range_not_found":                          "distsender.rangefeed.retry.range_not_found",
	"distsender_rangefeed_retry_range_split":                              "distsender.rangefeed.retry.range_split",
	"distsender_rangefeed_retry_rangefeed_closed":                         "distsender.rangefeed.retry.rangefeed_closed",
	"distsender_rangefeed_retry_replica_removed":                          "distsender.rangefeed.retry.replica_removed",
	"distsender_rangefeed_retry_send":                                     "distsender.rangefeed.retry.send",
	"distsender_rangefeed_retry_slow_consumer":                            "distsender.rangefeed.retry.slow_consumer",
	"distsender_rangefeed_retry_store_not_found":                          "distsender.rangefeed.retry.store_not_found",
	"distsender_rangefeed_retry_stuck":                                    "distsender.rangefeed.retry.stuck",
	"distsender_rangefeed_total_ranges":                                   "distsender.rangefeed.total_ranges",
	"distsender_rangelookups":                                             "distsender.rangelookups",
	"distsender_rpc_addsstable_sent":                                      "distsender.rpc.addsstable.sent",
	"distsender_rpc_adminchangereplicas_sent":                             "distsender.rpc.adminchangereplicas.sent",
	"distsender_rpc_adminmerge_sent":                                      "distsender.rpc.adminmerge.sent",
	"distsender_rpc_adminrelocaterange_sent":                              "distsender.rpc.adminrelocaterange.sent",
	"distsender_rpc_adminscatter_sent":                                    "distsender.rpc.adminscatter.sent",
	"distsender_rpc_adminsplit_sent":                                      "distsender.rpc.adminsplit.sent",
	"distsender_rpc_admintransferlease_sent":                              "distsender.rpc.admintransferlease.sent",
	"distsender_rpc_adminunsplit_sent":                                    "distsender.rpc.adminunsplit.sent",
	"distsender_rpc_adminverifyprotectedtimestamp_sent":                   "distsender.rpc.adminverifyprotectedtimestamp.sent",
	"distsender_rpc_barrier_sent":                                         "distsender.rpc.barrier.sent",
	"distsender_rpc_checkconsistency_sent":                                "distsender.rpc.checkconsistency.sent",
	"distsender_rpc_clearrange_sent":                                      "distsender.rpc.clearrange.sent",
	"distsender_rpc_computechecksum_sent":                                 "distsender.rpc.computechecksum.sent",
	"distsender_rpc_conditionalput_sent":                                  "distsender.rpc.conditionalput.sent",
	"distsender_rpc_delete_sent":                                          "distsender.rpc.delete.sent",
	"distsender_rpc_deleterange_sent":                                     "distsender.rpc.deleterange.sent",
	"distsender_rpc_endtxn_sent":                                          "distsender.rpc.endtxn.sent",
	"distsender_rpc_err_ambiguousresulterrtype":                           "distsender.rpc.err.ambiguousresulterrtype",
	"distsender_rpc_err_batchtimestampbeforegcerrtype":                    "distsender.rpc.err.batchtimestampbeforegcerrtype",
	"distsender_rpc_err_communicationerrtype":                             "distsender.rpc.err.communicationerrtype",
	"distsender_rpc_err_conditionfailederrtype":                           "distsender.rpc.err.conditionfailederrtype",
	"distsender_rpc_err_errordetailtype_0_":                               "distsender.rpc.err.errordetailtype_0_",
	"distsender_rpc_err_errordetailtype_15_":                              "distsender.rpc.err.errordetailtype_15_",
	"distsender_rpc_err_errordetailtype_19_":                              "distsender.rpc.err.errordetailtype_19_",
	"distsender_rpc_err_errordetailtype_20_":                              "distsender.rpc.err.errordetailtype_20_",
	"distsender_rpc_err_errordetailtype_21_":                              "distsender.rpc.err.errordetailtype_21_",
	"distsender_rpc_err_errordetailtype_23_":                              "distsender.rpc.err.errordetailtype_23_",
	"distsender_rpc_err_errordetailtype_24_":                              "distsender.rpc.err.errordetailtype_24_",
	"distsender_rpc_err_errordetailtype_29_":                              "distsender.rpc.err.errordetailtype_29_",
	"distsender_rpc_err_errordetailtype_30_":                              "distsender.rpc.err.errordetailtype_30_",
	"distsender_rpc_err_errordetailtype_33_":                              "distsender.rpc.err.errordetailtype_33_",
	"distsender_rpc_err_indeterminatecommiterrtype":                       "distsender.rpc.err.indeterminatecommiterrtype",
	"distsender_rpc_err_integeroverflowerrtype":                           "distsender.rpc.err.integeroverflowerrtype",
	"distsender_rpc_err_intentmissingerrtype":                             "distsender.rpc.err.intentmissingerrtype",
	"distsender_rpc_err_internalerrtype":                                  "distsender.rpc.err.internalerrtype",
	"distsender_rpc_err_invalidleaseerrtype":                              "distsender.rpc.err.invalidleaseerrtype",
	"distsender_rpc_err_leaserejectederrtype":                             "distsender.rpc.err.leaserejectederrtype",
	"distsender_rpc_err_lockconflicterrtype":                              "distsender.rpc.err.lockconflicterrtype",
	"distsender_rpc_err_mergeinprogresserrtype":                           "distsender.rpc.err.mergeinprogresserrtype",
	"distsender_rpc_err_mintimestampboundunsatisfiableerrtype":            "distsender.rpc.err.mintimestampboundunsatisfiableerrtype",
	"distsender_rpc_err_mvcchistorymutationerrtype":                       "distsender.rpc.err.mvcchistorymutationerrtype",
	"distsender_rpc_err_nodeunavailableerrtype":                           "distsender.rpc.err.nodeunavailableerrtype",
	"distsender_rpc_err_notleaseholdererrtype":                            "distsender.rpc.err.notleaseholdererrtype",
	"distsender_rpc_err_oprequirestxnerrtype":                             "distsender.rpc.err.oprequirestxnerrtype",
	"distsender_rpc_err_optimisticevalconflictserrtype":                   "distsender.rpc.err.optimisticevalconflictserrtype",
	"distsender_rpc_err_proxyfailederrtype":                               "distsender.rpc.err.proxyfailederrtype",
	"distsender_rpc_err_raftgroupdeletederrtype":                          "distsender.rpc.err.raftgroupdeletederrtype",
	"distsender_rpc_err_rangefeedretryerrtype":                            "distsender.rpc.err.rangefeedretryerrtype",
	"distsender_rpc_err_rangekeymismatcherrtype":                          "distsender.rpc.err.rangekeymismatcherrtype",
	"distsender_rpc_err_rangenotfounderrtype":                             "distsender.rpc.err.rangenotfounderrtype",
	"distsender_rpc_err_readwithinuncertaintyintervalerrtype":             "distsender.rpc.err.readwithinuncertaintyintervalerrtype",
	"distsender_rpc_err_refreshfailederrtype":                             "distsender.rpc.err.refreshfailederrtype",
	"distsender_rpc_err_replicacorruptionerrtype":                         "distsender.rpc.err.replicacorruptionerrtype",
	"distsender_rpc_err_replicatooolderrtype":                             "distsender.rpc.err.replicatooolderrtype",
	"distsender_rpc_err_replicaunavailableerrtype":                        "distsender.rpc.err.replicaunavailableerrtype",
	"distsender_rpc_err_storenotfounderrtype":                             "distsender.rpc.err.storenotfounderrtype",
	"distsender_rpc_err_transactionabortederrtype":                        "distsender.rpc.err.transactionabortederrtype",
	"distsender_rpc_err_transactionpusherrtype":                           "distsender.rpc.err.transactionpusherrtype",
	"distsender_rpc_err_transactionretryerrtype":                          "distsender.rpc.err.transactionretryerrtype",
	"distsender_rpc_err_transactionretrywithprotorefresherrtype":          "distsender.rpc.err.transactionretrywithprotorefresherrtype",
	"distsender_rpc_err_transactionstatuserrtype":                         "distsender.rpc.err.transactionstatuserrtype",
	"distsender_rpc_err_txnalreadyencounterederrtype":                     "distsender.rpc.err.txnalreadyencounterederrtype",
	"distsender_rpc_err_unsupportedrequesterrtype":                        "distsender.rpc.err.unsupportedrequesterrtype",
	"distsender_rpc_err_writeintenterrtype":                               "distsender.rpc.err.writeintenterrtype",
	"distsender_rpc_err_writetooolderrtype":                               "distsender.rpc.err.writetooolderrtype",
	"distsender_rpc_export_sent":                                          "distsender.rpc.export.sent",
	"distsender_rpc_gc_sent":                                              "distsender.rpc.gc.sent",
	"distsender_rpc_get_sent":                                             "distsender.rpc.get.sent",
	"distsender_rpc_heartbeattxn_sent":                                    "distsender.rpc.heartbeattxn.sent",
	"distsender_rpc_increment_sent":                                       "distsender.rpc.increment.sent",
	"distsender_rpc_initput_sent":                                         "distsender.rpc.initput.sent",
	"distsender_rpc_isspanempty_sent":                                     "distsender.rpc.isspanempty.sent",
	"distsender_rpc_leaseinfo_sent":                                       "distsender.rpc.leaseinfo.sent",
	"distsender_rpc_linkexternalsstable_sent":                             "distsender.rpc.linkexternalsstable.sent",
	"distsender_rpc_merge_sent":                                           "distsender.rpc.merge.sent",
	"distsender_rpc_migrate_sent":                                         "distsender.rpc.migrate.sent",
	"distsender_rpc_probe_sent":                                           "distsender.rpc.probe.sent",
	"distsender_rpc_proxy_err":                                            "distsender.rpc.proxy.err",
	"distsender_rpc_proxy_forward_err":                                    "distsender.rpc.proxy.forward.err",
	"distsender_rpc_proxy_forward_sent":                                   "distsender.rpc.proxy.forward.sent",
	"distsender_rpc_proxy_sent":                                           "distsender.rpc.proxy.sent",
	"distsender_rpc_pushtxn_sent":                                         "distsender.rpc.pushtxn.sent",
	"distsender_rpc_put_sent":                                             "distsender.rpc.put.sent",
	"distsender_rpc_queryintent_sent":                                     "distsender.rpc.queryintent.sent",
	"distsender_rpc_querylocks_sent":                                      "distsender.rpc.querylocks.sent",
	"distsender_rpc_queryresolvedtimestamp_sent":                          "distsender.rpc.queryresolvedtimestamp.sent",
	"distsender_rpc_querytxn_sent":                                        "distsender.rpc.querytxn.sent",
	"distsender_rpc_rangestats_sent":                                      "distsender.rpc.rangestats.sent",
	"distsender_rpc_recomputestats_sent":                                  "distsender.rpc.recomputestats.sent",
	"distsender_rpc_recovertxn_sent":                                      "distsender.rpc.recovertxn.sent",
	"distsender_rpc_refresh_sent":                                         "distsender.rpc.refresh.sent",
	"distsender_rpc_refreshrange_sent":                                    "distsender.rpc.refreshrange.sent",
	"distsender_rpc_requestlease_sent":                                    "distsender.rpc.requestlease.sent",
	"distsender_rpc_resolveintent_sent":                                   "distsender.rpc.resolveintent.sent",
	"distsender_rpc_resolveintentrange_sent":                              "distsender.rpc.resolveintentrange.sent",
	"distsender_rpc_reversescan_sent":                                     "distsender.rpc.reversescan.sent",
	"distsender_rpc_revertrange_sent":                                     "distsender.rpc.revertrange.sent",
	"distsender_rpc_scan_sent":                                            "distsender.rpc.scan.sent",
	"distsender_rpc_sent":                                                 "distsender.rpc.sent.total",
	"distsender_rpc_sent_local":                                           "distsender.rpc.sent.local",
	"distsender_rpc_sent_nextreplicaerror":                                "distsender.rpc.sent.nextreplicaerror",
	"distsender_rpc_subsume_sent":                                         "distsender.rpc.subsume.sent",
	"distsender_rpc_transferlease_sent":                                   "distsender.rpc.transferlease.sent",
	"distsender_rpc_truncatelog_sent":                                     "distsender.rpc.truncatelog.sent",
	"distsender_rpc_writebatch_sent":                                      "distsender.rpc.writebatch.sent",
	"distsender_slow_replicarpcs":                                         "distsender.slow.replicarpcs",
	"exec_error":                                                          "exec.error",
	"exec_latency":                                                        "exec.latency",
	"exec_latency_bucket":                                                 "exec.latency.bucket",
	"exec_latency_count":                                                  "exec.latency.count",
	"exec_latency_sum":                                                    "exec.latency.sum",
	"exec_success":                                                        "exec.success",
	"exportrequest_delay_total":                                           "exportrequest.delay.total",
	"follower_reads_success_count":                                        "follower_reads.success_count",
	"gcbytesage":                                                          "gcbytesage",
	"go_scheduler_latency":                                                "go.scheduler_latency",
	"go_scheduler_latency_bucket":                                         "go.scheduler_latency.bucket",
	"go_scheduler_latency_count":                                          "go.scheduler_latency.count",
	"go_scheduler_latency_sum":                                            "go.scheduler_latency.sum",
	"gossip_bytes_received":                                               "gossip.bytes.received",
	"gossip_bytes_sent":                                                   "gossip.bytes.sent",
	"gossip_connections_incoming":                                         "gossip.connections.incoming",
	"gossip_connections_outgoing":                                         "gossip.connections.outgoing",
	"gossip_connections_refused":                                          "gossip.connections.refused",
	"gossip_infos_received":                                               "gossip.infos.received",
	"gossip_infos_sent":                                                   "gossip.infos.sent",
	"intentage":                                                           "intentage",
	"intentbytes":                                                         "intentbytes",
	"intentcount":                                                         "intentcount",
	"intentresolver_async_throttled":                                      "intentresolver.async.throttled",
	"intentresolver_finalized_txns_failed":                                "intentresolver.finalized_txns.failed",
	"intentresolver_intents_failed":                                       "intentresolver.intents.failed",
	"intents_abort_attempts":                                              "intents.abort_attempts",
	"intents_poison_attempts":                                             "intents.poison_attempts",
	"intents_resolve_attempts":                                            "intents.resolve_attempts",
	"jobs_adopt_iterations":                                               "jobs.adopt_iterations",
	"jobs_auto_config_env_runner_currently_idle":                          "jobs.auto_config_env_runner.currently_idle",
	"jobs_auto_config_env_runner_currently_paused":                        "jobs.auto_config_env_runner.currently_paused",
	"jobs_auto_config_env_runner_currently_running":                       "jobs.auto_config_env_runner.currently_running",
	"jobs_auto_config_env_runner_expired_pts_records":                     "jobs.auto_config_env_runner.expired_pts_records",
	"jobs_auto_config_env_runner_fail_or_cancel_completed":                "jobs.auto_config_env_runner.fail_or_cancel_completed",
	"jobs_auto_config_env_runner_fail_or_cancel_failed":                   "jobs.auto_config_env_runner.fail_or_cancel_failed",
	"jobs_auto_config_env_runner_fail_or_cancel_retry_error":              "jobs.auto_config_env_runner.fail_or_cancel_retry_error",
	"jobs_auto_config_env_runner_protected_age_sec":                       "jobs.auto_config_env_runner.protected_age_sec",
	"jobs_auto_config_env_runner_protected_record_count":                  "jobs.auto_config_env_runner.protected_record_count",
	"jobs_auto_config_env_runner_resume_completed":                        "jobs.auto_config_env_runner.resume_completed",
	"jobs_auto_config_env_runner_resume_failed":                           "jobs.auto_config_env_runner.resume_failed",
	"jobs_auto_config_env_runner_resume_retry_error":                      "jobs.auto_config_env_runner.resume_retry_error",
	"jobs_auto_config_runner_currently_idle":                              "jobs.auto_config_runner.currently_idle",
	"jobs_auto_config_runner_currently_paused":                            "jobs.auto_config_runner.currently_paused",
	"jobs_auto_config_runner_currently_running":                           "jobs.auto_config_runner.currently_running",
	"jobs_auto_config_runner_expired_pts_records":                         "jobs.auto_config_runner.expired_pts_records",
	"jobs_auto_config_runner_fail_or_cancel_completed":                    "jobs.auto_config_runner.fail_or_cancel_completed",
	"jobs_auto_config_runner_fail_or_cancel_failed":                       "jobs.auto_config_runner.fail_or_cancel_failed",
	"jobs_auto_config_runner_fail_or_cancel_retry_error":                  "jobs.auto_config_runner.fail_or_cancel_retry_error",
	"jobs_auto_config_runner_protected_age_sec":                           "jobs.auto_config_runner.protected_age_sec",
	"jobs_auto_config_runner_protected_record_count":                      "jobs.auto_config_runner.protected_record_count",
	"jobs_auto_config_runner_resume_completed":                            "jobs.auto_config_runner.resume_completed",
	"jobs_auto_config_runner_resume_failed":                               "jobs.auto_config_runner.resume_failed",
	"jobs_auto_config_runner_resume_retry_error":                          "jobs.auto_config_runner.resume_retry_error",
	"jobs_auto_config_task_currently_idle":                                "jobs.auto_config_task.currently_idle",
	"jobs_auto_config_task_currently_paused":                              "jobs.auto_config_task.currently_paused",
	"jobs_auto_config_task_currently_running":                             "jobs.auto_config_task.currently_running",
	"jobs_auto_config_task_expired_pts_records":                           "jobs.auto_config_task.expired_pts_records",
	"jobs_auto_config_task_fail_or_cancel_completed":                      "jobs.auto_config_task.fail_or_cancel_completed",
	"jobs_auto_config_task_fail_or_cancel_failed":                         "jobs.auto_config_task.fail_or_cancel_failed",
	"jobs_auto_config_task_fail_or_cancel_retry_error":                    "jobs.auto_config_task.fail_or_cancel_retry_error",
	"jobs_auto_config_task_protected_age_sec":                             "jobs.auto_config_task.protected_age_sec",
	"jobs_auto_config_task_protected_record_count":                        "jobs.auto_config_task.protected_record_count",
	"jobs_auto_config_task_resume_completed":                              "jobs.auto_config_task.resume_completed",
	"jobs_auto_config_task_resume_failed":                                 "jobs.auto_config_task.resume_failed",
	"jobs_auto_config_task_resume_retry_error":                            "jobs.auto_config_task.resume_retry_error",
	"jobs_auto_create_stats_currently_idle":                               "jobs.auto_create_stats.currently_idle",
	"jobs_auto_create_stats_currently_paused":                             "jobs.auto.create.stats.currently_paused",
	"jobs_auto_create_stats_currently_running":                            "jobs.auto.create.stats.currently_running",
	"jobs_auto_create_stats_expired_pts_records":                          "jobs.auto_create_stats.expired_pts_records",
	"jobs_auto_create_stats_fail_or_cancel_completed":                     "jobs.auto_create_stats.fail_or_cancel_completed",
	"jobs_auto_create_stats_fail_or_cancel_failed":                        "jobs.auto_create_stats.fail_or_cancel_failed",
	"jobs_auto_create_stats_fail_or_cancel_retry_error":                   "jobs.auto_create_stats.fail_or_cancel_retry_error",
	"jobs_auto_create_stats_protected_age_sec":                            "jobs.auto_create_stats.protected_age_sec",
	"jobs_auto_create_stats_protected_record_count":                       "jobs.auto_create_stats.protected_record_count",
	"jobs_auto_create_stats_resume_completed":                             "jobs.auto_create_stats.resume_completed",
	"jobs_auto_create_stats_resume_failed":                                "jobs.auto.create.stats.resume_failed",
	"jobs_auto_create_stats_resume_retry_error":                           "jobs.auto_create_stats.resume_retry_error",
	"jobs_auto_schema_telemetry_currently_idle":                           "jobs.auto_schema_telemetry.currently_idle",
	"jobs_auto_schema_telemetry_currently_paused":                         "jobs.auto_schema_telemetry.currently_paused",
	"jobs_auto_schema_telemetry_currently_running":                        "jobs.auto_schema_telemetry.currently_running",
	"jobs_auto_schema_telemetry_expired_pts_records":                      "jobs.auto_schema_telemetry.expired_pts_records",
	"jobs_auto_schema_telemetry_fail_or_cancel_completed":                 "jobs.auto_schema_telemetry.fail_or_cancel_completed",
	"jobs_auto_schema_telemetry_fail_or_cancel_failed":                    "jobs.auto_schema_telemetry.fail_or_cancel_failed",
	"jobs_auto_schema_telemetry_fail_or_cancel_retry_error":               "jobs.auto_schema_telemetry.fail_or_cancel_retry_error",
	"jobs_auto_schema_telemetry_protected_age_sec":                        "jobs.auto_schema_telemetry.protected_age_sec",
	"jobs_auto_schema_telemetry_protected_record_count":                   "jobs.auto_schema_telemetry.protected_record_count",
	"jobs_auto_schema_telemetry_resume_completed":                         "jobs.auto_schema_telemetry.resume_completed",
	"jobs_auto_schema_telemetry_resume_failed":                            "jobs.auto_schema_telemetry.resume_failed",
	"jobs_auto_schema_telemetry_resume_retry_error":                       "jobs.auto_schema_telemetry.resume_retry_error",
	"jobs_auto_span_config_reconciliation_currently_idle":                 "jobs.auto_span_config_reconciliation.currently_idle",
	"jobs_auto_span_config_reconciliation_currently_paused":               "jobs.auto_span_config_reconciliation.currently_paused",
	"jobs_auto_span_config_reconciliation_currently_running":              "jobs.auto_span_config_reconciliation.currently_running",
	"jobs_auto_span_config_reconciliation_expired_pts_records":            "jobs.auto_span_config_reconciliation.expired_pts_records",
	"jobs_auto_span_config_reconciliation_fail_or_cancel_completed":       "jobs.auto_span_config_reconciliation.fail_or_cancel_completed",
	"jobs_auto_span_config_reconciliation_fail_or_cancel_failed":          "jobs.auto_span_config_reconciliation.fail_or_cancel_failed",
	"jobs_auto_span_config_reconciliation_fail_or_cancel_retry_error":     "jobs.auto_span_config_reconciliation.fail_or_cancel_retry_error",
	"jobs_auto_span_config_reconciliation_protected_age_sec":              "jobs.auto_span_config_reconciliation.protected_age_sec",
	"jobs_auto_span_config_reconciliation_protected_record_count":         "jobs.auto_span_config_reconciliation.protected_record_count",
	"jobs_auto_span_config_reconciliation_resume_completed":               "jobs.auto_span_config_reconciliation.resume_completed",
	"jobs_auto_span_config_reconciliation_resume_failed":                  "jobs.auto_span_config_reconciliation.resume_failed",
	"jobs_auto_span_config_reconciliation_resume_retry_error":             "jobs.auto_span_config_reconciliation.resume_retry_error",
	"jobs_auto_sql_stats_compaction_currently_idle":                       "jobs.auto_sql_stats_compaction.currently_idle",
	"jobs_auto_sql_stats_compaction_currently_paused":                     "jobs.auto_sql_stats_compaction.currently_paused",
	"jobs_auto_sql_stats_compaction_currently_running":                    "jobs.auto_sql_stats_compaction.currently_running",
	"jobs_auto_sql_stats_compaction_expired_pts_records":                  "jobs.auto_sql_stats_compaction.expired_pts_records",
	"jobs_auto_sql_stats_compaction_fail_or_cancel_completed":             "jobs.auto_sql_stats_compaction.fail_or_cancel_completed",
	"jobs_auto_sql_stats_compaction_fail_or_cancel_failed":                "jobs.auto_sql_stats_compaction.fail_or_cancel_failed",
	"jobs_auto_sql_stats_compaction_fail_or_cancel_retry_error":           "jobs.auto_sql_stats_compaction.fail_or_cancel_retry_error",
	"jobs_auto_sql_stats_compaction_protected_age_sec":                    "jobs.auto_sql_stats_compaction.protected_age_sec",
	"jobs_auto_sql_stats_compaction_protected_record_count":               "jobs.auto_sql_stats_compaction.protected_record_count",
	"jobs_auto_sql_stats_compaction_resume_completed":                     "jobs.auto_sql_stats_compaction.resume_completed",
	"jobs_auto_sql_stats_compaction_resume_failed":                        "jobs.auto_sql_stats_compaction.resume_failed",
	"jobs_auto_sql_stats_compaction_resume_retry_error":                   "jobs.auto_sql_stats_compaction.resume_retry_error",
	"jobs_auto_update_sql_activity_currently_idle":                        "jobs.auto_update_sql_activity.currently_idle",
	"jobs_auto_update_sql_activity_currently_paused":                      "jobs.auto_update_sql_activity.currently_paused",
	"jobs_auto_update_sql_activity_currently_running":                     "jobs.auto_update_sql_activity.currently_running",
	"jobs_auto_update_sql_activity_expired_pts_records":                   "jobs.auto_update_sql_activity.expired_pts_records",
	"jobs_auto_update_sql_activity_fail_or_cancel_completed":              "jobs.auto_update_sql_activity.fail_or_cancel_completed",
	"jobs_auto_update_sql_activity_fail_or_cancel_failed":                 "jobs.auto_update_sql_activity.fail_or_cancel_failed",
	"jobs_auto_update_sql_activity_fail_or_cancel_retry_error":            "jobs.auto_update_sql_activity.fail_or_cancel_retry_error",
	"jobs_auto_update_sql_activity_protected_age_sec":                     "jobs.auto_update_sql_activity.protected_age_sec",
	"jobs_auto_update_sql_activity_protected_record_count":                "jobs.auto_update_sql_activity.protected_record_count",
	"jobs_auto_update_sql_activity_resume_completed":                      "jobs.auto_update_sql_activity.resume_completed",
	"jobs_auto_update_sql_activity_resume_failed":                         "jobs.auto_update_sql_activity.resume_failed",
	"jobs_auto_update_sql_activity_resume_retry_error":                    "jobs.auto_update_sql_activity.resume_retry_error",
	"jobs_backup_currently_idle":                                          "jobs.backup.currently_idle",
	"jobs_backup_currently_paused":                                        "jobs.backup.currently_paused",
	"jobs_backup_currently_running":                                       "jobs.backup.currently_running",
	"jobs_backup_expired_pts_records":                                     "jobs.backup.expired_pts_records",
	"jobs_backup_fail_or_cancel_completed":                                "jobs.backup.fail_or_cancel_completed",
	"jobs_backup_fail_or_cancel_failed":                                   "jobs.backup.fail_or_cancel_failed",
	"jobs_backup_fail_or_cancel_retry_error":                              "jobs.backup.fail_or_cancel_retry_error",
	"jobs_backup_protected_age_sec":                                       "jobs.backup.protected_age_sec",
	"jobs_backup_protected_record_count":                                  "jobs.backup.protected_record_count",
	"jobs_backup_resume_completed":                                        "jobs.backup.resume_completed",
	"jobs_backup_resume_failed":                                           "jobs.backup.resume_failed",
	"jobs_backup_resume_retry_error":                                      "jobs.backup.resume_retry_error",
	"jobs_changefeed_currently_idle":                                      "jobs.changefeed.currently_idle",
	"jobs_changefeed_currently_paused":                                    "jobs.changefeed.currently_paused",
	"jobs_changefeed_currently_running":                                   "jobs.changefeed.currently_running",
	"jobs_changefeed_expired_pts_records":                                 "jobs.changefeed.expired_pts_records",
	"jobs_changefeed_fail_or_cancel_completed":                            "jobs.changefeed.fail_or_cancel_completed",
	"jobs_changefeed_fail_or_cancel_failed":                               "jobs.changefeed.fail_or_cancel_failed",
	"jobs_changefeed_fail_or_cancel_retry_error":                          "jobs.changefeed.fail_or_cancel_retry_error",
	"jobs_changefeed_protected_age_sec":                                   "jobs.changefeed.protected_age_sec",
	"jobs_changefeed_protected_record_count":                              "jobs.changefeed.protected_record_count",
	"jobs_changefeed_resume_completed":                                    "jobs.changefeed.resume_completed",
	"jobs_changefeed_resume_failed":                                       "jobs.changefeed.resume_failed",
	"jobs_changefeed_resume_retry_error":                                  "jobs.changefeed.resume.retry.error",
	"jobs_claimed_jobs":                                                   "jobs.claimed_jobs",
	"jobs_create_stats_currently_idle":                                    "jobs.create_stats.currently_idle",
	"jobs_create_stats_currently_paused":                                  "jobs.create_stats.currently_paused",
	"jobs_create_stats_currently_running":                                 "jobs.create.stats.currently_running",
	"jobs_create_stats_expired_pts_records":                               "jobs.create_stats.expired_pts_records",
	"jobs_create_stats_fail_or_cancel_completed":                          "jobs.create_stats.fail_or_cancel_completed",
	"jobs_create_stats_fail_or_cancel_failed":                             "jobs.create_stats.fail_or_cancel_failed",
	"jobs_create_stats_fail_or_cancel_retry_error":                        "jobs.create_stats.fail_or_cancel_retry_error",
	"jobs_create_stats_protected_age_sec":                                 "jobs.create_stats.protected_age_sec",
	"jobs_create_stats_protected_record_count":                            "jobs.create_stats.protected_record_count",
	"jobs_create_stats_resume_completed":                                  "jobs.create_stats.resume_completed",
	"jobs_create_stats_resume_failed":                                     "jobs.create_stats.resume_failed",
	"jobs_create_stats_resume_retry_error":                                "jobs.create_stats.resume_retry_error",
	"jobs_history_retention_currently_idle":                               "jobs.history_retention.currently_idle",
	"jobs_history_retention_currently_paused":                             "jobs.history_retention.currently_paused",
	"jobs_history_retention_currently_running":                            "jobs.history_retention.currently_running",
	"jobs_history_retention_expired_pts_records":                          "jobs.history_retention.expired_pts_records",
	"jobs_history_retention_fail_or_cancel_completed":                     "jobs.history_retention.fail_or_cancel_completed",
	"jobs_history_retention_fail_or_cancel_failed":                        "jobs.history_retention.fail_or_cancel_failed",
	"jobs_history_retention_fail_or_cancel_retry_error":                   "jobs.history_retention.fail_or_cancel_retry_error",
	"jobs_history_retention_protected_age_sec":                            "jobs.history_retention.protected_age_sec",
	"jobs_history_retention_protected_record_count":                       "jobs.history_retention.protected_record_count",
	"jobs_history_retention_resume_completed":                             "jobs.history_retention.resume_completed",
	"jobs_history_retention_resume_failed":                                "jobs.history_retention.resume_failed",
	"jobs_history_retention_resume_retry_error":                           "jobs.history_retention.resume_retry_error",
	"jobs_import_currently_idle":                                          "jobs.import.currently_idle",
	"jobs_import_currently_paused":                                        "jobs.import.currently_paused",
	"jobs_import_currently_running":                                       "jobs.import.currently_running",
	"jobs_import_expired_pts_records":                                     "jobs.import.expired_pts_records",
	"jobs_import_fail_or_cancel_completed":                                "jobs.import.fail_or_cancel_completed",
	"jobs_import_fail_or_cancel_failed":                                   "jobs.import.fail_or_cancel_failed",
	"jobs_import_fail_or_cancel_retry_error":                              "jobs.import.fail_or_cancel_retry_error",
	"jobs_import_protected_age_sec":                                       "jobs.import.protected_age_sec",
	"jobs_import_protected_record_count":                                  "jobs.import.protected_record_count",
	"jobs_import_resume_completed":                                        "jobs.import.resume_completed",
	"jobs_import_resume_failed":                                           "jobs.import.resume_failed",
	"jobs_import_resume_retry_error":                                      "jobs.import.resume_retry_error",
	"jobs_import_rollback_currently_idle":                                 "jobs.import_rollback.currently_idle",
	"jobs_import_rollback_currently_paused":                               "jobs.import_rollback.currently_paused",
	"jobs_import_rollback_currently_running":                              "jobs.import_rollback.currently_running",
	"jobs_import_rollback_expired_pts_records":                            "jobs.import_rollback.expired_pts_records",
	"jobs_import_rollback_fail_or_cancel_completed":                       "jobs.import_rollback.fail_or_cancel_completed",
	"jobs_import_rollback_fail_or_cancel_failed":                          "jobs.import_rollback.fail_or_cancel_failed",
	"jobs_import_rollback_fail_or_cancel_retry_error":                     "jobs.import_rollback.fail_or_cancel_retry_error",
	"jobs_import_rollback_protected_age_sec":                              "jobs.import_rollback.protected_age_sec",
	"jobs_import_rollback_protected_record_count":                         "jobs.import_rollback.protected_record_count",
	"jobs_import_rollback_resume_completed":                               "jobs.import_rollback.resume_completed",
	"jobs_import_rollback_resume_failed":                                  "jobs.import_rollback.resume_failed",
	"jobs_import_rollback_resume_retry_error":                             "jobs.import_rollback.resume_retry_error",
	"jobs_key_visualizer_currently_idle":                                  "jobs.key_visualizer.currently_idle",
	"jobs_key_visualizer_currently_paused":                                "jobs.key_visualizer.currently_paused",
	"jobs_key_visualizer_currently_running":                               "jobs.key_visualizer.currently_running",
	"jobs_key_visualizer_expired_pts_records":                             "jobs.key_visualizer.expired_pts_records",
	"jobs_key_visualizer_fail_or_cancel_completed":                        "jobs.key_visualizer.fail_or_cancel_completed",
	"jobs_key_visualizer_fail_or_cancel_failed":                           "jobs.key_visualizer.fail_or_cancel_failed",
	"jobs_key_visualizer_fail_or_cancel_retry_error":                      "jobs.key_visualizer.fail_or_cancel_retry_error",
	"jobs_key_visualizer_protected_age_sec":                               "jobs.key_visualizer.protected_age_sec",
	"jobs_key_visualizer_protected_record_count":                          "jobs.key_visualizer.protected_record_count",
	"jobs_key_visualizer_resume_completed":                                "jobs.key_visualizer.resume_completed",
	"jobs_key_visualizer_resume_failed":                                   "jobs.key_visualizer.resume_failed",
	"jobs_key_visualizer_resume_retry_error":                              "jobs.key_visualizer.resume_retry_error",
	"jobs_metrics_task_failed":                                            "jobs.metrics.task_failed",
	"jobs_migration_currently_idle":                                       "jobs.migration.currently_idle",
	"jobs_migration_currently_paused":                                     "jobs.migration.currently_paused",
	"jobs_migration_currently_running":                                    "jobs.migration.currently_running",
	"jobs_migration_expired_pts_records":                                  "jobs.migration.expired_pts_records",
	"jobs_migration_fail_or_cancel_completed":                             "jobs.migration.fail_or_cancel_completed",
	"jobs_migration_fail_or_cancel_failed":                                "jobs.migration.fail_or_cancel_failed",
	"jobs_migration_fail_or_cancel_retry_error":                           "jobs.migration.fail_or_cancel_retry_error",
	"jobs_migration_protected_age_sec":                                    "jobs.migration.protected_age_sec",
	"jobs_migration_protected_record_count":                               "jobs.migration.protected_record_count",
	"jobs_migration_resume_completed":                                     "jobs.migration.resume_completed",
	"jobs_migration_resume_failed":                                        "jobs.migration.resume_failed",
	"jobs_migration_resume_retry_error":                                   "jobs.migration.resume_retry_error",
	"jobs_mvcc_statistics_update_currently_idle":                          "jobs.mvcc_statistics_update.currently_idle",
	"jobs_mvcc_statistics_update_currently_paused":                        "jobs.mvcc_statistics_update.currently_paused",
	"jobs_mvcc_statistics_update_currently_running":                       "jobs.mvcc_statistics_update.currently_running",
	"jobs_mvcc_statistics_update_expired_pts_records":                     "jobs.mvcc_statistics_update.expired_pts_records",
	"jobs_mvcc_statistics_update_fail_or_cancel_completed":                "jobs.mvcc_statistics_update.fail_or_cancel_completed",
	"jobs_mvcc_statistics_update_fail_or_cancel_failed":                   "jobs.mvcc_statistics_update.fail_or_cancel_failed",
	"jobs_mvcc_statistics_update_fail_or_cancel_retry_error":              "jobs.mvcc_statistics_update.fail_or_cancel_retry_error",
	"jobs_mvcc_statistics_update_protected_age_sec":                       "jobs.mvcc_statistics_update.protected_age_sec",
	"jobs_mvcc_statistics_update_protected_record_count":                  "jobs.mvcc_statistics_update.protected_record_count",
	"jobs_mvcc_statistics_update_resume_completed":                        "jobs.mvcc_statistics_update.resume_completed",
	"jobs_mvcc_statistics_update_resume_failed":                           "jobs.mvcc_statistics_update.resume_failed",
	"jobs_mvcc_statistics_update_resume_retry_error":                      "jobs.mvcc_statistics_update.resume_retry_error",
	"jobs_new_schema_change_currently_idle":                               "jobs.new_schema_change.currently_idle",
	"jobs_new_schema_change_currently_paused":                             "jobs.new_schema_change.currently_paused",
	"jobs_new_schema_change_currently_running":                            "jobs.new_schema_change.currently_running",
	"jobs_new_schema_change_expired_pts_records":                          "jobs.new_schema_change.expired_pts_records",
	"jobs_new_schema_change_fail_or_cancel_completed":                     "jobs.new_schema_change.fail_or_cancel_completed",
	"jobs_new_schema_change_fail_or_cancel_failed":                        "jobs.new_schema_change.fail_or_cancel_failed",
	"jobs_new_schema_change_fail_or_cancel_retry_error":                   "jobs.new_schema_change.fail_or_cancel_retry_error",
	"jobs_new_schema_change_protected_age_sec":                            "jobs.new_schema_change.protected_age_sec",
	"jobs_new_schema_change_protected_record_count":                       "jobs.new_schema_change.protected_record_count",
	"jobs_new_schema_change_resume_completed":                             "jobs.new_schema_change.resume_completed",
	"jobs_new_schema_change_resume_failed":                                "jobs.new_schema_change.resume_failed",
	"jobs_new_schema_change_resume_retry_error":                           "jobs.new_schema_change.resume_retry_error",
	"jobs_poll_jobs_stats_currently_idle":                                 "jobs.poll_jobs_stats.currently_idle",
	"jobs_poll_jobs_stats_currently_paused":                               "jobs.poll_jobs_stats.currently_paused",
	"jobs_poll_jobs_stats_currently_running":                              "jobs.poll_jobs_stats.currently_running",
	"jobs_poll_jobs_stats_expired_pts_records":                            "jobs.poll_jobs_stats.expired_pts_records",
	"jobs_poll_jobs_stats_fail_or_cancel_completed":                       "jobs.poll_jobs_stats.fail_or_cancel_completed",
	"jobs_poll_jobs_stats_fail_or_cancel_failed":                          "jobs.poll_jobs_stats.fail_or_cancel_failed",
	"jobs_poll_jobs_stats_fail_or_cancel_retry_error":                     "jobs.poll_jobs_stats.fail_or_cancel_retry_error",
	"jobs_poll_jobs_stats_protected_age_sec":                              "jobs.poll_jobs_stats.protected_age_sec",
	"jobs_poll_jobs_stats_protected_record_count":                         "jobs.poll_jobs_stats.protected_record_count",
	"jobs_poll_jobs_stats_resume_completed":                               "jobs.poll_jobs_stats.resume_completed",
	"jobs_poll_jobs_stats_resume_failed":                                  "jobs.poll_jobs_stats.resume_failed",
	"jobs_poll_jobs_stats_resume_retry_error":                             "jobs.poll_jobs_stats.resume_retry_error",
	"jobs_replication_stream_ingestion_currently_idle":                    "jobs.replication_stream_ingestion.currently_idle",
	"jobs_replication_stream_ingestion_currently_paused":                  "jobs.replication_stream_ingestion.currently_paused",
	"jobs_replication_stream_ingestion_currently_running":                 "jobs.replication_stream_ingestion.currently_running",
	"jobs_replication_stream_ingestion_expired_pts_records":               "jobs.replication_stream_ingestion.expired_pts_records",
	"jobs_replication_stream_ingestion_fail_or_cancel_completed":          "jobs.replication_stream_ingestion.fail_or_cancel_completed",
	"jobs_replication_stream_ingestion_fail_or_cancel_failed":             "jobs.replication_stream_ingestion.fail_or_cancel_failed",
	"jobs_replication_stream_ingestion_fail_or_cancel_retry_error":        "jobs.replication_stream_ingestion.fail_or_cancel_retry_error",
	"jobs_replication_stream_ingestion_protected_age_sec":                 "jobs.replication_stream_ingestion.protected_age_sec",
	"jobs_replication_stream_ingestion_protected_record_count":            "jobs.replication_stream_ingestion.protected_record_count",
	"jobs_replication_stream_ingestion_resume_completed":                  "jobs.replication_stream_ingestion.resume_completed",
	"jobs_replication_stream_ingestion_resume_failed":                     "jobs.replication_stream_ingestion.resume_failed",
	"jobs_replication_stream_ingestion_resume_retry_error":                "jobs.replication_stream_ingestion.resume_retry_error",
	"jobs_replication_stream_producer_currently_idle":                     "jobs.replication_stream_producer.currently_idle",
	"jobs_replication_stream_producer_currently_paused":                   "jobs.replication_stream_producer.currently_paused",
	"jobs_replication_stream_producer_currently_running":                  "jobs.replication_stream_producer.currently_running",
	"jobs_replication_stream_producer_expired_pts_records":                "jobs.replication_stream_producer.expired_pts_records",
	"jobs_replication_stream_producer_fail_or_cancel_completed":           "jobs.replication_stream_producer.fail_or_cancel_completed",
	"jobs_replication_stream_producer_fail_or_cancel_failed":              "jobs.replication_stream_producer.fail_or_cancel_failed",
	"jobs_replication_stream_producer_fail_or_cancel_retry_error":         "jobs.replication_stream_producer.fail_or_cancel_retry_error",
	"jobs_replication_stream_producer_protected_age_sec":                  "jobs.replication_stream_producer.protected_age_sec",
	"jobs_replication_stream_producer_protected_record_count":             "jobs.replication_stream_producer.protected_record_count",
	"jobs_replication_stream_producer_resume_completed":                   "jobs.replication_stream_producer.resume_completed",
	"jobs_replication_stream_producer_resume_failed":                      "jobs.replication_stream_producer.resume_failed",
	"jobs_replication_stream_producer_resume_retry_error":                 "jobs.replication_stream_producer.resume_retry_error",
	"jobs_restore_currently_idle":                                         "jobs.restore.currently_idle",
	"jobs_restore_currently_paused":                                       "jobs.restore.currently_paused",
	"jobs_restore_currently_running":                                      "jobs.restore.currently_running",
	"jobs_restore_expired_pts_records":                                    "jobs.restore.expired_pts_records",
	"jobs_restore_fail_or_cancel_completed":                               "jobs.restore.fail_or_cancel_completed",
	"jobs_restore_fail_or_cancel_failed":                                  "jobs.restore.fail_or_cancel_failed",
	"jobs_restore_fail_or_cancel_retry_error":                             "jobs.restore.fail_or_cancel_retry_error",
	"jobs_restore_protected_age_sec":                                      "jobs.restore.protected_age_sec",
	"jobs_restore_protected_record_count":                                 "jobs.restore.protected_record_count",
	"jobs_restore_resume_completed":                                       "jobs.restore.resume_completed",
	"jobs_restore_resume_failed":                                          "jobs.restore.resume_failed",
	"jobs_restore_resume_retry_error":                                     "jobs.restore.resume_retry_error",
	"jobs_resumed_claimed_jobs":                                           "jobs.resumed_claimed_jobs",
	"jobs_row_level_ttl_currently_idle":                                   "jobs.row_level_ttl.currently_idle",
	"jobs_row_level_ttl_currently_paused":                                 "jobs.row.level.ttl.currently_paused",
	"jobs_row_level_ttl_currently_running":                                "jobs.row.level.ttl.currently_running",
	"jobs_row_level_ttl_delete_duration":                                  "jobs.row_level_ttl.delete_duration",
	"jobs_row_level_ttl_delete_duration_bucket":                           "jobs.row_level_ttl.delete_duration.bucket",
	"jobs_row_level_ttl_delete_duration_count":                            "jobs.row_level_ttl.delete_duration.count",
	"jobs_row_level_ttl_delete_duration_sum":                              "jobs.row_level_ttl.delete_duration.sum",
	"jobs_row_level_ttl_expired_pts_records":                              "jobs.row_level_ttl.expired_pts_records",
	"jobs_row_level_ttl_fail_or_cancel_completed":                         "jobs.row_level_ttl.fail_or_cancel_completed",
	"jobs_row_level_ttl_fail_or_cancel_failed":                            "jobs.row_level_ttl.fail_or_cancel_failed",
	"jobs_row_level_ttl_fail_or_cancel_retry_error":                       "jobs.row_level_ttl.fail_or_cancel_retry_error",
	"jobs_row_level_ttl_num_active_spans":                                 "jobs.row_level_ttl.num_active_spans",
	"jobs_row_level_ttl_protected_age_sec":                                "jobs.row_level_ttl.protected_age_sec",
	"jobs_row_level_ttl_protected_record_count":                           "jobs.row_level_ttl.protected_record_count",
	"jobs_row_level_ttl_resume_completed":                                 "jobs.row.level.ttl.resume_completed",
	"jobs_row_level_ttl_resume_failed":                                    "jobs.row.level.ttl.resume_failed",
	"jobs_row_level_ttl_resume_retry_error":                               "jobs.row_level_ttl.resume_retry_error",
	"jobs_row_level_ttl_rows_deleted":                                     "jobs.row.level.ttl.rows_deleted",
	"jobs_row_level_ttl_rows_selected":                                    "jobs.row.level.ttl.rows_selected",
	"jobs_row_level_ttl_select_duration":                                  "jobs.row_level_ttl.select_duration",
	"jobs_row_level_ttl_select_duration_bucket":                           "jobs.row_level_ttl.select_duration.bucket",
	"jobs_row_level_ttl_select_duration_count":                            "jobs.row_level_ttl.select_duration.count",
	"jobs_row_level_ttl_select_duration_sum":                              "jobs.row_level_ttl.select_duration.sum",
	"jobs_row_level_ttl_span_total_duration":                              "jobs.row_level_ttl.span_total_duration",
	"jobs_row_level_ttl_span_total_duration_bucket":                       "jobs.row_level_ttl.span_total_duration.bucket",
	"jobs_row_level_ttl_span_total_duration_count":                        "jobs.row_level_ttl.span_total_duration.count",
	"jobs_row_level_ttl_span_total_duration_sum":                          "jobs.row_level_ttl.span_total_duration.sum",
	"jobs_row_level_ttl_total_expired_rows":                               "jobs.row_level_ttl.total_expired_rows",
	"jobs_row_level_ttl_total_rows":                                       "jobs.row_level_ttl.total_rows",
	"jobs_running_non_idle":                                               "jobs.running_non_idle",
	"jobs_schema_change_currently_idle":                                   "jobs.schema_change.currently_idle",
	"jobs_schema_change_currently_paused":                                 "jobs.schema_change.currently_paused",
	"jobs_schema_change_currently_running":                                "jobs.schema_change.currently_running",
	"jobs_schema_change_expired_pts_records":                              "jobs.schema_change.expired_pts_records",
	"jobs_schema_change_fail_or_cancel_completed":                         "jobs.schema_change.fail_or_cancel_completed",
	"jobs_schema_change_fail_or_cancel_failed":                            "jobs.schema_change.fail_or_cancel_failed",
	"jobs_schema_change_fail_or_cancel_retry_error":                       "jobs.schema_change.fail_or_cancel_retry_error",
	"jobs_schema_change_gc_currently_idle":                                "jobs.schema_change_gc.currently_idle",
	"jobs_schema_change_gc_currently_paused":                              "jobs.schema_change_gc.currently_paused",
	"jobs_schema_change_gc_currently_running":                             "jobs.schema_change_gc.currently_running",
	"jobs_schema_change_gc_expired_pts_records":                           "jobs.schema_change_gc.expired_pts_records",
	"jobs_schema_change_gc_fail_or_cancel_completed":                      "jobs.schema_change_gc.fail_or_cancel_completed",
	"jobs_schema_change_gc_fail_or_cancel_failed":                         "jobs.schema_change_gc.fail_or_cancel_failed",
	"jobs_schema_change_gc_fail_or_cancel_retry_error":                    "jobs.schema_change_gc.fail_or_cancel_retry_error",
	"jobs_schema_change_gc_protected_age_sec":                             "jobs.schema_change_gc.protected_age_sec",
	"jobs_schema_change_gc_protected_record_count":                        "jobs.schema_change_gc.protected_record_count",
	"jobs_schema_change_gc_resume_completed":                              "jobs.schema_change_gc.resume_completed",
	"jobs_schema_change_gc_resume_failed":                                 "jobs.schema_change_gc.resume_failed",
	"jobs_schema_change_gc_resume_retry_error":                            "jobs.schema_change_gc.resume_retry_error",
	"jobs_schema_change_protected_age_sec":                                "jobs.schema_change.protected_age_sec",
	"jobs_schema_change_protected_record_count":                           "jobs.schema_change.protected_record_count",
	"jobs_schema_change_resume_completed":                                 "jobs.schema_change.resume_completed",
	"jobs_schema_change_resume_failed":                                    "jobs.schema_change.resume_failed",
	"jobs_schema_change_resume_retry_error":                               "jobs.schema_change.resume_retry_error",
	"jobs_typedesc_schema_change_currently_idle":                          "jobs.typedesc_schema_change.currently_idle",
	"jobs_typedesc_schema_change_currently_paused":                        "jobs.typedesc_schema_change.currently_paused",
	"jobs_typedesc_schema_change_currently_running":                       "jobs.typedesc_schema_change.currently_running",
	"jobs_typedesc_schema_change_expired_pts_records":                     "jobs.typedesc_schema_change.expired_pts_records",
	"jobs_typedesc_schema_change_fail_or_cancel_completed":                "jobs.typedesc_schema_change.fail_or_cancel_completed",
	"jobs_typedesc_schema_change_fail_or_cancel_failed":                   "jobs.typedesc_schema_change.fail_or_cancel_failed",
	"jobs_typedesc_schema_change_fail_or_cancel_retry_error":              "jobs.typedesc_schema_change.fail_or_cancel_retry_error",
	"jobs_typedesc_schema_change_protected_age_sec":                       "jobs.typedesc_schema_change.protected_age_sec",
	"jobs_typedesc_schema_change_protected_record_count":                  "jobs.typedesc_schema_change.protected_record_count",
	"jobs_typedesc_schema_change_resume_completed":                        "jobs.typedesc_schema_change.resume_completed",
	"jobs_typedesc_schema_change_resume_failed":                           "jobs.typedesc_schema_change.resume_failed",
	"jobs_typedesc_schema_change_resume_retry_error":                      "jobs.typedesc_schema_change.resume_retry_error",
	"keybytes": "keybytes",
	"keycount": "keycount",
	"kv_allocator_load_based_lease_transfers_cannot_find_better_candidate":         "kv.allocator.load_based_lease_transfers.cannot_find_better_candidate",
	"kv_allocator_load_based_lease_transfers_delta_not_significant":                "kv.allocator.load_based_lease_transfers.delta_not_significant",
	"kv_allocator_load_based_lease_transfers_existing_not_overfull":                "kv.allocator.load_based_lease_transfers.existing_not_overfull",
	"kv_allocator_load_based_lease_transfers_follow_the_workload":                  "kv.allocator.load_based_lease_transfers.follow_the_workload",
	"kv_allocator_load_based_lease_transfers_missing_stats_for_existing_stores":    "kv.allocator.load_based_lease_transfers.missing_stats_for_existing_stores",
	"kv_allocator_load_based_lease_transfers_should_transfer":                      "kv.allocator.load_based_lease_transfers.should_transfer",
	"kv_allocator_load_based_replica_rebalancing_cannot_find_better_candidate":     "kv.allocator.load_based_replica_rebalancing.cannot_find_better_candidate",
	"kv_allocator_load_based_replica_rebalancing_delta_not_significant":            "kv.allocator.load_based_replica_rebalancing.delta_not_significant",
	"kv_allocator_load_based_replica_rebalancing_existing_not_overfull":            "kv.allocator.load_based_replica_rebalancing.existing_not_overfull",
	"kv_allocator_load_based_replica_rebalancing_missing_stats_for_existing_store": "kv.allocator.load_based_replica_rebalancing.missing_stats_for_existing_store",
	"kv_allocator_load_based_replica_rebalancing_should_transfer":                  "kv.allocator.load_based_replica_rebalancing.should_transfer",
	"kv_closed_timestamp_max_behind_nanos":                                         "kv.closed_timestamp.max_behind_nanos",
	"kv_concurrency_avg_lock_hold_duration_nanos":                                  "kv.concurrency.avg_lock_hold_duration_nanos",
	"kv_concurrency_avg_lock_wait_duration_nanos":                                  "kv.concurrency.avg_lock_wait_duration_nanos",
	"kv_concurrency_latch_conflict_wait_durations":                                 "kv.concurrency.latch_conflict_wait_durations",
	"kv_concurrency_latch_conflict_wait_durations_bucket":                          "kv.concurrency.latch_conflict_wait_durations.bucket",
	"kv_concurrency_latch_conflict_wait_durations_count":                           "kv.concurrency.latch_conflict_wait_durations.count",
	"kv_concurrency_latch_conflict_wait_durations_sum":                             "kv.concurrency.latch_conflict_wait_durations.sum",
	"kv_concurrency_lock_wait_queue_waiters":                                       "kv.concurrency.lock_wait_queue_waiters",
	"kv_concurrency_locks":                                                         "kv.concurrency.locks",
	"kv_concurrency_locks_with_wait_queues":                                        "kv.concurrency.locks_with_wait_queues",
	"kv_concurrency_max_lock_hold_duration_nanos":                                  "kv.concurrency.max_lock_hold_duration_nanos",
	"kv_concurrency_max_lock_wait_duration_nanos":                                  "kv.concurrency.max_lock_wait_duration_nanos",
	"kv_concurrency_max_lock_wait_queue_waiters_for_lock":                          "kv.concurrency.max_lock_wait_queue_waiters_for_lock",
	"kv_loadsplitter_nosplitkey":                                                   "kv.loadsplitter.nosplitkey",
	"kv_loadsplitter_popularkey":                                                   "kv.loadsplitter.popularkey",
	"kv_prober_planning_attempts":                                                  "kv.prober.planning_attempts",
	"kv_prober_planning_failures":                                                  "kv.prober.planning_failures",
	"kv_prober_read_attempts":                                                      "kv.prober.read.attempts",
	"kv_prober_read_failures":                                                      "kv.prober.read.failures",
	"kv_prober_read_latency":                                                       "kv.prober.read.latency",
	"kv_prober_read_latency_bucket":                                                "kv.prober.read.latency.bucket",
	"kv_prober_read_latency_count":                                                 "kv.prober.read.latency.count",
	"kv_prober_read_latency_sum":                                                   "kv.prober.read.latency.sum",
	"kv_prober_write_attempts":                                                     "kv.prober.write.attempts",
	"kv_prober_write_failures":                                                     "kv.prober.write.failures",
	"kv_prober_write_latency":                                                      "kv.prober.write.latency",
	"kv_prober_write_latency_bucket":                                               "kv.prober.write.latency.bucket",
	"kv_prober_write_latency_count":                                                "kv.prober.write.latency.count",
	"kv_prober_write_latency_sum":                                                  "kv.prober.write.latency.sum",
	"kv_prober_write_quarantine_oldest_duration":                                   "kv.prober.write.quarantine.oldest_duration",
	"kv_protectedts_reconciliation_errors":                                         "kv.protectedts.reconciliation.errors",
	"kv_protectedts_reconciliation_num_runs":                                       "kv.protectedts.reconciliation.num_runs",
	"kv_protectedts_reconciliation_records_processed":                              "kv.protectedts.reconciliation.records_processed",
	"kv_protectedts_reconciliation_records_removed":                                "kv.protectedts.reconciliation.records_removed",
	"kv_rangefeed_budget_allocation_blocked":                                       "kv.rangefeed.budget_allocation_blocked",
	"kv_rangefeed_budget_allocation_failed":                                        "kv.rangefeed.budget_allocation_failed",
	"kv_rangefeed_catchup_scan_nanos":                                              "kv.rangefeed.catchup_scan_nanos",
	"kv_rangefeed_mem_shared":                                                      "kv.rangefeed.mem_shared",
	"kv_rangefeed_mem_system":                                                      "kv.rangefeed.mem_system",
	"kv_rangefeed_processors_goroutine":                                            "kv.rangefeed.processors_goroutine",
	"kv_rangefeed_processors_scheduler":                                            "kv.rangefeed.processors_scheduler",
	"kv_rangefeed_registrations":                                                   "kv.rangefeed.registrations",
	"kv_rangefeed_scheduler_normal_latency":                                        "kv.rangefeed.scheduler.normal.latency",
	"kv_rangefeed_scheduler_normal_latency_bucket":                                 "kv.rangefeed.scheduler.normal.latency.bucket",
	"kv_rangefeed_scheduler_normal_latency_count":                                  "kv.rangefeed.scheduler.normal.latency.count",
	"kv_rangefeed_scheduler_normal_latency_sum":                                    "kv.rangefeed.scheduler.normal.latency.sum",
	"kv_rangefeed_scheduler_normal_queue_size":                                     "kv.rangefeed.scheduler.normal.queue_size",
	"kv_rangefeed_scheduler_system_latency":                                        "kv.rangefeed.scheduler.system.latency",
	"kv_rangefeed_scheduler_system_latency_bucket":                                 "kv.rangefeed.scheduler.system.latency.bucket",
	"kv_rangefeed_scheduler_system_latency_count":                                  "kv.rangefeed.scheduler.system.latency.count",
	"kv_rangefeed_scheduler_system_latency_sum":                                    "kv.rangefeed.scheduler.system.latency.sum",
	"kv_rangefeed_scheduler_system_queue_size":                                     "kv.rangefeed.scheduler.system.queue_size",
	"kv_replica_circuit_breaker_num_tripped_events":                                "kv.replica_circuit_breaker.num_tripped_events",
	"kv_replica_circuit_breaker_num_tripped_replicas":                              "kv.replica_circuit_breaker.num_tripped_replicas",
	"kv_replica_read_batch_evaluate_dropped_latches_before_eval":                   "kv.replica_read_batch_evaluate.dropped_latches_before_eval",
	"kv_replica_read_batch_evaluate_latency":                                       "kv.replica_read_batch_evaluate.latency",
	"kv_replica_read_batch_evaluate_latency_bucket":                                "kv.replica_read_batch_evaluate.latency.bucket",
	"kv_replica_read_batch_evaluate_latency_count":                                 "kv.replica_read_batch_evaluate.latency.count",
	"kv_replica_read_batch_evaluate_latency_sum":                                   "kv.replica_read_batch_evaluate.latency.sum",
	"kv_replica_read_batch_evaluate_without_interleaving_iter":                     "kv.replica_read_batch_evaluate.without_interleaving_iter",
	"kv_replica_write_batch_evaluate_latency":                                      "kv.replica_write_batch_evaluate.latency",
	"kv_replica_write_batch_evaluate_latency_bucket":                               "kv.replica_write_batch_evaluate.latency.bucket",
	"kv_replica_write_batch_evaluate_latency_count":                                "kv.replica_write_batch_evaluate.latency.count",
	"kv_replica_write_batch_evaluate_latency_sum":                                  "kv.replica_write_batch_evaluate.latency.sum",
	"kv_split_estimated_stats":                                                     "kv.split.estimated_stats",
	"kv_split_total_bytes_estimates":                                               "kv.split.total_bytes_estimates",
	"kv_streamer_batches_in_progress":                                              "kv.streamer.batches.in_progress",
	"kv_streamer_batches_sent":                                                     "kv.streamer.batches.sent",
	"kv_streamer_batches_throttled":                                                "kv.streamer.batches.throttled",
	"kv_streamer_operators_active":                                                 "kv.streamer.operators.active",
	"kv_tenant_rate_limit_current_blocked":                                         "kv.tenant_rate_limit.current_blocked",
	"kv_tenant_rate_limit_num_tenants":                                             "kv.tenant_rate_limit.num_tenants",
	"kv_tenant_rate_limit_read_batches_admitted":                                   "kv.tenant_rate_limit.read_batches_admitted",
	"kv_tenant_rate_limit_read_bytes_admitted":                                     "kv.tenant_rate_limit.read_bytes_admitted",
	"kv_tenant_rate_limit_read_requests_admitted":                                  "kv.tenant_rate_limit.read_requests_admitted",
	"kv_tenant_rate_limit_write_batches_admitted":                                  "kv.tenant_rate_limit.write_batches_admitted",
	"kv_tenant_rate_limit_write_bytes_admitted":                                    "kv.tenant_rate_limit.write_bytes_admitted",
	"kv_tenant_rate_limit_write_requests_admitted":                                 "kv.tenant_rate_limit.write_requests_admitted",
	"kvadmission_flow_controller_elastic_blocked_stream_count":                     "kvadmission.flow_controller.elastic_blocked_stream_count",
	"kvadmission_flow_controller_elastic_requests_admitted":                        "kvadmission.flow_controller.elastic_requests_admitted",
	"kvadmission_flow_controller_elastic_requests_bypassed":                        "kvadmission.flow_controller.elastic_requests_bypassed",
	"kvadmission_flow_controller_elastic_requests_errored":                         "kvadmission.flow_controller.elastic_requests_errored",
	"kvadmission_flow_controller_elastic_requests_waiting":                         "kvadmission.flow_controller.elastic_requests_waiting",
	"kvadmission_flow_controller_elastic_stream_count":                             "kvadmission.flow_controller.elastic_stream_count",
	"kvadmission_flow_controller_elastic_tokens_available":                         "kvadmission.flow_controller.elastic_tokens_available",
	"kvadmission_flow_controller_elastic_tokens_deducted":                          "kvadmission.flow_controller.elastic_tokens_deducted",
	"kvadmission_flow_controller_elastic_tokens_returned":                          "kvadmission.flow_controller.elastic_tokens_returned",
	"kvadmission_flow_controller_elastic_tokens_unaccounted":                       "kvadmission.flow_controller.elastic_tokens_unaccounted",
	"kvadmission_flow_controller_elastic_wait_duration":                            "kvadmission.flow_controller.elastic_wait_duration",
	"kvadmission_flow_controller_elastic_wait_duration_bucket":                     "kvadmission.flow_controller.elastic_wait_duration.bucket",
	"kvadmission_flow_controller_elastic_wait_duration_count":                      "kvadmission.flow_controller.elastic_wait_duration.count",
	"kvadmission_flow_controller_elastic_wait_duration_sum":                        "kvadmission.flow_controller.elastic_wait_duration.sum",
	"kvadmission_flow_controller_regular_blocked_stream_count":                     "kvadmission.flow_controller.regular_blocked_stream_count",
	"kvadmission_flow_controller_regular_requests_admitted":                        "kvadmission.flow_controller.regular_requests_admitted",
	"kvadmission_flow_controller_regular_requests_bypassed":                        "kvadmission.flow_controller.regular_requests_bypassed",
	"kvadmission_flow_controller_regular_requests_errored":                         "kvadmission.flow_controller.regular_requests_errored",
	"kvadmission_flow_controller_regular_requests_waiting":                         "kvadmission.flow_controller.regular_requests_waiting",
	"kvadmission_flow_controller_regular_stream_count":                             "kvadmission.flow_controller.regular_stream_count",
	"kvadmission_flow_controller_regular_tokens_available":                         "kvadmission.flow_controller.regular_tokens_available",
	"kvadmission_flow_controller_regular_tokens_deducted":                          "kvadmission.flow_controller.regular_tokens_deducted",
	"kvadmission_flow_controller_regular_tokens_returned":                          "kvadmission.flow_controller.regular_tokens_returned",
	"kvadmission_flow_controller_regular_tokens_unaccounted":                       "kvadmission.flow_controller.regular_tokens_unaccounted",
	"kvadmission_flow_controller_regular_wait_duration":                            "kvadmission.flow_controller.regular_wait_duration",
	"kvadmission_flow_controller_regular_wait_duration_bucket":                     "kvadmission.flow_controller.regular_wait_duration.bucket",
	"kvadmission_flow_controller_regular_wait_duration_count":                      "kvadmission.flow_controller.regular_wait_duration.count",
	"kvadmission_flow_controller_regular_wait_duration_sum":                        "kvadmission.flow_controller.regular_wait_duration.sum",
	"kvadmission_flow_handle_elastic_requests_admitted":                            "kvadmission.flow_handle.elastic_requests_admitted",
	"kvadmission_flow_handle_elastic_requests_errored":                             "kvadmission.flow_handle.elastic_requests_errored",
	"kvadmission_flow_handle_elastic_requests_waiting":                             "kvadmission.flow_handle.elastic_requests_waiting",
	"kvadmission_flow_handle_elastic_wait_duration":                                "kvadmission.flow_handle.elastic_wait_duration",
	"kvadmission_flow_handle_elastic_wait_duration_bucket":                         "kvadmission.flow_handle.elastic_wait_duration.bucket",
	"kvadmission_flow_handle_elastic_wait_duration_count":                          "kvadmission.flow_handle.elastic_wait_duration.count",
	"kvadmission_flow_handle_elastic_wait_duration_sum":                            "kvadmission.flow_handle.elastic_wait_duration.sum",
	"kvadmission_flow_handle_regular_requests_admitted":                            "kvadmission.flow_handle.regular_requests_admitted",
	"kvadmission_flow_handle_regular_requests_errored":                             "kvadmission.flow_handle.regular_requests_errored",
	"kvadmission_flow_handle_regular_requests_waiting":                             "kvadmission.flow_handle.regular_requests_waiting",
	"kvadmission_flow_handle_regular_wait_duration":                                "kvadmission.flow_handle.regular_wait_duration",
	"kvadmission_flow_handle_regular_wait_duration_bucket":                         "kvadmission.flow_handle.regular_wait_duration.bucket",
	"kvadmission_flow_handle_regular_wait_duration_count":                          "kvadmission.flow_handle.regular_wait_duration.count",
	"kvadmission_flow_handle_regular_wait_duration_sum":                            "kvadmission.flow_handle.regular_wait_duration.sum",
	"kvadmission_flow_handle_streams_connected":                                    "kvadmission.flow_handle.streams_connected",
	"kvadmission_flow_handle_streams_disconnected":                                 "kvadmission.flow_handle.streams_disconnected",
	"kvadmission_flow_token_dispatch_coalesced_elastic":                            "kvadmission.flow_token_dispatch.coalesced_elastic",
	"kvadmission_flow_token_dispatch_coalesced_regular":                            "kvadmission.flow_token_dispatch.coalesced_regular",
	"kvadmission_flow_token_dispatch_local_elastic":                                "kvadmission.flow_token_dispatch.local_elastic",
	"kvadmission_flow_token_dispatch_local_regular":                                "kvadmission.flow_token_dispatch.local_regular",
	"kvadmission_flow_token_dispatch_pending_elastic":                              "kvadmission.flow_token_dispatch.pending_elastic",
	"kvadmission_flow_token_dispatch_pending_nodes":                                "kvadmission.flow_token_dispatch.pending_nodes",
	"kvadmission_flow_token_dispatch_pending_regular":                              "kvadmission.flow_token_dispatch.pending_regular",
	"kvadmission_flow_token_dispatch_remote_elastic":                               "kvadmission.flow_token_dispatch.remote_elastic",
	"kvadmission_flow_token_dispatch_remote_regular":                               "kvadmission.flow_token_dispatch.remote_regular",
	"lastupdatenanos":                                             "lastupdatenanos",
	"leases_epoch":                                                "leases.epoch",
	"leases_error":                                                "leases.error",
	"leases_expiration":                                           "leases.expiration",
	"leases_liveness":                                             "leases.liveness",
	"leases_preferences_less_preferred":                           "leases.preferences.less_preferred",
	"leases_preferences_violating":                                "leases.preferences.violating",
	"leases_requests_latency":                                     "leases.requests.latency",
	"leases_requests_latency_bucket":                              "leases.requests.latency.bucket",
	"leases_requests_latency_count":                               "leases.requests.latency.count",
	"leases_requests_latency_sum":                                 "leases.requests.latency.sum",
	"leases_success":                                              "leases.success",
	"leases_transfers_error":                                      "leases.transfers.error",
	"leases_transfers_success":                                    "leases.transfers.success",
	"livebytes":                                                   "livebytes",
	"livecount":                                                   "livecount",
	"liveness_epochincrements":                                    "liveness.epochincrements",
	"liveness_heartbeatfailures":                                  "liveness.heartbeatfailures",
	"liveness_heartbeatlatency":                                   "liveness.heartbeatlatency",
	"liveness_heartbeatlatency_bucket":                            "liveness.heartbeatlatency.bucket",
	"liveness_heartbeatlatency_count":                             "liveness.heartbeatlatency.count",
	"liveness_heartbeatlatency_sum":                               "liveness.heartbeatlatency.sum",
	"liveness_heartbeatsinflight":                                 "liveness.heartbeatsinflight",
	"liveness_heartbeatsuccesses":                                 "liveness.heartbeatsuccesses",
	"liveness_livenodes":                                          "liveness.livenodes",
	"lockbytes":                                                   "lockbytes",
	"lockcount":                                                   "lockcount",
	"log_buffered_messages_dropped":                               "log.buffered.messages.dropped",
	"log_fluent_sink_conn_attempts":                               "log.fluent.sink.conn.attempts",
	"log_fluent_sink_conn_errors":                                 "log.fluent.sink.conn.errors",
	"log_fluent_sink_write_attempts":                              "log.fluent.sink.write.attempts",
	"log_fluent_sink_write_errors":                                "log.fluent.sink.write.errors",
	"log_messages_count":                                          "log.messages.count",
	"node_id":                                                     "node_id",
	"obs_tablemetadata_update_job_duration":                       "obs.tablemetadata.update_job.duration",
	"obs_tablemetadata_update_job_duration_bucket":                "obs.tablemetadata.update_job.duration.bucket",
	"obs_tablemetadata_update_job_duration_count":                 "obs.tablemetadata.update_job.duration.count",
	"obs_tablemetadata_update_job_duration_sum":                   "obs.tablemetadata.update_job.duration.sum",
	"obs_tablemetadata_update_job_errors":                         "obs.tablemetadata.update_job.errors",
	"obs_tablemetadata_update_job_runs":                           "obs.tablemetadata.update_job.runs",
	"obs_tablemetadata_update_job_table_updates":                  "obs.tablemetadata.update_job.table_updates",
	"physical_replication_admit_latency":                          "physical_replication.admit_latency",
	"physical_replication_admit_latency_bucket":                   "physical_replication.admit_latency.bucket",
	"physical_replication_admit_latency_count":                    "physical_replication.admit_latency.count",
	"physical_replication_admit_latency_sum":                      "physical_replication.admit_latency.sum",
	"physical_replication_commit_latency":                         "physical_replication.commit_latency",
	"physical_replication_commit_latency_bucket":                  "physical_replication.commit_latency.bucket",
	"physical_replication_commit_latency_count":                   "physical_replication.commit_latency.count",
	"physical_replication_commit_latency_sum":                     "physical_replication.commit_latency.sum",
	"physical_replication_failover_progress":                      "physical_replication.failover_progress",
	"physical_replication_distsql_replan_count":                   "physical_replication.distsql_replan_count",
	"physical_replication_events_ingested":                        "physical_replication.events_ingested",
	"physical_replication_flush_hist_nanos":                       "physical_replication.flush_hist_nanos",
	"physical_replication_flush_hist_nanos_bucket":                "physical_replication.flush_hist_nanos.bucket",
	"physical_replication_flush_hist_nanos_count":                 "physical_replication.flush_hist_nanos.count",
	"physical_replication_flush_hist_nanos_sum":                   "physical_replication.flush_hist_nanos.sum",
	"physical_replication_flushes":                                "physical_replication.flushes",
	"physical_replication_logical_bytes":                          "physical_replication.logical_bytes",
	"physical_replication_replicated_time_seconds":                "physical_replication.replicated_time_seconds",
	"physical_replication_resolved_events_ingested":               "physical_replication.resolved_events_ingested",
	"physical_replication_running":                                "physical_replication.running",
	"queue_consistency_pending":                                   "queue.consistency.pending",
	"queue_consistency_process_failure":                           "queue.consistency.process.failure",
	"queue_consistency_process_success":                           "queue.consistency.process.success",
	"queue_consistency_processingnanos":                           "queue.consistency.processingnanos",
	"queue_gc_info_abortspanconsidered":                           "queue.gc.info.abortspanconsidered",
	"queue_gc_info_abortspangcnum":                                "queue.gc.info.abortspangcnum",
	"queue_gc_info_abortspanscanned":                              "queue.gc.info.abortspanscanned",
	"queue_gc_info_clearrangefailed":                              "queue.gc.info.clearrangefailed",
	"queue_gc_info_clearrangesuccess":                             "queue.gc.info.clearrangesuccess",
	"queue_gc_info_enqueuehighpriority":                           "queue.gc.info.enqueuehighpriority",
	"queue_gc_info_intentsconsidered":                             "queue.gc.info.intentsconsidered",
	"queue_gc_info_intenttxns":                                    "queue.gc.info.intenttxns",
	"queue_gc_info_numkeysaffected":                               "queue.gc.info.numkeysaffected",
	"queue_gc_info_numrangekeysaffected":                          "queue.gc.info.numrangekeysaffected",
	"queue_gc_info_pushtxn":                                       "queue.gc.info.pushtxn",
	"queue_gc_info_resolvefailed":                                 "queue.gc.info.resolvefailed",
	"queue_gc_info_resolvesuccess":                                "queue.gc.info.resolvesuccess",
	"queue_gc_info_resolvetotal":                                  "queue.gc.info.resolvetotal",
	"queue_gc_info_transactionresolvefailed":                      "queue.gc.info.transactionresolvefailed",
	"queue_gc_info_transactionspangcaborted":                      "queue.gc.info.transactionspangcaborted",
	"queue_gc_info_transactionspangccommitted":                    "queue.gc.info.transactionspangccommitted",
	"queue_gc_info_transactionspangcpending":                      "queue.gc.info.transactionspangcpending",
	"queue_gc_info_transactionspangcstaging":                      "queue.gc.info.transactionspangcstaging",
	"queue_gc_info_transactionspanscanned":                        "queue.gc.info.transactionspanscanned",
	"queue_gc_pending":                                            "queue.gc.pending",
	"queue_gc_process_failure":                                    "queue.gc.process.failure",
	"queue_gc_process_success":                                    "queue.gc.process.success",
	"queue_gc_processingnanos":                                    "queue.gc.processingnanos",
	"queue_lease_pending":                                         "queue.lease.pending",
	"queue_lease_process_failure":                                 "queue.lease.process.failure",
	"queue_lease_process_success":                                 "queue.lease.process.success",
	"queue_lease_processingnanos":                                 "queue.lease.processingnanos",
	"queue_lease_purgatory":                                       "queue.lease.purgatory",
	"queue_merge_pending":                                         "queue.merge.pending",
	"queue_merge_process_failure":                                 "queue.merge.process.failure",
	"queue_merge_process_success":                                 "queue.merge.process.success",
	"queue_merge_processingnanos":                                 "queue.merge.processingnanos",
	"queue_merge_purgatory":                                       "queue.merge.purgatory",
	"queue_raftlog_pending":                                       "queue.raftlog.pending",
	"queue_raftlog_process_failure":                               "queue.raftlog.process.failure",
	"queue_raftlog_process_success":                               "queue.raftlog.process.success",
	"queue_raftlog_processingnanos":                               "queue.raftlog.processingnanos",
	"queue_raftsnapshot_pending":                                  "queue.raftsnapshot.pending",
	"queue_raftsnapshot_process_failure":                          "queue.raftsnapshot.process.failure",
	"queue_raftsnapshot_process_success":                          "queue.raftsnapshot.process.success",
	"queue_raftsnapshot_processingnanos":                          "queue.raftsnapshot.processingnanos",
	"queue_replicagc_pending":                                     "queue.replicagc.pending",
	"queue_replicagc_process_failure":                             "queue.replicagc.process.failure",
	"queue_replicagc_process_success":                             "queue.replicagc.process.success",
	"queue_replicagc_processingnanos":                             "queue.replicagc.processingnanos",
	"queue_replicagc_removereplica":                               "queue.replicagc.removereplica",
	"queue_replicate_addnonvoterreplica":                          "queue.replicate.addnonvoterreplica",
	"queue_replicate_addreplica":                                  "queue.replicate.addreplica",
	"queue_replicate_addreplica_error":                            "queue.replicate.addreplica.error",
	"queue_replicate_addreplica_success":                          "queue.replicate.addreplica.success",
	"queue_replicate_addvoterreplica":                             "queue.replicate.addvoterreplica",
	"queue_replicate_nonvoterpromotions":                          "queue.replicate.nonvoterpromotions",
	"queue_replicate_pending":                                     "queue.replicate.pending",
	"queue_replicate_process_failure":                             "queue.replicate.process.failure",
	"queue_replicate_process_success":                             "queue.replicate.process.success",
	"queue_replicate_processingnanos":                             "queue.replicate.processingnanos",
	"queue_replicate_purgatory":                                   "queue.replicate.purgatory",
	"queue_replicate_rebalancenonvoterreplica":                    "queue.replicate.rebalancenonvoterreplica",
	"queue_replicate_rebalancereplica":                            "queue.replicate.rebalancereplica",
	"queue_replicate_rebalancevoterreplica":                       "queue.replicate.rebalancevoterreplica",
	"queue_replicate_removedeadnonvoterreplica":                   "queue.replicate.removedeadnonvoterreplica",
	"queue_replicate_removedeadreplica":                           "queue.replicate.removedeadreplica",
	"queue_replicate_removedeadreplica_error":                     "queue.replicate.removedeadreplica.error",
	"queue_replicate_removedeadreplica_success":                   "queue.replicate.removedeadreplica.success",
	"queue_replicate_removedeadvoterreplica":                      "queue.replicate.removedeadvoterreplica",
	"queue_replicate_removedecommissioningnonvoterreplica":        "queue.replicate.removedecommissioningnonvoterreplica",
	"queue_replicate_removedecommissioningreplica":                "queue.replicate.removedecommissioningreplica",
	"queue_replicate_removedecommissioningreplica_error":          "queue.replicate.removedecommissioningreplica.error",
	"queue_replicate_removedecommissioningreplica_success":        "queue.replicate.removedecommissioningreplica.success",
	"queue_replicate_removedecommissioningvoterreplica":           "queue.replicate.removedecommissioningvoterreplica",
	"queue_replicate_removelearnerreplica":                        "queue.replicate.removelearnerreplica",
	"queue_replicate_removenonvoterreplica":                       "queue.replicate.removenonvoterreplica",
	"queue_replicate_removereplica":                               "queue.replicate.removereplica",
	"queue_replicate_removereplica_error":                         "queue.replicate.removereplica.error",
	"queue_replicate_removereplica_success":                       "queue.replicate.removereplica.success",
	"queue_replicate_removevoterreplica":                          "queue.replicate.removevoterreplica",
	"queue_replicate_replacedeadreplica_error":                    "queue.replicate.replacedeadreplica.error",
	"queue_replicate_replacedeadreplica_success":                  "queue.replicate.replacedeadreplica.success",
	"queue_replicate_replacedecommissioningreplica_error":         "queue.replicate.replacedecommissioningreplica.error",
	"queue_replicate_replacedecommissioningreplica_success":       "queue.replicate.replacedecommissioningreplica.success",
	"queue_replicate_transferlease":                               "queue.replicate.transferlease",
	"queue_replicate_voterdemotions":                              "queue.replicate.voterdemotions",
	"queue_split_load_based":                                      "queue.split.load_based",
	"queue_split_pending":                                         "queue.split.pending",
	"queue_split_process_failure":                                 "queue.split.process.failure",
	"queue_split_process_success":                                 "queue.split.process.success",
	"queue_split_processingnanos":                                 "queue.split.processingnanos",
	"queue_split_purgatory":                                       "queue.split.purgatory",
	"queue_split_size_based":                                      "queue.split.size_based",
	"queue_split_span_config_based":                               "queue.split.span_config_based",
	"queue_tsmaintenance_pending":                                 "queue.tsmaintenance.pending",
	"queue_tsmaintenance_process_failure":                         "queue.tsmaintenance.process.failure",
	"queue_tsmaintenance_process_success":                         "queue.tsmaintenance.process.success",
	"queue_tsmaintenance_processingnanos":                         "queue.tsmaintenance.processingnanos",
	"raft_commands_pending":                                       "raft.commands.pending",
	"raft_commands_proposed":                                      "raft.commands.proposed",
	"raft_commands_reproposed_new_lai":                            "raft.commands.reproposed.new_lai",
	"raft_commands_reproposed_unchanged":                          "raft.commands.reproposed.unchanged",
	"raft_commandsapplied":                                        "raft.commandsapplied",
	"raft_dropped":                                                "raft.dropped",
	"raft_dropped_leader":                                         "raft.dropped_leader",
	"raft_enqueued_pending":                                       "raft.enqueued.pending",
	"raft_entrycache_accesses":                                    "raft.entrycache.accesses",
	"raft_entrycache_bytes":                                       "raft.entrycache.bytes",
	"raft_entrycache_hits":                                        "raft.entrycache.hits",
	"raft_entrycache_read_bytes":                                  "raft.entrycache.read_bytes",
	"raft_entrycache_size":                                        "raft.entrycache.size",
	"raft_heartbeats_pending":                                     "raft.heartbeats.pending",
	"raft_loaded_entries_bytes":                                   "raft.loaded_entries.bytes",
	"raft_loaded_entries_reserved_bytes":                          "raft.loaded_entries.reserved.bytes",
	"raft_process_applycommitted_latency":                         "raft.process.applycommitted.latency",
	"raft_process_applycommitted_latency_bucket":                  "raft.process.applycommitted.latency.bucket",
	"raft_process_applycommitted_latency_count":                   "raft.process.applycommitted.latency.count",
	"raft_process_applycommitted_latency_sum":                     "raft.process.applycommitted.latency.sum",
	"raft_process_commandcommit_latency":                          "raft.process.commandcommit.latency",
	"raft_process_commandcommit_latency_bucket":                   "raft.process.commandcommit.latency.bucket",
	"raft_process_commandcommit_latency_count":                    "raft.process.commandcommit.latency.count",
	"raft_process_commandcommit_latency_sum":                      "raft.process.commandcommit.latency.sum",
	"raft_process_handleready_latency":                            "raft.process.handleready.latency",
	"raft_process_handleready_latency_bucket":                     "raft.process.handleready.latency.bucket",
	"raft_process_handleready_latency_count":                      "raft.process.handleready.latency.count",
	"raft_process_handleready_latency_sum":                        "raft.process.handleready.latency.sum",
	"raft_process_logcommit_latency":                              "raft.process.logcommit.latency",
	"raft_process_logcommit_latency_bucket":                       "raft.process.logcommit.latency.bucket",
	"raft_process_logcommit_latency_count":                        "raft.process.logcommit.latency.count",
	"raft_process_logcommit_latency_sum":                          "raft.process.logcommit.latency.sum",
	"raft_process_tickingnanos":                                   "raft.process.tickingnanos",
	"raft_process_workingnanos":                                   "raft.process.workingnanos",
	"raft_quota_pool_percent_used":                                "raft.quota_pool.percent_used",
	"raft_quota_pool_percent_used_bucket":                         "raft.quota_pool.percent_used.bucket",
	"raft_quota_pool_percent_used_count":                          "raft.quota_pool.percent_used.count",
	"raft_quota_pool_percent_used_sum":                            "raft.quota_pool.percent_used.sum",
	"raft_rcvd_app":                                               "raft.rcvd.app",
	"raft_rcvd_appresp":                                           "raft.rcvd.appresp",
	"raft_rcvd_bytes":                                             "raft.rcvd.bytes",
	"raft_rcvd_cross_region_bytes":                                "raft.rcvd.cross_region.bytes",
	"raft_rcvd_cross_zone_bytes":                                  "raft.rcvd.cross_zone.bytes",
	"raft_rcvd_dropped":                                           "raft.rcvd.dropped",
	"raft_rcvd_dropped_bytes":                                     "raft.rcvd.dropped_bytes",
	"raft_rcvd_heartbeat":                                         "raft.rcvd.heartbeat",
	"raft_rcvd_heartbeatresp":                                     "raft.rcvd.heartbeatresp",
	"raft_rcvd_prevote":                                           "raft.rcvd.prevote",
	"raft_rcvd_prevoteresp":                                       "raft.rcvd.prevoteresp",
	"raft_rcvd_prop":                                              "raft.rcvd.prop",
	"raft_rcvd_queued_bytes":                                      "raft.rcvd.queued_bytes",
	"raft_rcvd_snap":                                              "raft.rcvd.snap",
	"raft_rcvd_stepped_bytes":                                     "raft.rcvd.stepped_bytes",
	"raft_rcvd_timeoutnow":                                        "raft.rcvd.timeoutnow",
	"raft_rcvd_transferleader":                                    "raft.rcvd.transferleader",
	"raft_rcvd_vote":                                              "raft.rcvd.vote",
	"raft_rcvd_voteresp":                                          "raft.rcvd.voteresp",
	"raft_replication_latency":                                    "raft.replication.latency",
	"raft_replication_latency_bucket":                             "raft.replication.latency.bucket",
	"raft_replication_latency_count":                              "raft.replication.latency.count",
	"raft_replication_latency_sum":                                "raft.replication.latency.sum",
	"raft_scheduler_latency":                                      "raft.scheduler.latency",
	"raft_scheduler_latency_bucket":                               "raft.scheduler.latency.bucket",
	"raft_scheduler_latency_count":                                "raft.scheduler.latency.count",
	"raft_scheduler_latency_sum":                                  "raft.scheduler.latency.sum",
	"raft_sent_bytes":                                             "raft.sent.bytes",
	"raft_sent_cross_region_bytes":                                "raft.sent.cross_region.bytes",
	"raft_sent_cross_zone_bytes":                                  "raft.sent.cross_zone.bytes",
	"raft_storage_error":                                          "raft.storage.error",
	"raft_storage_read_bytes":                                     "raft.storage.read_bytes",
	"raft_ticks":                                                  "raft.ticks",
	"raft_timeoutcampaign":                                        "raft.timeoutcampaign",
	"raft_transport_flow_token_dispatches_dropped":                "raft.transport.flow_token_dispatches_dropped",
	"raft_transport_rcvd":                                         "raft.transport.rcvd",
	"raft_transport_reverse_rcvd":                                 "raft.transport.reverse_rcvd",
	"raft_transport_reverse_sent":                                 "raft.transport.reverse_sent",
	"raft_transport_send_queue_bytes":                             "raft.transport.send_queue_bytes",
	"raft_transport_send_queue_size":                              "raft.transport.send_queue_size",
	"raft_transport_sends_dropped":                                "raft.transport.sends_dropped",
	"raft_transport_sent":                                         "raft.transport.sent",
	"raft_fortification_resp_accepted":                            "raft.fortification_resp.accepted",
	"raft_fortification_resp_rejected":                            "raft.fortification_resp.rejected",
	"raft_fortification_skipped_no_support":                       "raft.fortification.skipped_no_support",
	"raftlog_behind":                                              "raftlog.behind",
	"raftlog_truncated":                                           "raftlog.truncated",
	"range_adds":                                                  "range.adds",
	"range_merges":                                                "range.merges",
	"range_raftleaderremovals":                                    "range.raftleaderremovals",
	"range_raftleadertransfers":                                   "range.raftleadertransfers",
	"range_recoveries":                                            "range.recoveries",
	"range_removes":                                               "range.removes",
	"range_snapshots_applied_initial":                             "range.snapshots.applied_initial",
	"range_snapshots_applied_non_voter":                           "range.snapshots.applied_non_voter",
	"range_snapshots_applied_voter":                               "range.snapshots.applied_voter",
	"range_snapshots_cross_region_rcvd_bytes":                     "range.snapshots.cross_region.rcvd_bytes",
	"range_snapshots_cross_region_sent_bytes":                     "range.snapshots.cross_region.sent_bytes",
	"range_snapshots_cross_zone_rcvd_bytes":                       "range.snapshots.cross_zone.rcvd_bytes",
	"range_snapshots_cross_zone_sent_bytes":                       "range.snapshots.cross_zone.sent_bytes",
	"range_snapshots_delegate_failures":                           "range.snapshots.delegate.failures",
	"range_snapshots_delegate_in_progress":                        "range.snapshots.delegate.in_progress",
	"range_snapshots_delegate_sent_bytes":                         "range.snapshots.delegate.sent_bytes",
	"range_snapshots_delegate_successes":                          "range.snapshots.delegate.successes",
	"range_snapshots_generated":                                   "range.snapshots.generated",
	"range_snapshots_normal_applied":                              "range.snapshots.normal_applied",
	"range_snapshots_preemptive_applied":                          "range.snapshots.preemptive_applied",
	"range_snapshots_rcvd_bytes":                                  "range.snapshots.rcvd_bytes",
	"range_snapshots_rebalancing_rcvd_bytes":                      "range.snapshots.rebalancing.rcvd_bytes",
	"range_snapshots_rebalancing_sent_bytes":                      "range.snapshots.rebalancing.sent_bytes",
	"range_snapshots_recovery_rcvd_bytes":                         "range.snapshots.recovery.rcvd_bytes",
	"range_snapshots_recovery_sent_bytes":                         "range.snapshots.recovery.sent_bytes",
	"range_snapshots_recv_failed":                                 "range.snapshots.recv_failed",
	"range_snapshots_recv_in_progress":                            "range.snapshots.recv_in_progress",
	"range_snapshots_recv_queue":                                  "range.snapshots.recv_queue",
	"range_snapshots_recv_queue_bytes":                            "range.snapshots.recv_queue_bytes",
	"range_snapshots_recv_total_in_progress":                      "range.snapshots.recv_total_in_progress",
	"range_snapshots_recv_unusable":                               "range.snapshots.recv_unusable",
	"range_snapshots_send_in_progress":                            "range.snapshots.send_in_progress",
	"range_snapshots_send_queue":                                  "range.snapshots.send_queue",
	"range_snapshots_send_queue_bytes":                            "range.snapshots.send_queue_bytes",
	"range_snapshots_send_total_in_progress":                      "range.snapshots.send_total_in_progress",
	"range_snapshots_sent_bytes":                                  "range.snapshots.sent_bytes",
	"range_snapshots_unknown_rcvd_bytes":                          "range.snapshots.unknown.rcvd_bytes",
	"range_snapshots_unknown_sent_bytes":                          "range.snapshots.unknown.sent_bytes",
	"range_snapshots_upreplication_rcvd_bytes":                    "range.snapshots.upreplication.rcvd_bytes",
	"range_snapshots_upreplication_sent_bytes":                    "range.snapshots.upreplication.sent_bytes",
	"range_splits":                                                "range.splits.total",
	"rangekeybytes":                                               "rangekeybytes",
	"rangekeycount":                                               "rangekeycount",
	"ranges":                                                      "ranges",
	"ranges_overreplicated":                                       "ranges.overreplicated",
	"ranges_unavailable":                                          "ranges.unavailable",
	"ranges_underreplicated":                                      "ranges.underreplicated",
	"rangevalbytes":                                               "rangevalbytes",
	"rangevalcount":                                               "rangevalcount",
	"rebalancing_cpunanospersecond":                               "rebalancing.cpunanospersecond",
	"rebalancing_lease_transfers":                                 "rebalancing.lease.transfers",
	"rebalancing_queriespersecond":                                "rebalancing.queriespersecond",
	"rebalancing_range_rebalances":                                "rebalancing.range.rebalances",
	"rebalancing_readbytespersecond":                              "rebalancing.readbytespersecond",
	"rebalancing_readspersecond":                                  "rebalancing.readspersecond",
	"rebalancing_replicas_cpunanospersecond":                      "rebalancing.replicas.cpunanospersecond",
	"rebalancing_replicas_cpunanospersecond_bucket":               "rebalancing.replicas.cpunanospersecond.bucket",
	"rebalancing_replicas_cpunanospersecond_count":                "rebalancing.replicas.cpunanospersecond.count",
	"rebalancing_replicas_cpunanospersecond_sum":                  "rebalancing.replicas.cpunanospersecond.sum",
	"rebalancing_replicas_queriespersecond":                       "rebalancing.replicas.queriespersecond",
	"rebalancing_replicas_queriespersecond_bucket":                "rebalancing.replicas.queriespersecond.bucket",
	"rebalancing_replicas_queriespersecond_count":                 "rebalancing.replicas.queriespersecond.count",
	"rebalancing_replicas_queriespersecond_sum":                   "rebalancing.replicas.queriespersecond.sum",
	"rebalancing_requestspersecond":                               "rebalancing.requestspersecond",
	"rebalancing_state_imbalanced_overfull_options_exhausted":     "rebalancing.state.imbalanced_overfull_options_exhausted",
	"rebalancing_writebytespersecond":                             "rebalancing.writebytespersecond",
	"rebalancing_writespersecond":                                 "rebalancing.writespersecond",
	"replicas":                                                    "replicas.total",
	"replicas_commandqueue_combinedqueuesize":                     "replicas.commandqueue.combinedqueuesize",
	"replicas_commandqueue_combinedreadcount":                     "replicas.commandqueue.combinedreadcount",
	"replicas_commandqueue_combinedwritecount":                    "replicas.commandqueue.combinedwritecount",
	"replicas_commandqueue_maxoverlaps":                           "replicas.commandqueue.maxoverlaps",
	"replicas_commandqueue_maxreadcount":                          "replicas.commandqueue.maxreadcount",
	"replicas_commandqueue_maxsize":                               "replicas.commandqueue.maxsize",
	"replicas_commandqueue_maxtreesize":                           "replicas.commandqueue.maxtreesize",
	"replicas_commandqueue_maxwritecount":                         "replicas.commandqueue.maxwritecount",
	"replicas_leaders":                                            "replicas.leaders",
	"replicas_leaders_invalid_lease":                              "replicas.leaders_invalid_lease",
	"replicas_leaders_not_leaseholders":                           "replicas.leaders.not_leaseholders",
	"replicas_leaders_not_fortified":                              "replicas.leaders.not_fortified",
	"replicas_leaseholders":                                       "replicas.leaseholders",
	"replicas_quiescent":                                          "replicas.quiescent",
	"replicas_reserved":                                           "replicas.reserved",
	"replicas_uninitialized":                                      "replicas.uninitialized",
	"requests_backpressure_split":                                 "requests.backpressure.split",
	"requests_slow_commandqueue":                                  "requests.slow.commandqueue",
	"requests_slow_distsender":                                    "requests.slow.distsender",
	"requests_slow_latch":                                         "requests.slow.latch",
	"requests_slow_lease":                                         "requests.slow.lease",
	"requests_slow_raft":                                          "requests.slow.raft",
	"rocksdb.compactions.total":                                   "rocksdb.compactions",
	"rocksdb_block_cache_hits":                                    "rocksdb.block.cache.hits",
	"rocksdb_block_cache_misses":                                  "rocksdb.block.cache.misses",
	"rocksdb_block_cache_pinned_usage":                            "rocksdb.block.cache.pinned.usage",
	"rocksdb_block_cache_usage":                                   "rocksdb.block.cache.usage",
	"rocksdb_bloom_filter_prefix_checked":                         "rocksdb.bloom_filter.prefix.checked",
	"rocksdb_bloom_filter_prefix_useful":                          "rocksdb.bloom_filter.prefix.useful",
	"rocksdb_compacted_bytes_read":                                "rocksdb.compacted_bytes_read",
	"rocksdb_compacted_bytes_written":                             "rocksdb.compacted_bytes_written",
	"rocksdb_compactions":                                         "rocksdb.compactions.total",
	"rocksdb_encryption_algorithm":                                "rocksdb.encryption.algorithm",
	"rocksdb_estimated_pending_compaction":                        "rocksdb.estimated_pending_compaction",
	"rocksdb_flushed_bytes":                                       "rocksdb.flushed_bytes",
	"rocksdb_flushes":                                             "rocksdb.flushes.total",
	"rocksdb_ingested_bytes":                                      "rocksdb.ingested_bytes",
	"rocksdb_memtable_total_size":                                 "rocksdb.memtable.total.size",
	"rocksdb_num_sstables":                                        "rocksdb.num_sstables",
	"rocksdb_read_amplification":                                  "rocksdb.read.amplification",
	"rocksdb_table_readers_mem_estimate":                          "rocksdb.table.readers.mem.estimate",
	"round_trip_latency":                                          "round_trip.latency",
	"round_trip_latency_bucket":                                   "round_trip_latency.bucket",
	"round_trip_latency_count":                                    "round_trip_latency.count",
	"round_trip_latency_sum":                                      "round_trip_latency.sum",
	"rpc_batches_recv":                                            "rpc.batches.recv",
	"rpc_connection_avg_round_trip_latency":                       "rpc.connection.avg_round_trip_latency",
	"rpc_connection_failures":                                     "rpc.connection.failures",
	"rpc_connection_healthy":                                      "rpc.connection.healthy",
	"rpc_connection_healthy_nanos":                                "rpc.connection.healthy_nanos",
	"rpc_connection_heartbeats":                                   "rpc.connection.heartbeats",
	"rpc_connection_inactive":                                     "rpc.connection.inactive",
	"rpc_connection_unhealthy":                                    "rpc.connection.unhealthy",
	"rpc_connection_unhealthy_nanos":                              "rpc.connection.unhealthy_nanos",
	"rpc_method_addsstable_recv":                                  "rpc.method.addsstable.recv",
	"rpc_method_adminchangereplicas_recv":                         "rpc.method.adminchangereplicas.recv",
	"rpc_method_adminmerge_recv":                                  "rpc.method.adminmerge.recv",
	"rpc_method_adminrelocaterange_recv":                          "rpc.method.adminrelocaterange.recv",
	"rpc_method_adminscatter_recv":                                "rpc.method.adminscatter.recv",
	"rpc_method_adminsplit_recv":                                  "rpc.method.adminsplit.recv",
	"rpc_method_admintransferlease_recv":                          "rpc.method.admintransferlease.recv",
	"rpc_method_adminunsplit_recv":                                "rpc.method.adminunsplit.recv",
	"rpc_method_adminverifyprotectedtimestamp_recv":               "rpc.method.adminverifyprotectedtimestamp.recv",
	"rpc_method_barrier_recv":                                     "rpc.method.barrier.recv",
	"rpc_method_checkconsistency_recv":                            "rpc.method.checkconsistency.recv",
	"rpc_method_clearrange_recv":                                  "rpc.method.clearrange.recv",
	"rpc_method_computechecksum_recv":                             "rpc.method.computechecksum.recv",
	"rpc_method_conditionalput_recv":                              "rpc.method.conditionalput.recv",
	"rpc_method_delete_recv":                                      "rpc.method.delete.recv",
	"rpc_method_deleterange_recv":                                 "rpc.method.deleterange.recv",
	"rpc_method_endtxn_recv":                                      "rpc.method.endtxn.recv",
	"rpc_method_export_recv":                                      "rpc.method.export.recv",
	"rpc_method_gc_recv":                                          "rpc.method.gc.recv",
	"rpc_method_get_recv":                                         "rpc.method.get.recv",
	"rpc_method_heartbeattxn_recv":                                "rpc.method.heartbeattxn.recv",
	"rpc_method_increment_recv":                                   "rpc.method.increment.recv",
	"rpc_method_initput_recv":                                     "rpc.method.initput.recv",
	"rpc_method_isspanempty_recv":                                 "rpc.method.isspanempty.recv",
	"rpc_method_leaseinfo_recv":                                   "rpc.method.leaseinfo.recv",
	"rpc_method_linkexternalsstable_recv":                         "rpc.method.linkexternalsstable.recv",
	"rpc_method_merge_recv":                                       "rpc.method.merge.recv",
	"rpc_method_migrate_recv":                                     "rpc.method.migrate.recv",
	"rpc_method_probe_recv":                                       "rpc.method.probe.recv",
	"rpc_method_pushtxn_recv":                                     "rpc.method.pushtxn.recv",
	"rpc_method_put_recv":                                         "rpc.method.put.recv",
	"rpc_method_queryintent_recv":                                 "rpc.method.queryintent.recv",
	"rpc_method_querylocks_recv":                                  "rpc.method.querylocks.recv",
	"rpc_method_queryresolvedtimestamp_recv":                      "rpc.method.queryresolvedtimestamp.recv",
	"rpc_method_querytxn_recv":                                    "rpc.method.querytxn.recv",
	"rpc_method_rangestats_recv":                                  "rpc.method.rangestats.recv",
	"rpc_method_recomputestats_recv":                              "rpc.method.recomputestats.recv",
	"rpc_method_recovertxn_recv":                                  "rpc.method.recovertxn.recv",
	"rpc_method_refresh_recv":                                     "rpc.method.refresh.recv",
	"rpc_method_refreshrange_recv":                                "rpc.method.refreshrange.recv",
	"rpc_method_requestlease_recv":                                "rpc.method.requestlease.recv",
	"rpc_method_resolveintent_recv":                               "rpc.method.resolveintent.recv",
	"rpc_method_resolveintentrange_recv":                          "rpc.method.resolveintentrange.recv",
	"rpc_method_reversescan_recv":                                 "rpc.method.reversescan.recv",
	"rpc_method_revertrange_recv":                                 "rpc.method.revertrange.recv",
	"rpc_method_scan_recv":                                        "rpc.method.scan.recv",
	"rpc_method_subsume_recv":                                     "rpc.method.subsume.recv",
	"rpc_method_transferlease_recv":                               "rpc.method.transferlease.recv",
	"rpc_method_truncatelog_recv":                                 "rpc.method.truncatelog.recv",
	"rpc_method_writebatch_recv":                                  "rpc.method.writebatch.recv",
	"rpc_streams_mux_rangefeed_active":                            "rpc.streams.mux_rangefeed.active",
	"rpc_streams_mux_rangefeed_recv":                              "rpc.streams.mux_rangefeed.recv",
	"rpc_streams_rangefeed_active":                                "rpc.streams.rangefeed.active",
	"rpc_streams_rangefeed_recv":                                  "rpc.streams.rangefeed.recv",
	"schedules_BACKUP_failed":                                     "schedules.backup.failed",
	"schedules_BACKUP_last_completed_time":                        "schedules.backup.last_completed_time",
	"schedules_BACKUP_protected_age_sec":                          "schedules.BACKUP.protected_age_sec",
	"schedules_BACKUP_protected_record_count":                     "schedules.BACKUP.protected_record_count",
	"schedules_BACKUP_started":                                    "schedules.backup.started",
	"schedules_BACKUP_succeeded":                                  "schedules.backup.succeeded",
	"schedules_CHANGEFEED_failed":                                 "schedules.CHANGEFEED.failed",
	"schedules_CHANGEFEED_started":                                "schedules.CHANGEFEED.started",
	"schedules_CHANGEFEED_succeeded":                              "schedules.CHANGEFEED.succeeded",
	"schedules_error":                                             "schedules.error",
	"schedules_malformed":                                         "schedules.malformed",
	"schedules_round_jobs_started":                                "schedules.round.jobs_started",
	"schedules_round_reschedule_skip":                             "schedules.round.reschedule_skip",
	"schedules_round_reschedule_wait":                             "schedules.round.reschedule_wait",
	"schedules_scheduled_row_level_ttl_executor_failed":           "schedules.scheduled.row.level.ttl.executor_failed",
	"schedules_scheduled_row_level_ttl_executor_started":          "schedules.scheduled_row_level_ttl_executor.started",
	"schedules_scheduled_row_level_ttl_executor_succeeded":        "schedules.scheduled_row_level_ttl_executor.succeeded",
	"schedules_scheduled_schema_telemetry_executor_failed":        "schedules.scheduled_schema_telemetry_executor.failed",
	"schedules_scheduled_schema_telemetry_executor_started":       "schedules.scheduled_schema_telemetry_executor.started",
	"schedules_scheduled_schema_telemetry_executor_succeeded":     "schedules.scheduled_schema_telemetry_executor.succeeded",
	"schedules_scheduled_sql_stats_compaction_executor_failed":    "schedules.scheduled_sql_stats_compaction_executor.failed",
	"schedules_scheduled_sql_stats_compaction_executor_started":   "schedules.scheduled_sql_stats_compaction_executor.started",
	"schedules_scheduled_sql_stats_compaction_executor_succeeded": "schedules.scheduled_sql_stats_compaction_executor.succeeded",
	"seconds_until_enterprise_license_expiry":                     "seconds.until.enterprise.license.expiry",
	"security_certificate_expiration_ca":                          "security.certificate_expiration.ca",
	"security_certificate_expiration_ca_client_tenant":            "security.certificate.expiration.ca_client_tenant",
	"security_certificate_expiration_client":                      "security.certificate.expiration.client",
	"security_certificate_expiration_client_ca":                   "security.certificate_expiration.client_ca",
	"security_certificate_expiration_client_tenant":               "security.certificate.expiration.client_tenant",
	"security_certificate_expiration_node":                        "security.certificate_expiration.node",
	"security_certificate_expiration_node_client":                 "security.certificate_expiration.node_client",
	"security_certificate_expiration_ui":                          "security.certificate_expiration.ui",
	"security_certificate_expiration_ui_ca":                       "security.certificate_expiration.ui_ca",
	"server_http_request_duration_nanos":                          "server.http.request.duration.nanos",
	"server_http_request_duration_nanos_bucket":                   "server.http.request.duration.nanos.bucket",
	"server_http_request_duration_nanos_count":                    "server.http.request.duration.nanos.count",
	"server_http_request_duration_nanos_sum":                      "server.http.request.duration.nanos.sum",
	"spanconfig_kvsubscriber_oldest_protected_record_nanos":       "spanconfig.kvsubscriber.oldest_protected_record_nanos",
	"spanconfig_kvsubscriber_protected_record_count":              "spanconfig.kvsubscriber.protected_record_count",
	"spanconfig_kvsubscriber_update_behind_nanos":                 "spanconfig.kvsubscriber.update_behind_nanos",
	"sql_bytesin":                                                 "sql.bytesin",
	"sql_bytesout":                                                "sql.bytesout",
	"sql_conn_failures":                                           "sql.conn.failures",
	"sql_conn_latency":                                            "sql.conn.latency",
	"sql_conn_latency_bucket":                                     "sql.conn.latency.bucket",
	"sql_conn_latency_count":                                      "sql.conn.latency.count",
	"sql_conn_latency_sum":                                        "sql.conn.latency.sum",
	"sql_conns":                                                   "sql.conns",
	"sql_conns_waiting_to_hash":                                   "sql.conns_waiting_to_hash",
	"sql_contention_resolver_failed_resolutions":                  "sql.contention.resolver.failed_resolutions",
	"sql_contention_resolver_queue_size":                          "sql.contention.resolver.queue_size",
	"sql_contention_resolver_retries":                             "sql.contention.resolver.retries",
	"sql_contention_txn_id_cache_miss":                            "sql.contention.txn_id_cache.miss",
	"sql_contention_txn_id_cache_read":                            "sql.contention.txn_id_cache.read",
	"sql_copy_count":                                              "sql.copy.count",
	"sql_copy_count_internal":                                     "sql.copy.internal",
	"sql_copy_nonatomic_count":                                    "sql.copy.nonatomic.count",
	"sql_copy_nonatomic_count_internal":                           "sql.copy.nonatomic.internal",
	"sql_copy_nonatomic_started_count":                            "sql.copy.nonatomic.started.count",
	"sql_copy_nonatomic_started_count_internal":                   "sql.copy.nonatomic.started.internal",
	"sql_copy_started_count":                                      "sql.copy.started.count",
	"sql_copy_started_count_internal":                             "sql.copy.started.internal",
	"sql_ddl_count":                                               "sql.ddl.count",
	"sql_ddl_count_internal":                                      "sql.ddl.internal",
	"sql_ddl_started_count":                                       "sql.ddl.started.count",
	"sql_ddl_started_count_internal":                              "sql.ddl.started.internal",
	"sql_delete_count":                                            "sql.delete.count",
	"sql_delete_count_internal":                                   "sql.delete.internal",
	"sql_delete_started_count":                                    "sql.delete.started.count",
	"sql_delete_started_count_internal":                           "sql.delete.started.internal",
	"sql_disk_distsql_current":                                    "sql.disk.distsql.current",
	"sql_disk_distsql_max":                                        "sql.disk.distsql.max",
	"sql_disk_distsql_max_bucket":                                 "sql.disk.distsql.max.bucket",
	"sql_disk_distsql_max_count":                                  "sql.disk.distsql.max.count",
	"sql_disk_distsql_max_sum":                                    "sql.disk.distsql.max.sum",
	"sql_disk_distsql_spilled_bytes_read":                         "sql.disk.distsql.spilled.bytes.read",
	"sql_disk_distsql_spilled_bytes_written":                      "sql.disk.distsql.spilled.bytes.written",
	"sql_distsql_contended_queries_count":                         "sql.distsql.contended.queries",
	"sql_distsql_cumulative_contention_nanos":                     "sql.distsql.cumulative_contention_nanos",
	"sql_distsql_distributed_exec_count":                          "sql.distsql.distributed_exec.count",
	"sql_distsql_dist_query_rerun_locally_count":                  "sql.distsql.dist_query_rerun_locally.count",
	"sql_distsql_dist_query_rerun_locally_failure_count":          "sql.distsql.dist_query_rerun_locally.failure_count",
	"sql_distsql_exec_latency":                                    "sql.distsql.exec.latency",
	"sql_distsql_exec_latency_bucket":                             "sql.distsql.exec.latency.bucket",
	"sql_distsql_exec_latency_count":                              "sql.distsql.exec.latency.count",
	"sql_distsql_exec_latency_internal":                           "sql.distsql.exec.latency.internal",
	"sql_distsql_exec_latency_internal_bucket":                    "sql.distsql.exec.latency.internal.bucket",
	"sql_distsql_exec_latency_internal_count":                     "sql.distsql.exec.latency.internal.count",
	"sql_distsql_exec_latency_internal_sum":                       "sql.distsql.exec.latency.internal.sum",
	"sql_distsql_exec_latency_sum":                                "sql.distsql.exec.latency.sum",
	"sql_distsql_flows_active":                                    "sql.distsql.flows.active",
	"sql_distsql_flows_total":                                     "sql.distsql.flows.total",
	"sql_distsql_queries_active":                                  "sql.distsql.queries.active",
	"sql_distsql_queries_spilled":                                 "sql.distsql.queries.spilled",
	"sql_distsql_queries_total":                                   "sql.distsql.queries.total",
	"sql_distsql_select_count":                                    "sql.distsql.select.count",
	"sql_distsql_select_count_internal":                           "sql.distsql.select.count.internal",
	"sql_distsql_select_distributed_exec_count":                   "sql.distsql.select.distributed_exec.count",
	"sql_distsql_select_distributed_exec_count_internal":          "sql.distsql.select.distributed_exec.count.internal",
	"sql_distsql_service_latency":                                 "sql.distsql.service.latency",
	"sql_distsql_service_latency_bucket":                          "sql.distsql.service.latency.bucket",
	"sql_distsql_service_latency_count":                           "sql.distsql.service.latency.count",
	"sql_distsql_service_latency_internal":                        "sql.distsql.service.latency.internal",
	"sql_distsql_service_latency_internal_bucket":                 "sql.distsql.service.latency.internal.bucket",
	"sql_distsql_service_latency_internal_count":                  "sql.distsql.service.latency.internal.count",
	"sql_distsql_service_latency_internal_sum":                    "sql.distsql.service.latency.internal.sum",
	"sql_distsql_service_latency_sum":                             "sql.distsql.service.latency.sum",
	"sql_distsql_vec_openfds":                                     "sql.distsql.vec.openfds",
	"sql_exec_latency":                                            "sql.exec.latency",
	"sql_exec_latency_bucket":                                     "sql.exec.latency.bucket",
	"sql_exec_latency_count":                                      "sql.exec.latency.count",
	"sql_exec_latency_internal":                                   "sql.exec.latency.internal",
	"sql_exec_latency_internal_bucket":                            "sql.exec.latency.internal.bucket",
	"sql_exec_latency_internal_count":                             "sql.exec.latency.internal.count",
	"sql_exec_latency_internal_sum":                               "sql.exec.latency.internal.sum",
	"sql_exec_latency_sum":                                        "sql.exec.latency.sum",
	"sql_failure_count":                                           "sql.failure",
	"sql_failure_count_internal":                                  "sql.failure.internal",
	"sql_feature_flag_denial":                                     "sql.feature_flag_denial",
	"sql_full_scan_count":                                         "sql.full.scan",
	"sql_full_scan_count_internal":                                "sql.full.scan.internal",
	"sql_guardrails_full_scan_rejected_count":                     "sql.guardrails.full_scan_rejected.count",
	"sql_guardrails_full_scan_rejected_count_internal":            "sql.guardrails.full_scan_rejected.internal",
	"sql_guardrails_max_row_size_err_count":                       "sql.guardrails.max_row_size_err.count",
	"sql_guardrails_max_row_size_err_count_internal":              "sql.guardrails.max_row_size_err.internal",
	"sql_guardrails_max_row_size_log_count":                       "sql.guardrails.max_row_size_log.count",
	"sql_guardrails_max_row_size_log_count_internal":              "sql.guardrails.max_row_size_log.internal",
	"sql_guardrails_transaction_rows_read_err_count":              "sql.guardrails.transaction_rows_read_err.count",
	"sql_guardrails_transaction_rows_read_err_count_internal":     "sql.guardrails.transaction_rows_read_err.internal",
	"sql_guardrails_transaction_rows_read_log_count":              "sql.guardrails.transaction_rows_read_log.count",
	"sql_guardrails_transaction_rows_read_log_count_internal":     "sql.guardrails.transaction_rows_read_log.internal",
	"sql_guardrails_transaction_rows_written_err_count":           "sql.guardrails.transaction_rows_written_err.count",
	"sql_guardrails_transaction_rows_written_err_count_internal":  "sql.guardrails.transaction_rows_written_err.internal",
	"sql_guardrails_transaction_rows_written_log_count":           "sql.guardrails.transaction_rows_written_log.count",
	"sql_guardrails_transaction_rows_written_log_count_internal":  "sql.guardrails.transaction_rows_written_log.internal",
	"sql_hydrated_schema_cache_hits":                              "sql.hydrated_schema_cache.hits",
	"sql_hydrated_schema_cache_misses":                            "sql.hydrated_schema_cache.misses",
	"sql_hydrated_table_cache_hits":                               "sql.hydrated_table_cache.hits",
	"sql_hydrated_table_cache_misses":                             "sql.hydrated_table_cache.misses",
	"sql_hydrated_type_cache_hits":                                "sql.hydrated_type_cache.hits",
	"sql_hydrated_type_cache_misses":                              "sql.hydrated_type_cache.misses",
	"sql_hydrated_udf_cache_hits":                                 "sql.hydrated_udf_cache.hits",
	"sql_hydrated_udf_cache_misses":                               "sql.hydrated_udf_cache.misses",
	"sql_insert_count":                                            "sql.insert.count",
	"sql_insert_count_internal":                                   "sql.insert.internal",
	"sql_insert_started_count":                                    "sql.insert.started.count",
	"sql_insert_started_count_internal":                           "sql.insert.started.internal",
	"sql_insights_anomaly_detection_evictions":                    "sql.insights.anomaly_detection.evictions",
	"sql_insights_anomaly_detection_fingerprints":                 "sql.insights.anomaly_detection.fingerprints",
	"sql_insights_anomaly_detection_memory":                       "sql.insights.anomaly_detection.memory",
	"sql_leases_active":                                           "sql.leases.active",
	"sql_leases_expired":                                          "sql.leases.expired",
	"sql_leases_long_wait_for_no_version":                         "sql.leases.long_wait_for_no_version",
	"sql_leases_long_wait_for_one_version":                        "sql.leases.long_wait_for_one_version",
	"sql_leases_long_wait_for_two_version_invariant":              "sql.leases.long_wait_for_two_version_invariant",
	"sql_leases_waiting_to_expire":                                "sql.leases.waiting_to_expire",
	"sql_mem_admin_current":                                       "sql.mem.admin.current",
	"sql_mem_admin_max":                                           "sql.mem.admin.max",
	"sql_mem_admin_session_current":                               "sql.mem.admin.session.current",
	"sql_mem_admin_session_max":                                   "sql.mem.admin.session.max",
	"sql_mem_admin_txn_current":                                   "sql.mem.admin.txn.current",
	"sql_mem_admin_txn_max":                                       "sql.mem.admin.txn.max",
	"sql_mem_bulk_current":                                        "sql.mem.bulk.current",
	"sql_mem_bulk_max":                                            "sql.mem.bulk.max",
	"sql_mem_bulk_max_bucket":                                     "sql.mem.bulk.max.bucket",
	"sql_mem_bulk_max_count":                                      "sql.mem.bulk.max.count",
	"sql_mem_bulk_max_sum":                                        "sql.mem.bulk.max.sum",
	"sql_mem_client_current":                                      "sql.mem.client.current",
	"sql_mem_client_max":                                          "sql.mem.client.max",
	"sql_mem_client_session_current":                              "sql.mem.client.session.current",
	"sql_mem_client_session_max":                                  "sql.mem.client.session.max",
	"sql_mem_client_txn_current":                                  "sql.mem.client.txn.current",
	"sql_mem_client_txn_max":                                      "sql.mem.client.txn.max",
	"sql_mem_conns_current":                                       "sql.mem.conns.current",
	"sql_mem_conns_max":                                           "sql.mem.conns.max",
	"sql_mem_conns_max_bucket":                                    "sql.mem.conns.max.bucket",
	"sql_mem_conns_max_count":                                     "sql.mem.conns.max.count",
	"sql_mem_conns_max_sum":                                       "sql.mem.conns.max.sum",
	"sql_mem_conns_session_current":                               "sql.mem.conns.session.current",
	"sql_mem_conns_session_max":                                   "sql.mem.conns.session.max",
	"sql_mem_conns_txn_current":                                   "sql.mem.conns.txn.current",
	"sql_mem_conns_txn_max":                                       "sql.mem.conns.txn.max",
	"sql_mem_distsql_current":                                     "sql.mem.distsql.current",
	"sql_mem_distsql_max":                                         "sql.mem.distsql.max",
	"sql_mem_distsql_max_bucket":                                  "sql.mem.distsql.max.bucket",
	"sql_mem_distsql_max_count":                                   "sql.mem.distsql.max.count",
	"sql_mem_distsql_max_sum":                                     "sql.mem.distsql.max.sum",
	"sql_mem_internal_current":                                    "sql.mem.internal.current",
	"sql_mem_internal_max":                                        "sql.mem.internal.max",
	"sql_mem_internal_max_bucket":                                 "sql.mem.internal.max.bucket",
	"sql_mem_internal_max_count":                                  "sql.mem.internal.max.count",
	"sql_mem_internal_max_sum":                                    "sql.mem.internal.max.sum",
	"sql_mem_internal_session_current":                            "sql.mem.internal.session.current",
	"sql_mem_internal_session_max":                                "sql.mem.internal.session.max",
	"sql_mem_internal_session_max_bucket":                         "sql.mem.internal.session.max.bucket",
	"sql_mem_internal_session_max_count":                          "sql.mem.internal.session.max.count",
	"sql_mem_internal_session_max_sum":                            "sql.mem.internal.session.max.sum",
	"sql_mem_internal_session_prepared_current":                   "sql.mem.internal.session.prepared.current",
	"sql_mem_internal_session_prepared_max":                       "sql.mem.internal.session.prepared.max",
	"sql_mem_internal_session_prepared_max_bucket":                "sql.mem.internal.session.prepared.max.bucket",
	"sql_mem_internal_session_prepared_max_count":                 "sql.mem.internal.session.prepared.max.count",
	"sql_mem_internal_session_prepared_max_sum":                   "sql.mem.internal.session.prepared.max.sum",
	"sql_mem_internal_txn_current":                                "sql.mem.internal.txn.current",
	"sql_mem_internal_txn_max":                                    "sql.mem.internal.txn.max",
	"sql_mem_internal_txn_max_bucket":                             "sql.mem.internal.txn.max.bucket",
	"sql_mem_internal_txn_max_count":                              "sql.mem.internal.txn.max.count",
	"sql_mem_internal_txn_max_sum":                                "sql.mem.internal.txn.max.sum",
	"sql_mem_root_current":                                        "sql.mem.root.current",
	"sql_mem_root_max":                                            "sql.mem.root.max",
	"sql_mem_root_max_bucket":                                     "sql.mem.root.max.bucket",
	"sql_mem_root_max_count":                                      "sql.mem.root.max.count",
	"sql_mem_root_max_sum":                                        "sql.mem.root.max.sum",
	"sql_mem_sql_current":                                         "sql.mem.sql.current",
	"sql_mem_sql_max":                                             "sql.mem.sql.max",
	"sql_mem_sql_max_bucket":                                      "sql.mem.sql.max.bucket",
	"sql_mem_sql_max_count":                                       "sql.mem.sql.max.count",
	"sql_mem_sql_max_sum":                                         "sql.mem.sql.max.sum",
	"sql_mem_sql_session_current":                                 "sql.mem.sql.session.current",
	"sql_mem_sql_session_max":                                     "sql.mem.sql.session.max",
	"sql_mem_sql_session_max_bucket":                              "sql.mem.sql.session.max.bucket",
	"sql_mem_sql_session_max_count":                               "sql.mem.sql.session.max.count",
	"sql_mem_sql_session_max_sum":                                 "sql.mem.sql.session.max.sum",
	"sql_mem_sql_session_prepared_current":                        "sql.mem.sql.session.prepared.current",
	"sql_mem_sql_session_prepared_max":                            "sql.mem.sql.session.prepared.max",
	"sql_mem_sql_session_prepared_max_bucket":                     "sql.mem.sql.session.prepared.max.bucket",
	"sql_mem_sql_session_prepared_max_count":                      "sql.mem.sql.session.prepared.max.count",
	"sql_mem_sql_session_prepared_max_sum":                        "sql.mem.sql.session.prepared.max.sum",
	"sql_mem_sql_txn_current":                                     "sql.mem.sql.txn.current",
	"sql_mem_sql_txn_max":                                         "sql.mem.sql.txn.max",
	"sql_mem_sql_txn_max_bucket":                                  "sql.mem.sql.txn.max.bucket",
	"sql_mem_sql_txn_max_count":                                   "sql.mem.sql.txn.max.count",
	"sql_mem_sql_txn_max_sum":                                     "sql.mem.sql.txn.max.sum",
	"sql_misc_count":                                              "sql.misc.count",
	"sql_misc_count_internal":                                     "sql.misc.internal",
	"sql_misc_started_count":                                      "sql.misc.started.count",
	"sql_misc_started_count_internal":                             "sql.misc.started.internal",
	"sql_new_conns":                                               "sql.new_conns",
	"sql_optimizer_fallback_count":                                "sql.optimizer.fallback.count",
	"sql_optimizer_fallback_count_internal":                       "sql.optimizer.fallback.internal",
	"sql_optimizer_plan_cache_hits":                               "sql.optimizer.plan_cache.hits",
	"sql_optimizer_plan_cache_hits_internal":                      "sql.optimizer.plan_cache.hits.internal",
	"sql_optimizer_plan_cache_misses":                             "sql.optimizer.plan_cache.misses",
	"sql_optimizer_plan_cache_misses_internal":                    "sql.optimizer.plan_cache.misses.internal",
	"sql_pgwire_cancel_ignored":                                   "sql.pgwire_cancel.ignored",
	"sql_pgwire_cancel_successful":                                "sql.pgwire_cancel.successful",
	"sql_pgwire_cancel_total":                                     "sql.pgwire_cancel.total",
	"sql_pgwire_pipeline_count":                                   "sql.pgwire.pipeline.count",
	"sql_pre_serve_bytesin":                                       "sql.pre_serve.bytesin",
	"sql_pre_serve_bytesout":                                      "sql.pre_serve.bytesout",
	"sql_pre_serve_conn_failures":                                 "sql.pre_serve.conn.failures",
	"sql_pre_serve_mem_cur":                                       "sql.pre_serve.mem.cur",
	"sql_pre_serve_mem_max":                                       "sql.pre_serve.mem.max",
	"sql_pre_serve_mem_max_bucket":                                "sql.pre_serve.mem.max.bucket",
	"sql_pre_serve_mem_max_count":                                 "sql.pre_serve.mem.max.count",
	"sql_pre_serve_mem_max_sum":                                   "sql.pre_serve.mem.max.sum",
	"sql_pre_serve_new_conns":                                     "sql.pre_serve.new_conns",
	"sql_query_count":                                             "sql.query.count",
	"sql_query_count_internal":                                    "sql.query.internal",
	"sql_query_started_count":                                     "sql.query.started.count",
	"sql_query_started_count_internal":                            "sql.query.started.internal",
	"sql_restart_savepoint_count":                                 "sql.restart_savepoint.count",
	"sql_restart_savepoint_count_internal":                        "sql.restart_savepoint.internal",
	"sql_restart_savepoint_release_count":                         "sql.restart_savepoint.release.count",
	"sql_restart_savepoint_release_count_internal":                "sql.restart_savepoint.release.internal",
	"sql_restart_savepoint_release_started_count":                 "sql.restart_savepoint.release.started.count",
	"sql_restart_savepoint_release_started_count_internal":        "sql.restart_savepoint.release.started.internal",
	"sql_restart_savepoint_rollback_count":                        "sql.restart_savepoint.rollback.count",
	"sql_restart_savepoint_rollback_count_internal":               "sql.restart_savepoint.rollback.internal",
	"sql_restart_savepoint_rollback_started_count":                "sql.restart_savepoint.rollback.started.count",
	"sql_restart_savepoint_rollback_started_count_internal":       "sql.restart_savepoint.rollback.started.internal",
	"sql_restart_savepoint_started_count":                         "sql.restart_savepoint.started.count",
	"sql_restart_savepoint_started_count_internal":                "sql.restart_savepoint.started.internal",
	"sql_savepoint_count":                                         "sql.savepoint.count",
	"sql_savepoint_count_internal":                                "sql.savepoint.internal",
	"sql_savepoint_release_count":                                 "sql.savepoint.release.count",
	"sql_savepoint_release_count_internal":                        "sql.savepoint.release.internal",
	"sql_savepoint_release_started_count":                         "sql.savepoint.release.started.count",
	"sql_savepoint_release_started_count_internal":                "sql.savepoint.release.started.internal",
	"sql_savepoint_rollback_count":                                "sql.savepoint.rollback.count",
	"sql_savepoint_rollback_count_internal":                       "sql.savepoint.rollback.internal",
	"sql_savepoint_rollback_started_count":                        "sql.savepoint.rollback.started.count",
	"sql_savepoint_rollback_started_count_internal":               "sql.savepoint.rollback.started.internal",
	"sql_savepoint_started_count":                                 "sql.savepoint.started.count",
	"sql_savepoint_started_count_internal":                        "sql.savepoint.started.internal",
	"sql_schema_changer_permanent_errors":                         "sql.schema_changer.permanent_errors",
	"sql_schema_changer_retry_errors":                             "sql.schema_changer.retry_errors",
	"sql_schema_changer_running":                                  "sql.schema_changer.running",
	"sql_schema_changer_successes":                                "sql.schema_changer.successes",
	"sql_schema_invalid_objects":                                  "sql.schema.invalid_objects",
	"sql_select_count":                                            "sql.select.count",
	"sql_select_count_internal":                                   "sql.select.internal",
	"sql_select_started_count":                                    "sql.select.started.count",
	"sql_select_started_count_internal":                           "sql.select.started.internal",
	"sql_service_latency":                                         "sql.service.latency",
	"sql_service_latency_bucket":                                  "sql.service.latency.bucket",
	"sql_service_latency_count":                                   "sql.service.latency.count",
	"sql_service_latency_internal":                                "sql.service.latency.internal",
	"sql_service_latency_internal_bucket":                         "sql.service.latency.internal.bucket",
	"sql_service_latency_internal_count":                          "sql.service.latency.internal.count",
	"sql_service_latency_internal_sum":                            "sql.service.latency.internal.sum",
	"sql_service_latency_sum":                                     "sql.service.latency.sum",
	"sql_statements_active":                                       "sql.statements.active",
	"sql_statements_active_internal":                              "sql.statements.active.internal",
	"sql_stats_activity_update_latency":                           "sql.stats.activity.update.latency",
	"sql_stats_activity_update_latency_bucket":                    "sql.stats.activity.update.latency.bucket",
	"sql_stats_activity_update_latency_count":                     "sql.stats.activity.update.latency.count",
	"sql_stats_activity_update_latency_sum":                       "sql.stats.activity.update.latency.sum",
	"sql_stats_activity_updates_failed":                           "sql.stats.activity.updates.failed",
	"sql_stats_activity_updates_successful":                       "sql.stats.activity.updates.successful",
	"sql_stats_cleanup_rows_removed":                              "sql.stats.cleanup.rows_removed",
	"sql_stats_discarded_current":                                 "sql.stats.discarded.current",
	"sql_stats_flush_count":                                       "sql.stats.flush.count",
	"sql_stats_flush_done_signals_ignored":                        "sql.stats.flush.done_signals.ignored",
	"sql_stats_flush_duration":                                    "sql.stats.flush.duration",
	"sql_stats_flush_error":                                       "sql.stats.flush.error",
	"sql_stats_flush_fingerprint_count":                           "sql.stats.flush.fingerprint.count",
	"sql_stats_flush_latency":                                     "sql.stats.flush.latency",
	"sql_stats_flush_latency_bucket":                              "sql.stats.flush.latency.bucket",
	"sql_stats_flush_latency_count":                               "sql.stats.flush.latency.count",
	"sql_stats_flush_latency_sum":                                 "sql.stats.flush.latency.sum",
	"sql_stats_flushes_failed":                                    "sql.stats.flushes.failed",
	"sql_stats_flushes_successful":                                "sql.stats.flushes.successful",
	"sql_stats_mem_current":                                       "sql.stats.mem.current",
	"sql_stats_mem_max":                                           "sql.stats.mem.max",
	"sql_stats_mem_max_bucket":                                    "sql.stats.mem.max.bucket",
	"sql_stats_mem_max_count":                                     "sql.stats.mem.max.count",
	"sql_stats_mem_max_sum":                                       "sql.stats.mem.max.sum",
	"sql_stats_reported_mem_current":                              "sql.stats.reported.mem.current",
	"sql_stats_reported_mem_max":                                  "sql.stats.reported.mem.max",
	"sql_stats_reported_mem_max_bucket":                           "sql.stats.reported.mem.max.bucket",
	"sql_stats_reported_mem_max_count":                            "sql.stats.reported.mem.max.count",
	"sql_stats_reported_mem_max_sum":                              "sql.stats.reported.mem.max.sum",
	"sql_stats_txn_stats_collection_duration":                     "sql.stats.txn_stats_collection.duration",
	"sql_stats_txn_stats_collection_duration_bucket":              "sql.stats.txn_stats_collection.duration.bucket",
	"sql_stats_txn_stats_collection_duration_count":               "sql.stats.txn_stats_collection.duration.count",
	"sql_stats_txn_stats_collection_duration_sum":                 "sql.stats.txn_stats_collection.duration.sum",
	"sql_temp_object_cleaner_active_cleaners":                     "sql.temp_object_cleaner.active_cleaners",
	"sql_temp_object_cleaner_schemas_deletion_error":              "sql.temp_object_cleaner.schemas_deletion_error",
	"sql_temp_object_cleaner_schemas_deletion_success":            "sql.temp_object_cleaner.schemas_deletion_success",
	"sql_temp_object_cleaner_schemas_to_delete":                   "sql.temp_object_cleaner.schemas_to_delete",
	"sql_txn_abort_count":                                         "sql.txn.abort.count",
	"sql_txn_abort_count_internal":                                "sql.txn.abort.internal",
	"sql_txn_begin_count":                                         "sql.txn.begin.count",
	"sql_txn_begin_count_internal":                                "sql.txn.begin.internal",
	"sql_txn_begin_started_count":                                 "sql.txn.begin.started.count",
	"sql_txn_begin_started_count_internal":                        "sql.txn.begin.started.internal",
	"sql_txn_commit_count":                                        "sql.txn.commit.count",
	"sql_txn_commit_count_internal":                               "sql.txn.commit.internal",
	"sql_txn_commit_started_count":                                "sql.txn.commit.started.count",
	"sql_txn_commit_started_count_internal":                       "sql.txn.commit.started.internal",
	"sql_txn_contended_count":                                     "sql.txn.contended.count",
	"sql_txn_contended_count_internal":                            "sql.txn.contended.internal",
	"sql_txn_latency":                                             "sql.txn.latency",
	"sql_txn_latency_bucket":                                      "sql.txn.latency.bucket",
	"sql_txn_latency_count":                                       "sql.txn.latency.count",
	"sql_txn_latency_internal":                                    "sql.txn.latency.internal",
	"sql_txn_latency_internal_bucket":                             "sql.txn.latency.internal.bucket",
	"sql_txn_latency_internal_count":                              "sql.txn.latency.internal.count",
	"sql_txn_latency_internal_sum":                                "sql.txn.latency.internal.sum",
	"sql_txn_latency_sum":                                         "sql.txn.latency.sum",
	"sql_txn_rollback_count":                                      "sql.txn.rollback.count",
	"sql_txn_rollback_count_internal":                             "sql.txn.rollback.internal",
	"sql_txn_rollback_started_count":                              "sql.txn.rollback.started.count",
	"sql_txn_rollback_started_count_internal":                     "sql.txn.rollback.started.internal",
	"sql_txn_upgraded_iso_level_count":                            "sql.txn.upgraded_iso_level.count",
	"sql_txn_upgraded_iso_level_count_internal":                   "sql.txn.upgraded_iso_level.count.internal",
	"sql_txns_open":                                               "sql.txns.open",
	"sql_txns_open_internal":                                      "sql.txns.open.internal",
	"sql_update_count":                                            "sql.update.count",
	"sql_update_count_internal":                                   "sql.update.internal",
	"sql_update_started_count":                                    "sql.update.started.count",
	"sql_update_started_count_internal":                           "sql.update.started.internal",
	"sqlliveness_is_alive_cache_hits":                             "sqlliveness.is_alive.cache_hits",
	"sqlliveness_is_alive_cache_misses":                           "sqlliveness.is_alive.cache_misses",
	"sqlliveness_sessions_deleted":                                "sqlliveness.sessions_deleted",
	"sqlliveness_sessions_deletion_runs":                          "sqlliveness.sessions_deletion_runs",
	"sqlliveness_write_failures":                                  "sqlliveness.write_failures",
	"sqlliveness_write_successes":                                 "sqlliveness.write_successes",
	"storage_batch_commit_commit_wait_duration":                   "storage.batch_commit.commit_wait.duration",
	"storage_batch_commit_count":                                  "storage.batch_commit.count",
	"storage_batch_commit_duration":                               "storage.batch_commit.duration",
	"storage_batch_commit_l0_stall_duration":                      "storage.batch_commit.l0_stall.duration",
	"storage_batch_commit_mem_stall_duration":                     "storage.batch_commit.mem_stall.duration",
	"storage_batch_commit_sem_wait_duration":                      "storage.batch_commit.sem_wait.duration",
	"storage_batch_commit_wal_queue_wait_duration":                "storage.batch_commit.wal_queue_wait.duration",
	"storage_batch_commit_wal_rotation_duration":                  "storage.batch_commit.wal_rotation.duration",
	"storage_category_pebble_manifest_bytes_written":              "storage.category_pebble_manifest.bytes_written",
	"storage_category_pebble_wal_bytes_written":                   "storage.category_pebble_wal.bytes_written",
	"storage_category_unspecified_bytes_written":                  "storage.category_unspecified.bytes_written",
	"storage_checkpoints":                                         "storage.checkpoints",
	"storage_compactions_duration":                                "storage.compactions.duration",
	"storage_compactions_keys_pinned_bytes":                       "storage.compactions.keys.pinned.bytes",
	"storage_compactions_keys_pinned_count":                       "storage.compactions.keys.pinned.count",
	"storage_disk_io_time":                                        "storage.disk.io.time",
	"storage_disk_iopsinprogress":                                 "storage.disk.iopsinprogress",
	"storage_disk_read_bytes":                                     "storage.disk.read.bytes",
	"storage_disk_read_count":                                     "storage.disk.read.count",
	"storage_disk_read_max_bytespersecond":                        "storage.disk.read_max.bytespersecond",
	"storage_disk_read_time":                                      "storage.disk.read.time",
	"storage_disk_slow":                                           "storage.disk_slow",
	"storage_disk_stalled":                                        "storage.disk_stalled",
	"storage_disk_weightedio_time":                                "storage.disk.weightedio.time",
	"storage_disk_write_bytes":                                    "storage.disk.write.bytes",
	"storage_disk_write_count":                                    "storage.disk.write.count",
	"storage_disk_write_max_bytespersecond":                       "storage.disk.write_max.bytespersecond",
	"storage_disk_write_time":                                     "storage.disk.write.time",
	"storage_flush_ingest_count":                                  "storage.flush.ingest.count",
	"storage_flush_ingest_table_bytes":                            "storage.flush.ingest.table.bytes",
	"storage_flush_ingest_table_count":                            "storage.flush.ingest.table.count",
	"storage_flush_utilization":                                   "storage.flush.utilization",
	"storage_ingest_count":                                        "storage.ingest.count",
	"storage_iterator_block_load_bytes":                           "storage.iterator.block_load.bytes",
	"storage_iterator_block_load_cached_bytes":                    "storage.iterator.block_load.cached_bytes",
	"storage_iterator_block_load_read_duration":                   "storage.iterator.block_load.read_duration",
	"storage_iterator_external_seeks":                             "storage.iterator.external.seeks",
	"storage_iterator_external_steps":                             "storage.iterator.external.steps",
	"storage_iterator_internal_seeks":                             "storage.iterator.internal.seeks",
	"storage_iterator_internal_steps":                             "storage.iterator.internal.steps",
	"storage_keys_range_key_set_count":                            "storage.keys.range_key_set.count",
	"storage_keys_tombstone_count":                                "storage.keys.tombstone.count",
	"storage_l0_bytes_flushed":                                    "storage.l0_bytes_flushed",
	"storage_l0_bytes_ingested":                                   "storage.l0_bytes_ingested",
	"storage_l0_level_score":                                      "storage.l0_level_score",
	"storage_l0_level_size":                                       "storage.l0_level_size",
	"storage_l0_num_files":                                        "storage.l0_num_files",
	"storage_l0_sublevels":                                        "storage.l0_sublevels",
	"storage_l1_bytes_ingested":                                   "storage.l1_bytes_ingested",
	"storage_l1_level_score":                                      "storage.l1_level_score",
	"storage_l1_level_size":                                       "storage.l1_level_size",
	"storage_l2_bytes_ingested":                                   "storage.l2_bytes_ingested",
	"storage_l2_level_score":                                      "storage.l2_level_score",
	"storage_l2_level_size":                                       "storage.l2_level_size",
	"storage_l3_bytes_ingested":                                   "storage.l3_bytes_ingested",
	"storage_l3_level_score":                                      "storage.l3_level_score",
	"storage_l3_level_size":                                       "storage.l3_level_size",
	"storage_l4_bytes_ingested":                                   "storage.l4_bytes_ingested",
	"storage_l4_level_score":                                      "storage.l4_level_score",
	"storage_l4_level_size":                                       "storage.l4_level_size",
	"storage_l5_bytes_ingested":                                   "storage.l5_bytes_ingested",
	"storage_l5_level_score":                                      "storage.l5_level_score",
	"storage_l5_level_size":                                       "storage.l5_level_size",
	"storage_l6_bytes_ingested":                                   "storage.l6_bytes_ingested",
	"storage_l6_level_score":                                      "storage.l6_level_score",
	"storage_l6_level_size":                                       "storage.l6_level_size",
	"storage_marked_for_compaction_files":                         "storage.marked_for_compaction_files",
	"storage_queue_store_failures":                                "storage.queue.store_failures",
	"storage_secondary_cache_count":                               "storage.secondary_cache.count",
	"storage_secondary_cache_evictions":                           "storage.secondary_cache.evictions",
	"storage_secondary_cache_reads_full_hit":                      "storage.secondary_cache.reads_full_hit",
	"storage_secondary_cache_reads_multi_block":                   "storage.secondary_cache.reads_multi_block",
	"storage_secondary_cache_reads_multi_shard":                   "storage.secondary_cache.reads_multi_shard",
	"storage_secondary_cache_reads_no_hit":                        "storage.secondary_cache.reads_no_hit",
	"storage_secondary_cache_reads_partial_hit":                   "storage.secondary_cache.reads_partial_hit",
	"storage_secondary_cache_reads_total":                         "storage.secondary_cache.reads_total",
	"storage_secondary_cache_size":                                "storage.secondary_cache.size",
	"storage_secondary_cache_write_back_failures":                 "storage.secondary_cache.write_back_failures",
	"storage_shared_storage_read":                                 "storage.shared_storage.read",
	"storage_shared_storage_write":                                "storage.shared_storage.write",
	"storage_single_delete_ineffectual":                           "storage.single_delete.ineffectual",
	"storage_single_delete_invariant_violation":                   "storage.single_delete.invariant_violation",
	"storage_sstable_zombie_bytes":                                "storage.sstable.zombie.bytes",
	"storage_wal_bytes_in":                                        "storage.wal.bytes_in",
	"storage_wal_bytes_written":                                   "storage.wal.bytes_written",
	"storage_wal_failover_primary_duration":                       "storage.wal.failover.primary.duration",
	"storage_wal_failover_secondary_duration":                     "storage.wal.failover.secondary.duration",
	"storage_wal_failover_switch_count":                           "storage.wal.failover.switch.count",
	"storage_wal_failover_write_and_sync_latency":                 "storage.wal.failover.write_and_sync.latency",
	"storage_wal_failover_write_and_sync_latency_bucket":          "storage.wal.failover.write_and_sync.latency.bucket",
	"storage_wal_failover_write_and_sync_latency_count":           "storage.wal.failover.write_and_sync.latency.count",
	"storage_wal_failover_write_and_sync_latency_sum":             "storage.wal.failover.write_and_sync.latency.sum",
	"storage_wal_fsync_latency":                                   "storage.wal.fsync.latency",
	"storage_wal_fsync_latency_bucket":                            "storage.wal.fsync.latency.bucket",
	"storage_wal_fsync_latency_count":                             "storage.wal.fsync.latency.count",
	"storage_wal_fsync_latency_sum":                               "storage.wal.fsync.latency.sum",
	"storage_write_stall_nanos":                                   "storage.write_stall_nanos",
	"storage_write_stalls":                                        "storage.write.stalls",
	"sys_cgo_allocbytes":                                          "sys.cgo.allocbytes",
	"sys_cgo_totalbytes":                                          "sys.cgo.totalbytes",
	"sys_cgocalls":                                                "sys.cgocalls",
	"sys_cpu_combined_percent_normalized":                         "sys.cpu.combined.percent.normalized",
	"sys_cpu_host_combined_percent_normalized":                    "sys.cpu.host.combined.percent_normalized",
	"sys_cpu_now_ns":                                              "sys.cpu.now.ns",
	"sys_cpu_sys_ns":                                              "sys.cpu.sys.ns",
	"sys_cpu_sys_percent":                                         "sys.cpu.sys.percent",
	"sys_cpu_user_ns":                                             "sys.cpu.user.ns",
	"sys_cpu_user_percent":                                        "sys.cpu.user.percent",
	"sys_fd_open":                                                 "sys.fd.open",
	"sys_fd_softlimit":                                            "sys.fd.softlimit",
	"sys_gc_assist_ns":                                            "sys.gc.assist.ns",
	"sys_gc_count":                                                "sys.gc.count",
	"sys_gc_pause_ns":                                             "sys.gc.pause.ns",
	"sys_gc_pause_percent":                                        "sys.gc.pause.percent",
	"sys_gc_stop_ns":                                              "sys.gc.stop.ns",
	"sys_go_allocbytes":                                           "sys.go.allocbytes",
	"sys_go_heap_allocbytes":                                      "sys.go.heap.allocbytes",
	"sys_go_heap_heapfragmentbytes":                               "sys.go.heap.heapfragmentbytes",
	"sys_go_heap_heapreleasedbytes":                               "sys.go.heap.heapreleasedbytes",
	"sys_go_heap_heapreservedbytes":                               "sys.go.heap.heapreservedbytes",
	"sys_go_pause_other_ns":                                       "sys.go.pause.other.ns",
	"sys_go_stack_systembytes":                                    "sys.go.stack.systembytes",
	"sys_go_stop_other_ns":                                        "sys.go.stop.other.ns",
	"sys_go_totalbytes":                                           "sys.go.totalbytes",
	"sys_goroutines":                                              "sys.goroutines",
	"sys_host_disk_io_time":                                       "sys.host.disk.io.time",
	"sys_host_disk_iopsinprogress":                                "sys.host.disk.iopsinprogress",
	"sys_host_disk_read_bytes":                                    "sys.host.disk.read.bytes",
	"sys_host_disk_read_count":                                    "sys.host.disk.read",
	"sys_host_disk_read_time":                                     "sys.host.disk.read.time",
	"sys_host_disk_weightedio_time":                               "sys.host.disk.weightedio.time",
	"sys_host_disk_write_bytes":                                   "sys.host.disk.write.bytes",
	"sys_host_disk_write_count":                                   "sys.host.disk.write",
	"sys_host_disk_write_time":                                    "sys.host.disk.write.time",
	"sys_host_net_recv_bytes":                                     "sys.host.net.recv.bytes",
	"sys_host_net_recv_drop":                                      "sys.host.net.recv.drop",
	"sys_host_net_recv_err":                                       "sys.host.net.recv.err",
	"sys_host_net_recv_packets":                                   "sys.host.net.recv.packets",
	"sys_host_net_send_bytes":                                     "sys.host.net.send.bytes",
	"sys_host_net_send_drop":                                      "sys.host.net.send.drop",
	"sys_host_net_send_err":                                       "sys.host.net.send.err",
	"sys_host_net_send_packets":                                   "sys.host.net.send.packets",
	"sys_rss":                                                     "sys.rss",
	"sys_runnable_goroutines_per_cpu":                             "sys.runnable.goroutines.per_cpu",
	"sys_totalmem":                                                "sys.totalmem",
	"sys_uptime":                                                  "sys.uptime",
	"sysbytes":                                                    "sysbytes",
	"syscount":                                                    "syscount",
	"tenant_consumption_cross_region_network_ru":                  "tenant.consumption.cross_region_network_ru",
	"tenant_consumption_external_io_egress_bytes":                 "tenant.consumption.external_io_egress_bytes",
	"tenant_consumption_external_io_ingress_bytes":                "tenant.consumption.external_io_ingress_bytes",
	"tenant_consumption_kv_request_units":                         "tenant.consumption.kv_request_units",
	"tenant_consumption_pgwire_egress_bytes":                      "tenant.consumption.pgwire_egress_bytes",
	"tenant_consumption_read_batches":                             "tenant.consumption.read_batches",
	"tenant_consumption_read_bytes":                               "tenant.consumption.read_bytes",
	"tenant_consumption_read_requests":                            "tenant.consumption.read_requests",
	"tenant_consumption_request_units":                            "tenant.consumption.request_units",
	"tenant_consumption_sql_pods_cpu_seconds":                     "tenant.consumption.sql_pods_cpu_seconds",
	"tenant_consumption_write_batches":                            "tenant.consumption.write_batches",
	"tenant_consumption_write_bytes":                              "tenant.consumption.write_bytes",
	"tenant_consumption_write_requests":                           "tenant.consumption.write_requests",
	"tenant_cost_client_blocked_requests":                         "tenant.cost_client.blocked_requests",
	"tenant_sql_usage_cross_region_network_ru":                    "tenant.sql_usage.cross_region_network_ru",
	"tenant_sql_usage_external_io_egress_bytes":                   "tenant.sql_usage.external_io_egress_bytes",
	"tenant_sql_usage_external_io_ingress_bytes":                  "tenant.sql_usage.external_io_ingress_bytes",
	"tenant_sql_usage_kv_request_units":                           "tenant.sql_usage.kv_request_units",
	"tenant_sql_usage_pgwire_egress_bytes":                        "tenant.sql_usage.pgwire_egress_bytes",
	"tenant_sql_usage_read_batches":                               "tenant.sql_usage.read_batches",
	"tenant_sql_usage_read_bytes":                                 "tenant.sql_usage.read_bytes",
	"tenant_sql_usage_read_requests":                              "tenant.sql_usage.read_requests",
	"tenant_sql_usage_request_units":                              "tenant.sql_usage.request_units",
	"tenant_sql_usage_sql_pods_cpu_seconds":                       "tenant.sql_usage.sql_pods_cpu_seconds",
	"tenant_sql_usage_write_batches":                              "tenant.sql_usage.write_batches",
	"tenant_sql_usage_write_bytes":                                "tenant.sql_usage.write_bytes",
	"tenant_sql_usage_write_requests":                             "tenant.sql_usage.write_requests",
	"timeseries_write_bytes":                                      "timeseries.write.bytes",
	"timeseries_write_errors":                                     "timeseries.write.errors",
	"timeseries_write_samples":                                    "timeseries.write.samples",
	"totalbytes":                                                  "totalbytes",
	"tscache_skl_pages":                                           "tscache.skl.pages",
	"tscache_skl_read_pages":                                      "tscache.skl.read.pages",
	"tscache_skl_read_rotations":                                  "tscache.skl.read.rotations",
	"tscache_skl_rotations":                                       "tscache.skl.rotations",
	"tscache_skl_write_pages":                                     "tscache.skl.write.pages",
	"tscache_skl_write_rotations":                                 "tscache.skl.write.rotations",
	"txn_abandons":                                                "txn.abandons",
	"txn_aborts":                                                  "txn.aborts",
	"txn_autoretries":                                             "txn.autoretries",
	"txn_commit_waits":                                            "txn.commit_waits",
	"txn_commit_waits_before_commit_trigger":                      "txn.commit_waits.before_commit_trigger",
	"txn_commits":                                                 "txn.commits",
	"txn_commits1PC":                                              "txn.commits1PC",
	"txn_commits_read_only":                                       "txn.commits_read_only",
	"txn_condensed_intent_spans":                                  "txn.condensed_intent_spans",
	"txn_condensed_intent_spans_gauge":                            "txn.condensed_intent_spans_gauge",
	"txn_condensed_intent_spans_rejected":                         "txn.condensed_intent_spans_rejected",
	"txn_durations":                                               "txn.durations",
	"txn_durations_bucket":                                        "txn.durations.bucket",
	"txn_durations_count":                                         "txn.durations.count",
	"txn_durations_sum":                                           "txn.durations.sum",
	"txn_inflight_locks_over_tracking_budget":                     "txn.inflight_locks_over_tracking_budget",
	"txn_parallelcommits":                                         "txn.parallelcommits",
	"txn_parallelcommits_auto_retries":                            "txn.parallelcommits.auto_retries",
	"txn_refresh_auto_retries":                                    "txn.refresh.auto_retries",
	"txn_refresh_fail":                                            "txn.refresh.fail",
	"txn_refresh_fail_with_condensed_spans":                       "txn.refresh.fail_with_condensed_spans",
	"txn_refresh_memory_limit_exceeded":                           "txn.refresh.memory_limit_exceeded",
	"txn_refresh_success":                                         "txn.refresh.success",
	"txn_refresh_success_server_side":                             "txn.refresh.success_server_side",
	"txn_restarts":                                                "txn.restarts",
	"txn_restarts_asyncwritefailure":                              "txn.restarts.asyncwritefailure",
	"txn_restarts_bucket":                                         "txn.restarts.bucket",
	"txn_restarts_commitdeadlineexceeded":                         "txn.restarts.commitdeadlineexceeded",
	"txn_restarts_count":                                          "txn.restarts.count",
	"txn_restarts_deleterange":                                    "txn.restarts.deleterange",
	"txn_restarts_possiblereplay":                                 "txn.restarts.possiblereplay",
	"txn_restarts_readwithinuncertainty":                          "txn.restarts.readwithinuncertainty",
	"txn_restarts_serializable":                                   "txn.restarts.serializable",
	"txn_restarts_sum":                                            "txn.restarts.sum",
	"txn_restarts_txnaborted":                                     "txn.restarts.txnaborted",
	"txn_restarts_txnpush":                                        "txn.restarts.txnpush",
	"txn_restarts_unknown":                                        "txn.restarts.unknown",
	"txn_restarts_writetooold":                                    "txn.restarts.writetooold",
	"txn_rollbacks_async_failed":                                  "txn.rollbacks.async.failed",
	"txn_rollbacks_failed":                                        "txn.rollbacks.failed",
	"txn_server_side_1PC_failure":                                 "txn.server_side.1PC.failure",
	"txn_server_side_1PC_success":                                 "txn.server_side.1PC.success",
	"txn_server_side_retry_read_evaluation_failure":               "txn.server_side_retry.read_evaluation.failure",
	"txn_server_side_retry_read_evaluation_success":               "txn.server_side_retry.read_evaluation.success",
	"txn_server_side_retry_uncertainty_interval_error_failure":    "txn.server_side_retry.uncertainty_interval_error.failure",
	"txn_server_side_retry_uncertainty_interval_error_success":    "txn.server_side_retry.uncertainty_interval_error.success",
	"txn_server_side_retry_write_evaluation_failure":              "txn.server_side_retry.write_evaluation.failure",
	"txn_server_side_retry_write_evaluation_success":              "txn.server_side_retry.write_evaluation.success",
	"txnrecovery_attempts":                                        "txnrecovery.attempts",
	"txnrecovery_attempts_pending":                                "txnrecovery.attempts.pending",
	"txnrecovery_attempts_total":                                  "txnrecovery.attempts.total",
	"txnrecovery_failures":                                        "txnrecovery.failures",
	"txnrecovery_successes_aborted":                               "txnrecovery.successes.aborted",
	"txnrecovery_successes_committed":                             "txnrecovery.successes.committed",
	"txnrecovery_successes_pending":                               "txnrecovery.successes.pending",
	"txnwaitqueue_deadlocks_total":                                "txnwaitqueue.deadlocks.total",
	"txnwaitqueue_pushee_waiting":                                 "txnwaitqueue.pushee.waiting",
	"txnwaitqueue_pusher_slow":                                    "txnwaitqueue.pusher.slow",
	"txnwaitqueue_pusher_wait_time":                               "txnwaitqueue.pusher.wait_time",
	"txnwaitqueue_pusher_wait_time_bucket":                        "txnwaitqueue.pusher.wait_time.bucket",
	"txnwaitqueue_pusher_wait_time_count":                         "txnwaitqueue.pusher.wait_time.count",
	"txnwaitqueue_pusher_wait_time_sum":                           "txnwaitqueue.pusher.wait_time.sum",
	"txnwaitqueue_pusher_waiting":                                 "txnwaitqueue.pusher.waiting",
	"txnwaitqueue_query_wait_time":                                "txnwaitqueue.query.wait_time",
	"txnwaitqueue_query_wait_time_bucket":                         "txnwaitqueue.query.wait_time.bucket",
	"txnwaitqueue_query_wait_time_count":                          "txnwaitqueue.query.wait_time.count",
	"txnwaitqueue_query_wait_time_sum":                            "txnwaitqueue.query.wait_time.sum",
	"txnwaitqueue_query_waiting":                                  "txnwaitqueue.query.waiting",
	"valbytes":                                                    "valbytes",
	"valcount":                                                    "valcount",
}
