// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package tenantcapabilities

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[CanAdminRelocateRange-1]
	_ = x[CanAdminScatter-2]
	_ = x[CanAdminSplit-3]
	_ = x[CanAdminUnsplit-4]
	_ = x[CanUseNodelocalStorage-5]
	_ = x[CanViewNodeInfo-6]
	_ = x[CanCheckConsistency-7]
	_ = x[CanViewTSDBMetrics-8]
	_ = x[ExemptFromRateLimiting-9]
	_ = x[TenantSpanConfigBounds-10]
	_ = x[CanDebugProcess-11]
	_ = x[CanViewAllMetrics-12]
	_ = x[CanPrepareTxns-13]
	_ = x[MaxCapabilityID-13]
}

func (i ID) String() string {
	switch i {
	case CanAdminRelocateRange:
		return "can_admin_relocate_range"
	case CanAdminScatter:
		return "can_admin_scatter"
	case CanAdminSplit:
		return "can_admin_split"
	case CanAdminUnsplit:
		return "can_admin_unsplit"
	case CanUseNodelocalStorage:
		return "can_use_nodelocal_storage"
	case CanViewNodeInfo:
		return "can_view_node_info"
	case CanCheckConsistency:
		return "can_check_consistency"
	case CanViewTSDBMetrics:
		return "can_view_tsdb_metrics"
	case ExemptFromRateLimiting:
		return "exempt_from_rate_limiting"
	case TenantSpanConfigBounds:
		return "span_config_bounds"
	case CanDebugProcess:
		return "can_debug_process"
	case CanViewAllMetrics:
		return "can_view_all_metrics"
	case CanPrepareTxns:
		return "can_prepare_txns"
	default:
		return "ID(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}

var stringToCapabilityIDMap = map[string]ID{
	"can_admin_relocate_range":  1,
	"can_admin_scatter":         2,
	"can_admin_split":           3,
	"can_admin_unsplit":         4,
	"can_use_nodelocal_storage": 5,
	"can_view_node_info":        6,
	"can_check_consistency":     7,
	"can_view_tsdb_metrics":     8,
	"exempt_from_rate_limiting": 9,
	"span_config_bounds":        10,
	"can_debug_process":         11,
	"can_view_all_metrics":      12,
	"can_prepare_txns":          13,
	"MaxCapabilityID":           13,
}

var IDs = []ID{
	CanAdminRelocateRange,
	CanAdminScatter,
	CanAdminSplit,
	CanAdminUnsplit,
	CanCheckConsistency,
	CanDebugProcess,
	CanPrepareTxns,
	CanUseNodelocalStorage,
	CanViewAllMetrics,
	CanViewNodeInfo,
	CanViewTSDBMetrics,
	ExemptFromRateLimiting,
	TenantSpanConfigBounds,
}
