// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package kvserver

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[noReason-0]
	_ = x[reasonNewLeader-1]
	_ = x[reasonNewLeaderOrConfigChange-2]
	_ = x[reasonSnapshotApplied-3]
	_ = x[reasonTicks-4]
}

func (i refreshRaftReason) String() string {
	switch i {
	case noReason:
		return "noReason"
	case reasonNewLeader:
		return "reasonNewLeader"
	case reasonNewLeaderOrConfigChange:
		return "reasonNewLeaderOrConfigChange"
	case reasonSnapshotApplied:
		return "reasonSnapshotApplied"
	case reasonTicks:
		return "reasonTicks"
	default:
		return "refreshRaftReason(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
