// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package sidetransport

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[ReasonUnknown-0]
	_ = x[ReplicaDestroyed-1]
	_ = x[InvalidLease-2]
	_ = x[TargetOverLeaseExpiration-3]
	_ = x[MergeInProgress-4]
	_ = x[ProposalsInFlight-5]
	_ = x[RequestsEvaluatingBelowTarget-6]
	_ = x[MaxReason-7]
}

func (i CantCloseReason) String() string {
	switch i {
	case ReasonUnknown:
		return "ReasonUnknown"
	case ReplicaDestroyed:
		return "ReplicaDestroyed"
	case InvalidLease:
		return "InvalidLease"
	case TargetOverLeaseExpiration:
		return "TargetOverLeaseExpiration"
	case MergeInProgress:
		return "MergeInProgress"
	case ProposalsInFlight:
		return "ProposalsInFlight"
	case RequestsEvaluatingBelowTarget:
		return "RequestsEvaluatingBelowTarget"
	case MaxReason:
		return "MaxReason"
	default:
		return "CantCloseReason(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
