// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package config

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[RangeMinBytes-1]
	_ = x[RangeMaxBytes-2]
	_ = x[GlobalReads-3]
	_ = x[NumReplicas-4]
	_ = x[NumVoters-5]
	_ = x[GCTTL-6]
	_ = x[Constraints-7]
	_ = x[VoterConstraints-8]
	_ = x[LeasePreferences-9]
}

func (i Field) String() string {
	switch i {
	case RangeMinBytes:
		return "range_min_bytes"
	case RangeMaxBytes:
		return "range_max_bytes"
	case GlobalReads:
		return "global_reads"
	case NumReplicas:
		return "num_replicas"
	case NumVoters:
		return "num_voters"
	case GCTTL:
		return "gc.ttlseconds"
	case Constraints:
		return "constraints"
	case VoterConstraints:
		return "voter_constraints"
	case LeasePreferences:
		return "lease_preferences"
	default:
		return "Field(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
