// Copyright 2019 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package tests

// Please keep these lists alphabetized for easy diffing.
// After a failed run, an updated version of this blocklist should be available
// in the test log.
var pgjdbcBlockList = blocklist{
	`org.postgresql.core.OidValuesCorrectnessTest.testValue[oidName=BOX, oidValue=603]`:                                                                             "unknown",
	`org.postgresql.core.OidValuesCorrectnessTest.testValue[oidName=BOX_ARRAY, oidValue=1,020]`:                                                                     "unknown",
	`org.postgresql.core.OidValuesCorrectnessTest.testValue[oidName=CIDR, oidValue=650]`:                                                                            "unknown",
	`org.postgresql.core.OidValuesCorrectnessTest.testValue[oidName=CIRCLE, oidValue=718]`:                                                                          "unknown",
	`org.postgresql.core.OidValuesCorrectnessTest.testValue[oidName=JSON, oidValue=114]`:                                                                            "unknown",
	`org.postgresql.core.OidValuesCorrectnessTest.testValue[oidName=JSON_ARRAY, oidValue=199]`:                                                                      "unknown",
	`org.postgresql.core.OidValuesCorrectnessTest.testValue[oidName=LINE, oidValue=628]`:                                                                            "unknown",
	`org.postgresql.core.OidValuesCorrectnessTest.testValue[oidName=LSEG, oidValue=601]`:                                                                            "unknown",
	`org.postgresql.core.OidValuesCorrectnessTest.testValue[oidName=MACADDR, oidValue=829]`:                                                                         "unknown",
	`org.postgresql.core.OidValuesCorrectnessTest.testValue[oidName=MACADDR8, oidValue=774]`:                                                                        "unknown",
	`org.postgresql.core.OidValuesCorrectnessTest.testValue[oidName=MONEY, oidValue=790]`:                                                                           "unknown",
	`org.postgresql.core.OidValuesCorrectnessTest.testValue[oidName=MONEY_ARRAY, oidValue=791]`:                                                                     "unknown",
	`org.postgresql.core.OidValuesCorrectnessTest.testValue[oidName=PATH, oidValue=602]`:                                                                            "unknown",
	`org.postgresql.core.OidValuesCorrectnessTest.testValue[oidName=POINT, oidValue=600]`:                                                                           "unknown",
	`org.postgresql.core.OidValuesCorrectnessTest.testValue[oidName=POINT_ARRAY, oidValue=1,017]`:                                                                   "unknown",
	`org.postgresql.core.OidValuesCorrectnessTest.testValue[oidName=POLYGON, oidValue=604]`:                                                                         "unknown",
	`org.postgresql.core.OidValuesCorrectnessTest.testValue[oidName=XML, oidValue=142]`:                                                                             "unknown",
	`org.postgresql.core.OidValuesCorrectnessTest.testValue[oidName=XML_ARRAY, oidValue=143]`:                                                                       "unknown",
	`org.postgresql.jdbc.BitFieldTest.TestGetObjectForBitFields`:                                                                                                    "unknown",
	`org.postgresql.jdbc.BitFieldTest.TestSetBitParameter`:                                                                                                          "unknown",
	`org.postgresql.jdbc.LargeObjectManagerTest.objectWriteThenRead()`:                                                                                              "unknown",
	`org.postgresql.jdbc.LargeObjectManagerTest.openWithErrorAndSubsequentParameterStatusMessageShouldLeaveConnectionInUsableStateAndUpdateParameterStatus()`:       "unknown",
	`org.postgresql.jdbc.UUIDArrayTest.initializationError`:                                                                                                         "32552",
	`org.postgresql.replication.CopyBothResponseTest.keedAliveContainsCorrectLSN()`:                                                                                 "unknown",
	`org.postgresql.replication.CopyBothResponseTest.openConnectByReplicationProtocol()`:                                                                            "unknown",
	`org.postgresql.replication.CopyBothResponseTest.receiveKeepAliveMessage()`:                                                                                     "unknown",
	`org.postgresql.replication.CopyBothResponseTest.receiveXLogData()`:                                                                                             "unknown",
	`org.postgresql.replication.LogicalReplicationStatusTest.applyLocationDoNotChangeDuringReceiveMessage()`:                                                        "unknown",
	`org.postgresql.replication.LogicalReplicationStatusTest.applyLocationDoNotDependOnFlushLocation()`:                                                             "unknown",
	`org.postgresql.replication.LogicalReplicationStatusTest.applyLocationEqualToSetLocation()`:                                                                     "unknown",
	`org.postgresql.replication.LogicalReplicationStatusTest.flushLocationDoNotChangeDuringReceiveMessage()`:                                                        "unknown",
	`org.postgresql.replication.LogicalReplicationStatusTest.flushLocationEqualToSetLocation()`:                                                                     "unknown",
	`org.postgresql.replication.LogicalReplicationStatusTest.keepAliveServerLSNCanBeUsedToAdvanceFlushLSN()`:                                                        "unknown",
	`org.postgresql.replication.LogicalReplicationStatusTest.lastReceiveLSNCorrectOnView()`:                                                                         "unknown",
	`org.postgresql.replication.LogicalReplicationStatusTest.receivedLSNDependentOnProcessMessage()`:                                                                "unknown",
	`org.postgresql.replication.LogicalReplicationStatusTest.sentLocationEqualToLastReceiveLSN()`:                                                                   "unknown",
	`org.postgresql.replication.LogicalReplicationStatusTest.statusCanBeSentToBackendAsynchronously()`:                                                              "unknown",
	`org.postgresql.replication.LogicalReplicationStatusTest.writeLocationCanBeLessThanSendLocation()`:                                                              "unknown",
	`org.postgresql.replication.LogicalReplicationTest.afterCloseConnectionDBSLotStatusNotActive()`:                                                                 "unknown",
	`org.postgresql.replication.LogicalReplicationTest.afterCloseReplicationStreamDBSlotStatusNotActive()`:                                                          "unknown",
	`org.postgresql.replication.LogicalReplicationTest.afterStartStreamingDBSlotStatusActive()`:                                                                     "unknown",
	`org.postgresql.replication.LogicalReplicationTest.avoidTimeoutDisconnectWithDefaultStatusInterval()`:                                                           "unknown",
	`org.postgresql.replication.LogicalReplicationTest.doesNotHavePendingMessageWhenStartFromLastLSN()`:                                                             "unknown",
	`org.postgresql.replication.LogicalReplicationTest.duringSendBigTransactionConnectionCloseSlotStatusNotActive()`:                                                "unknown",
	`org.postgresql.replication.LogicalReplicationTest.duringSendBigTransactionReplicationStreamCloseNotActive()`:                                                   "unknown",
	`org.postgresql.replication.LogicalReplicationTest.notAvailableStartNotExistReplicationSlot()`:                                                                  "unknown",
	`org.postgresql.replication.LogicalReplicationTest.readActualChangesWithoutBlock()`:                                                                             "unknown",
	`org.postgresql.replication.LogicalReplicationTest.readPreviousChangesWithoutBlock()`:                                                                           "unknown",
	`org.postgresql.replication.LogicalReplicationTest.receiveChangesAfterStartReplication()`:                                                                       "unknown",
	`org.postgresql.replication.LogicalReplicationTest.receiveChangesOccursBeforeStartReplication()`:                                                                "unknown",
	`org.postgresql.replication.LogicalReplicationTest.repeatWalPositionTwice()`:                                                                                    "unknown",
	`org.postgresql.replication.LogicalReplicationTest.replicationRestartFromLastFeedbackPosition()`:                                                                "unknown",
	`org.postgresql.replication.LogicalReplicationTest.replicationRestartFromLastFeedbackPositionParallelTransaction()`:                                             "unknown",
	`org.postgresql.replication.LogicalReplicationTest.restartReplicationFromRestartSlotLSNWhenFeedbackAbsent()`:                                                    "unknown",
	`org.postgresql.replication.LogicalReplicationTest.startFromCurrentServerLSNWithoutSpecifyLSNExplicitly()`:                                                      "unknown",
	`org.postgresql.replication.PhysicalReplicationTest.afterCloseReplicationStreamDBSlotStatusNotActive()`:                                                         "unknown",
	`org.postgresql.replication.PhysicalReplicationTest.afterStartStreamingDBSlotStatusActive()`:                                                                    "unknown",
	`org.postgresql.replication.PhysicalReplicationTest.receiveChangesWithReplicationSlot()`:                                                                        "unknown",
	`org.postgresql.replication.PhysicalReplicationTest.receiveChangesWithoutReplicationSlot()`:                                                                     "unknown",
	`org.postgresql.replication.PhysicalReplicationTest.restartPhysicalReplicationWithoutRepeatMessage()`:                                                           "unknown",
	`org.postgresql.replication.PhysicalReplicationTest.walRecordCanBeRepeatBeRestartReplication()`:                                                                 "unknown",
	`org.postgresql.replication.ReplicationConnectionTest.connectionNotValidWhenSessionTerminated()`:                                                                "unknown",
	`org.postgresql.replication.ReplicationSlotTest.createLogicalSlot()`:                                                                                            "unknown",
	`org.postgresql.replication.ReplicationSlotTest.createLogicalSlotReturnedInfo()`:                                                                                "unknown",
	`org.postgresql.replication.ReplicationSlotTest.createPhysicalSlot()`:                                                                                           "unknown",
	`org.postgresql.replication.ReplicationSlotTest.createPhysicalSlotReturnedInfo()`:                                                                               "unknown",
	`org.postgresql.replication.ReplicationSlotTest.createTemporaryLogicalSlotPg10AndHigher()`:                                                                      "unknown",
	`org.postgresql.replication.ReplicationSlotTest.createTemporaryPhysicalSlotPg10AndHigher()`:                                                                     "unknown",
	`org.postgresql.replication.ReplicationSlotTest.dropLogicalSlot()`:                                                                                              "unknown",
	`org.postgresql.replication.ReplicationSlotTest.dropPhysicalSlot()`:                                                                                             "unknown",
	`org.postgresql.test.core.LogServerMessagePropertyTest.batchExplicitlyEnabled()`:                                                                                "unknown",
	`org.postgresql.test.core.LogServerMessagePropertyTest.batchWithDefaults()`:                                                                                     "unknown",
	`org.postgresql.test.core.LogServerMessagePropertyTest.batchWithLogServerErrorDetailDisabled()`:                                                                 "unknown",
	`org.postgresql.test.core.LogServerMessagePropertyTest.withDefaults()`:                                                                                          "unknown",
	`org.postgresql.test.core.LogServerMessagePropertyTest.withExplicitlyEnabled()`:                                                                                 "unknown",
	`org.postgresql.test.core.LogServerMessagePropertyTest.withLogServerErrorDetailDisabled()`:                                                                      "unknown",
	`org.postgresql.test.jdbc2.ArrayTest.testEscaping[binary = FORCE]`:                                                                                              "32552",
	`org.postgresql.test.jdbc2.ArrayTest.testEscaping[binary = REGULAR]`:                                                                                            "32552",
	`org.postgresql.test.jdbc2.ArrayTest.testIndexAccess[binary = FORCE]`:                                                                                           "32552",
	`org.postgresql.test.jdbc2.ArrayTest.testIndexAccess[binary = REGULAR]`:                                                                                         "32552",
	`org.postgresql.test.jdbc2.ArrayTest.testMultiDimensionalArray[binary = FORCE]`:                                                                                 "32552",
	`org.postgresql.test.jdbc2.ArrayTest.testMultiDimensionalArray[binary = REGULAR]`:                                                                               "32552",
	`org.postgresql.test.jdbc2.ArrayTest.testNonStandardBounds[binary = FORCE]`:                                                                                     "41405",
	`org.postgresql.test.jdbc2.ArrayTest.testNonStandardBounds[binary = REGULAR]`:                                                                                   "41405",
	`org.postgresql.test.jdbc2.ArrayTest.testNonStandardDelimiter[binary = FORCE]`:                                                                                  "21286",
	`org.postgresql.test.jdbc2.ArrayTest.testNonStandardDelimiter[binary = REGULAR]`:                                                                                "21286",
	`org.postgresql.test.jdbc2.ArrayTest.testNullValues[binary = FORCE]`:                                                                                            "26925",
	`org.postgresql.test.jdbc2.ArrayTest.testNullValues[binary = REGULAR]`:                                                                                          "26925",
	`org.postgresql.test.jdbc2.ArrayTest.testRecursiveResultSets[binary = FORCE]`:                                                                                   "32552",
	`org.postgresql.test.jdbc2.ArrayTest.testRecursiveResultSets[binary = REGULAR]`:                                                                                 "32552",
	`org.postgresql.test.jdbc2.ArrayTest.testRetrieveArrays[binary = FORCE]`:                                                                                        "41405",
	`org.postgresql.test.jdbc2.ArrayTest.testRetrieveArrays[binary = REGULAR]`:                                                                                      "41405",
	`org.postgresql.test.jdbc2.ArrayTest.testRetrieveResultSets[binary = FORCE]`:                                                                                    "41405",
	`org.postgresql.test.jdbc2.ArrayTest.testRetrieveResultSets[binary = REGULAR]`:                                                                                  "41405",
	`org.postgresql.test.jdbc2.ArrayTest.testSetArray[binary = FORCE]`:                                                                                              "26925",
	`org.postgresql.test.jdbc2.ArrayTest.testSetArray[binary = REGULAR]`:                                                                                            "26925",
	`org.postgresql.test.jdbc2.ArrayTest.testSetPrimitiveArraysObjects[binary = FORCE]`:                                                                             "26925",
	`org.postgresql.test.jdbc2.ArrayTest.testSetPrimitiveArraysObjects[binary = REGULAR]`:                                                                           "26925",
	`org.postgresql.test.jdbc2.ArrayTest.testSetPrimitiveObjects[binary = FORCE]`:                                                                                   "26925",
	`org.postgresql.test.jdbc2.ArrayTest.testSetPrimitiveObjects[binary = REGULAR]`:                                                                                 "26925",
	`org.postgresql.test.jdbc2.ArrayTest.testStringEscaping[binary = FORCE]`:                                                                                        "unknown",
	`org.postgresql.test.jdbc2.ArrayTest.testStringEscaping[binary = REGULAR]`:                                                                                      "unknown",
	`org.postgresql.test.jdbc2.ArrayTest.testUnknownArrayType[binary = FORCE]`:                                                                                      "unknown",
	`org.postgresql.test.jdbc2.ArrayTest.testUnknownArrayType[binary = REGULAR]`:                                                                                    "unknown",
	`org.postgresql.test.jdbc2.ArrayTest.testWriteMultiDimensional[binary = FORCE]`:                                                                                 "32552",
	`org.postgresql.test.jdbc2.ArrayTest.testWriteMultiDimensional[binary = REGULAR]`:                                                                               "32552",
	`org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingTypes[binary = FORCE, insertRewrite = false]`:                                               "41513",
	`org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingTypes[binary = FORCE, insertRewrite = true]`:                                                "41513",
	`org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingTypes[binary = REGULAR, insertRewrite = false]`:                                             "41513",
	`org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingTypes[binary = REGULAR, insertRewrite = true]`:                                              "41513",
	`org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithEmbeddedNulls[binary = FORCE, insertRewrite = false]`:                                                  "26366",
	`org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithEmbeddedNulls[binary = FORCE, insertRewrite = true]`:                                                   "26366",
	`org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithEmbeddedNulls[binary = REGULAR, insertRewrite = false]`:                                                "26366",
	`org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithEmbeddedNulls[binary = REGULAR, insertRewrite = true]`:                                                 "26366",
	`org.postgresql.test.jdbc2.BlobTest.initializationError`:                                                                                                        "unknown",
	`org.postgresql.test.jdbc2.BlobTransactionTest.concurrentReplace()`:                                                                                             "102201",
	`org.postgresql.test.jdbc2.CallableStmtTest.testBadStmt`:                                                                                                        "17511",
	`org.postgresql.test.jdbc2.CallableStmtTest.testBatchCall`:                                                                                                      "17511",
	`org.postgresql.test.jdbc2.CallableStmtTest.testFetchBeforeExecute`:                                                                                             "17511",
	`org.postgresql.test.jdbc2.CallableStmtTest.testFetchWithNoResults`:                                                                                             "17511",
	`org.postgresql.test.jdbc2.CallableStmtTest.testGetArray`:                                                                                                       "17511",
	`org.postgresql.test.jdbc2.CallableStmtTest.testGetDouble`:                                                                                                      "17511",
	`org.postgresql.test.jdbc2.CallableStmtTest.testGetInt`:                                                                                                         "17511",
	`org.postgresql.test.jdbc2.CallableStmtTest.testGetNumeric`:                                                                                                     "17511",
	`org.postgresql.test.jdbc2.CallableStmtTest.testGetNumericWithoutArg`:                                                                                           "17511",
	`org.postgresql.test.jdbc2.CallableStmtTest.testGetShort`:                                                                                                       "17511",
	`org.postgresql.test.jdbc2.CallableStmtTest.testGetString`:                                                                                                      "17511",
	`org.postgresql.test.jdbc2.CallableStmtTest.testGetUpdateCount`:                                                                                                 "17511",
	`org.postgresql.test.jdbc2.CallableStmtTest.testRaiseNotice`:                                                                                                    "17511",
	`org.postgresql.test.jdbc2.CallableStmtTest.testWasNullBeforeFetch`:                                                                                             "17511",
	`org.postgresql.test.jdbc2.ClientEncodingTest.setEncodingAscii[allowEncodingChanges=false]`:                                                                     "37129",
	`org.postgresql.test.jdbc2.ClientEncodingTest.setEncodingAscii[allowEncodingChanges=true]`:                                                                      "37129",
	`org.postgresql.test.jdbc2.ConnectionTest.createStatement()`:                                                                                                    "41578",
	`org.postgresql.test.jdbc2.ConnectionTest.doubleClose()`:                                                                                                        "41578",
	`org.postgresql.test.jdbc2.ConnectionTest.getTypeMapEmpty()`:                                                                                                    "41578",
	`org.postgresql.test.jdbc2.ConnectionTest.isClosed()`:                                                                                                           "41578",
	`org.postgresql.test.jdbc2.ConnectionTest.nativeSQL()`:                                                                                                          "41578",
	`org.postgresql.test.jdbc2.ConnectionTest.pGStreamSettings()`:                                                                                                   "41578",
	`org.postgresql.test.jdbc2.ConnectionTest.prepareCall()`:                                                                                                        "41578",
	`org.postgresql.test.jdbc2.ConnectionTest.prepareStatement()`:                                                                                                   "41578",
	`org.postgresql.test.jdbc2.ConnectionTest.readOnly_always()`:                                                                                                    "41578",
	`org.postgresql.test.jdbc2.ConnectionTest.readOnly_ignore()`:                                                                                                    "41578",
	`org.postgresql.test.jdbc2.ConnectionTest.readOnly_transaction()`:                                                                                               "41578",
	`org.postgresql.test.jdbc2.ConnectionTest.transactionIsolation()`:                                                                                               "41578",
	`org.postgresql.test.jdbc2.ConnectionTest.transactions()`:                                                                                                       "41578",
	`org.postgresql.test.jdbc2.ConnectionTest.typeMaps()`:                                                                                                           "41578",
	`org.postgresql.test.jdbc2.ConnectionTest.warnings()`:                                                                                                           "41578",
	`org.postgresql.test.jdbc2.CopyTest.changeDateStyle()`:                                                                                                          "unknown",
	`org.postgresql.test.jdbc2.CopyTest.copyMultiApi()`:                                                                                                             "unknown",
	`org.postgresql.test.jdbc2.CopyTest.lockReleaseOnCancelFailure()`:                                                                                               "unknown",
	`org.postgresql.test.jdbc2.CustomTypeWithBinaryTransferTest.initializationError`:                                                                                "21286",
	`org.postgresql.test.jdbc2.DatabaseMetaDataCacheTest.getSQLTypeQueryCache()`:                                                                                    "unknown",
	`org.postgresql.test.jdbc2.DatabaseMetaDataTest.binary = FORCE`:                                                                                                 "32552",
	`org.postgresql.test.jdbc2.DatabaseMetaDataTest.binary = REGULAR`:                                                                                               "32552",
	`org.postgresql.test.jdbc2.DatabaseMetaDataTransactionIsolationTest.[1] 8`:                                                                                      "unknown",
	`org.postgresql.test.jdbc2.DatabaseMetaDataTransactionIsolationTest.[1] read committed`:                                                                         "unknown",
	`org.postgresql.test.jdbc2.DatabaseMetaDataTransactionIsolationTest.[2] 4`:                                                                                      "unknown",
	`org.postgresql.test.jdbc2.DatabaseMetaDataTransactionIsolationTest.[2] read uncommitted`:                                                                       "unknown",
	`org.postgresql.test.jdbc2.DatabaseMetaDataTransactionIsolationTest.[3] 2`:                                                                                      "unknown",
	`org.postgresql.test.jdbc2.DatabaseMetaDataTransactionIsolationTest.[3] repeatable read`:                                                                        "unknown",
	`org.postgresql.test.jdbc2.DatabaseMetaDataTransactionIsolationTest.[4] 1`:                                                                                      "unknown",
	`org.postgresql.test.jdbc2.DatabaseMetaDataTransactionIsolationTest.[4] serializable`:                                                                           "unknown",
	`org.postgresql.test.jdbc2.DatabaseMetaDataTransactionIsolationTest.connectionTransactionIsolation()`:                                                           "unknown",
	`org.postgresql.test.jdbc2.DatabaseMetaDataTransactionIsolationTest.metadataDefaultTransactionIsolation()`:                                                      "unknown",
	`org.postgresql.test.jdbc2.DateStyleTest.connect[dateStyle=PostgreSQL, shouldPass=false]`:                                                                       "unknown",
	`org.postgresql.test.jdbc2.EnumTest.enumArrayArray[binary = FORCE]`:                                                                                             "51480",
	`org.postgresql.test.jdbc2.EnumTest.enumArrayArray[binary = REGULAR]`:                                                                                           "51480",
	`org.postgresql.test.jdbc2.EnumTest.enumArray[binary = FORCE]`:                                                                                                  "51480",
	`org.postgresql.test.jdbc2.EnumTest.enumArray[binary = REGULAR]`:                                                                                                "51480",
	`org.postgresql.test.jdbc2.GeometricTest.testPGbox[binary = FORCE]`:                                                                                             "21286",
	`org.postgresql.test.jdbc2.GeometricTest.testPGbox[binary = REGULAR]`:                                                                                           "21286",
	`org.postgresql.test.jdbc2.GeometricTest.testPGcircle[binary = FORCE]`:                                                                                          "21286",
	`org.postgresql.test.jdbc2.GeometricTest.testPGcircle[binary = REGULAR]`:                                                                                        "21286",
	`org.postgresql.test.jdbc2.GeometricTest.testPGline[binary = FORCE]`:                                                                                            "21286",
	`org.postgresql.test.jdbc2.GeometricTest.testPGline[binary = REGULAR]`:                                                                                          "21286",
	`org.postgresql.test.jdbc2.GeometricTest.testPGlseg[binary = FORCE]`:                                                                                            "21286",
	`org.postgresql.test.jdbc2.GeometricTest.testPGlseg[binary = REGULAR]`:                                                                                          "21286",
	`org.postgresql.test.jdbc2.GeometricTest.testPGpath[binary = FORCE]`:                                                                                            "21286",
	`org.postgresql.test.jdbc2.GeometricTest.testPGpath[binary = REGULAR]`:                                                                                          "21286",
	`org.postgresql.test.jdbc2.GeometricTest.testPGpoint[binary = FORCE]`:                                                                                           "21286",
	`org.postgresql.test.jdbc2.GeometricTest.testPGpoint[binary = REGULAR]`:                                                                                         "21286",
	`org.postgresql.test.jdbc2.GeometricTest.testPGpolygon[binary = FORCE]`:                                                                                         "21286",
	`org.postgresql.test.jdbc2.GeometricTest.testPGpolygon[binary = REGULAR]`:                                                                                       "21286",
	`org.postgresql.test.jdbc2.JBuilderTest.money()`:                                                                                                                "41578",
	`org.postgresql.test.jdbc2.NotifyTest.asyncNotify()`:                                                                                                            "unknown",
	`org.postgresql.test.jdbc2.NotifyTest.asyncNotifyWithEndlessTimeoutAndMessagesAvailableWhenStartingListening()`:                                                 "unknown",
	`org.postgresql.test.jdbc2.NotifyTest.asyncNotifyWithEndlessTimeoutAndMessagesSendAfter()`:                                                                      "unknown",
	`org.postgresql.test.jdbc2.NotifyTest.asyncNotifyWithTimeout()`:                                                                                                 "unknown",
	`org.postgresql.test.jdbc2.NotifyTest.asyncNotifyWithTimeoutAndMessagesAvailableWhenStartingListening()`:                                                        "unknown",
	`org.postgresql.test.jdbc2.NotifyTest.asyncNotifyWithTimeoutAndMessagesSendAfter()`:                                                                             "unknown",
	`org.postgresql.test.jdbc2.NotifyTest.asyncNotifyWithTimeoutAndSocketThatBecomesClosed()`:                                                                       "unknown",
	`org.postgresql.test.jdbc2.NotifyTest.notifyArgument()`:                                                                                                         "unknown",
	`org.postgresql.test.jdbc2.NotifyTest.testNotify()`:                                                                                                             "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest.receive100000[binary = REGULAR]`:                                                                                 "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest.sendReceive100000[binary = REGULAR]`:                                                                             "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest2.sendReceiveValue[binary = FORCE, value = -1]`:                                                                   "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest2.sendReceiveValue[binary = FORCE, value = 0.1]`:                                                                  "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest2.sendReceiveValue[binary = FORCE, value = 0]`:                                                                    "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest2.sendReceiveValue[binary = FORCE, value = 1,000,000]`:                                                            "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest2.sendReceiveValue[binary = FORCE, value = 1.1]`:                                                                  "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest2.sendReceiveValue[binary = FORCE, value = 10,000,000,000,000,000,000,000,000,000,000,000,000]`:                   "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest2.sendReceiveValue[binary = FORCE, value = 1]`:                                                                    "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest2.sendReceiveValue[binary = FORCE, value = 20,000]`:                                                               "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest2.sendReceiveValue[binary = FORCE, value = 40,000]`:                                                               "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest2.sendReceiveValue[binary = FORCE, value = 9,990,000]`:                                                            "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest2.sendReceiveValue[binary = REGULAR, value = -1]`:                                                                 "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest2.sendReceiveValue[binary = REGULAR, value = 0.1]`:                                                                "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest2.sendReceiveValue[binary = REGULAR, value = 0]`:                                                                  "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest2.sendReceiveValue[binary = REGULAR, value = 1,000,000]`:                                                          "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest2.sendReceiveValue[binary = REGULAR, value = 1.1]`:                                                                "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest2.sendReceiveValue[binary = REGULAR, value = 10,000,000,000,000,000,000,000,000,000,000,000,000]`:                 "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest2.sendReceiveValue[binary = REGULAR, value = 1]`:                                                                  "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest2.sendReceiveValue[binary = REGULAR, value = 20,000]`:                                                             "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest2.sendReceiveValue[binary = REGULAR, value = 40,000]`:                                                             "unknown",
	`org.postgresql.test.jdbc2.NumericTransferTest2.sendReceiveValue[binary = REGULAR, value = 9,990,000]`:                                                          "unknown",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobjectSubtype[binary = FORCE, sql = null::box, type = class org.postgresql.geometric.PGbox]`:                  "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobjectSubtype[binary = FORCE, sql = null::circle, type = class org.postgresql.geometric.PGcircle]`:            "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobjectSubtype[binary = FORCE, sql = null::line, type = class org.postgresql.geometric.PGline]`:                "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobjectSubtype[binary = FORCE, sql = null::lseg, type = class org.postgresql.geometric.PGlseg]`:                "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobjectSubtype[binary = FORCE, sql = null::money, type = class org.postgresql.util.PGmoney]`:                   "41578",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobjectSubtype[binary = FORCE, sql = null::path, type = class org.postgresql.geometric.PGpath]`:                "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobjectSubtype[binary = FORCE, sql = null::point, type = class org.postgresql.geometric.PGpoint]`:              "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobjectSubtype[binary = FORCE, sql = null::polygon, type = class org.postgresql.geometric.PGpolygon]`:          "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobjectSubtype[binary = REGULAR, sql = null::box, type = class org.postgresql.geometric.PGbox]`:                "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobjectSubtype[binary = REGULAR, sql = null::circle, type = class org.postgresql.geometric.PGcircle]`:          "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobjectSubtype[binary = REGULAR, sql = null::line, type = class org.postgresql.geometric.PGline]`:              "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobjectSubtype[binary = REGULAR, sql = null::lseg, type = class org.postgresql.geometric.PGlseg]`:              "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobjectSubtype[binary = REGULAR, sql = null::money, type = class org.postgresql.util.PGmoney]`:                 "41578",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobjectSubtype[binary = REGULAR, sql = null::path, type = class org.postgresql.geometric.PGpath]`:              "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobjectSubtype[binary = REGULAR, sql = null::point, type = class org.postgresql.geometric.PGpoint]`:            "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobjectSubtype[binary = REGULAR, sql = null::polygon, type = class org.postgresql.geometric.PGpolygon]`:        "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobject[binary = FORCE, sql = null::box, type = class org.postgresql.geometric.PGbox]`:                         "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobject[binary = FORCE, sql = null::circle, type = class org.postgresql.geometric.PGcircle]`:                   "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobject[binary = FORCE, sql = null::line, type = class org.postgresql.geometric.PGline]`:                       "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobject[binary = FORCE, sql = null::lseg, type = class org.postgresql.geometric.PGlseg]`:                       "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobject[binary = FORCE, sql = null::money, type = class org.postgresql.util.PGmoney]`:                          "41578",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobject[binary = FORCE, sql = null::path, type = class org.postgresql.geometric.PGpath]`:                       "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobject[binary = FORCE, sql = null::point, type = class org.postgresql.geometric.PGpoint]`:                     "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobject[binary = FORCE, sql = null::polygon, type = class org.postgresql.geometric.PGpolygon]`:                 "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobject[binary = REGULAR, sql = null::box, type = class org.postgresql.geometric.PGbox]`:                       "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobject[binary = REGULAR, sql = null::circle, type = class org.postgresql.geometric.PGcircle]`:                 "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobject[binary = REGULAR, sql = null::line, type = class org.postgresql.geometric.PGline]`:                     "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobject[binary = REGULAR, sql = null::lseg, type = class org.postgresql.geometric.PGlseg]`:                     "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobject[binary = REGULAR, sql = null::money, type = class org.postgresql.util.PGmoney]`:                        "41578",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobject[binary = REGULAR, sql = null::path, type = class org.postgresql.geometric.PGpath]`:                     "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobject[binary = REGULAR, sql = null::point, type = class org.postgresql.geometric.PGpoint]`:                   "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsPGobject[binary = REGULAR, sql = null::polygon, type = class org.postgresql.geometric.PGpolygon]`:               "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsString[binary = FORCE, sql = null::box, type = class org.postgresql.geometric.PGbox]`:                           "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsString[binary = FORCE, sql = null::circle, type = class org.postgresql.geometric.PGcircle]`:                     "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsString[binary = FORCE, sql = null::line, type = class org.postgresql.geometric.PGline]`:                         "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsString[binary = FORCE, sql = null::lseg, type = class org.postgresql.geometric.PGlseg]`:                         "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsString[binary = FORCE, sql = null::money, type = class org.postgresql.util.PGmoney]`:                            "41578",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsString[binary = FORCE, sql = null::path, type = class org.postgresql.geometric.PGpath]`:                         "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsString[binary = FORCE, sql = null::point, type = class org.postgresql.geometric.PGpoint]`:                       "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsString[binary = FORCE, sql = null::polygon, type = class org.postgresql.geometric.PGpolygon]`:                   "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsString[binary = REGULAR, sql = null::box, type = class org.postgresql.geometric.PGbox]`:                         "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsString[binary = REGULAR, sql = null::circle, type = class org.postgresql.geometric.PGcircle]`:                   "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsString[binary = REGULAR, sql = null::line, type = class org.postgresql.geometric.PGline]`:                       "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsString[binary = REGULAR, sql = null::lseg, type = class org.postgresql.geometric.PGlseg]`:                       "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsString[binary = REGULAR, sql = null::money, type = class org.postgresql.util.PGmoney]`:                          "41578",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsString[binary = REGULAR, sql = null::path, type = class org.postgresql.geometric.PGpath]`:                       "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsString[binary = REGULAR, sql = null::point, type = class org.postgresql.geometric.PGpoint]`:                     "21286",
	`org.postgresql.test.jdbc2.PGObjectGetTest.getAsString[binary = REGULAR, sql = null::polygon, type = class org.postgresql.geometric.PGpolygon]`:                 "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobjectSubtype[binary = FORCE, sql = box, type = class org.postgresql.geometric.PGbox]`:                    "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobjectSubtype[binary = FORCE, sql = circle, type = class org.postgresql.geometric.PGcircle]`:              "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobjectSubtype[binary = FORCE, sql = line, type = class org.postgresql.geometric.PGline]`:                  "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobjectSubtype[binary = FORCE, sql = lseg, type = class org.postgresql.geometric.PGlseg]`:                  "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobjectSubtype[binary = FORCE, sql = money, type = class org.postgresql.util.PGmoney]`:                     "41578",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobjectSubtype[binary = FORCE, sql = path, type = class org.postgresql.geometric.PGpath]`:                  "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobjectSubtype[binary = FORCE, sql = point, type = class org.postgresql.geometric.PGpoint]`:                "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobjectSubtype[binary = FORCE, sql = polygon, type = class org.postgresql.geometric.PGpolygon]`:            "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobjectSubtype[binary = REGULAR, sql = box, type = class org.postgresql.geometric.PGbox]`:                  "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobjectSubtype[binary = REGULAR, sql = circle, type = class org.postgresql.geometric.PGcircle]`:            "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobjectSubtype[binary = REGULAR, sql = line, type = class org.postgresql.geometric.PGline]`:                "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobjectSubtype[binary = REGULAR, sql = lseg, type = class org.postgresql.geometric.PGlseg]`:                "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobjectSubtype[binary = REGULAR, sql = money, type = class org.postgresql.util.PGmoney]`:                   "41578",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobjectSubtype[binary = REGULAR, sql = path, type = class org.postgresql.geometric.PGpath]`:                "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobjectSubtype[binary = REGULAR, sql = point, type = class org.postgresql.geometric.PGpoint]`:              "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobjectSubtype[binary = REGULAR, sql = polygon, type = class org.postgresql.geometric.PGpolygon]`:          "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobject[binary = FORCE, sql = box, type = class org.postgresql.geometric.PGbox]`:                           "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobject[binary = FORCE, sql = circle, type = class org.postgresql.geometric.PGcircle]`:                     "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobject[binary = FORCE, sql = line, type = class org.postgresql.geometric.PGline]`:                         "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobject[binary = FORCE, sql = lseg, type = class org.postgresql.geometric.PGlseg]`:                         "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobject[binary = FORCE, sql = money, type = class org.postgresql.util.PGmoney]`:                            "41578",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobject[binary = FORCE, sql = path, type = class org.postgresql.geometric.PGpath]`:                         "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobject[binary = FORCE, sql = point, type = class org.postgresql.geometric.PGpoint]`:                       "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobject[binary = FORCE, sql = polygon, type = class org.postgresql.geometric.PGpolygon]`:                   "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobject[binary = REGULAR, sql = box, type = class org.postgresql.geometric.PGbox]`:                         "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobject[binary = REGULAR, sql = circle, type = class org.postgresql.geometric.PGcircle]`:                   "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobject[binary = REGULAR, sql = line, type = class org.postgresql.geometric.PGline]`:                       "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobject[binary = REGULAR, sql = lseg, type = class org.postgresql.geometric.PGlseg]`:                       "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobject[binary = REGULAR, sql = money, type = class org.postgresql.util.PGmoney]`:                          "41578",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobject[binary = REGULAR, sql = path, type = class org.postgresql.geometric.PGpath]`:                       "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobject[binary = REGULAR, sql = point, type = class org.postgresql.geometric.PGpoint]`:                     "21286",
	`org.postgresql.test.jdbc2.PGObjectSetTest.setNullAsPGobject[binary = REGULAR, sql = polygon, type = class org.postgresql.geometric.PGpolygon]`:                 "21286",
	`org.postgresql.test.jdbc2.ParameterStatusTest.transactionalParametersRollback`:                                                                                 "69396",
	`org.postgresql.test.jdbc2.PreparedStatementTest.testBatchWithPrepareThreshold5[binary = REGULAR]`:                                                              "5807",
	`org.postgresql.test.jdbc2.PreparedStatementTest.testDoubleQuestionMark[binary = FORCE]`:                                                                        "21286",
	`org.postgresql.test.jdbc2.PreparedStatementTest.testDoubleQuestionMark[binary = REGULAR]`:                                                                      "21286",
	`org.postgresql.test.jdbc2.PreparedStatementTest.testSingleQuotes[binary = FORCE]`:                                                                              "36215",
	`org.postgresql.test.jdbc2.PreparedStatementTest.testSingleQuotes[binary = REGULAR]`:                                                                            "36215",
	`org.postgresql.test.jdbc2.PreparedStatementTest.testTrailingSpaces[binary = FORCE]`:                                                                            "unknown",
	`org.postgresql.test.jdbc2.PreparedStatementTest.testTrailingSpaces[binary = REGULAR]`:                                                                          "unknown",
	`org.postgresql.test.jdbc2.PreparedStatementTest.testUnknownSetObject[binary = FORCE]`:                                                                          "41779",
	`org.postgresql.test.jdbc2.PreparedStatementTest.testUnknownSetObject[binary = REGULAR]`:                                                                        "41779",
	`org.postgresql.test.jdbc2.RefCursorFetchTest.initializationError`:                                                                                              "unknown",
	`org.postgresql.test.jdbc2.RefCursorTest.testEmptyResult[typeName = OTHER, cursorType = 1,111]`:                                                                 "17511",
	`org.postgresql.test.jdbc2.RefCursorTest.testEmptyResult[typeName = REF_CURSOR, cursorType = 2,012]`:                                                            "17511",
	`org.postgresql.test.jdbc2.RefCursorTest.testMetaData[typeName = OTHER, cursorType = 1,111]`:                                                                    "17511",
	`org.postgresql.test.jdbc2.RefCursorTest.testMetaData[typeName = REF_CURSOR, cursorType = 2,012]`:                                                               "17511",
	`org.postgresql.test.jdbc2.RefCursorTest.testResultType[typeName = OTHER, cursorType = 1,111]`:                                                                  "17511",
	`org.postgresql.test.jdbc2.RefCursorTest.testResultType[typeName = REF_CURSOR, cursorType = 2,012]`:                                                             "17511",
	`org.postgresql.test.jdbc2.RefCursorTest.testResult[typeName = OTHER, cursorType = 1,111]`:                                                                      "17511",
	`org.postgresql.test.jdbc2.RefCursorTest.testResult[typeName = REF_CURSOR, cursorType = 2,012]`:                                                                 "17511",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testCache[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = 0]`:                                "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testCache[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = null]`:                             "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testCache[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = 0]`:                             "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testCache[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = null]`:                          "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testClassesMatch[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = 0]`:                         "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testClassesMatch[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = null]`:                      "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testClassesMatch[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = 0]`:                      "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testClassesMatch[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = null]`:                   "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testClosedResultSet[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = 0]`:                      "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testClosedResultSet[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = null]`:                   "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testClosedResultSet[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = 0]`:                   "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testClosedResultSet[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = null]`:                "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testColumnDisplaySize[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = 0]`:                    "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testColumnDisplaySize[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = null]`:                 "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testColumnDisplaySize[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = 0]`:                 "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testColumnDisplaySize[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = null]`:              "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testComposite[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = 0]`:                            "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testComposite[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = null]`:                         "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testComposite[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = 0]`:                         "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testComposite[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = null]`:                      "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testDatabaseMetaDataNames[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = 0]`:                "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testDatabaseMetaDataNames[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = null]`:             "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testDatabaseMetaDataNames[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = 0]`:             "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testDatabaseMetaDataNames[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = null]`:          "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testIdentityColumn[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = 0]`:                       "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testIdentityColumn[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = null]`:                    "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testIdentityColumn[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = 0]`:                    "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testIdentityColumn[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = null]`:                 "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testIsAutoIncrement[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = 0]`:                      "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testIsAutoIncrement[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = null]`:                   "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testIsAutoIncrement[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = 0]`:                   "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testIsAutoIncrement[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = null]`:                "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testPreparedResultSet[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = 0]`:                    "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testPreparedResultSet[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = null]`:                 "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testPreparedResultSet[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = 0]`:                 "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testPreparedResultSet[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = null]`:              "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testPreparedUpdate[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = 0]`:                       "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testPreparedUpdate[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = null]`:                    "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testPreparedUpdate[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = 0]`:                    "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testPreparedUpdate[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = null]`:                 "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testSmallSerialColumns[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = 0]`:                   "48532",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testSmallSerialColumns[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = null]`:                "48532",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testSmallSerialColumns[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = 0]`:                "48532",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testSmallSerialColumns[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = null]`:             "48532",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testSmallSerialSequenceLikeColumns[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = 0]`:       "48532",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testSmallSerialSequenceLikeColumns[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = null]`:    "48532",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testSmallSerialSequenceLikeColumns[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = 0]`:    "48532",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testSmallSerialSequenceLikeColumns[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = null]`: "48532",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testStandardResultSet[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = 0]`:                    "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testStandardResultSet[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = null]`:                 "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testStandardResultSet[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = 0]`:                 "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testStandardResultSet[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = null]`:              "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testTimestampInfo[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = 0]`:                        "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testTimestampInfo[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = null]`:                     "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testTimestampInfo[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = 0]`:                     "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testTimestampInfo[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = null]`:                  "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testUnexecutedStatement[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = 0]`:                  "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testUnexecutedStatement[databaseMetadataCacheFields = 0, databaseMetadataCacheFieldsMib = null]`:               "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testUnexecutedStatement[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = 0]`:               "32565",
	`org.postgresql.test.jdbc2.ResultSetMetaDataTest.testUnexecutedStatement[databaseMetadataCacheFields = null, databaseMetadataCacheFieldsMib = null]`:            "32565",
	`org.postgresql.test.jdbc2.ResultSetTest.testRowResultPositioning[binary = FORCE]`:                                                                              "unknown",
	`org.postgresql.test.jdbc2.ResultSetTest.testRowResultPositioning[binary = REGULAR]`:                                                                            "unknown",
	`org.postgresql.test.jdbc2.ResultSetTest.testTimestamp[binary = FORCE]`:                                                                                         "unknown",
	`org.postgresql.test.jdbc2.ResultSetTest.testTimestamp[binary = REGULAR]`:                                                                                       "unknown",
	`org.postgresql.test.jdbc2.ResultSetTest.testgetBadBoolean[binary = FORCE]`:                                                                                     "32552",
	`org.postgresql.test.jdbc2.ResultSetTest.testgetBadBoolean[binary = REGULAR]`:                                                                                   "unknown",
	`org.postgresql.test.jdbc2.SearchPathLookupTest.searchPathNormalLookup()`:                                                                                       "unknown",
	`org.postgresql.test.jdbc2.ServerCursorTest.testBinaryFetch`:                                                                                                    "41412",
	`org.postgresql.test.jdbc2.ServerErrorTest.testCheckConstraint`:                                                                                                 "27796",
	`org.postgresql.test.jdbc2.ServerErrorTest.testColumn`:                                                                                                          "27796",
	`org.postgresql.test.jdbc2.ServerErrorTest.testDatatype`:                                                                                                        "27796",
	`org.postgresql.test.jdbc2.ServerErrorTest.testExclusionConstraint`:                                                                                             "27796",
	`org.postgresql.test.jdbc2.ServerErrorTest.testForeignKeyConstraint`:                                                                                            "27796",
	`org.postgresql.test.jdbc2.ServerErrorTest.testNotNullConstraint`:                                                                                               "27796",
	`org.postgresql.test.jdbc2.ServerErrorTest.testPrimaryKey`:                                                                                                      "27796",
	`org.postgresql.test.jdbc2.StatementTest.closeInProgressStatement()`:                                                                                            "unknown",
	`org.postgresql.test.jdbc2.StatementTest.fastCloses()`:                                                                                                          "unknown",
	`org.postgresql.test.jdbc2.StatementTest.parsingSemiColons()`:                                                                                                   "unknown",
	`org.postgresql.test.jdbc2.StatementTest.updateCount()`:                                                                                                         "unknown",
	`org.postgresql.test.jdbc2.StatementTest.warningsAreAvailableAsap()`:                                                                                            "unknown",
	`org.postgresql.test.jdbc2.TimeTest.getTimeZone()`:                                                                                                              "unknown",
	`org.postgresql.test.jdbc2.UpdateableResultTest.testArray`:                                                                                                      "26925",
	`org.postgresql.test.jdbc2.UpdateableResultTest.testOidUpdatable`:                                                                                               "unknown",
	`org.postgresql.test.jdbc3.CompositeTest.complexArgumentSelect()`:                                                                                               "51480",
	`org.postgresql.test.jdbc3.CompositeTest.complexSelect()`:                                                                                                       "51480",
	`org.postgresql.test.jdbc3.CompositeTest.complexTableNameMetadata()`:                                                                                            "51480",
	`org.postgresql.test.jdbc3.CompositeTest.compositeFromTable()`:                                                                                                  "51480",
	`org.postgresql.test.jdbc3.CompositeTest.nullArrayElement()`:                                                                                                    "51480",
	`org.postgresql.test.jdbc3.CompositeTest.simpleArgumentSelect()`:                                                                                                "51480",
	`org.postgresql.test.jdbc3.CompositeTest.simpleSelect()`:                                                                                                        "51480",
	`org.postgresql.test.jdbc3.CompositeTest.tableMetadata()`:                                                                                                       "51480",
	`org.postgresql.test.jdbc3.DatabaseMetaDataTest.getColumnsForDomain()`:                                                                                          "27796",
	`org.postgresql.test.jdbc3.EscapeSyntaxCallModeCallIfNoReturnTest.testInvokeFunction`:                                                                           "17511",
	`org.postgresql.test.jdbc3.EscapeSyntaxCallModeCallIfNoReturnTest.testInvokeFunctionHavingReturnParameter`:                                                      "17511",
	`org.postgresql.test.jdbc3.EscapeSyntaxCallModeCallIfNoReturnTest.testInvokeProcedure`:                                                                          "17511",
	`org.postgresql.test.jdbc3.EscapeSyntaxCallModeCallTest.testInvokeFunction`:                                                                                     "17511",
	`org.postgresql.test.jdbc3.EscapeSyntaxCallModeCallTest.testInvokeFunctionHavingReturnParameter`:                                                                "17511",
	`org.postgresql.test.jdbc3.EscapeSyntaxCallModeCallTest.testInvokeProcedure`:                                                                                    "17511",
	`org.postgresql.test.jdbc3.EscapeSyntaxCallModeSelectTest.testInvokeFunction`:                                                                                   "17511",
	`org.postgresql.test.jdbc3.EscapeSyntaxCallModeSelectTest.testInvokeFunctionHavingReturnParameter`:                                                              "17511",
	`org.postgresql.test.jdbc3.Jdbc3BlobTest.allBytes()`:                                                                                                            "unknown",
	`org.postgresql.test.jdbc3.Jdbc3BlobTest.allBytesStream()`:                                                                                                      "unknown",
	`org.postgresql.test.jdbc3.Jdbc3BlobTest.manyBytes()`:                                                                                                           "unknown",
	`org.postgresql.test.jdbc3.Jdbc3BlobTest.manyBytesOffset()`:                                                                                                     "unknown",
	`org.postgresql.test.jdbc3.Jdbc3BlobTest.manyBytesOffsetStream()`:                                                                                               "unknown",
	`org.postgresql.test.jdbc3.Jdbc3BlobTest.manyBytesStream()`:                                                                                                     "unknown",
	`org.postgresql.test.jdbc3.Jdbc3BlobTest.pattern()`:                                                                                                             "unknown",
	`org.postgresql.test.jdbc3.Jdbc3BlobTest.test1Byte()`:                                                                                                           "unknown",
	`org.postgresql.test.jdbc3.Jdbc3BlobTest.test1ByteOffset()`:                                                                                                     "unknown",
	`org.postgresql.test.jdbc3.Jdbc3BlobTest.test1ByteOffsetStream()`:                                                                                               "unknown",
	`org.postgresql.test.jdbc3.Jdbc3BlobTest.test1ByteStream()`:                                                                                                     "unknown",
	`org.postgresql.test.jdbc3.Jdbc3BlobTest.truncate()`:                                                                                                            "unknown",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testAllInOut`:                                                                                             "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testCall5Times`:                                                                                           "unknown",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testFunctionNoParametersWithParentheses`:                                                                  "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testFunctionNoParametersWithoutParentheses`:                                                               "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testGetBit1WithoutArg`:                                                                                    "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testGetBit2WithoutArg`:                                                                                    "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testGetBoolean01`:                                                                                         "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testGetBooleanWithoutArg`:                                                                                 "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testGetByte01`:                                                                                            "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testGetBytes01`:                                                                                           "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testGetBytes02`:                                                                                           "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testGetDouble01`:                                                                                          "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testGetDoubleAsReal`:                                                                                      "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testGetInt01`:                                                                                             "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testGetLong01`:                                                                                            "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testGetObjectDecimal`:                                                                                     "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testGetObjectFloat`:                                                                                       "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testGetObjectLongVarchar`:                                                                                 "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testGetShort01`:                                                                                           "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testInOut`:                                                                                                "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testMultipleOutExecutions`:                                                                                "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testNotEnoughParameters`:                                                                                  "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testNumeric`:                                                                                              "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testProcedureInOnlyNativeCall`:                                                                            "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testProcedureInOutNativeCall`:                                                                             "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testProcedureNoParametersWithParentheses`:                                                                 "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testProcedureNoParametersWithoutParentheses`:                                                              "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testSetObjectBit`:                                                                                         "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testSomeInOut`:                                                                                            "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testSum`:                                                                                                  "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testTooManyParameters`:                                                                                    "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testUpdateDecimal`:                                                                                        "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testUpdateReal`:                                                                                           "121375",
	`org.postgresql.test.jdbc3.Jdbc3CallableStatementTest.testVarcharBool`:                                                                                          "121375",
	`org.postgresql.test.jdbc3.ParameterMetaDataTest.testFailsOnBadIndex[binary = FORCE]`:                                                                           "21286",
	`org.postgresql.test.jdbc3.ParameterMetaDataTest.testFailsOnBadIndex[binary = REGULAR]`:                                                                         "21286",
	`org.postgresql.test.jdbc3.ParameterMetaDataTest.testMultiStatement[binary = FORCE]`:                                                                            "21286",
	`org.postgresql.test.jdbc3.ParameterMetaDataTest.testMultiStatement[binary = REGULAR]`:                                                                          "21286",
	`org.postgresql.test.jdbc3.ParameterMetaDataTest.testParameterMD[binary = FORCE]`:                                                                               "21286",
	`org.postgresql.test.jdbc3.ParameterMetaDataTest.testParameterMD[binary = REGULAR]`:                                                                             "21286",
	`org.postgresql.test.jdbc3.ParameterMetaDataTest.testTypeChangeWithUnknown[binary = FORCE]`:                                                                     "21286",
	`org.postgresql.test.jdbc3.ParameterMetaDataTest.testTypeChangeWithUnknown[binary = REGULAR]`:                                                                   "21286",
	`org.postgresql.test.jdbc3.ProcedureTransactionTest.testProcAutoCommitFalse`:                                                                                    "121375",
	`org.postgresql.test.jdbc3.ProcedureTransactionTest.testProcAutoCommitTrue`:                                                                                     "121375",
	`org.postgresql.test.jdbc3.ProcedureTransactionTest.testProcWithCommitInside`:                                                                                   "121375",
	`org.postgresql.test.jdbc3.ProcedureTransactionTest.testProcWithNoTxnControl`:                                                                                   "121375",
	`org.postgresql.test.jdbc3.ProcedureTransactionTest.testProcWithRollbackInside`:                                                                                 "121375",
	`org.postgresql.test.jdbc3.StringTypeParameterTest.testMultipleEnumBinds[stringType = null]`:                                                                    "27793",
	`org.postgresql.test.jdbc3.StringTypeParameterTest.testMultipleEnumBinds[stringType = unspecified]`:                                                             "27793",
	`org.postgresql.test.jdbc3.StringTypeParameterTest.testMultipleEnumBinds[stringType = varchar]`:                                                                 "27793",
	`org.postgresql.test.jdbc3.StringTypeParameterTest.testOtherAsEnum[stringType = null]`:                                                                          "27793",
	`org.postgresql.test.jdbc3.StringTypeParameterTest.testOtherAsEnum[stringType = unspecified]`:                                                                   "27793",
	`org.postgresql.test.jdbc3.StringTypeParameterTest.testOtherAsEnum[stringType = varchar]`:                                                                       "27793",
	`org.postgresql.test.jdbc3.StringTypeParameterTest.testParameterUnspecified[stringType = null]`:                                                                 "27793",
	`org.postgresql.test.jdbc3.StringTypeParameterTest.testParameterUnspecified[stringType = unspecified]`:                                                          "27793",
	`org.postgresql.test.jdbc3.StringTypeParameterTest.testParameterUnspecified[stringType = varchar]`:                                                              "27793",
	`org.postgresql.test.jdbc3.StringTypeParameterTest.testVarcharAsEnum[stringType = null]`:                                                                        "27793",
	`org.postgresql.test.jdbc3.StringTypeParameterTest.testVarcharAsEnum[stringType = unspecified]`:                                                                 "27793",
	`org.postgresql.test.jdbc3.StringTypeParameterTest.testVarcharAsEnum[stringType = varchar]`:                                                                     "27793",
	`org.postgresql.test.jdbc3.TypesTest.testCallableBoolean`:                                                                                                       "17511",
	`org.postgresql.test.jdbc4.ArrayTest.createNullArray[binary = FORCE]`:                                                                                           "32552",
	`org.postgresql.test.jdbc4.ArrayTest.createNullArray[binary = REGULAR]`:                                                                                         "32552",
	`org.postgresql.test.jdbc4.ArrayTest.insertAndQueryMultiDimArray[binary = FORCE]`:                                                                               "32552",
	`org.postgresql.test.jdbc4.ArrayTest.insertAndQueryMultiDimArray[binary = REGULAR]`:                                                                             "32552",
	`org.postgresql.test.jdbc4.ArrayTest.multiDimIntArray[binary = FORCE]`:                                                                                          "32552",
	`org.postgresql.test.jdbc4.ArrayTest.multiDimIntArray[binary = REGULAR]`:                                                                                        "32552",
	`org.postgresql.test.jdbc4.ArrayTest.nullArray[binary = FORCE]`:                                                                                                 "32552",
	`org.postgresql.test.jdbc4.ArrayTest.nullArray[binary = REGULAR]`:                                                                                               "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCasingBuiltinAlias[binary = FORCE]`:                                                                                    "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCasingBuiltinAlias[binary = REGULAR]`:                                                                                  "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCasingBuiltinNonAlias[binary = FORCE]`:                                                                                 "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCasingBuiltinNonAlias[binary = REGULAR]`:                                                                               "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCasingComposite[binary = FORCE]`:                                                                                       "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCasingComposite[binary = REGULAR]`:                                                                                     "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateArrayOfBool[binary = FORCE]`:                                                                                     "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateArrayOfBool[binary = REGULAR]`:                                                                                   "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateArrayOfBytesFromString[binary = FORCE]`:                                                                          "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateArrayOfBytesFromString[binary = REGULAR]`:                                                                        "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateArrayOfBytes[binary = FORCE]`:                                                                                    "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateArrayOfBytes[binary = REGULAR]`:                                                                                  "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateArrayOfInt[binary = FORCE]`:                                                                                      "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateArrayOfInt[binary = REGULAR]`:                                                                                    "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateArrayOfMultiJson[binary = FORCE]`:                                                                                "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateArrayOfMultiJson[binary = REGULAR]`:                                                                              "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateArrayOfMultiString[binary = FORCE]`:                                                                              "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateArrayOfMultiString[binary = REGULAR]`:                                                                            "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateArrayOfNull[binary = FORCE]`:                                                                                     "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateArrayOfNull[binary = REGULAR]`:                                                                                   "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateArrayOfSmallInt[binary = FORCE]`:                                                                                 "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateArrayOfSmallInt[binary = REGULAR]`:                                                                               "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateArrayWithNonStandardDelimiter[binary = FORCE]`:                                                                   "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateArrayWithNonStandardDelimiter[binary = REGULAR]`:                                                                 "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateArrayWithoutServer[binary = FORCE]`:                                                                              "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateArrayWithoutServer[binary = REGULAR]`:                                                                            "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateEmptyArrayOfIntViaAlias[binary = FORCE]`:                                                                         "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreateEmptyArrayOfIntViaAlias[binary = REGULAR]`:                                                                       "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreatePrimitiveArray[binary = FORCE]`:                                                                                  "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testCreatePrimitiveArray[binary = REGULAR]`:                                                                                "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testEvilCasing[binary = FORCE]`:                                                                                            "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testEvilCasing[binary = REGULAR]`:                                                                                          "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testGetArrayOfComposites[binary = FORCE]`:                                                                                  "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testGetArrayOfComposites[binary = REGULAR]`:                                                                                "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testJsonbArray[binary = FORCE]`:                                                                                            "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testJsonbArray[binary = REGULAR]`:                                                                                          "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testSetObjectFromJavaArray[binary = FORCE]`:                                                                                "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testSetObjectFromJavaArray[binary = REGULAR]`:                                                                              "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testToString[binary = FORCE]`:                                                                                              "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testToString[binary = REGULAR]`:                                                                                            "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testUUIDArray[binary = FORCE]`:                                                                                             "32552",
	`org.postgresql.test.jdbc4.ArrayTest.testUUIDArray[binary = REGULAR]`:                                                                                           "32552",
	`org.postgresql.test.jdbc4.BlobTest.free()`:                                                                                                                     "unknown",
	`org.postgresql.test.jdbc4.BlobTest.getBinaryStreamWithBoundaries()`:                                                                                            "unknown",
	`org.postgresql.test.jdbc4.BlobTest.getBinaryStreamWithBoundaries2()`:                                                                                           "unknown",
	`org.postgresql.test.jdbc4.BlobTest.setBlobWithStream()`:                                                                                                        "unknown",
	`org.postgresql.test.jdbc4.BlobTest.setBlobWithStreamAndLength()`:                                                                                               "unknown",
	`org.postgresql.test.jdbc4.DatabaseMetaDataHideUnprivilegedObjectsTest.initializationError`:                                                                     "17511",
	`org.postgresql.test.jdbc4.DatabaseMetaDataTest.getColumnsForAutoIncrement()`:                                                                                   "unknown",
	`org.postgresql.test.jdbc4.DatabaseMetaDataTest.getFunctionsWithSpecificTypes()`:                                                                                "100226",
	`org.postgresql.test.jdbc4.DatabaseMetaDataTest.getSqlTypes()`:                                                                                                  "unknown",
	`org.postgresql.test.jdbc4.IsValidTest.testIsValidRemoteClose`:                                                                                                  "35897",
	`org.postgresql.test.jdbc4.UUIDTest.testUUIDString[binary=FORCE, stringType=VARCHAR]`:                                                                           "5807",
	`org.postgresql.test.jdbc4.UUIDTest.testUUIDString[binary=REGULAR, stringType=VARCHAR]`:                                                                         "5807",
	`org.postgresql.test.jdbc4.jdbc41.DriverSupportsClassUnloadingTest.driverUnloadsWhenConnectionClosedExplicitly()`:                                               "unknown",
	`org.postgresql.test.jdbc4.jdbc41.DriverSupportsClassUnloadingTest.driverUnloadsWhenConnectionLeaks()`:                                                          "unknown",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getArray()`:                                                                                                     "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getBigDecimal()`:                                                                                                "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getBigInteger()`:                                                                                                "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getBlob()`:                                                                                                      "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getBoolean()`:                                                                                                   "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getBooleanNull()`:                                                                                               "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getBox()`:                                                                                                       "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getCalendar()`:                                                                                                  "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getCircle()`:                                                                                                    "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getClob()`:                                                                                                      "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getDate()`:                                                                                                      "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getDouble()`:                                                                                                    "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getDoubleNull()`:                                                                                                "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getFloat()`:                                                                                                     "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getFloatNull()`:                                                                                                 "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getInet4Address()`:                                                                                              "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getInet6Address()`:                                                                                              "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getInetAddressNull()`:                                                                                           "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getInteger()`:                                                                                                   "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getIntegerNull()`:                                                                                               "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getInterval()`:                                                                                                  "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getJavaUtilDate()`:                                                                                              "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getLine()`:                                                                                                      "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getLineseg()`:                                                                                                   "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getLong()`:                                                                                                      "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getLongNull()`:                                                                                                  "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getNullDate()`:                                                                                                  "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getNullTimestamp()`:                                                                                             "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getPath()`:                                                                                                      "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getPoint()`:                                                                                                     "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getPolygon()`:                                                                                                   "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getSerial()`:                                                                                                    "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getShort()`:                                                                                                     "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getShortNull()`:                                                                                                 "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getString()`:                                                                                                    "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getTime()`:                                                                                                      "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getTimestamp()`:                                                                                                 "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getTimestampWithTimeZone()`:                                                                                     "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getUuid()`:                                                                                                      "21286",
	`org.postgresql.test.jdbc4.jdbc41.GetObjectTest.getXml()`:                                                                                                       "21286",
	`org.postgresql.test.jdbc4.jdbc41.SchemaTest.searchPathPreparedStatement()`:                                                                                     "unknown",
	`org.postgresql.test.jdbc4.jdbc41.SchemaTest.searchPathPreparedStatementAutoCommitFalse()`:                                                                      "unknown",
	`org.postgresql.test.jdbc4.jdbc41.SchemaTest.searchPathPreparedStatementAutoCommitTrue()`:                                                                       "unknown",
	`org.postgresql.test.jdbc42.DatabaseMetaDataTest.getColumnsForNullScale()`:                                                                                      "51480",
	`org.postgresql.test.jdbc42.DatabaseMetaDataTest.getCorrectSQLTypeForOffPathTypes()`:                                                                            "51480",
	`org.postgresql.test.jdbc42.DatabaseMetaDataTest.getCorrectSQLTypeForShadowedTypes()`:                                                                           "51480",
	`org.postgresql.test.jdbc42.DatabaseMetaDataTest.largeOidIsHandledCorrectly()`:                                                                                  "51480",
	`org.postgresql.test.jdbc42.DatabaseMetaDataTest.oidConversion()`:                                                                                               "51480",
	`org.postgresql.test.jdbc42.DatabaseMetaDataTest.oidConversionThrowsForNegativeLongValues()`:                                                                    "51480",
	`org.postgresql.test.jdbc42.DatabaseMetaDataTest.oidConversionThrowsForTooLargeLongValues()`:                                                                    "51480",
	`org.postgresql.test.jdbc42.GetObject310Test.testGetOffsetTime[binary = FORCE]`:                                                                                 "unknown",
	`org.postgresql.test.jdbc42.GetObject310Test.testGetOffsetTime[binary = REGULAR]`:                                                                               "unknown",
	`org.postgresql.test.jdbc42.Jdbc42CallableStatementTest.testGetResultSetWithoutArg`:                                                                             "17511",
	`org.postgresql.test.jdbc42.Jdbc42CallableStatementTest.testGetResultSetWithoutArgUnsupportedConversion`:                                                        "17511",
	`org.postgresql.test.plugin.AuthenticationPluginTest.authPluginMD5()`:                                                                                           "unknown",
	`org.postgresql.test.util.PasswordUtilTest.alterUserPasswordSupportsNullEncoding()`:                                                                             "73337",
	`org.postgresql.test.util.PasswordUtilTest.customScramParams()`:                                                                                                 "unknown",
	`org.postgresql.test.util.PasswordUtilTest.encodePasswordWithServersPasswordEncryption()`:                                                                       "unknown",
	`org.postgresql.test.util.PasswordUtilTest.encryptionTypeValueOfOff()`:                                                                                          "73337",
	`org.postgresql.test.util.PasswordUtilTest.encryptionTypeValueOfOn()`:                                                                                           "73337",
	`org.postgresql.test.util.PasswordUtilTest.mD5()`:                                                                                                               "73337",
	`org.postgresql.test.util.PasswordUtilTest.scramSha256()`:                                                                                                       "unknown",
	`org.postgresql.test.xa.XADataSourceTest.mappingOfConstraintViolations()`:                                                                                       "unknown",
}

var pgjdbcIgnoreList = blocklist{
	"org.postgresql.jdbc.PgSQLXMLTest.setCharacterStream":                                                                                           "43355",
	"org.postgresql.jdbc.PgSQLXMLTest.testGetSourceXxeDOMSource":                                                                                    "43355",
	"org.postgresql.jdbc.PgSQLXMLTest.testGetSourceXxeNull":                                                                                         "43355",
	"org.postgresql.jdbc.PgSQLXMLTest.testGetSourceXxeSAXSource":                                                                                    "43355",
	"org.postgresql.jdbc.PgSQLXMLTest.testGetSourceXxeStAXSource":                                                                                   "43355",
	"org.postgresql.jdbc.PgSQLXMLTest.testLegacyXxe":                                                                                                "43355",
	"org.postgresql.replication.CopyBothResponseTest.testKeedAliveContaintCorrectLSN":                                                               "uses pg replication",
	"org.postgresql.replication.CopyBothResponseTest.testOpenConnectByReplicationProtocol":                                                          "uses pg replication",
	"org.postgresql.replication.CopyBothResponseTest.testReceiveKeepAliveMessage":                                                                   "uses pg replication",
	"org.postgresql.replication.CopyBothResponseTest.testReceiveXLogData":                                                                           "uses pg replication",
	"org.postgresql.replication.LogicalReplicationStatusTest.testApplyLocationDoNotChangeDuringReceiveMessage":                                      "uses pg replication",
	"org.postgresql.replication.LogicalReplicationStatusTest.testApplyLocationDoNotDependOnFlushLocation":                                           "uses pg replication",
	"org.postgresql.replication.LogicalReplicationStatusTest.testApplyLocationEqualToSetLocation":                                                   "uses pg replication",
	"org.postgresql.replication.LogicalReplicationStatusTest.testFlushLocationDoNotChangeDuringReceiveMessage":                                      "uses pg replication",
	"org.postgresql.replication.LogicalReplicationStatusTest.testFlushLocationEqualToSetLocation":                                                   "uses pg replication",
	"org.postgresql.replication.LogicalReplicationStatusTest.testLastReceiveLSNCorrectOnView":                                                       "uses pg replication",
	"org.postgresql.replication.LogicalReplicationStatusTest.testReceivedLSNDependentOnProcessMessage":                                              "uses pg replication",
	"org.postgresql.replication.LogicalReplicationStatusTest.testSentLocationEqualToLastReceiveLSN":                                                 "uses pg replication",
	"org.postgresql.replication.LogicalReplicationStatusTest.testStatusCanBeSentToBackendAsynchronously":                                            "uses pg replication",
	"org.postgresql.replication.LogicalReplicationStatusTest.testWriteLocationCanBeLessThanSendLocation":                                            "uses pg replication",
	"org.postgresql.replication.LogicalReplicationTest.testAfterCloseConnectionDBSLotStatusNotActive":                                               "uses pg replication",
	"org.postgresql.replication.LogicalReplicationTest.testAfterCloseReplicationStreamDBSlotStatusNotActive":                                        "uses pg replication",
	"org.postgresql.replication.LogicalReplicationTest.testAfterStartStreamingDBSlotStatusActive":                                                   "uses pg replication",
	"org.postgresql.replication.LogicalReplicationTest.testAvoidTimeoutDisconnectWithDefaultStatusInterval":                                         "uses pg replication",
	"org.postgresql.replication.LogicalReplicationTest.testDoesNotHavePendingMessageWhenStartFromLastLSN":                                           "uses pg replication",
	"org.postgresql.replication.LogicalReplicationTest.testDuringSendBigTransactionConnectionCloseSlotStatusNotActive":                              "uses pg replication",
	"org.postgresql.replication.LogicalReplicationTest.testDuringSendBigTransactionReplicationStreamCloseNotActive":                                 "uses pg replication",
	"org.postgresql.replication.LogicalReplicationTest.testNotAvailableStartNotExistReplicationSlot":                                                "uses pg replication",
	"org.postgresql.replication.LogicalReplicationTest.testReadActualChangesWithoutBlock":                                                           "uses pg replication",
	"org.postgresql.replication.LogicalReplicationTest.testReadPreviousChangesWithoutBlock":                                                         "uses pg replication",
	"org.postgresql.replication.LogicalReplicationTest.testReceiveChangesAfterStartReplication":                                                     "uses pg replication",
	"org.postgresql.replication.LogicalReplicationTest.testReceiveChangesOccursBeforStartReplication":                                               "uses pg replication",
	"org.postgresql.replication.LogicalReplicationTest.testRepeatWalPositionTwice":                                                                  "uses pg replication",
	"org.postgresql.replication.LogicalReplicationTest.testReplicationRestartFromLastFeedbackPosition":                                              "uses pg replication",
	"org.postgresql.replication.LogicalReplicationTest.testReplicationRestartFromLastFeedbackPositionParallelTransaction":                           "uses pg replication",
	"org.postgresql.replication.LogicalReplicationTest.testRestartReplicationFromRestartSlotLSNWhenFeedbackAbsent":                                  "uses pg replication",
	"org.postgresql.replication.LogicalReplicationTest.testStartFromCurrentServerLSNWithoutSpecifyLSNExplicitly":                                    "uses pg replication",
	"org.postgresql.replication.PhysicalReplicationTest.restartPhysicalReplicationWithoutRepeatMessage":                                             "uses pg replication",
	"org.postgresql.replication.PhysicalReplicationTest.testAfterCloseReplicationStreamDBSlotStatusNotActive":                                       "uses pg replication",
	"org.postgresql.replication.PhysicalReplicationTest.testAfterStartStreamingDBSlotStatusActive":                                                  "uses pg replication",
	"org.postgresql.replication.PhysicalReplicationTest.testReceiveChangesWithReplicationSlot":                                                      "uses pg replication",
	"org.postgresql.replication.PhysicalReplicationTest.testReceiveChangesWithoutReplicationSlot":                                                   "uses pg replication",
	"org.postgresql.replication.PhysicalReplicationTest.testWalRecordCanBeRepeatBeRestartReplication":                                               "uses pg replication",
	"org.postgresql.replication.ReplicationConnectionTest.testConnectionNotValidWhenSessionTerminated":                                              "uses pg replication",
	"org.postgresql.replication.ReplicationConnectionTest.testIsValid":                                                                              "uses pg replication",
	"org.postgresql.replication.ReplicationConnectionTest.testReplicationCommandResultSetAccessByIndex":                                             "uses pg replication",
	"org.postgresql.replication.ReplicationConnectionTest.testReplicationCommandResultSetAccessByName":                                              "uses pg replication",
	"org.postgresql.replication.ReplicationSlotTest.testCreateLogicalSlot":                                                                          "uses pg replication",
	"org.postgresql.replication.ReplicationSlotTest.testCreateLogicalSlotReturnedInfo":                                                              "uses pg replication",
	"org.postgresql.replication.ReplicationSlotTest.testCreatePhysicalSlot":                                                                         "uses pg replication",
	"org.postgresql.replication.ReplicationSlotTest.testCreatePhysicalSlotReturnedInfo":                                                             "uses pg replication",
	"org.postgresql.replication.ReplicationSlotTest.testCreateTemporaryLogicalSlotPg10AndHigher":                                                    "uses pg replication",
	"org.postgresql.replication.ReplicationSlotTest.testCreateTemporaryPhysicalSlotPg10AndHigher":                                                   "uses pg replication",
	"org.postgresql.replication.ReplicationSlotTest.testDropLogicalSlot":                                                                            "uses pg replication",
	"org.postgresql.replication.ReplicationSlotTest.testDropPhysicalSlot":                                                                           "uses pg replication",
	"org.postgresql.test.core.LogServerMessagePropertyTest.testWithDefaults":                                                                        "expected fail - checks error message",
	"org.postgresql.test.core.LogServerMessagePropertyTest.testWithExplicitlyEnabled":                                                               "expected fail - checks error message",
	"org.postgresql.test.core.LogServerMessagePropertyTest.testWithLogServerErrorDetailDisabled":                                                    "expected fail - checks error message",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchEscapeProcessing[binary = FORCE, insertRewrite = false]":                                   "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchEscapeProcessing[binary = FORCE, insertRewrite = true]":                                    "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchEscapeProcessing[binary = REGULAR, insertRewrite = false]":                                 "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchEscapeProcessing[binary = REGULAR, insertRewrite = true]":                                  "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchReturningMixedNulls[binary = FORCE, insertRewrite = false]":                                "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchReturningMixedNulls[binary = FORCE, insertRewrite = true]":                                 "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchReturningMixedNulls[binary = REGULAR, insertRewrite = false]":                              "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchReturningMixedNulls[binary = REGULAR, insertRewrite = true]":                               "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes0[binary = FORCE, insertRewrite = false]":                    "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes0[binary = FORCE, insertRewrite = true]":                     "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes0[binary = REGULAR, insertRewrite = false]":                  "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes0[binary = REGULAR, insertRewrite = true]":                   "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes1[binary = FORCE, insertRewrite = false]":                    "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes1[binary = FORCE, insertRewrite = true]":                     "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes1[binary = REGULAR, insertRewrite = false]":                  "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes1[binary = REGULAR, insertRewrite = true]":                   "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes2[binary = FORCE, insertRewrite = false]":                    "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes2[binary = FORCE, insertRewrite = true]":                     "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes2[binary = REGULAR, insertRewrite = false]":                  "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes2[binary = REGULAR, insertRewrite = true]":                   "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes3[binary = FORCE, insertRewrite = false]":                    "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes3[binary = FORCE, insertRewrite = true]":                     "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes3[binary = REGULAR, insertRewrite = false]":                  "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes3[binary = REGULAR, insertRewrite = true]":                   "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes4[binary = FORCE, insertRewrite = false]":                    "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes4[binary = FORCE, insertRewrite = true]":                     "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes4[binary = REGULAR, insertRewrite = false]":                  "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes4[binary = REGULAR, insertRewrite = true]":                   "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes5[binary = FORCE, insertRewrite = false]":                    "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes5[binary = FORCE, insertRewrite = true]":                     "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes5[binary = REGULAR, insertRewrite = false]":                  "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes5[binary = REGULAR, insertRewrite = true]":                   "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes6[binary = FORCE, insertRewrite = false]":                    "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes6[binary = FORCE, insertRewrite = true]":                     "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes6[binary = REGULAR, insertRewrite = false]":                  "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithAlternatingAndUnknownTypes6[binary = REGULAR, insertRewrite = true]":                   "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithMultiInsert[binary = FORCE, insertRewrite = false]":                                    "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithMultiInsert[binary = FORCE, insertRewrite = true]":                                     "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithMultiInsert[binary = REGULAR, insertRewrite = false]":                                  "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithMultiInsert[binary = REGULAR, insertRewrite = true]":                                   "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithRepeatedInsertStatement[binary = FORCE, insertRewrite = false]":                        "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithRepeatedInsertStatement[binary = FORCE, insertRewrite = true]":                         "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithRepeatedInsertStatement[binary = REGULAR, insertRewrite = false]":                      "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithRepeatedInsertStatement[binary = REGULAR, insertRewrite = true]":                       "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithTwoMultiInsertStatements[binary = FORCE, insertRewrite = false]":                       "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithTwoMultiInsertStatements[binary = FORCE, insertRewrite = true]":                        "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithTwoMultiInsertStatements[binary = REGULAR, insertRewrite = false]":                     "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testBatchWithTwoMultiInsertStatements[binary = REGULAR, insertRewrite = true]":                      "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testClearBatch[binary = FORCE, insertRewrite = false]":                                              "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testClearBatch[binary = FORCE, insertRewrite = true]":                                               "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testClearBatch[binary = REGULAR, insertRewrite = false]":                                            "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testClearBatch[binary = REGULAR, insertRewrite = true]":                                             "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testClearPreparedEmptyBatch[binary = FORCE, insertRewrite = false]":                                 "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testClearPreparedEmptyBatch[binary = FORCE, insertRewrite = true]":                                  "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testClearPreparedEmptyBatch[binary = REGULAR, insertRewrite = false]":                               "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testClearPreparedEmptyBatch[binary = REGULAR, insertRewrite = true]":                                "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testClearPreparedNoArgBatch[binary = FORCE, insertRewrite = false]":                                 "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testClearPreparedNoArgBatch[binary = FORCE, insertRewrite = true]":                                  "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testClearPreparedNoArgBatch[binary = REGULAR, insertRewrite = false]":                               "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testClearPreparedNoArgBatch[binary = REGULAR, insertRewrite = true]":                                "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testEmptyClearBatch[binary = FORCE, insertRewrite = false]":                                         "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testEmptyClearBatch[binary = FORCE, insertRewrite = true]":                                          "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testEmptyClearBatch[binary = REGULAR, insertRewrite = false]":                                       "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testEmptyClearBatch[binary = REGULAR, insertRewrite = true]":                                        "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testExecuteEmptyBatch[binary = FORCE, insertRewrite = false]":                                       "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testExecuteEmptyBatch[binary = FORCE, insertRewrite = true]":                                        "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testExecuteEmptyBatch[binary = REGULAR, insertRewrite = false]":                                     "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testExecuteEmptyBatch[binary = REGULAR, insertRewrite = true]":                                      "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testExecuteEmptyPreparedBatch[binary = FORCE, insertRewrite = false]":                               "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testExecuteEmptyPreparedBatch[binary = FORCE, insertRewrite = true]":                                "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testExecuteEmptyPreparedBatch[binary = REGULAR, insertRewrite = false]":                             "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testExecuteEmptyPreparedBatch[binary = REGULAR, insertRewrite = true]":                              "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testNoServerPrepareOneRow[binary = FORCE, insertRewrite = false]":                                   "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testNoServerPrepareOneRow[binary = FORCE, insertRewrite = true]":                                    "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testNoServerPrepareOneRow[binary = REGULAR, insertRewrite = false]":                                 "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testNoServerPrepareOneRow[binary = REGULAR, insertRewrite = true]":                                  "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testPreparedNoParameters[binary = FORCE, insertRewrite = false]":                                    "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testPreparedNoParameters[binary = FORCE, insertRewrite = true]":                                     "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testPreparedNoParameters[binary = REGULAR, insertRewrite = false]":                                  "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testPreparedNoParameters[binary = REGULAR, insertRewrite = true]":                                   "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testPreparedStatement[binary = FORCE, insertRewrite = false]":                                       "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testPreparedStatement[binary = FORCE, insertRewrite = true]":                                        "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testPreparedStatement[binary = REGULAR, insertRewrite = false]":                                     "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testPreparedStatement[binary = REGULAR, insertRewrite = true]":                                      "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testSelectInBatchThrows[binary = FORCE, insertRewrite = false]":                                     "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testSelectInBatchThrows[binary = FORCE, insertRewrite = true]":                                      "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testSelectInBatchThrows[binary = REGULAR, insertRewrite = false]":                                   "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testSelectInBatchThrows[binary = REGULAR, insertRewrite = true]":                                    "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testServerPrepareMultipleRows[binary = FORCE, insertRewrite = false]":                               "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testServerPrepareMultipleRows[binary = FORCE, insertRewrite = true]":                                "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testServerPrepareMultipleRows[binary = REGULAR, insertRewrite = false]":                             "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testServerPrepareMultipleRows[binary = REGULAR, insertRewrite = true]":                              "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testSmallBatchUpdateFailureSimple[binary = FORCE, insertRewrite = true]":                            "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testSmallBatchUpdateFailureSimple[binary = REGULAR, insertRewrite = true]":                          "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testStringAddBatchOnPreparedStatement[binary = FORCE, insertRewrite = false]":                       "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testStringAddBatchOnPreparedStatement[binary = FORCE, insertRewrite = true]":                        "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testStringAddBatchOnPreparedStatement[binary = REGULAR, insertRewrite = false]":                     "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testStringAddBatchOnPreparedStatement[binary = REGULAR, insertRewrite = true]":                      "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testSupportsBatchUpdates[binary = FORCE, insertRewrite = false]":                                    "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testSupportsBatchUpdates[binary = FORCE, insertRewrite = true]":                                     "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testSupportsBatchUpdates[binary = REGULAR, insertRewrite = false]":                                  "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testSupportsBatchUpdates[binary = REGULAR, insertRewrite = true]":                                   "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testTransactionalBehaviour[binary = FORCE, insertRewrite = false]":                                  "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testTransactionalBehaviour[binary = FORCE, insertRewrite = true]":                                   "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testTransactionalBehaviour[binary = REGULAR, insertRewrite = false]":                                "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testTransactionalBehaviour[binary = REGULAR, insertRewrite = true]":                                 "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testWarningsAreCleared[binary = FORCE, insertRewrite = false]":                                      "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testWarningsAreCleared[binary = FORCE, insertRewrite = true]":                                       "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testWarningsAreCleared[binary = REGULAR, insertRewrite = false]":                                    "54477",
	"org.postgresql.test.jdbc2.BatchExecuteTest.testWarningsAreCleared[binary = REGULAR, insertRewrite = true]":                                     "54477",
	"org.postgresql.test.jdbc2.BatchedInsertReWriteEnabledTest.testBatchWithReWrittenBatchStatementWithSemiColon[2: autoCommit=NO, binary=REGULAR]": "54477",
	"org.postgresql.test.jdbc2.BatchedInsertReWriteEnabledTest.testBatchWithReWrittenBatchStatementWithSemiColon[3: autoCommit=NO, binary=FORCE]":   "54477",
	"org.postgresql.test.jdbc2.BatchedInsertReWriteEnabledTest.testBatchWithReWrittenMixedCaseValues[2: autoCommit=NO, binary=REGULAR]":             "54477",
	"org.postgresql.test.jdbc2.BatchedInsertReWriteEnabledTest.testBatchWithReWrittenMixedCaseValues[3: autoCommit=NO, binary=FORCE]":               "54477",
	"org.postgresql.test.jdbc2.BatchedInsertReWriteEnabledTest.testBatchWithReWrittenSpaceAfterValues[2: autoCommit=NO, binary=REGULAR]":            "54477",
	"org.postgresql.test.jdbc2.BatchedInsertReWriteEnabledTest.testBatchWithReWrittenSpaceAfterValues[3: autoCommit=NO, binary=FORCE]":              "54477",
	"org.postgresql.test.jdbc2.BatchedInsertReWriteEnabledTest.testReWriteDisabledForPlainBatch[2: autoCommit=NO, binary=REGULAR]":                  "54477",
	"org.postgresql.test.jdbc2.BatchedInsertReWriteEnabledTest.testReWriteDisabledForPlainBatch[3: autoCommit=NO, binary=FORCE]":                    "54477",
	"org.postgresql.test.jdbc2.CursorFetchTest.testBasicFetch[binary = FORCE]":                                                                      "flaky",
	"org.postgresql.test.jdbc2.CursorFetchTest.testBasicFetch[binary = REGULAR]":                                                                    "flaky",
	"org.postgresql.test.jdbc2.CursorFetchTest.testMultiRowResultPositioning[binary = FORCE]":                                                       "flaky",
	"org.postgresql.test.jdbc2.DatabaseEncodingTest.testBadUTF8Decode":                                                                              "54477",
	"org.postgresql.test.jdbc2.DatabaseEncodingTest.testTruncatedUTF8Decode":                                                                        "54477",
	"org.postgresql.test.jdbc2.DatabaseEncodingTest.testUTF8Decode":                                                                                 "54477",
	"org.postgresql.test.jdbc2.DatabaseMetaDataCacheTest.testGetTypeInfoUsesCache":                                                                  "https://github.com/cockroachdb/cockroach/issues/119332#issuecomment-1950242848",
	"org.postgresql.test.jdbc2.StatementTest.shortQueryTimeout()":                                                                                   "flaky",
	"org.postgresql.test.jdbc4.jdbc41.SchemaTest.testCurrentSchemaPropertyNotVisibilityTableInsideFunction":                                         "https://github.com/pgjdbc/pgjdbc/pull/2806",
	"org.postgresql.test.jdbc4.jdbc41.SchemaTest.testCurrentSchemaPropertyVisibilityFunction":                                                       "https://github.com/pgjdbc/pgjdbc/pull/2806",
	"org.postgresql.test.jdbc4.jdbc41.SchemaTest.testCurrentSchemaPropertyVisibilityTableDuringFunctionCreation":                                    "https://github.com/pgjdbc/pgjdbc/pull/2806",
}
