// Copyright 2019 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package main

import (
	"fmt"
	"os/exec"
)

// generatePanic downloads the cockroachdb binary and forces a panic crash in order to trigger a Sentry event,
// which should file a GitHub issue.
func generatePanic(tag string) error {
	// the call usually exits non-zero on panic, but we don't need to fail in that case, thus "|| true"
	// TODO: do not hardcode the URL
	script := fmt.Sprintf(`
set -exuo pipefail
curl --retry-connrefused --retry 5 --fail --silent --show-error --output /dev/stdout --url https://storage.googleapis.com/cockroach-builds-artifacts-prod/cockroach-%s.linux-amd64.tgz | tar -xz
./cockroach-%s.linux-amd64/cockroach demo --insecure -e "select crdb_internal.force_panic('testing')" || true
`, tag, tag)
	cmd := exec.Command("bash", "-c", script)
	out, err := cmd.CombinedOutput()
	if err != nil {
		return fmt.Errorf("failed to generate panic. output was: %s, err: %w", string(out), err)
	}
	fmt.Println(string(out))
	return nil
}
