// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package main

var cli_test_template = `// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by generate-acceptance-tests, DO NOT EDIT.

package acceptance

import (
	"testing"

	"github.com/cockroachdb/cockroach/pkg/util/log"
)
{{range $testNameSuffix, $testFilePath := .TestCases}}
func TestDockerCLI_{{$testNameSuffix}}(t *testing.T) {
	s := log.Scope(t)
	defer s.Close(t)

	runTestDockerCLI(t, "{{$testNameSuffix}}", "{{$testFilePath}}")
}
{{end}}`
