// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package sqlproxyccl

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[codeNone-0]
	_ = x[codeAuthFailed-1]
	_ = x[codeBackendReadFailed-2]
	_ = x[codeBackendWriteFailed-3]
	_ = x[codeClientReadFailed-4]
	_ = x[codeClientWriteFailed-5]
	_ = x[codeUnexpectedInsecureStartupMessage-6]
	_ = x[codeUnexpectedStartupMessage-7]
	_ = x[codeParamsRoutingFailed-8]
	_ = x[codeBackendDialFailed-9]
	_ = x[codeBackendDisconnected-10]
	_ = x[codeClientDisconnected-11]
	_ = x[codeProxyRefusedConnection-12]
	_ = x[codeExpiredClientConnection-13]
	_ = x[codeUnavailable-14]
}

func (i errorCode) String() string {
	switch i {
	case codeNone:
		return "codeNone"
	case codeAuthFailed:
		return "codeAuthFailed"
	case codeBackendReadFailed:
		return "codeBackendReadFailed"
	case codeBackendWriteFailed:
		return "codeBackendWriteFailed"
	case codeClientReadFailed:
		return "codeClientReadFailed"
	case codeClientWriteFailed:
		return "codeClientWriteFailed"
	case codeUnexpectedInsecureStartupMessage:
		return "codeUnexpectedInsecureStartupMessage"
	case codeUnexpectedStartupMessage:
		return "codeUnexpectedStartupMessage"
	case codeParamsRoutingFailed:
		return "codeParamsRoutingFailed"
	case codeBackendDialFailed:
		return "codeBackendDialFailed"
	case codeBackendDisconnected:
		return "codeBackendDisconnected"
	case codeClientDisconnected:
		return "codeClientDisconnected"
	case codeProxyRefusedConnection:
		return "codeProxyRefusedConnection"
	case codeExpiredClientConnection:
		return "codeExpiredClientConnection"
	case codeUnavailable:
		return "codeUnavailable"
	default:
		return "errorCode(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
