// Copyright 2022 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by sctestgen, DO NOT EDIT.

package schemachangerccl

import (
	"testing"

	"github.com/cockroachdb/cockroach/pkg/sql/schemachanger/sctest"
	"github.com/cockroachdb/cockroach/pkg/util/leaktest"
	"github.com/cockroachdb/cockroach/pkg/util/log"
)

func TestBackupRollbacks_base_add_column(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_add_column_default_seq(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_seq"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_add_column_default_unique(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_unique"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_add_column_default_unique_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_unique_not_null"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_add_column_no_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_no_default"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_add_column_serial_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_rowid"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_add_column_serial_simple_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_add_column_serial_simple_sequence_cached(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_cached"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_add_column_serial_simple_sequence_cached_node(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_cached_node"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_add_column_serial_simple_sequence_virtual(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_virtual"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_add_column_serial_unordered_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_unordered_rowid"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_add_column_virtual_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_virtual_not_null"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_add_column_with_stored(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_with_stored"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_add_column_with_stored_family(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_with_stored_family"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_database_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_database_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone_discard"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_database_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone_multiple"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_index_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_index_configure_zone_discard"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_named_range_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_named_range_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone_discard"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_named_range_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone_multiple"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_add_check_udf(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_udf"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_add_check_unvalidated(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_unvalidated"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_add_check_vanilla(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_vanilla"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_add_check_with_seq_and_udt(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_with_seq_and_udt"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_add_foreign_key(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_foreign_key"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_add_primary_key_drop_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_primary_key_drop_rowid"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_add_primary_key_drop_rowid_with_secondary_idx(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_primary_key_drop_rowid_with_secondary_idx"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_add_unique_without_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_unique_without_index"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_alter_column_drop_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_drop_default"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_alter_column_set_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_set_default"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_alter_column_set_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_set_not_null"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_alter_column_type_general(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_general"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_alter_column_type_general_expr(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_general_expr"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_alter_column_type_noop(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_noop"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_alter_column_type_trivial(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_trivial"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_alter_column_type_validation(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_validation"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_alter_primary_key_drop_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_drop_rowid"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_alter_primary_key_using_hash(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_using_hash"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_alter_primary_key_vanilla(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_vanilla"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone_discard"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone_multiple"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_drop_add_same_col_implicit(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_add_same_col_implicit"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_drop_constraint_check(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_check"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_drop_constraint_fk(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_fk"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_drop_constraint_uwi(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_uwi"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_multiple_commands(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_multiple_commands"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_alter_table_validate_constraint(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_validate_constraint"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_comment_on_type_composite(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/comment_on_type_composite"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_comment_on_type_enum(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/comment_on_type_enum"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_create_complex(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_complex"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_create_database(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_database"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_create_database_drop_database_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_database_drop_database_separate_statements"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_create_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_create_function_calling_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function_calling_function"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_create_function_in_txn(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function_in_txn"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_create_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_create_index_create_database_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index_create_database_separate_statements"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_create_index_create_schema_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index_create_schema_separate_statements"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_create_schema(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_schema"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_create_schema_drop_schema_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_schema_drop_schema_separate_statements"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_create_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_create_sequence_add_column(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence_add_column"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_create_sequence_drop_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence_drop_sequence"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_create_temp_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_temp_sequence"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_column_basic(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_basic"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_column_computed_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_computed_index"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_column_create_index_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_create_index_separate_statements"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_column_sequence_owner(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_sequence_owner"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_column_unique_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_unique_index"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_column_with_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_index"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_column_with_null_constraint(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_null_constraint"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_column_with_partial_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_partial_index"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_column_with_udf_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_udf_default"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_comment_on_type_composite(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_comment_on_type_composite"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_comment_on_type_enum(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_comment_on_type_enum"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_function"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_index_hash_sharded_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_hash_sharded_index"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_index_partial_expression_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_partial_expression_index"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_index_vanilla_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_vanilla_index"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_index_with_fks(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_with_fks"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_index_with_materialized_view_dep(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_with_materialized_view_dep"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_multiple_columns_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_multiple_columns_separate_statements"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_schema(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_schema"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_table(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_table"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacks_base_drop_table_udf_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_table_udf_default"
	sctest.BackupRollbacks(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_add_column(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_add_column_default_seq(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_seq"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_add_column_default_unique(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_unique"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_add_column_default_unique_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_unique_not_null"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_add_column_no_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_no_default"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_add_column_serial_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_rowid"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_add_column_serial_simple_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_add_column_serial_simple_sequence_cached(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_cached"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_add_column_serial_simple_sequence_cached_node(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_cached_node"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_add_column_serial_simple_sequence_virtual(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_virtual"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_add_column_serial_unordered_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_unordered_rowid"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_add_column_virtual_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_virtual_not_null"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_add_column_with_stored(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_with_stored"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_add_column_with_stored_family(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_with_stored_family"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_database_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_database_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone_discard"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_database_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone_multiple"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_index_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_index_configure_zone_discard"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_named_range_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_named_range_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone_discard"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_named_range_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone_multiple"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_add_check_udf(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_udf"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_add_check_unvalidated(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_unvalidated"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_add_check_vanilla(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_vanilla"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_add_check_with_seq_and_udt(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_with_seq_and_udt"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_add_foreign_key(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_foreign_key"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_add_primary_key_drop_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_primary_key_drop_rowid"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_add_primary_key_drop_rowid_with_secondary_idx(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_primary_key_drop_rowid_with_secondary_idx"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_add_unique_without_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_unique_without_index"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_alter_column_drop_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_drop_default"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_alter_column_set_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_set_default"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_alter_column_set_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_set_not_null"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_alter_column_type_general(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_general"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_alter_column_type_general_expr(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_general_expr"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_alter_column_type_noop(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_noop"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_alter_column_type_trivial(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_trivial"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_alter_column_type_validation(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_validation"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_alter_primary_key_drop_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_drop_rowid"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_alter_primary_key_using_hash(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_using_hash"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_alter_primary_key_vanilla(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_vanilla"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone_discard"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone_multiple"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_drop_add_same_col_implicit(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_add_same_col_implicit"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_drop_constraint_check(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_check"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_drop_constraint_fk(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_fk"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_drop_constraint_uwi(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_uwi"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_multiple_commands(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_multiple_commands"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_alter_table_validate_constraint(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_validate_constraint"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_comment_on_type_composite(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/comment_on_type_composite"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_comment_on_type_enum(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/comment_on_type_enum"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_create_complex(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_complex"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_create_database(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_database"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_create_database_drop_database_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_database_drop_database_separate_statements"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_create_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_create_function_calling_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function_calling_function"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_create_function_in_txn(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function_in_txn"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_create_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_create_index_create_database_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index_create_database_separate_statements"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_create_index_create_schema_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index_create_schema_separate_statements"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_create_schema(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_schema"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_create_schema_drop_schema_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_schema_drop_schema_separate_statements"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_create_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_create_sequence_add_column(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence_add_column"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_create_sequence_drop_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence_drop_sequence"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_create_temp_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_temp_sequence"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_column_basic(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_basic"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_column_computed_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_computed_index"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_column_create_index_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_create_index_separate_statements"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_column_sequence_owner(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_sequence_owner"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_column_unique_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_unique_index"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_column_with_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_index"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_column_with_null_constraint(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_null_constraint"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_column_with_partial_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_partial_index"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_column_with_udf_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_udf_default"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_comment_on_type_composite(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_comment_on_type_composite"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_comment_on_type_enum(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_comment_on_type_enum"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_function"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_index_hash_sharded_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_hash_sharded_index"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_index_partial_expression_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_partial_expression_index"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_index_vanilla_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_vanilla_index"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_index_with_fks(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_with_fks"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_index_with_materialized_view_dep(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_with_materialized_view_dep"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_multiple_columns_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_multiple_columns_separate_statements"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_schema(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_schema"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_table(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_table"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupRollbacksMixedVersion_base_drop_table_udf_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_table_udf_default"
	sctest.BackupRollbacksMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_add_column(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_add_column_default_seq(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_seq"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_add_column_default_unique(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_unique"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_add_column_default_unique_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_unique_not_null"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_add_column_no_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_no_default"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_add_column_serial_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_rowid"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_add_column_serial_simple_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_add_column_serial_simple_sequence_cached(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_cached"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_add_column_serial_simple_sequence_cached_node(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_cached_node"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_add_column_serial_simple_sequence_virtual(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_virtual"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_add_column_serial_unordered_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_unordered_rowid"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_add_column_virtual_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_virtual_not_null"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_add_column_with_stored(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_with_stored"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_add_column_with_stored_family(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_with_stored_family"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_database_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_database_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone_discard"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_database_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone_multiple"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_index_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_index_configure_zone_discard"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_named_range_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_named_range_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone_discard"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_named_range_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone_multiple"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_add_check_udf(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_udf"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_add_check_unvalidated(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_unvalidated"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_add_check_vanilla(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_vanilla"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_add_check_with_seq_and_udt(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_with_seq_and_udt"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_add_foreign_key(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_foreign_key"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_add_primary_key_drop_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_primary_key_drop_rowid"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_add_primary_key_drop_rowid_with_secondary_idx(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_primary_key_drop_rowid_with_secondary_idx"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_add_unique_without_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_unique_without_index"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_alter_column_drop_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_drop_default"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_alter_column_set_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_set_default"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_alter_column_set_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_set_not_null"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_alter_column_type_general(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_general"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_alter_column_type_general_expr(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_general_expr"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_alter_column_type_noop(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_noop"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_alter_column_type_trivial(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_trivial"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_alter_column_type_validation(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_validation"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_alter_primary_key_drop_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_drop_rowid"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_alter_primary_key_using_hash(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_using_hash"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_alter_primary_key_vanilla(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_vanilla"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone_discard"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone_multiple"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_drop_add_same_col_implicit(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_add_same_col_implicit"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_drop_constraint_check(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_check"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_drop_constraint_fk(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_fk"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_drop_constraint_uwi(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_uwi"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_multiple_commands(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_multiple_commands"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_alter_table_validate_constraint(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_validate_constraint"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_comment_on_type_composite(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/comment_on_type_composite"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_comment_on_type_enum(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/comment_on_type_enum"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_create_complex(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_complex"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_create_database(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_database"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_create_database_drop_database_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_database_drop_database_separate_statements"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_create_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_create_function_calling_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function_calling_function"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_create_function_in_txn(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function_in_txn"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_create_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_create_index_create_database_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index_create_database_separate_statements"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_create_index_create_schema_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index_create_schema_separate_statements"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_create_schema(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_schema"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_create_schema_drop_schema_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_schema_drop_schema_separate_statements"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_create_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_create_sequence_add_column(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence_add_column"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_create_sequence_drop_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence_drop_sequence"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_create_temp_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_temp_sequence"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_column_basic(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_basic"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_column_computed_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_computed_index"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_column_create_index_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_create_index_separate_statements"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_column_sequence_owner(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_sequence_owner"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_column_unique_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_unique_index"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_column_with_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_index"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_column_with_null_constraint(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_null_constraint"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_column_with_partial_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_partial_index"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_column_with_udf_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_udf_default"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_comment_on_type_composite(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_comment_on_type_composite"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_comment_on_type_enum(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_comment_on_type_enum"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_function"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_index_hash_sharded_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_hash_sharded_index"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_index_partial_expression_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_partial_expression_index"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_index_vanilla_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_vanilla_index"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_index_with_fks(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_with_fks"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_index_with_materialized_view_dep(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_with_materialized_view_dep"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_multiple_columns_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_multiple_columns_separate_statements"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_schema(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_schema"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_table(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_table"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccess_base_drop_table_udf_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_table_udf_default"
	sctest.BackupSuccess(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_add_column(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_add_column_default_seq(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_seq"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_add_column_default_unique(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_unique"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_add_column_default_unique_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_default_unique_not_null"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_add_column_no_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_no_default"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_add_column_serial_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_rowid"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_add_column_serial_simple_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_add_column_serial_simple_sequence_cached(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_cached"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_add_column_serial_simple_sequence_cached_node(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_cached_node"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_add_column_serial_simple_sequence_virtual(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_simple_sequence_virtual"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_add_column_serial_unordered_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_serial_unordered_rowid"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_add_column_virtual_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_virtual_not_null"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_add_column_with_stored(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_with_stored"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_add_column_with_stored_family(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/add_column_with_stored_family"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_database_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_database_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone_discard"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_database_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_database_configure_zone_multiple"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_index_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_index_configure_zone_discard"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_named_range_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_named_range_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone_discard"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_named_range_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_named_range_configure_zone_multiple"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_add_check_udf(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_udf"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_add_check_unvalidated(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_unvalidated"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_add_check_vanilla(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_vanilla"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_add_check_with_seq_and_udt(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_check_with_seq_and_udt"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_add_foreign_key(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_foreign_key"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_add_primary_key_drop_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_primary_key_drop_rowid"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_add_primary_key_drop_rowid_with_secondary_idx(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_primary_key_drop_rowid_with_secondary_idx"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_add_unique_without_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_add_unique_without_index"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_alter_column_drop_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_drop_default"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_alter_column_set_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_set_default"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_alter_column_set_not_null(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_set_not_null"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_alter_column_type_general(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_general"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_alter_column_type_general_expr(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_general_expr"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_alter_column_type_noop(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_noop"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_alter_column_type_trivial(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_trivial"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_alter_column_type_validation(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_column_type_validation"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_alter_primary_key_drop_rowid(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_drop_rowid"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_alter_primary_key_using_hash(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_using_hash"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_alter_primary_key_vanilla(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_alter_primary_key_vanilla"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_configure_zone(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_configure_zone_discard(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone_discard"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_configure_zone_multiple(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_configure_zone_multiple"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_drop_add_same_col_implicit(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_add_same_col_implicit"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_drop_constraint_check(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_check"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_drop_constraint_fk(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_fk"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_drop_constraint_uwi(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_drop_constraint_uwi"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_multiple_commands(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_multiple_commands"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_alter_table_validate_constraint(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/alter_table_validate_constraint"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_comment_on_type_composite(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/comment_on_type_composite"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_comment_on_type_enum(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/comment_on_type_enum"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_create_complex(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_complex"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_create_database(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_database"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_create_database_drop_database_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_database_drop_database_separate_statements"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_create_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_create_function_calling_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function_calling_function"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_create_function_in_txn(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_function_in_txn"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_create_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_create_index_create_database_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index_create_database_separate_statements"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_create_index_create_schema_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_index_create_schema_separate_statements"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_create_schema(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_schema"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_create_schema_drop_schema_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_schema_drop_schema_separate_statements"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_create_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_create_sequence_add_column(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence_add_column"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_create_sequence_drop_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_sequence_drop_sequence"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_create_temp_sequence(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/create_temp_sequence"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_column_basic(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_basic"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_column_computed_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_computed_index"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_column_create_index_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_create_index_separate_statements"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_column_sequence_owner(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_sequence_owner"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_column_unique_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_unique_index"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_column_with_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_index"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_column_with_null_constraint(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_null_constraint"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_column_with_partial_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_partial_index"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_column_with_udf_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_column_with_udf_default"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_comment_on_type_composite(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_comment_on_type_composite"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_comment_on_type_enum(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_comment_on_type_enum"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_function(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_function"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_index_hash_sharded_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_hash_sharded_index"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_index_partial_expression_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_partial_expression_index"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_index_vanilla_index(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_vanilla_index"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_index_with_fks(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_with_fks"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_index_with_materialized_view_dep(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_index_with_materialized_view_dep"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_multiple_columns_separate_statements(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_multiple_columns_separate_statements"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_schema(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_schema"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_table(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_table"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}

func TestBackupSuccessMixedVersion_base_drop_table_udf_default(t *testing.T) {
	defer leaktest.AfterTest(t)()
	defer log.Scope(t).Close(t)
	const path = "pkg/sql/schemachanger/testdata/end_to_end/drop_table_udf_default"
	sctest.BackupSuccessMixedVersion(t, path, sctest.SingleNodeTestClusterFactory{})
}
