// Copyright 2024 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package pgcryptocipherccl

// Note: The encrypted values were manually checked against the results of
// the equivalent function on Postgres 15.3.
var CipherTestCases = map[string]struct {
	Plaintext  []byte
	Key        []byte
	Iv         []byte
	CipherType string
	Ciphertext []byte
}{
	"AES-128": {
		Plaintext:  []byte("abc"),
		Key:        []byte("16_byte_long_key"),
		CipherType: "aes",
		Ciphertext: []byte{0x0, 0x26, 0xcd, 0x62, 0x6, 0xcf, 0xd9, 0x21, 0x40, 0x88, 0x3b, 0x75, 0xc0, 0x98, 0xd6, 0x13},
	},
	"AES-128 with IV": {
		Plaintext:  []byte("abc"),
		Key:        []byte("16_byte_long_key"),
		Iv:         []byte{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20},
		CipherType: "aes/pad:pkcs",
		Ciphertext: []byte{0xf8, 0x3e, 0xf0, 0x88, 0x83, 0x9b, 0x2f, 0x19, 0x1c, 0x42, 0x5, 0xa2, 0xe, 0x62, 0x69, 0xd3},
	},
	"AES-192": {
		Plaintext:  []byte("UCVBgQEhwVxXrABksapmqglhTGNWRRnGnUUQHtNanYuyIDrQgHvQanwkfXRvTnJLsMauOfdlLBuJRJkzaGpnVRyENKGwFfauXLJD"),
		Key:        []byte("24_byte_looooooooong_key"),
		CipherType: "aes",
		Ciphertext: []byte{0x44, 0x68, 0x34, 0xe4, 0x3c, 0xb1, 0x76, 0x3, 0xa2, 0xb2, 0x3d, 0x25, 0x13, 0xa7, 0x84, 0xa3, 0x6b, 0xae, 0x79, 0x3, 0x72, 0x74, 0x57, 0x1c, 0x32, 0xcd, 0x29, 0x4a, 0xd, 0x6e, 0xe, 0xf9, 0x27, 0xee, 0x0, 0x76, 0xdc, 0xa4, 0x60, 0xb0, 0x9, 0x0, 0xbc, 0x11, 0x75, 0x4f, 0xee, 0x61, 0x22, 0x52, 0xa6, 0x7, 0x25, 0xa, 0x4f, 0x86, 0xd6, 0x20, 0x56, 0xb6, 0xae, 0xee, 0xc, 0xcd, 0x66, 0x4, 0x88, 0x9e, 0x7f, 0x39, 0xaf, 0x64, 0xce, 0x8b, 0x59, 0x60, 0xc1, 0x74, 0x4d, 0xb2, 0x16, 0xb0, 0x10, 0xea, 0x9c, 0x1, 0x49, 0x6c, 0x42, 0x9f, 0xd5, 0xf5, 0x81, 0x6, 0xf6, 0x4f, 0x21, 0x12, 0xf4, 0xdb, 0xc2, 0x90, 0x74, 0x2a, 0xa3, 0xd1, 0x66, 0x91, 0x5d, 0x97, 0x60, 0x64},
	},
	"AES-192 with IV": {
		Plaintext:  []byte("UCVBgQEhwVxXrABksapmqglhTGNWRRnGnUUQHtNanYuyIDrQgHvQanwkfXRvTnJLsMauOfdlLBuJRJkzaGpnVRyENKGwFfauXLJD"),
		Key:        []byte("24_byte_looooooooong_key"),
		Iv:         []byte{152, 0, 68, 172},
		CipherType: "aes",
		Ciphertext: []byte{0xd2, 0x84, 0x24, 0x69, 0x11, 0x17, 0xec, 0x5c, 0x1c, 0xbe, 0x2d, 0x34, 0x67, 0xb7, 0xf, 0xa9, 0x94, 0xeb, 0x11, 0x97, 0xe4, 0x60, 0x72, 0xe7, 0xf1, 0x49, 0x9b, 0xc7, 0xc8, 0xc6, 0x7e, 0xad, 0x2b, 0xe2, 0x36, 0x6a, 0xd1, 0x20, 0x0, 0x4a, 0x28, 0x7a, 0x25, 0x86, 0x9a, 0x23, 0x9, 0xe9, 0xf1, 0x2c, 0x7e, 0xe, 0x3a, 0xec, 0xb9, 0x10, 0xf5, 0x35, 0xb6, 0xc2, 0xf6, 0x93, 0x16, 0x2, 0xd, 0x3b, 0x65, 0x63, 0x27, 0x29, 0xd2, 0xeb, 0xc8, 0xc0, 0xa0, 0x2e, 0x19, 0x22, 0xc4, 0x1e, 0x38, 0x73, 0xb0, 0x34, 0x69, 0xda, 0x52, 0x63, 0x9e, 0xaa, 0xa5, 0x93, 0x1, 0x37, 0xff, 0x9d, 0x4e, 0xf1, 0x7f, 0x72, 0x79, 0xe6, 0xad, 0x4b, 0x1f, 0x67, 0x4f, 0x2, 0xab, 0x17, 0x13, 0xcc},
	},
	"AES-256": {
		Plaintext:  []byte("ghJxetyYQiLwdAtibf52bECQbA6QP0FsC0wDURcrR9DRZs7WChql2cJSunTh6rr6b5MM5YYgzWgXHvTxHaEIMiAuEXHsfcyInlxIyaHe2wS03PV6HZ1GKNbhksUx6NjKEoW5SmvmSngdlXSAOWwTYalUP6mKZm9BYHe57LQiHhiX76dKkqqVBvt16t6Hki3hRbqxdUH9JTB3sNAjoH6EjZKnH9h04M02IYncyJAhEpfDINkaerYMQ1Hbavpo0UHu"),
		Key:        []byte("32_byte_looooooooooooooooong_key"),
		CipherType: "aes/pad:none",
		Ciphertext: []byte{0xb1, 0x7e, 0x2f, 0xfd, 0x8d, 0xe2, 0x96, 0x5, 0xdc, 0xb1, 0x74, 0x5f, 0x59, 0x67, 0x2e, 0x30, 0x78, 0x6c, 0xdf, 0x2e, 0xd6, 0xbd, 0x23, 0xcd, 0xf2, 0x9b, 0x31, 0xd0, 0xa1, 0xa3, 0xd5, 0xd0, 0x4e, 0x25, 0x81, 0x25, 0x19, 0xdd, 0x4a, 0x67, 0xb4, 0xba, 0x71, 0x28, 0x2f, 0xa6, 0x31, 0x71, 0xf, 0xfc, 0xd6, 0x9a, 0xe3, 0xa6, 0x7e, 0xc7, 0x5d, 0xe7, 0xe5, 0xef, 0x8c, 0x90, 0xeb, 0x15, 0xfb, 0xa0, 0xd7, 0x30, 0x87, 0xf6, 0x5, 0xa9, 0x16, 0x86, 0xcc, 0xc0, 0x9f, 0x19, 0x14, 0xb8, 0x43, 0x72, 0xcb, 0x35, 0x9d, 0x18, 0xdc, 0xd2, 0xd6, 0xe4, 0x30, 0xc5, 0xc4, 0x8f, 0x4b, 0x98, 0xdd, 0x29, 0x53, 0xd9, 0x6, 0x1b, 0x48, 0xe9, 0x4a, 0x76, 0x36, 0xf5, 0x5a, 0x55, 0x5e, 0xd, 0x18, 0x57, 0xfe, 0xc2, 0x90, 0x5b, 0x82, 0x50, 0x7e, 0x14, 0xe1, 0xe0, 0xb0, 0x5e, 0x26, 0x44, 0x61, 0xe4, 0x22, 0x72, 0x7, 0x19, 0x60, 0xef, 0x6c, 0xb9, 0xfb, 0xa5, 0x9e, 0x5c, 0x7, 0xf6, 0x13, 0xc7, 0xa1, 0x97, 0x6b, 0xc, 0x1c, 0xaa, 0xaa, 0xcf, 0xd8, 0x6d, 0x39, 0x50, 0x57, 0x94, 0xce, 0x5d, 0xd, 0xf2, 0xd4, 0x2b, 0xbd, 0x71, 0xb4, 0xc6, 0x3b, 0x92, 0xb0, 0x5f, 0x3d, 0x56, 0xf5, 0x23, 0x6d, 0xaf, 0xb0, 0xbc, 0x62, 0xd5, 0xf0, 0x1e, 0x75, 0xad, 0xc2, 0x64, 0xbf, 0x66, 0xe7, 0xad, 0xab, 0xfd, 0xbf, 0xde, 0x72, 0xa4, 0x6, 0x39, 0xd2, 0xf4, 0x3, 0x5e, 0x27, 0x6, 0x98, 0x92, 0x7d, 0x2c, 0xe4, 0xac, 0x9e, 0xff, 0x41, 0xc1, 0xe7, 0xc1, 0x69, 0xbd, 0x8f, 0x5b, 0xc4, 0x1e, 0x36, 0x59, 0xa9, 0xb5, 0xbc, 0x64, 0x49, 0xfd, 0x78, 0x7f, 0xc, 0xad, 0x25, 0xae, 0x4b, 0xec, 0xb5, 0x4f, 0x97, 0x9e, 0x8c, 0xa6, 0x7b, 0x9, 0x2a, 0x76, 0xcd, 0x2d, 0x2e, 0x41},
	},
	"AES-256 with IV": {
		Plaintext:  []byte("ghJxetyYQiLwdAtibf52bECQbA6QP0FsC0wDURcrR9DRZs7WChql2cJSunTh6rr6b5MM5YYgzWgXHvTxHaEIMiAuEXHsfcyInlxIyaHe2wS03PV6HZ1GKNbhksUx6NjKEoW5SmvmSngdlXSAOWwTYalUP6mKZm9BYHe57LQiHhiX76dKkqqVBvt16t6Hki3hRbqxdUH9JTB3sNAjoH6EjZKnH9h04M02IYncyJAhEpfDINkaerYMQ1Hbavpo0UHu"),
		Key:        []byte("32_byte_looooooooooooooooong_key"),
		Iv:         []byte{154, 201, 158, 144, 3, 25, 184, 208, 70, 90, 123, 45, 168, 27, 236, 25},
		CipherType: "aes",
		Ciphertext: []byte{0x8b, 0xb2, 0xd7, 0x52, 0xdd, 0xff, 0x46, 0xa, 0xb9, 0x67, 0x12, 0x57, 0xe0, 0xff, 0x61, 0x23, 0x7, 0x60, 0x2, 0xe2, 0x28, 0x53, 0x53, 0x7c, 0x3e, 0xa, 0xdf, 0x8, 0x6e, 0xbd, 0x54, 0x48, 0xb3, 0x82, 0xf7, 0x6a, 0xce, 0xc6, 0xc8, 0xb3, 0xda, 0x19, 0xc5, 0x81, 0x91, 0x11, 0xd8, 0xd0, 0x87, 0x7d, 0xc0, 0x29, 0xb4, 0xe4, 0x8d, 0x74, 0x93, 0x0, 0xeb, 0x34, 0xc9, 0xd2, 0xb1, 0xc9, 0x30, 0xbc, 0xd9, 0x67, 0x7b, 0xa4, 0xeb, 0x81, 0x32, 0x8c, 0xa9, 0x95, 0xb9, 0x7c, 0xfb, 0xc0, 0x5f, 0x87, 0x2c, 0x32, 0x43, 0x15, 0xb4, 0xd1, 0x9b, 0x25, 0x3c, 0xe, 0xaf, 0xd1, 0x56, 0x17, 0xac, 0x26, 0x51, 0x17, 0x36, 0xda, 0xf6, 0x13, 0x5d, 0xf8, 0x12, 0xf6, 0x1f, 0x4, 0x17, 0x5b, 0xa8, 0xf1, 0xb1, 0xda, 0xc, 0x38, 0x13, 0x10, 0xe7, 0xe0, 0xd7, 0xa8, 0x4a, 0x69, 0x83, 0x5e, 0xe7, 0xc0, 0xf7, 0x21, 0xdb, 0xe3, 0x9d, 0x84, 0xce, 0x8e, 0x50, 0x7, 0x44, 0xe4, 0xe, 0xdf, 0xde, 0x88, 0xa5, 0xee, 0xd7, 0xf4, 0x32, 0xa0, 0x60, 0x24, 0x9d, 0x8b, 0x5a, 0xdf, 0xbc, 0xca, 0x6c, 0x2c, 0x80, 0x40, 0x47, 0xdf, 0x3f, 0x9b, 0xbe, 0x86, 0x34, 0x2b, 0x79, 0xc1, 0x27, 0xcf, 0x4c, 0xda, 0x89, 0x6b, 0xd8, 0xcb, 0xf8, 0xcd, 0x57, 0x46, 0xbc, 0x54, 0x55, 0x21, 0xc3, 0x34, 0x5e, 0x4c, 0xc8, 0xc3, 0x21, 0x51, 0xce, 0x8b, 0x3e, 0xcb, 0x36, 0xdc, 0x32, 0x31, 0xdc, 0x27, 0xf8, 0x12, 0x77, 0x64, 0xa8, 0xb8, 0x6d, 0x3c, 0x42, 0x6a, 0xd9, 0x7c, 0xbf, 0x14, 0xc5, 0x58, 0xdb, 0x1d, 0x24, 0x74, 0xb5, 0x47, 0xce, 0x54, 0x50, 0x32, 0xfc, 0xb9, 0x9f, 0xd3, 0x45, 0xa2, 0x5, 0x5d, 0xa4, 0x8a, 0x57, 0x58, 0x10, 0xc7, 0x5e, 0x83, 0x9f, 0x2b, 0x64, 0xe3, 0xd4, 0x98, 0x15, 0xf7, 0x8a, 0xdf, 0xe7, 0xc7, 0x2, 0x27, 0xa4, 0xff, 0xa7, 0x98, 0x24, 0xa, 0xf0, 0x2d},
	},
}
