// Copyright 2022 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by generate-logictest, DO NOT EDIT.

package testlocal_repeatable_read

import (
	"os"
	"path/filepath"
	"testing"

	"github.com/cockroachdb/cockroach/pkg/base"
	"github.com/cockroachdb/cockroach/pkg/build/bazel"
	"github.com/cockroachdb/cockroach/pkg/ccl"
	"github.com/cockroachdb/cockroach/pkg/security/securityassets"
	"github.com/cockroachdb/cockroach/pkg/security/securitytest"
	"github.com/cockroachdb/cockroach/pkg/server"
	"github.com/cockroachdb/cockroach/pkg/sql"
	"github.com/cockroachdb/cockroach/pkg/sql/logictest"
	"github.com/cockroachdb/cockroach/pkg/testutils/serverutils"
	"github.com/cockroachdb/cockroach/pkg/testutils/skip"
	"github.com/cockroachdb/cockroach/pkg/testutils/testcluster"
	"github.com/cockroachdb/cockroach/pkg/util/leaktest"
	"github.com/cockroachdb/cockroach/pkg/util/randutil"
)

const configIdx = 4

var logicTestDir string
var cclLogicTestDir string
var execBuildLogicTestDir string

func init() {
	if bazel.BuiltWithBazel() {
		var err error
		logicTestDir, err = bazel.Runfile("pkg/sql/logictest/testdata/logic_test")
		if err != nil {
			panic(err)
		}
	} else {
		logicTestDir = "../../../../sql/logictest/testdata/logic_test"
	}
	if bazel.BuiltWithBazel() {
		var err error
		cclLogicTestDir, err = bazel.Runfile("pkg/ccl/logictestccl/testdata/logic_test")
		if err != nil {
			panic(err)
		}
	} else {
		cclLogicTestDir = "../../../../ccl/logictestccl/testdata/logic_test"
	}
	if bazel.BuiltWithBazel() {
		var err error
		execBuildLogicTestDir, err = bazel.Runfile("pkg/sql/opt/exec/execbuilder/testdata")
		if err != nil {
			panic(err)
		}
	} else {
		execBuildLogicTestDir = "../../../../sql/opt/exec/execbuilder/testdata"
	}
}

func TestMain(m *testing.M) {
	defer ccl.TestingEnableEnterprise()()
	securityassets.SetLoader(securitytest.EmbeddedAssets)
	randutil.SeedForTests()
	serverutils.InitTestServerFactory(server.TestServerFactory)
	serverutils.InitTestClusterFactory(testcluster.TestClusterFactory)

	defer serverutils.TestingSetDefaultTenantSelectionOverride(
		base.TestIsForStuffThatShouldWorkWithSecondaryTenantsButDoesntYet(76378),
	)()

	os.Exit(m.Run())
}

func runLogicTest(t *testing.T, file string) {
	skip.UnderDeadlock(t, "times out and/or hangs")
	logictest.RunLogicTest(t, logictest.TestServerArgs{}, configIdx, filepath.Join(logicTestDir, file))
}
func runCCLLogicTest(t *testing.T, file string) {
	skip.UnderDeadlock(t, "times out and/or hangs")
	logictest.RunLogicTest(t, logictest.TestServerArgs{}, configIdx, filepath.Join(cclLogicTestDir, file))
}
func runExecBuildLogicTest(t *testing.T, file string) {
	defer sql.TestingOverrideExplainEnvVersion("CockroachDB execbuilder test version")()
	skip.UnderDeadlock(t, "times out and/or hangs")
	serverArgs := logictest.TestServerArgs{
		DisableWorkmemRandomization: true,
		// Disable the direct scans in order to keep the output of EXPLAIN (VEC)
		// deterministic.
		DisableDirectColumnarScans: true,
	}
	logictest.RunLogicTest(t, serverArgs, configIdx, filepath.Join(execBuildLogicTestDir, file))
}

// TestLogic_tmp runs any tests that are prefixed with "_", in which a dedicated
// test is not generated for. This allows developers to create and run temporary
// test files that are not checked into the repository, without repeatedly
// regenerating and reverting changes to this file, generated_test.go.
//
// TODO(mgartner): Add file filtering so that individual files can be run,
// instead of all files with the "_" prefix.
func TestLogic_tmp(t *testing.T) {
	defer leaktest.AfterTest(t)()
	var glob string
	glob = filepath.Join(logicTestDir, "_*")
	logictest.RunLogicTests(t, logictest.TestServerArgs{}, configIdx, glob)
	glob = filepath.Join(cclLogicTestDir, "_*")
	logictest.RunLogicTests(t, logictest.TestServerArgs{}, configIdx, glob)
	glob = filepath.Join(execBuildLogicTestDir, "_*")
	serverArgs := logictest.TestServerArgs{
		DisableWorkmemRandomization: true,
	}
	logictest.RunLogicTests(t, serverArgs, configIdx, glob)
}

func TestRepeatableReadLogic_aggregate(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "aggregate")
}

func TestRepeatableReadLogic_alias_types(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alias_types")
}

func TestRepeatableReadLogic_alter_column_type(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_column_type")
}

func TestRepeatableReadLogic_alter_database_convert_to_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_database_convert_to_schema")
}

func TestRepeatableReadLogic_alter_database_owner(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_database_owner")
}

func TestRepeatableReadLogic_alter_default_privileges_for_all_roles(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_default_privileges_for_all_roles")
}

func TestRepeatableReadLogic_alter_default_privileges_for_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_default_privileges_for_schema")
}

func TestRepeatableReadLogic_alter_default_privileges_for_sequence(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_default_privileges_for_sequence")
}

func TestRepeatableReadLogic_alter_default_privileges_for_table(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_default_privileges_for_table")
}

func TestRepeatableReadLogic_alter_default_privileges_for_type(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_default_privileges_for_type")
}

func TestRepeatableReadLogic_alter_default_privileges_in_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_default_privileges_in_schema")
}

func TestRepeatableReadLogic_alter_default_privileges_with_grant_option(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_default_privileges_with_grant_option")
}

func TestRepeatableReadLogic_alter_primary_key(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_primary_key")
}

func TestRepeatableReadLogic_alter_role(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_role")
}

func TestRepeatableReadLogic_alter_role_set(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_role_set")
}

func TestRepeatableReadLogic_alter_schema_owner(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_schema_owner")
}

func TestRepeatableReadLogic_alter_sequence(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_sequence")
}

func TestRepeatableReadLogic_alter_sequence_owner(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_sequence_owner")
}

func TestRepeatableReadLogic_alter_table(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_table")
}

func TestRepeatableReadLogic_alter_table_owner(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_table_owner")
}

func TestRepeatableReadLogic_alter_type(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_type")
}

func TestRepeatableReadLogic_alter_type_owner(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_type_owner")
}

func TestRepeatableReadLogic_alter_view_owner(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_view_owner")
}

func TestRepeatableReadLogic_and_or(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "and_or")
}

func TestRepeatableReadLogic_apply_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "apply_join")
}

func TestRepeatableReadLogic_array(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "array")
}

func TestRepeatableReadLogic_as_of(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "as_of")
}

func TestRepeatableReadLogic_asyncpg(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "asyncpg")
}

func TestRepeatableReadLogic_auto_span_config_reconciliation_job(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "auto_span_config_reconciliation_job")
}

func TestRepeatableReadLogic_bit(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "bit")
}

func TestRepeatableReadLogic_bpchar(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "bpchar")
}

func TestRepeatableReadLogic_builtin_function(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "builtin_function")
}

func TestRepeatableReadLogic_builtin_function_notenant(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "builtin_function_notenant")
}

func TestRepeatableReadLogic_bytes(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "bytes")
}

func TestRepeatableReadLogic_cascade(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "cascade")
}

func TestRepeatableReadLogic_case_sensitive_names(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "case_sensitive_names")
}

func TestRepeatableReadLogic_cast(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "cast")
}

func TestRepeatableReadLogic_check_constraints(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "check_constraints")
}

func TestRepeatableReadLogic_cluster_settings(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "cluster_settings")
}

func TestRepeatableReadLogic_collatedstring(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "collatedstring")
}

func TestRepeatableReadLogic_collatedstring_constraint(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "collatedstring_constraint")
}

func TestRepeatableReadLogic_collatedstring_index1(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "collatedstring_index1")
}

func TestRepeatableReadLogic_collatedstring_index2(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "collatedstring_index2")
}

func TestRepeatableReadLogic_collatedstring_normalization(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "collatedstring_normalization")
}

func TestRepeatableReadLogic_collatedstring_nullinindex(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "collatedstring_nullinindex")
}

func TestRepeatableReadLogic_collatedstring_uniqueindex1(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "collatedstring_uniqueindex1")
}

func TestRepeatableReadLogic_collatedstring_uniqueindex2(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "collatedstring_uniqueindex2")
}

func TestRepeatableReadLogic_comment_on(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "comment_on")
}

func TestRepeatableReadLogic_composite_types(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "composite_types")
}

func TestRepeatableReadLogic_computed(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "computed")
}

func TestRepeatableReadLogic_conditional(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "conditional")
}

func TestRepeatableReadLogic_connect_privilege(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "connect_privilege")
}

func TestRepeatableReadLogic_crdb_internal(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "crdb_internal")
}

func TestRepeatableReadLogic_crdb_internal_catalog(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "crdb_internal_catalog")
}

func TestRepeatableReadLogic_crdb_internal_default_privileges(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "crdb_internal_default_privileges")
}

func TestRepeatableReadLogic_create_as(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "create_as")
}

func TestRepeatableReadLogic_create_index(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "create_index")
}

func TestRepeatableReadLogic_create_table(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "create_table")
}

func TestRepeatableReadLogic_cross_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "cross_join")
}

func TestRepeatableReadLogic_cursor(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "cursor")
}

func TestRepeatableReadLogic_custom_escape_character(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "custom_escape_character")
}

func TestRepeatableReadLogic_dangerous_statements(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "dangerous_statements")
}

func TestRepeatableReadLogic_database(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "database")
}

func TestRepeatableReadLogic_datetime(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "datetime")
}

func TestRepeatableReadLogic_decimal(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "decimal")
}

func TestRepeatableReadLogic_default(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "default")
}

func TestRepeatableReadLogic_delete(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "delete")
}

func TestRepeatableReadLogic_delete_batch(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "delete_batch")
}

func TestRepeatableReadLogic_dependencies(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "dependencies")
}

func TestRepeatableReadLogic_discard(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "discard")
}

func TestRepeatableReadLogic_disjunction_in_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "disjunction_in_join")
}

func TestRepeatableReadLogic_distinct(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "distinct")
}

func TestRepeatableReadLogic_distinct_on(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "distinct_on")
}

func TestRepeatableReadLogic_distsql_automatic_partial_stats(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "distsql_automatic_partial_stats")
}

func TestRepeatableReadLogic_distsql_automatic_stats(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "distsql_automatic_stats")
}

func TestRepeatableReadLogic_distsql_event_log(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "distsql_event_log")
}

func TestRepeatableReadLogic_distsql_expr(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "distsql_expr")
}

func TestRepeatableReadLogic_distsql_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "distsql_join")
}

func TestRepeatableReadLogic_distsql_srfs(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "distsql_srfs")
}

func TestRepeatableReadLogic_drop_database(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_database")
}

func TestRepeatableReadLogic_drop_function(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_function")
}

func TestRepeatableReadLogic_drop_index(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_index")
}

func TestRepeatableReadLogic_drop_owned_by(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_owned_by")
}

func TestRepeatableReadLogic_drop_procedure(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_procedure")
}

func TestRepeatableReadLogic_drop_role_with_default_privileges(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_role_with_default_privileges")
}

func TestRepeatableReadLogic_drop_role_with_default_privileges_in_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_role_with_default_privileges_in_schema")
}

func TestRepeatableReadLogic_drop_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_schema")
}

func TestRepeatableReadLogic_drop_sequence(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_sequence")
}

func TestRepeatableReadLogic_drop_table(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_table")
}

func TestRepeatableReadLogic_drop_temp(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_temp")
}

func TestRepeatableReadLogic_drop_type(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_type")
}

func TestRepeatableReadLogic_drop_user(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_user")
}

func TestRepeatableReadLogic_drop_view(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_view")
}

func TestRepeatableReadLogic_edge(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "edge")
}

func TestRepeatableReadLogic_enums(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "enums")
}

func TestRepeatableReadLogic_errors(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "errors")
}

func TestRepeatableReadLogic_event_log(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "event_log")
}

func TestRepeatableReadLogic_exclude_data_from_backup(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "exclude_data_from_backup")
}

func TestRepeatableReadLogic_experimental_distsql_planning(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "experimental_distsql_planning")
}

func TestRepeatableReadLogic_explain_analyze(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "explain_analyze")
}

func TestRepeatableReadLogic_export(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "export")
}

func TestRepeatableReadLogic_expression_index(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "expression_index")
}

func TestRepeatableReadLogic_external_connection_privileges(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "external_connection_privileges")
}

func TestRepeatableReadLogic_family(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "family")
}

func TestRepeatableReadLogic_fk(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "fk")
}

func TestRepeatableReadLogic_float(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "float")
}

func TestRepeatableReadLogic_format(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "format")
}

func TestRepeatableReadLogic_function_lookup(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "function_lookup")
}

func TestRepeatableReadLogic_fuzzystrmatch(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "fuzzystrmatch")
}

func TestRepeatableReadLogic_geospatial(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "geospatial")
}

func TestRepeatableReadLogic_geospatial_index(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "geospatial_index")
}

func TestRepeatableReadLogic_geospatial_meta(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "geospatial_meta")
}

func TestRepeatableReadLogic_geospatial_regression(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "geospatial_regression")
}

func TestRepeatableReadLogic_geospatial_zm(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "geospatial_zm")
}

func TestRepeatableReadLogic_grant_database(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "grant_database")
}

func TestRepeatableReadLogic_grant_in_txn(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "grant_in_txn")
}

func TestRepeatableReadLogic_grant_on_all_sequences_in_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "grant_on_all_sequences_in_schema")
}

func TestRepeatableReadLogic_grant_on_all_tables_in_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "grant_on_all_tables_in_schema")
}

func TestRepeatableReadLogic_grant_revoke_with_grant_option(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "grant_revoke_with_grant_option")
}

func TestRepeatableReadLogic_grant_role(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "grant_role")
}

func TestRepeatableReadLogic_grant_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "grant_schema")
}

func TestRepeatableReadLogic_group_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "group_join")
}

func TestRepeatableReadLogic_hash_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "hash_join")
}

func TestRepeatableReadLogic_hash_sharded_index(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "hash_sharded_index")
}

func TestRepeatableReadLogic_hidden_columns(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "hidden_columns")
}

func TestRepeatableReadLogic_impure(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "impure")
}

func TestRepeatableReadLogic_index_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "index_join")
}

func TestRepeatableReadLogic_inet(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "inet")
}

func TestRepeatableReadLogic_inflight_trace_spans(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "inflight_trace_spans")
}

func TestRepeatableReadLogic_information_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "information_schema")
}

func TestRepeatableReadLogic_inner_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "inner-join")
}

func TestRepeatableReadLogic_insert(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "insert")
}

func TestRepeatableReadLogic_int_size(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "int_size")
}

func TestRepeatableReadLogic_internal_executor(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "internal_executor")
}

func TestRepeatableReadLogic_interval(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "interval")
}

func TestRepeatableReadLogic_inverted_filter_geospatial(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "inverted_filter_geospatial")
}

func TestRepeatableReadLogic_inverted_filter_json_array(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "inverted_filter_json_array")
}

func TestRepeatableReadLogic_inverted_index(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "inverted_index")
}

func TestRepeatableReadLogic_inverted_index_multi_column(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "inverted_index_multi_column")
}

func TestRepeatableReadLogic_inverted_join_geospatial(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "inverted_join_geospatial")
}

func TestRepeatableReadLogic_inverted_join_json_array(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "inverted_join_json_array")
}

func TestRepeatableReadLogic_inverted_join_multi_column(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "inverted_join_multi_column")
}

func TestRepeatableReadLogic_jobs(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "jobs")
}

func TestRepeatableReadLogic_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "join")
}

func TestRepeatableReadLogic_json(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "json")
}

func TestRepeatableReadLogic_json_builtins(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "json_builtins")
}

func TestRepeatableReadLogic_json_index(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "json_index")
}

func TestRepeatableReadLogic_kv_builtin_functions(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "kv_builtin_functions")
}

func TestRepeatableReadLogic_limit(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "limit")
}

func TestRepeatableReadLogic_locality(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "locality")
}

func TestRepeatableReadLogic_lock_timeout(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "lock_timeout")
}

func TestRepeatableReadLogic_lookup_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "lookup_join")
}

func TestRepeatableReadLogic_lookup_join_spans(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "lookup_join_spans")
}

func TestRepeatableReadLogic_manual_retry(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "manual_retry")
}

func TestRepeatableReadLogic_materialized_view(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "materialized_view")
}

func TestRepeatableReadLogic_merge_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "merge_join")
}

func TestRepeatableReadLogic_multi_statement(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "multi_statement")
}

func TestRepeatableReadLogic_name_escapes(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "name_escapes")
}

func TestRepeatableReadLogic_namespace(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "namespace")
}

func TestRepeatableReadLogic_new_schema_changer(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "new_schema_changer")
}

func TestRepeatableReadLogic_no_primary_key(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "no_primary_key")
}

func TestRepeatableReadLogic_notice(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "notice")
}

func TestRepeatableReadLogic_numeric_references(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "numeric_references")
}

func TestRepeatableReadLogic_on_update(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "on_update")
}

func TestRepeatableReadLogic_operator(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "operator")
}

func TestRepeatableReadLogic_optimizer_timeout(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "optimizer_timeout")
}

func TestRepeatableReadLogic_order_by(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "order_by")
}

func TestRepeatableReadLogic_ordinal_references(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "ordinal_references")
}

func TestRepeatableReadLogic_ordinality(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "ordinality")
}

func TestRepeatableReadLogic_overflow(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "overflow")
}

func TestRepeatableReadLogic_overlaps(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "overlaps")
}

func TestRepeatableReadLogic_owner(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "owner")
}

func TestRepeatableReadLogic_parallel_stmts_compat(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "parallel_stmts_compat")
}

func TestRepeatableReadLogic_partial_index(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "partial_index")
}

func TestRepeatableReadLogic_partial_txn_commit(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "partial_txn_commit")
}

func TestRepeatableReadLogic_pg_builtins(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "pg_builtins")
}

func TestRepeatableReadLogic_pg_catalog_pg_default_acl(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "pg_catalog_pg_default_acl")
}

func TestRepeatableReadLogic_pg_catalog_pg_default_acl_with_grant_option(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "pg_catalog_pg_default_acl_with_grant_option")
}

func TestRepeatableReadLogic_pg_extension(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "pg_extension")
}

func TestRepeatableReadLogic_pg_lsn(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "pg_lsn")
}

func TestRepeatableReadLogic_pgcrypto_builtins(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "pgcrypto_builtins")
}

func TestRepeatableReadLogic_pgoidtype(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "pgoidtype")
}

func TestRepeatableReadLogic_plpgsql_builtins(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "plpgsql_builtins")
}

func TestRepeatableReadLogic_poison_after_push(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "poison_after_push")
}

func TestRepeatableReadLogic_postgres_jsonb(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "postgres_jsonb")
}

func TestRepeatableReadLogic_postgresjoin(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "postgresjoin")
}

func TestRepeatableReadLogic_privilege_builtins(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "privilege_builtins")
}

func TestRepeatableReadLogic_privileges_comments(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "privileges_comments")
}

func TestRepeatableReadLogic_privileges_table(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "privileges_table")
}

func TestRepeatableReadLogic_proc_invokes_proc(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "proc_invokes_proc")
}

func TestRepeatableReadLogic_procedure(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "procedure")
}

func TestRepeatableReadLogic_procedure_cte(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "procedure_cte")
}

func TestRepeatableReadLogic_procedure_deps(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "procedure_deps")
}

func TestRepeatableReadLogic_procedure_params(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "procedure_params")
}

func TestRepeatableReadLogic_procedure_polymorphic(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "procedure_polymorphic")
}

func TestRepeatableReadLogic_procedure_privileges(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "procedure_privileges")
}

func TestRepeatableReadLogic_procedure_schema_change(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "procedure_schema_change")
}

func TestRepeatableReadLogic_propagate_input_ordering(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "propagate_input_ordering")
}

func TestRepeatableReadLogic_reassign_owned_by(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "reassign_owned_by")
}

func TestRepeatableReadLogic_record(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "record")
}

func TestRepeatableReadLogic_redact_descriptor(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "redact_descriptor")
}

func TestRepeatableReadLogic_rename_atomic(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "rename_atomic")
}

func TestRepeatableReadLogic_rename_column(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "rename_column")
}

func TestRepeatableReadLogic_rename_constraint(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "rename_constraint")
}

func TestRepeatableReadLogic_rename_database(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "rename_database")
}

func TestRepeatableReadLogic_rename_index(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "rename_index")
}

func TestRepeatableReadLogic_rename_sequence(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "rename_sequence")
}

func TestRepeatableReadLogic_rename_table(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "rename_table")
}

func TestRepeatableReadLogic_rename_view(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "rename_view")
}

func TestRepeatableReadLogic_reset(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "reset")
}

func TestRepeatableReadLogic_retry(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "retry")
}

func TestRepeatableReadLogic_returning(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "returning")
}

func TestRepeatableReadLogic_routine_schema_change(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "routine_schema_change")
}

func TestRepeatableReadLogic_row_level_ttl(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "row_level_ttl")
}

func TestRepeatableReadLogic_rows_from(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "rows_from")
}

func TestRepeatableReadLogic_run_control(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "run_control")
}

func TestRepeatableReadLogic_save_table(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "save_table")
}

func TestRepeatableReadLogic_savepoints(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "savepoints")
}

func TestRepeatableReadLogic_scale(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "scale")
}

func TestRepeatableReadLogic_scatter(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "scatter")
}

func TestRepeatableReadLogic_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "schema")
}

func TestRepeatableReadLogic_schema_change_feature_flags(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "schema_change_feature_flags")
}

func TestRepeatableReadLogic_schema_change_in_txn(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "schema_change_in_txn")
}

func TestRepeatableReadLogic_schema_change_logical_replication(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "schema_change_logical_replication")
}

func TestRepeatableReadLogic_schema_change_retry(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "schema_change_retry")
}

func TestRepeatableReadLogic_schema_locked(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "schema_locked")
}

func TestRepeatableReadLogic_schema_repair(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "schema_repair")
}

func TestRepeatableReadLogic_scrub(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "scrub")
}

func TestRepeatableReadLogic_secondary_index_column_families(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "secondary_index_column_families")
}

func TestRepeatableReadLogic_select(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "select")
}

func TestRepeatableReadLogic_select_for_share(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "select_for_share")
}

func TestRepeatableReadLogic_select_index(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "select_index")
}

func TestRepeatableReadLogic_select_index_flags(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "select_index_flags")
}

func TestRepeatableReadLogic_select_search_path(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "select_search_path")
}

func TestRepeatableReadLogic_select_table_alias(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "select_table_alias")
}

func TestRepeatableReadLogic_sequences(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "sequences")
}

func TestRepeatableReadLogic_sequences_distsql(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "sequences_distsql")
}

func TestRepeatableReadLogic_sequences_regclass(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "sequences_regclass")
}

func TestRepeatableReadLogic_serial(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "serial")
}

func TestRepeatableReadLogic_serializable_eager_restart(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "serializable_eager_restart")
}

func TestRepeatableReadLogic_set_local(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "set_local")
}

func TestRepeatableReadLogic_set_role(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "set_role")
}

func TestRepeatableReadLogic_set_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "set_schema")
}

func TestRepeatableReadLogic_set_time_zone(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "set_time_zone")
}

func TestRepeatableReadLogic_shift(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "shift")
}

func TestRepeatableReadLogic_show_commit_timestamp(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_commit_timestamp")
}

func TestRepeatableReadLogic_show_completions(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_completions")
}

func TestRepeatableReadLogic_show_create(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_create")
}

func TestRepeatableReadLogic_show_create_all_schemas(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_create_all_schemas")
}

func TestRepeatableReadLogic_show_create_all_tables(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_create_all_tables")
}

func TestRepeatableReadLogic_show_create_all_tables_builtin(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_create_all_tables_builtin")
}

func TestRepeatableReadLogic_show_create_all_types(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_create_all_types")
}

func TestRepeatableReadLogic_show_create_redact(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_create_redact")
}

func TestRepeatableReadLogic_show_default_privileges(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_default_privileges")
}

func TestRepeatableReadLogic_show_external_connections(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_external_connections")
}

func TestRepeatableReadLogic_show_fingerprints(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_fingerprints")
}

func TestRepeatableReadLogic_show_grants_on_virtual_table(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_grants_on_virtual_table")
}

func TestRepeatableReadLogic_show_grants_synthetic(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_grants_synthetic")
}

func TestRepeatableReadLogic_show_indexes(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_indexes")
}

func TestRepeatableReadLogic_show_transfer_state(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_transfer_state")
}

func TestRepeatableReadLogic_show_var(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_var")
}

func TestRepeatableReadLogic_span_builtins(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "span_builtins")
}

func TestRepeatableReadLogic_split_at(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "split_at")
}

func TestRepeatableReadLogic_sqllite(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "sqllite")
}

func TestRepeatableReadLogic_sqlliveness(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "sqlliveness")
}

func TestRepeatableReadLogic_sqlsmith(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "sqlsmith")
}

func TestRepeatableReadLogic_srfs(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "srfs")
}

func TestRepeatableReadLogic_statement_source(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "statement_source")
}

func TestRepeatableReadLogic_statement_statistics_errors(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "statement_statistics_errors")
}

func TestRepeatableReadLogic_statement_statistics_errors_redacted(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "statement_statistics_errors_redacted")
}

func TestRepeatableReadLogic_stats(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "stats")
}

func TestRepeatableReadLogic_storing(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "storing")
}

func TestRepeatableReadLogic_strict_ddl_atomicity(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "strict_ddl_atomicity")
}

func TestRepeatableReadLogic_suboperators(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "suboperators")
}

func TestRepeatableReadLogic_subquery(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "subquery")
}

func TestRepeatableReadLogic_subquery_correlated(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "subquery_correlated")
}

func TestRepeatableReadLogic_synthetic_privileges(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "synthetic_privileges")
}

func TestRepeatableReadLogic_system(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "system")
}

func TestRepeatableReadLogic_system_columns(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "system_columns")
}

func TestRepeatableReadLogic_system_namespace(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "system_namespace")
}

func TestRepeatableReadLogic_table(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "table")
}

func TestRepeatableReadLogic_target_names(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "target_names")
}

func TestRepeatableReadLogic_temp_table(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "temp_table")
}

func TestRepeatableReadLogic_temp_table_txn(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "temp_table_txn")
}

func TestRepeatableReadLogic_tenant(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "tenant")
}

func TestRepeatableReadLogic_time(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "time")
}

func TestRepeatableReadLogic_timestamp(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "timestamp")
}

func TestRepeatableReadLogic_timetz(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "timetz")
}

func TestRepeatableReadLogic_trigram_builtins(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "trigram_builtins")
}

func TestRepeatableReadLogic_trigram_indexes(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "trigram_indexes")
}

func TestRepeatableReadLogic_truncate(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "truncate")
}

func TestRepeatableReadLogic_truncate_with_concurrent_mutation(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "truncate_with_concurrent_mutation")
}

func TestRepeatableReadLogic_tsvector(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "tsvector")
}

func TestRepeatableReadLogic_tuple(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "tuple")
}

func TestRepeatableReadLogic_tuple_local(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "tuple_local")
}

func TestRepeatableReadLogic_two_phase_commit(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "two_phase_commit")
}

func TestRepeatableReadLogic_txn(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "txn")
}

func TestRepeatableReadLogic_txn_as_of(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "txn_as_of")
}

func TestRepeatableReadLogic_txn_retry(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "txn_retry")
}

func TestRepeatableReadLogic_txn_stats(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "txn_stats")
}

func TestRepeatableReadLogic_type_privileges(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "type_privileges")
}

func TestRepeatableReadLogic_typing(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "typing")
}

func TestRepeatableReadLogic_udf(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf")
}

func TestRepeatableReadLogic_udf_calling_udf(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_calling_udf")
}

func TestRepeatableReadLogic_udf_cte(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_cte")
}

func TestRepeatableReadLogic_udf_delete(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_delete")
}

func TestRepeatableReadLogic_udf_deps(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_deps")
}

func TestRepeatableReadLogic_udf_fk(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_fk")
}

func TestRepeatableReadLogic_udf_in_column_defaults(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_in_column_defaults")
}

func TestRepeatableReadLogic_udf_in_constraints(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_in_constraints")
}

func TestRepeatableReadLogic_udf_insert(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_insert")
}

func TestRepeatableReadLogic_udf_observability(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_observability")
}

func TestRepeatableReadLogic_udf_oid_ref(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_oid_ref")
}

func TestRepeatableReadLogic_udf_options(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_options")
}

func TestRepeatableReadLogic_udf_params(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_params")
}

func TestRepeatableReadLogic_udf_polymorphic(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_polymorphic")
}

func TestRepeatableReadLogic_udf_prepare(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_prepare")
}

func TestRepeatableReadLogic_udf_privileges(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_privileges")
}

func TestRepeatableReadLogic_udf_privileges_mutations(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_privileges_mutations")
}

func TestRepeatableReadLogic_udf_procedure_mix(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_procedure_mix")
}

func TestRepeatableReadLogic_udf_record(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_record")
}

func TestRepeatableReadLogic_udf_regressions(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_regressions")
}

func TestRepeatableReadLogic_udf_rewrite(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_rewrite")
}

func TestRepeatableReadLogic_udf_schema_change(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_schema_change")
}

func TestRepeatableReadLogic_udf_security(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_security")
}

func TestRepeatableReadLogic_udf_setof(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_setof")
}

func TestRepeatableReadLogic_udf_star(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_star")
}

func TestRepeatableReadLogic_udf_subquery(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_subquery")
}

func TestRepeatableReadLogic_udf_unsupported(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_unsupported")
}

func TestRepeatableReadLogic_udf_update(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_update")
}

func TestRepeatableReadLogic_udf_upsert(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_upsert")
}

func TestRepeatableReadLogic_union(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "union")
}

func TestRepeatableReadLogic_update(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "update")
}

func TestRepeatableReadLogic_update_from(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "update_from")
}

func TestRepeatableReadLogic_upsert(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "upsert")
}

func TestRepeatableReadLogic_upsert_non_metamorphic(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "upsert_non_metamorphic")
}

func TestRepeatableReadLogic_uuid(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "uuid")
}

func TestRepeatableReadLogic_values(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "values")
}

func TestRepeatableReadLogic_vectorize_agg(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "vectorize_agg")
}

func TestRepeatableReadLogic_vectorize_overloads(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "vectorize_overloads")
}

func TestRepeatableReadLogic_vectorize_shutdown(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "vectorize_shutdown")
}

func TestRepeatableReadLogic_vectorize_types(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "vectorize_types")
}

func TestRepeatableReadLogic_vectorize_unsupported(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "vectorize_unsupported")
}

func TestRepeatableReadLogic_views(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "views")
}

func TestRepeatableReadLogic_virtual_columns(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "virtual_columns")
}

func TestRepeatableReadLogic_virtual_table_privileges(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "virtual_table_privileges")
}

func TestRepeatableReadLogic_void(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "void")
}

func TestRepeatableReadLogic_where(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "where")
}

func TestRepeatableReadLogic_window(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "window")
}

func TestRepeatableReadLogic_with(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "with")
}

func TestRepeatableReadLogic_workload_indexrecs(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "workload_indexrecs")
}

func TestRepeatableReadLogic_zero(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "zero")
}

func TestRepeatableReadLogic_zigzag_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "zigzag_join")
}

func TestRepeatableReadLogic_zone_config(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "zone_config")
}

func TestRepeatableReadLogic_zone_config_system_tenant(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "zone_config_system_tenant")
}

func TestRepeatableReadLogicCCL_fips_ready(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "fips_ready")
}

func TestRepeatableReadLogicCCL_fk_read_committed(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "fk_read_committed")
}

func TestRepeatableReadLogicCCL_hash_sharded_index_read_committed(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "hash_sharded_index_read_committed")
}

func TestRepeatableReadLogicCCL_nested_routines(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "nested_routines")
}

func TestRepeatableReadLogicCCL_new_schema_changer(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "new_schema_changer")
}

func TestRepeatableReadLogicCCL_partitioning_enum(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "partitioning_enum")
}

func TestRepeatableReadLogicCCL_pgcrypto_builtins(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "pgcrypto_builtins")
}

func TestRepeatableReadLogicCCL_plpgsql_assign(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "plpgsql_assign")
}

func TestRepeatableReadLogicCCL_plpgsql_block(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "plpgsql_block")
}

func TestRepeatableReadLogicCCL_plpgsql_call(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "plpgsql_call")
}

func TestRepeatableReadLogicCCL_plpgsql_cte(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "plpgsql_cte")
}

func TestRepeatableReadLogicCCL_plpgsql_cursor(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "plpgsql_cursor")
}

func TestRepeatableReadLogicCCL_plpgsql_into(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "plpgsql_into")
}

func TestRepeatableReadLogicCCL_plpgsql_record(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "plpgsql_record")
}

func TestRepeatableReadLogicCCL_plpgsql_txn(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "plpgsql_txn")
}

func TestRepeatableReadLogicCCL_plpgsql_unsupported(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "plpgsql_unsupported")
}

func TestRepeatableReadLogicCCL_procedure_params(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "procedure_params")
}

func TestRepeatableReadLogicCCL_procedure_plpgsql(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "procedure_plpgsql")
}

func TestRepeatableReadLogicCCL_read_committed(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "read_committed")
}

func TestRepeatableReadLogicCCL_redact_descriptor(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "redact_descriptor")
}

func TestRepeatableReadLogicCCL_refcursor(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "refcursor")
}

func TestRepeatableReadLogicCCL_schema_change_in_txn(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "schema_change_in_txn")
}

func TestRepeatableReadLogicCCL_select_for_update_read_committed(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "select_for_update_read_committed")
}

func TestRepeatableReadLogicCCL_show_create(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "show_create")
}

func TestRepeatableReadLogicCCL_subject(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "subject")
}

func TestRepeatableReadLogicCCL_triggers(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "triggers")
}

func TestRepeatableReadLogicCCL_udf_params(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "udf_params")
}

func TestRepeatableReadLogicCCL_udf_plpgsql(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "udf_plpgsql")
}

func TestRepeatableReadLogicCCL_udf_rewrite(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "udf_rewrite")
}

func TestRepeatableReadLogicCCL_udf_volatility_check(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "udf_volatility_check")
}

func TestRepeatableReadLogicCCL_unique_read_committed(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "unique_read_committed")
}

func TestRepeatableReadLogicCCL_vector(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "vector")
}

func TestRepeatableReadExecBuild_geospatial(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runExecBuildLogicTest(t, "geospatial")
}
