// Copyright 2022 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by generate-logictest, DO NOT EDIT.

package testlocal_read_committed

import (
	"os"
	"path/filepath"
	"testing"

	"github.com/cockroachdb/cockroach/pkg/base"
	"github.com/cockroachdb/cockroach/pkg/build/bazel"
	"github.com/cockroachdb/cockroach/pkg/ccl"
	"github.com/cockroachdb/cockroach/pkg/security/securityassets"
	"github.com/cockroachdb/cockroach/pkg/security/securitytest"
	"github.com/cockroachdb/cockroach/pkg/server"
	"github.com/cockroachdb/cockroach/pkg/sql"
	"github.com/cockroachdb/cockroach/pkg/sql/logictest"
	"github.com/cockroachdb/cockroach/pkg/testutils/serverutils"
	"github.com/cockroachdb/cockroach/pkg/testutils/skip"
	"github.com/cockroachdb/cockroach/pkg/testutils/testcluster"
	"github.com/cockroachdb/cockroach/pkg/util/leaktest"
	"github.com/cockroachdb/cockroach/pkg/util/randutil"
)

const configIdx = 3

var logicTestDir string
var cclLogicTestDir string
var execBuildLogicTestDir string

func init() {
	if bazel.BuiltWithBazel() {
		var err error
		logicTestDir, err = bazel.Runfile("pkg/sql/logictest/testdata/logic_test")
		if err != nil {
			panic(err)
		}
	} else {
		logicTestDir = "../../../../sql/logictest/testdata/logic_test"
	}
	if bazel.BuiltWithBazel() {
		var err error
		cclLogicTestDir, err = bazel.Runfile("pkg/ccl/logictestccl/testdata/logic_test")
		if err != nil {
			panic(err)
		}
	} else {
		cclLogicTestDir = "../../../../ccl/logictestccl/testdata/logic_test"
	}
	if bazel.BuiltWithBazel() {
		var err error
		execBuildLogicTestDir, err = bazel.Runfile("pkg/sql/opt/exec/execbuilder/testdata")
		if err != nil {
			panic(err)
		}
	} else {
		execBuildLogicTestDir = "../../../../sql/opt/exec/execbuilder/testdata"
	}
}

func TestMain(m *testing.M) {
	defer ccl.TestingEnableEnterprise()()
	securityassets.SetLoader(securitytest.EmbeddedAssets)
	randutil.SeedForTests()
	serverutils.InitTestServerFactory(server.TestServerFactory)
	serverutils.InitTestClusterFactory(testcluster.TestClusterFactory)

	defer serverutils.TestingSetDefaultTenantSelectionOverride(
		base.TestIsForStuffThatShouldWorkWithSecondaryTenantsButDoesntYet(76378),
	)()

	os.Exit(m.Run())
}

func runLogicTest(t *testing.T, file string) {
	skip.UnderDeadlock(t, "times out and/or hangs")
	logictest.RunLogicTest(t, logictest.TestServerArgs{}, configIdx, filepath.Join(logicTestDir, file))
}
func runCCLLogicTest(t *testing.T, file string) {
	skip.UnderDeadlock(t, "times out and/or hangs")
	logictest.RunLogicTest(t, logictest.TestServerArgs{}, configIdx, filepath.Join(cclLogicTestDir, file))
}
func runExecBuildLogicTest(t *testing.T, file string) {
	defer sql.TestingOverrideExplainEnvVersion("CockroachDB execbuilder test version")()
	skip.UnderDeadlock(t, "times out and/or hangs")
	serverArgs := logictest.TestServerArgs{
		DisableWorkmemRandomization: true,
		// Disable the direct scans in order to keep the output of EXPLAIN (VEC)
		// deterministic.
		DisableDirectColumnarScans: true,
	}
	logictest.RunLogicTest(t, serverArgs, configIdx, filepath.Join(execBuildLogicTestDir, file))
}

// TestLogic_tmp runs any tests that are prefixed with "_", in which a dedicated
// test is not generated for. This allows developers to create and run temporary
// test files that are not checked into the repository, without repeatedly
// regenerating and reverting changes to this file, generated_test.go.
//
// TODO(mgartner): Add file filtering so that individual files can be run,
// instead of all files with the "_" prefix.
func TestLogic_tmp(t *testing.T) {
	defer leaktest.AfterTest(t)()
	var glob string
	glob = filepath.Join(logicTestDir, "_*")
	logictest.RunLogicTests(t, logictest.TestServerArgs{}, configIdx, glob)
	glob = filepath.Join(cclLogicTestDir, "_*")
	logictest.RunLogicTests(t, logictest.TestServerArgs{}, configIdx, glob)
	glob = filepath.Join(execBuildLogicTestDir, "_*")
	serverArgs := logictest.TestServerArgs{
		DisableWorkmemRandomization: true,
	}
	logictest.RunLogicTests(t, serverArgs, configIdx, glob)
}

func TestReadCommittedLogic_aggregate(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "aggregate")
}

func TestReadCommittedLogic_alias_types(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alias_types")
}

func TestReadCommittedLogic_alter_column_type(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_column_type")
}

func TestReadCommittedLogic_alter_database_convert_to_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_database_convert_to_schema")
}

func TestReadCommittedLogic_alter_database_owner(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_database_owner")
}

func TestReadCommittedLogic_alter_default_privileges_for_all_roles(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_default_privileges_for_all_roles")
}

func TestReadCommittedLogic_alter_default_privileges_for_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_default_privileges_for_schema")
}

func TestReadCommittedLogic_alter_default_privileges_for_sequence(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_default_privileges_for_sequence")
}

func TestReadCommittedLogic_alter_default_privileges_for_table(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_default_privileges_for_table")
}

func TestReadCommittedLogic_alter_default_privileges_for_type(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_default_privileges_for_type")
}

func TestReadCommittedLogic_alter_default_privileges_in_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_default_privileges_in_schema")
}

func TestReadCommittedLogic_alter_default_privileges_with_grant_option(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_default_privileges_with_grant_option")
}

func TestReadCommittedLogic_alter_primary_key(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_primary_key")
}

func TestReadCommittedLogic_alter_role(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_role")
}

func TestReadCommittedLogic_alter_role_set(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_role_set")
}

func TestReadCommittedLogic_alter_schema_owner(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_schema_owner")
}

func TestReadCommittedLogic_alter_sequence(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_sequence")
}

func TestReadCommittedLogic_alter_sequence_owner(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_sequence_owner")
}

func TestReadCommittedLogic_alter_table(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_table")
}

func TestReadCommittedLogic_alter_table_owner(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_table_owner")
}

func TestReadCommittedLogic_alter_type(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_type")
}

func TestReadCommittedLogic_alter_type_owner(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_type_owner")
}

func TestReadCommittedLogic_alter_view_owner(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "alter_view_owner")
}

func TestReadCommittedLogic_and_or(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "and_or")
}

func TestReadCommittedLogic_apply_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "apply_join")
}

func TestReadCommittedLogic_array(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "array")
}

func TestReadCommittedLogic_as_of(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "as_of")
}

func TestReadCommittedLogic_asyncpg(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "asyncpg")
}

func TestReadCommittedLogic_auto_span_config_reconciliation_job(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "auto_span_config_reconciliation_job")
}

func TestReadCommittedLogic_bit(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "bit")
}

func TestReadCommittedLogic_bpchar(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "bpchar")
}

func TestReadCommittedLogic_builtin_function(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "builtin_function")
}

func TestReadCommittedLogic_builtin_function_notenant(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "builtin_function_notenant")
}

func TestReadCommittedLogic_bytes(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "bytes")
}

func TestReadCommittedLogic_cascade(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "cascade")
}

func TestReadCommittedLogic_case_sensitive_names(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "case_sensitive_names")
}

func TestReadCommittedLogic_cast(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "cast")
}

func TestReadCommittedLogic_check_constraints(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "check_constraints")
}

func TestReadCommittedLogic_cluster_locks(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "cluster_locks")
}

func TestReadCommittedLogic_cluster_settings(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "cluster_settings")
}

func TestReadCommittedLogic_collatedstring(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "collatedstring")
}

func TestReadCommittedLogic_collatedstring_constraint(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "collatedstring_constraint")
}

func TestReadCommittedLogic_collatedstring_index1(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "collatedstring_index1")
}

func TestReadCommittedLogic_collatedstring_index2(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "collatedstring_index2")
}

func TestReadCommittedLogic_collatedstring_normalization(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "collatedstring_normalization")
}

func TestReadCommittedLogic_collatedstring_nullinindex(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "collatedstring_nullinindex")
}

func TestReadCommittedLogic_collatedstring_uniqueindex1(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "collatedstring_uniqueindex1")
}

func TestReadCommittedLogic_collatedstring_uniqueindex2(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "collatedstring_uniqueindex2")
}

func TestReadCommittedLogic_comment_on(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "comment_on")
}

func TestReadCommittedLogic_composite_types(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "composite_types")
}

func TestReadCommittedLogic_computed(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "computed")
}

func TestReadCommittedLogic_conditional(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "conditional")
}

func TestReadCommittedLogic_connect_privilege(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "connect_privilege")
}

func TestReadCommittedLogic_crdb_internal(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "crdb_internal")
}

func TestReadCommittedLogic_crdb_internal_catalog(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "crdb_internal_catalog")
}

func TestReadCommittedLogic_crdb_internal_default_privileges(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "crdb_internal_default_privileges")
}

func TestReadCommittedLogic_create_as(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "create_as")
}

func TestReadCommittedLogic_create_index(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "create_index")
}

func TestReadCommittedLogic_create_table(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "create_table")
}

func TestReadCommittedLogic_cross_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "cross_join")
}

func TestReadCommittedLogic_cursor(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "cursor")
}

func TestReadCommittedLogic_custom_escape_character(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "custom_escape_character")
}

func TestReadCommittedLogic_dangerous_statements(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "dangerous_statements")
}

func TestReadCommittedLogic_database(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "database")
}

func TestReadCommittedLogic_datetime(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "datetime")
}

func TestReadCommittedLogic_decimal(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "decimal")
}

func TestReadCommittedLogic_default(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "default")
}

func TestReadCommittedLogic_delete(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "delete")
}

func TestReadCommittedLogic_delete_batch(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "delete_batch")
}

func TestReadCommittedLogic_dependencies(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "dependencies")
}

func TestReadCommittedLogic_discard(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "discard")
}

func TestReadCommittedLogic_disjunction_in_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "disjunction_in_join")
}

func TestReadCommittedLogic_distinct(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "distinct")
}

func TestReadCommittedLogic_distinct_on(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "distinct_on")
}

func TestReadCommittedLogic_distsql_automatic_partial_stats(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "distsql_automatic_partial_stats")
}

func TestReadCommittedLogic_distsql_automatic_stats(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "distsql_automatic_stats")
}

func TestReadCommittedLogic_distsql_event_log(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "distsql_event_log")
}

func TestReadCommittedLogic_distsql_expr(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "distsql_expr")
}

func TestReadCommittedLogic_distsql_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "distsql_join")
}

func TestReadCommittedLogic_distsql_srfs(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "distsql_srfs")
}

func TestReadCommittedLogic_drop_database(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_database")
}

func TestReadCommittedLogic_drop_function(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_function")
}

func TestReadCommittedLogic_drop_index(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_index")
}

func TestReadCommittedLogic_drop_owned_by(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_owned_by")
}

func TestReadCommittedLogic_drop_procedure(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_procedure")
}

func TestReadCommittedLogic_drop_role_with_default_privileges(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_role_with_default_privileges")
}

func TestReadCommittedLogic_drop_role_with_default_privileges_in_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_role_with_default_privileges_in_schema")
}

func TestReadCommittedLogic_drop_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_schema")
}

func TestReadCommittedLogic_drop_sequence(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_sequence")
}

func TestReadCommittedLogic_drop_table(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_table")
}

func TestReadCommittedLogic_drop_temp(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_temp")
}

func TestReadCommittedLogic_drop_type(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_type")
}

func TestReadCommittedLogic_drop_user(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_user")
}

func TestReadCommittedLogic_drop_view(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "drop_view")
}

func TestReadCommittedLogic_edge(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "edge")
}

func TestReadCommittedLogic_enums(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "enums")
}

func TestReadCommittedLogic_errors(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "errors")
}

func TestReadCommittedLogic_event_log(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "event_log")
}

func TestReadCommittedLogic_exclude_data_from_backup(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "exclude_data_from_backup")
}

func TestReadCommittedLogic_experimental_distsql_planning(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "experimental_distsql_planning")
}

func TestReadCommittedLogic_explain_analyze(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "explain_analyze")
}

func TestReadCommittedLogic_export(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "export")
}

func TestReadCommittedLogic_expression_index(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "expression_index")
}

func TestReadCommittedLogic_external_connection_privileges(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "external_connection_privileges")
}

func TestReadCommittedLogic_family(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "family")
}

func TestReadCommittedLogic_fk(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "fk")
}

func TestReadCommittedLogic_float(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "float")
}

func TestReadCommittedLogic_format(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "format")
}

func TestReadCommittedLogic_function_lookup(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "function_lookup")
}

func TestReadCommittedLogic_fuzzystrmatch(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "fuzzystrmatch")
}

func TestReadCommittedLogic_geospatial(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "geospatial")
}

func TestReadCommittedLogic_geospatial_index(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "geospatial_index")
}

func TestReadCommittedLogic_geospatial_meta(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "geospatial_meta")
}

func TestReadCommittedLogic_geospatial_regression(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "geospatial_regression")
}

func TestReadCommittedLogic_geospatial_zm(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "geospatial_zm")
}

func TestReadCommittedLogic_grant_database(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "grant_database")
}

func TestReadCommittedLogic_grant_in_txn(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "grant_in_txn")
}

func TestReadCommittedLogic_grant_on_all_sequences_in_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "grant_on_all_sequences_in_schema")
}

func TestReadCommittedLogic_grant_on_all_tables_in_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "grant_on_all_tables_in_schema")
}

func TestReadCommittedLogic_grant_revoke_with_grant_option(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "grant_revoke_with_grant_option")
}

func TestReadCommittedLogic_grant_role(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "grant_role")
}

func TestReadCommittedLogic_grant_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "grant_schema")
}

func TestReadCommittedLogic_group_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "group_join")
}

func TestReadCommittedLogic_hash_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "hash_join")
}

func TestReadCommittedLogic_hash_sharded_index(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "hash_sharded_index")
}

func TestReadCommittedLogic_hidden_columns(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "hidden_columns")
}

func TestReadCommittedLogic_impure(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "impure")
}

func TestReadCommittedLogic_index_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "index_join")
}

func TestReadCommittedLogic_inet(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "inet")
}

func TestReadCommittedLogic_inflight_trace_spans(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "inflight_trace_spans")
}

func TestReadCommittedLogic_information_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "information_schema")
}

func TestReadCommittedLogic_inner_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "inner-join")
}

func TestReadCommittedLogic_insert(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "insert")
}

func TestReadCommittedLogic_int_size(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "int_size")
}

func TestReadCommittedLogic_internal_executor(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "internal_executor")
}

func TestReadCommittedLogic_interval(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "interval")
}

func TestReadCommittedLogic_inverted_filter_geospatial(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "inverted_filter_geospatial")
}

func TestReadCommittedLogic_inverted_filter_json_array(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "inverted_filter_json_array")
}

func TestReadCommittedLogic_inverted_index(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "inverted_index")
}

func TestReadCommittedLogic_inverted_index_multi_column(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "inverted_index_multi_column")
}

func TestReadCommittedLogic_inverted_join_geospatial(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "inverted_join_geospatial")
}

func TestReadCommittedLogic_inverted_join_json_array(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "inverted_join_json_array")
}

func TestReadCommittedLogic_inverted_join_multi_column(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "inverted_join_multi_column")
}

func TestReadCommittedLogic_jobs(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "jobs")
}

func TestReadCommittedLogic_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "join")
}

func TestReadCommittedLogic_json(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "json")
}

func TestReadCommittedLogic_json_builtins(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "json_builtins")
}

func TestReadCommittedLogic_json_index(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "json_index")
}

func TestReadCommittedLogic_kv_builtin_functions(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "kv_builtin_functions")
}

func TestReadCommittedLogic_limit(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "limit")
}

func TestReadCommittedLogic_locality(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "locality")
}

func TestReadCommittedLogic_lock_timeout(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "lock_timeout")
}

func TestReadCommittedLogic_lookup_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "lookup_join")
}

func TestReadCommittedLogic_lookup_join_spans(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "lookup_join_spans")
}

func TestReadCommittedLogic_manual_retry(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "manual_retry")
}

func TestReadCommittedLogic_materialized_view(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "materialized_view")
}

func TestReadCommittedLogic_merge_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "merge_join")
}

func TestReadCommittedLogic_multi_statement(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "multi_statement")
}

func TestReadCommittedLogic_name_escapes(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "name_escapes")
}

func TestReadCommittedLogic_namespace(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "namespace")
}

func TestReadCommittedLogic_new_schema_changer(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "new_schema_changer")
}

func TestReadCommittedLogic_no_primary_key(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "no_primary_key")
}

func TestReadCommittedLogic_notice(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "notice")
}

func TestReadCommittedLogic_numeric_references(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "numeric_references")
}

func TestReadCommittedLogic_on_update(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "on_update")
}

func TestReadCommittedLogic_operator(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "operator")
}

func TestReadCommittedLogic_optimizer_timeout(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "optimizer_timeout")
}

func TestReadCommittedLogic_order_by(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "order_by")
}

func TestReadCommittedLogic_ordinal_references(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "ordinal_references")
}

func TestReadCommittedLogic_ordinality(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "ordinality")
}

func TestReadCommittedLogic_overflow(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "overflow")
}

func TestReadCommittedLogic_overlaps(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "overlaps")
}

func TestReadCommittedLogic_owner(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "owner")
}

func TestReadCommittedLogic_parallel_stmts_compat(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "parallel_stmts_compat")
}

func TestReadCommittedLogic_partial_index(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "partial_index")
}

func TestReadCommittedLogic_partial_txn_commit(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "partial_txn_commit")
}

func TestReadCommittedLogic_pg_builtins(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "pg_builtins")
}

func TestReadCommittedLogic_pg_catalog_pg_default_acl(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "pg_catalog_pg_default_acl")
}

func TestReadCommittedLogic_pg_catalog_pg_default_acl_with_grant_option(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "pg_catalog_pg_default_acl_with_grant_option")
}

func TestReadCommittedLogic_pg_extension(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "pg_extension")
}

func TestReadCommittedLogic_pg_lsn(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "pg_lsn")
}

func TestReadCommittedLogic_pgcrypto_builtins(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "pgcrypto_builtins")
}

func TestReadCommittedLogic_pgoidtype(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "pgoidtype")
}

func TestReadCommittedLogic_plpgsql_builtins(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "plpgsql_builtins")
}

func TestReadCommittedLogic_poison_after_push(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "poison_after_push")
}

func TestReadCommittedLogic_postgres_jsonb(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "postgres_jsonb")
}

func TestReadCommittedLogic_postgresjoin(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "postgresjoin")
}

func TestReadCommittedLogic_privilege_builtins(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "privilege_builtins")
}

func TestReadCommittedLogic_privileges_comments(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "privileges_comments")
}

func TestReadCommittedLogic_privileges_table(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "privileges_table")
}

func TestReadCommittedLogic_proc_invokes_proc(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "proc_invokes_proc")
}

func TestReadCommittedLogic_procedure(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "procedure")
}

func TestReadCommittedLogic_procedure_cte(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "procedure_cte")
}

func TestReadCommittedLogic_procedure_deps(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "procedure_deps")
}

func TestReadCommittedLogic_procedure_params(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "procedure_params")
}

func TestReadCommittedLogic_procedure_polymorphic(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "procedure_polymorphic")
}

func TestReadCommittedLogic_procedure_privileges(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "procedure_privileges")
}

func TestReadCommittedLogic_procedure_schema_change(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "procedure_schema_change")
}

func TestReadCommittedLogic_propagate_input_ordering(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "propagate_input_ordering")
}

func TestReadCommittedLogic_reassign_owned_by(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "reassign_owned_by")
}

func TestReadCommittedLogic_record(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "record")
}

func TestReadCommittedLogic_redact_descriptor(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "redact_descriptor")
}

func TestReadCommittedLogic_rename_atomic(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "rename_atomic")
}

func TestReadCommittedLogic_rename_column(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "rename_column")
}

func TestReadCommittedLogic_rename_constraint(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "rename_constraint")
}

func TestReadCommittedLogic_rename_database(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "rename_database")
}

func TestReadCommittedLogic_rename_index(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "rename_index")
}

func TestReadCommittedLogic_rename_sequence(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "rename_sequence")
}

func TestReadCommittedLogic_rename_table(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "rename_table")
}

func TestReadCommittedLogic_rename_view(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "rename_view")
}

func TestReadCommittedLogic_reset(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "reset")
}

func TestReadCommittedLogic_retry(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "retry")
}

func TestReadCommittedLogic_returning(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "returning")
}

func TestReadCommittedLogic_routine_schema_change(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "routine_schema_change")
}

func TestReadCommittedLogic_row_level_ttl(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "row_level_ttl")
}

func TestReadCommittedLogic_rows_from(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "rows_from")
}

func TestReadCommittedLogic_run_control(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "run_control")
}

func TestReadCommittedLogic_save_table(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "save_table")
}

func TestReadCommittedLogic_savepoints(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "savepoints")
}

func TestReadCommittedLogic_scale(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "scale")
}

func TestReadCommittedLogic_scatter(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "scatter")
}

func TestReadCommittedLogic_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "schema")
}

func TestReadCommittedLogic_schema_change_feature_flags(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "schema_change_feature_flags")
}

func TestReadCommittedLogic_schema_change_in_txn(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "schema_change_in_txn")
}

func TestReadCommittedLogic_schema_change_logical_replication(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "schema_change_logical_replication")
}

func TestReadCommittedLogic_schema_change_retry(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "schema_change_retry")
}

func TestReadCommittedLogic_schema_locked(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "schema_locked")
}

func TestReadCommittedLogic_schema_repair(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "schema_repair")
}

func TestReadCommittedLogic_scrub(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "scrub")
}

func TestReadCommittedLogic_secondary_index_column_families(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "secondary_index_column_families")
}

func TestReadCommittedLogic_select(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "select")
}

func TestReadCommittedLogic_select_for_share(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "select_for_share")
}

func TestReadCommittedLogic_select_index(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "select_index")
}

func TestReadCommittedLogic_select_index_flags(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "select_index_flags")
}

func TestReadCommittedLogic_select_search_path(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "select_search_path")
}

func TestReadCommittedLogic_select_table_alias(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "select_table_alias")
}

func TestReadCommittedLogic_sequences(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "sequences")
}

func TestReadCommittedLogic_sequences_distsql(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "sequences_distsql")
}

func TestReadCommittedLogic_sequences_regclass(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "sequences_regclass")
}

func TestReadCommittedLogic_serial(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "serial")
}

func TestReadCommittedLogic_serializable_eager_restart(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "serializable_eager_restart")
}

func TestReadCommittedLogic_set_local(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "set_local")
}

func TestReadCommittedLogic_set_role(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "set_role")
}

func TestReadCommittedLogic_set_schema(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "set_schema")
}

func TestReadCommittedLogic_set_time_zone(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "set_time_zone")
}

func TestReadCommittedLogic_shift(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "shift")
}

func TestReadCommittedLogic_show_commit_timestamp(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_commit_timestamp")
}

func TestReadCommittedLogic_show_completions(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_completions")
}

func TestReadCommittedLogic_show_create(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_create")
}

func TestReadCommittedLogic_show_create_all_schemas(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_create_all_schemas")
}

func TestReadCommittedLogic_show_create_all_tables(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_create_all_tables")
}

func TestReadCommittedLogic_show_create_all_tables_builtin(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_create_all_tables_builtin")
}

func TestReadCommittedLogic_show_create_all_types(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_create_all_types")
}

func TestReadCommittedLogic_show_create_redact(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_create_redact")
}

func TestReadCommittedLogic_show_default_privileges(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_default_privileges")
}

func TestReadCommittedLogic_show_external_connections(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_external_connections")
}

func TestReadCommittedLogic_show_fingerprints(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_fingerprints")
}

func TestReadCommittedLogic_show_grants_on_virtual_table(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_grants_on_virtual_table")
}

func TestReadCommittedLogic_show_grants_synthetic(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_grants_synthetic")
}

func TestReadCommittedLogic_show_indexes(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_indexes")
}

func TestReadCommittedLogic_show_transfer_state(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_transfer_state")
}

func TestReadCommittedLogic_show_var(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "show_var")
}

func TestReadCommittedLogic_span_builtins(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "span_builtins")
}

func TestReadCommittedLogic_split_at(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "split_at")
}

func TestReadCommittedLogic_sqllite(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "sqllite")
}

func TestReadCommittedLogic_sqlliveness(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "sqlliveness")
}

func TestReadCommittedLogic_sqlsmith(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "sqlsmith")
}

func TestReadCommittedLogic_srfs(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "srfs")
}

func TestReadCommittedLogic_statement_source(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "statement_source")
}

func TestReadCommittedLogic_statement_statistics_errors(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "statement_statistics_errors")
}

func TestReadCommittedLogic_statement_statistics_errors_redacted(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "statement_statistics_errors_redacted")
}

func TestReadCommittedLogic_stats(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "stats")
}

func TestReadCommittedLogic_storing(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "storing")
}

func TestReadCommittedLogic_strict_ddl_atomicity(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "strict_ddl_atomicity")
}

func TestReadCommittedLogic_suboperators(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "suboperators")
}

func TestReadCommittedLogic_subquery(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "subquery")
}

func TestReadCommittedLogic_subquery_correlated(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "subquery_correlated")
}

func TestReadCommittedLogic_synthetic_privileges(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "synthetic_privileges")
}

func TestReadCommittedLogic_system(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "system")
}

func TestReadCommittedLogic_system_columns(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "system_columns")
}

func TestReadCommittedLogic_system_namespace(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "system_namespace")
}

func TestReadCommittedLogic_table(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "table")
}

func TestReadCommittedLogic_target_names(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "target_names")
}

func TestReadCommittedLogic_temp_table(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "temp_table")
}

func TestReadCommittedLogic_temp_table_txn(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "temp_table_txn")
}

func TestReadCommittedLogic_tenant(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "tenant")
}

func TestReadCommittedLogic_time(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "time")
}

func TestReadCommittedLogic_timestamp(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "timestamp")
}

func TestReadCommittedLogic_timetz(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "timetz")
}

func TestReadCommittedLogic_trigram_builtins(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "trigram_builtins")
}

func TestReadCommittedLogic_trigram_indexes(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "trigram_indexes")
}

func TestReadCommittedLogic_truncate(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "truncate")
}

func TestReadCommittedLogic_truncate_with_concurrent_mutation(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "truncate_with_concurrent_mutation")
}

func TestReadCommittedLogic_tsvector(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "tsvector")
}

func TestReadCommittedLogic_tuple(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "tuple")
}

func TestReadCommittedLogic_tuple_local(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "tuple_local")
}

func TestReadCommittedLogic_two_phase_commit(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "two_phase_commit")
}

func TestReadCommittedLogic_txn(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "txn")
}

func TestReadCommittedLogic_txn_as_of(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "txn_as_of")
}

func TestReadCommittedLogic_txn_retry(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "txn_retry")
}

func TestReadCommittedLogic_txn_stats(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "txn_stats")
}

func TestReadCommittedLogic_type_privileges(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "type_privileges")
}

func TestReadCommittedLogic_typing(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "typing")
}

func TestReadCommittedLogic_udf(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf")
}

func TestReadCommittedLogic_udf_calling_udf(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_calling_udf")
}

func TestReadCommittedLogic_udf_cte(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_cte")
}

func TestReadCommittedLogic_udf_delete(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_delete")
}

func TestReadCommittedLogic_udf_deps(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_deps")
}

func TestReadCommittedLogic_udf_fk(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_fk")
}

func TestReadCommittedLogic_udf_in_column_defaults(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_in_column_defaults")
}

func TestReadCommittedLogic_udf_in_constraints(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_in_constraints")
}

func TestReadCommittedLogic_udf_insert(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_insert")
}

func TestReadCommittedLogic_udf_observability(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_observability")
}

func TestReadCommittedLogic_udf_oid_ref(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_oid_ref")
}

func TestReadCommittedLogic_udf_options(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_options")
}

func TestReadCommittedLogic_udf_params(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_params")
}

func TestReadCommittedLogic_udf_polymorphic(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_polymorphic")
}

func TestReadCommittedLogic_udf_prepare(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_prepare")
}

func TestReadCommittedLogic_udf_privileges(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_privileges")
}

func TestReadCommittedLogic_udf_privileges_mutations(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_privileges_mutations")
}

func TestReadCommittedLogic_udf_procedure_mix(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_procedure_mix")
}

func TestReadCommittedLogic_udf_record(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_record")
}

func TestReadCommittedLogic_udf_regressions(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_regressions")
}

func TestReadCommittedLogic_udf_rewrite(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_rewrite")
}

func TestReadCommittedLogic_udf_schema_change(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_schema_change")
}

func TestReadCommittedLogic_udf_security(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_security")
}

func TestReadCommittedLogic_udf_setof(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_setof")
}

func TestReadCommittedLogic_udf_star(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_star")
}

func TestReadCommittedLogic_udf_subquery(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_subquery")
}

func TestReadCommittedLogic_udf_unsupported(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_unsupported")
}

func TestReadCommittedLogic_udf_update(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_update")
}

func TestReadCommittedLogic_udf_upsert(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "udf_upsert")
}

func TestReadCommittedLogic_union(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "union")
}

func TestReadCommittedLogic_update(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "update")
}

func TestReadCommittedLogic_update_from(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "update_from")
}

func TestReadCommittedLogic_upsert(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "upsert")
}

func TestReadCommittedLogic_upsert_non_metamorphic(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "upsert_non_metamorphic")
}

func TestReadCommittedLogic_uuid(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "uuid")
}

func TestReadCommittedLogic_values(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "values")
}

func TestReadCommittedLogic_vectorize_agg(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "vectorize_agg")
}

func TestReadCommittedLogic_vectorize_overloads(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "vectorize_overloads")
}

func TestReadCommittedLogic_vectorize_shutdown(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "vectorize_shutdown")
}

func TestReadCommittedLogic_vectorize_types(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "vectorize_types")
}

func TestReadCommittedLogic_vectorize_unsupported(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "vectorize_unsupported")
}

func TestReadCommittedLogic_views(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "views")
}

func TestReadCommittedLogic_virtual_columns(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "virtual_columns")
}

func TestReadCommittedLogic_virtual_table_privileges(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "virtual_table_privileges")
}

func TestReadCommittedLogic_void(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "void")
}

func TestReadCommittedLogic_where(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "where")
}

func TestReadCommittedLogic_window(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "window")
}

func TestReadCommittedLogic_with(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "with")
}

func TestReadCommittedLogic_workload_indexrecs(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "workload_indexrecs")
}

func TestReadCommittedLogic_zero(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "zero")
}

func TestReadCommittedLogic_zigzag_join(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "zigzag_join")
}

func TestReadCommittedLogic_zone_config(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "zone_config")
}

func TestReadCommittedLogic_zone_config_system_tenant(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runLogicTest(t, "zone_config_system_tenant")
}

func TestReadCommittedLogicCCL_fips_ready(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "fips_ready")
}

func TestReadCommittedLogicCCL_fk_read_committed(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "fk_read_committed")
}

func TestReadCommittedLogicCCL_hash_sharded_index_read_committed(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "hash_sharded_index_read_committed")
}

func TestReadCommittedLogicCCL_nested_routines(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "nested_routines")
}

func TestReadCommittedLogicCCL_new_schema_changer(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "new_schema_changer")
}

func TestReadCommittedLogicCCL_partitioning_enum(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "partitioning_enum")
}

func TestReadCommittedLogicCCL_pgcrypto_builtins(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "pgcrypto_builtins")
}

func TestReadCommittedLogicCCL_plpgsql_assign(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "plpgsql_assign")
}

func TestReadCommittedLogicCCL_plpgsql_block(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "plpgsql_block")
}

func TestReadCommittedLogicCCL_plpgsql_call(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "plpgsql_call")
}

func TestReadCommittedLogicCCL_plpgsql_cte(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "plpgsql_cte")
}

func TestReadCommittedLogicCCL_plpgsql_cursor(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "plpgsql_cursor")
}

func TestReadCommittedLogicCCL_plpgsql_into(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "plpgsql_into")
}

func TestReadCommittedLogicCCL_plpgsql_record(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "plpgsql_record")
}

func TestReadCommittedLogicCCL_plpgsql_txn(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "plpgsql_txn")
}

func TestReadCommittedLogicCCL_plpgsql_unsupported(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "plpgsql_unsupported")
}

func TestReadCommittedLogicCCL_procedure_params(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "procedure_params")
}

func TestReadCommittedLogicCCL_procedure_plpgsql(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "procedure_plpgsql")
}

func TestReadCommittedLogicCCL_read_committed(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "read_committed")
}

func TestReadCommittedLogicCCL_redact_descriptor(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "redact_descriptor")
}

func TestReadCommittedLogicCCL_refcursor(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "refcursor")
}

func TestReadCommittedLogicCCL_schema_change_in_txn(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "schema_change_in_txn")
}

func TestReadCommittedLogicCCL_select_for_update_read_committed(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "select_for_update_read_committed")
}

func TestReadCommittedLogicCCL_show_create(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "show_create")
}

func TestReadCommittedLogicCCL_subject(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "subject")
}

func TestReadCommittedLogicCCL_triggers(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "triggers")
}

func TestReadCommittedLogicCCL_udf_params(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "udf_params")
}

func TestReadCommittedLogicCCL_udf_plpgsql(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "udf_plpgsql")
}

func TestReadCommittedLogicCCL_udf_rewrite(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "udf_rewrite")
}

func TestReadCommittedLogicCCL_udf_volatility_check(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "udf_volatility_check")
}

func TestReadCommittedLogicCCL_unique_read_committed(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "unique_read_committed")
}

func TestReadCommittedLogicCCL_vector(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runCCLLogicTest(t, "vector")
}

func TestReadCommittedExecBuild_explain_analyze_read_committed(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runExecBuildLogicTest(t, "explain_analyze_read_committed")
}

func TestReadCommittedExecBuild_fk_read_committed(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runExecBuildLogicTest(t, "fk_read_committed")
}

func TestReadCommittedExecBuild_geospatial(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runExecBuildLogicTest(t, "geospatial")
}

func TestReadCommittedExecBuild_select_for_update_read_committed(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runExecBuildLogicTest(t, "select_for_update_read_committed")
}

func TestReadCommittedExecBuild_unique_read_committed(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runExecBuildLogicTest(t, "unique_read_committed")
}

func TestReadCommittedExecBuild_update_read_committed(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runExecBuildLogicTest(t, "update_read_committed")
}

func TestReadCommittedExecBuild_upsert_read_committed(
	t *testing.T,
) {
	defer leaktest.AfterTest(t)()
	runExecBuildLogicTest(t, "upsert_read_committed")
}
