// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package schemafeed

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[tableEventUnknown-0]
	_ = x[tableEventAddColumnNoBackfill-1]
	_ = x[tableEventAddColumnWithBackfill-2]
	_ = x[tableEventDropColumn-3]
	_ = x[tableEventTruncate-4]
	_ = x[tableEventPrimaryKeyChange-5]
	_ = x[tableEventLocalityRegionalByRowChange-6]
	_ = x[tableEventAddHiddenColumn-7]
}

func (i tableEventType) String() string {
	switch i {
	case tableEventUnknown:
		return "Unknown"
	case tableEventAddColumnNoBackfill:
		return "AddColumnNoBackfill"
	case tableEventAddColumnWithBackfill:
		return "AddColumnWithBackfill"
	case tableEventDropColumn:
		return "DropColumn"
	case tableEventTruncate:
		return "Truncate"
	case tableEventPrimaryKeyChange:
		return "PrimaryKeyChange"
	case tableEventLocalityRegionalByRowChange:
		return "LocalityRegionalByRowChange"
	case tableEventAddHiddenColumn:
		return "AddHiddenColumn"
	default:
		return "tableEventType(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
