// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package backup

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[unknownScope-0]
	_ = x[tableScope-1]
	_ = x[schemaScope-2]
	_ = x[databaseScope-3]
	_ = x[clusterScope-4]
}

func (i targetScope) String() string {
	switch i {
	case unknownScope:
		return "unknown"
	case tableScope:
		return "table"
	case schemaScope:
		return "schema"
	case databaseScope:
		return "database"
	case clusterScope:
		return "cluster"
	default:
		return "targetScope(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
