This directory contains patches that are applied to third-party code
(dependencies) before the Bazel build runs. The files here are named such that
the patch `foo.patch` will be applied to the repo `@foo`.

If you add a new patch to a Go dependency here, running `dev generate bazel`
will add the patches to `DEPS.bazel`. For non-Go dependencies, you'll have to
manually add the patches to the appropriate repo in `WORKSPACE`.

Generally speaking, the patches here "fix" `BUILD` files, which were either
originally present in the repo, or which will be generated by Gazelle. A couple
examples:

* `com_github_cockroachdb_pebble.patch` adds the file
  `internal/buildtags/invariants_on.go` to the `go_library` for the `invariants`
  package -- otherwise, Gazelle omits, causing builds to fail if you pass
  the `invariants` build tag.
* `com_github_gogo_protobuf.patch` adds a rule, `gogo_proto`, so that we can
  import `gogoproto/gogo.proto` in our own `.proto` files, while not updating
  the existing `gogoproto` rule that uses the pre-generated `.pb.go` file.
* `com_github_grpc_ecosystem_grpc_gateway.patch` replaces some dependencies that
  Gazelle infers (those under `@io_bazel_rules_go//proto/wkt`) with the build
  targets using pre-generated `.pb.go` files under
  `@com_github_golang_protobuf//ptypes`. We do this because the `wkt` rules
  create conflicts in our build.

The `build/scripts` directory contains scripts that can help with development of
patches:
* `patch-prepare-repo.sh` generates WORKSPACE and BUILD.bazel files for the
  dependency;
* `patch-apply.sh` applies a patch on a prepared repo;
* `patch-gen.sh` extracts a patch from a prepared repo.

