## CockroachDB Projects

Suitable for | Project |  Resources
-------------|---------|------------
For new developers | [Create a to-do app using CockroachDB and a language/ORM of your choice](https://github.com/cockroachdb/cockroachdb-todo-apps) | [How to contribute to the to-do apps repository](https://github.com/cockroachdb/cockroachdb-todo-apps#how-to-contribute-to-this-repository)
For Go developers | Work on CockroachDB code: [List of good first issues](https://github.com/cockroachdb/cockroach/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22) | [Your first CockroachDB PR](https://wiki.crdb.io/wiki/spaces/CRDB/pages/181633464/Your+first+CockroachDB+PR)
For Kubernetes enthusiasts | Work on the Kubernetes Operator: [List of good first issues](https://github.com/cockroachdb/cockroach-operator/labels/good%20first%20issue) | [Your first CockroachDB PR](https://wiki.crdb.io/wiki/spaces/CRDB/pages/181633464/Your+first+CockroachDB+PR)
For tech writers and docs enthusiasts | Help improve CockroachDB docs: [List of good first issues](https://github.com/cockroachdb/docs/issues?q=is%3Aopen+is%3Aissue+label%3Agood-first-issue) | [Docs contribution guide](https://github.com/cockroachdb/docs/wiki#using-github-desktop)

## Contributor Guidelines

Our contributor guidelines are available on [the public wiki at **wiki.crdb.io**](https://wiki.crdb.io/wiki/spaces/CRDB/pages/73204033/Contributing+to+CockroachDB).

At this location, we share our team guidelines and knowledge base
regarding:

- repository layout
- how to build from source
- how to organize your code change
- commenting guidelines
- commit message guidelines
- code style guidelines
- how to write and run tests
- how to write release notes
- how to submit a change for review
- how to use continuous integration (CI)
- how to troubleshoot certain issues

as well as many other practical topics.

## Don’t Forget to Join our Community
Join our [Community Slack](https://go.crdb.dev/p/slack) (there's a dedicated #contributors channel!) to ask questions, discuss your ideas, or connect with other contributors.

Please follow the guidelines outlined in our [Code of Conduct](https://docs.google.com/document/d/1_BB3IrsAVglDNPy37Z6KQlii_c3fYETFlWMMBUpbY1M/edit#) to help us make the CockroachDB community a welcoming and helpful place for everyone.

## Code of Conduct

As a contributor, you can help us keep our community open and
inclusive. Please read and follow our [Code of
Conduct](https://github.com/cockroachdb/code-of-conduct).
