{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnPasCodeDoc;
{* |<PRE>
================================================================================
* ƣCnPack Ԫ
* Ԫƣ CnPack ĴгȡעγĵĹߵԪ
* ԪߣCnPack  (master@cnpack.org)
*     ע
* ƽ̨PWin7 + Delphi 5
* ݲԣ
*   õԪеַϱػʽ
* ޸ļ¼2022.04.02 V1.0
*               Ԫʵֹ
================================================================================
|</PRE>}

{$I CnPack.inc}

interface

uses
  Classes, SysUtils, Contnrs, CnPascalAst;

type
  ECnPasCodeDocException = class(Exception);
  {* ĵ쳣}

  TCnDocType = (dtUnit, dtConst, dtType, dtProcedure, dtVar, dtField, dtProperty);
  {* ֧ĵԪ}

  TCnDocScope = (dsNone, dsPrivate, dsProtected, dsPublic, dsPublished);
  {* ԪصĿɼԣ޿ɼԵΪ dsNone}

  TCnScanProcDeclEvent = procedure (ProcLeaf: TCnPasAstLeaf; Visibility: TCnDocScope;
    const CurrentTypeName: string) of object;
  {* ɨ Pascal ԴļʱʱĻص ProcLeaf µĽṹ£

    function  ProcLeaf
      <FunctionName>
      FormalParameters
        (
          FormalParam
            IdentList
              A
              ,
              B
            :
            CommonType
              TypeID
                Int64
          ;
          FormalParam
            ...
          FormalParam
            ...
        )
      :
      COMMONTYPE
        TypeID
          Boolean

     function ڵͬңԽ directive ȣҵһעͽڵעͿ
  }

  TCnDocBaseItem = class(TObject)
  {* ĵԪصĻ}
  private
    FItems: TObjectList;
    FDeclareName: string;
    FDeclareType: string;
    FComment: string;
    FOwner: TCnDocBaseItem;
    FScope: TCnDocScope;
    FDocType: TCnDocType;
    function GetItem(Index: Integer): TCnDocBaseItem;
    procedure SetItem(Index: Integer; const Value: TCnDocBaseItem);
    function GetCount: Integer;
  protected
    procedure Sort; virtual;
    {* ڲ}
  public
    constructor Create; virtual;
    destructor Destroy; override;

    function AddItem(Item: TCnDocBaseItem): Integer;
    {* һⲿѾõĵڲб}
    procedure Exchange(Index1, Index2: Integer);
    {* Ӷ}
    procedure Delete(Index: Integer);
    {* ɾӶ}
    function Extract(Item: TCnDocBaseItem): TCnDocBaseItem;
    {* бгӶ󣬵ͷ}

    procedure DumpToStrings(Strs: TStrings; Indent: Integer = 0);
    {* ݱ浽ַб}

    function GetScopeStr: string;
    {*  FScope Ӧַ}

    property DocType: TCnDocType read FDocType;
    {* ĵԪ}

    property DeclareName: string read FDeclareName write FDeclareName;
    {* ͵ĶƣͬвͬĹ涨}
    property DeclareType: string read FDeclareType write FDeclareType;
    {* ͵ĶͣͬҲвͬ;ڴ洢}
    property Comment: string read FComment write FComment;
    {* Ԫصעĵ}
    property Scope: TCnDocScope read FScope write FScope;
    {* ԪصĿɼ}
    property Owner: TCnDocBaseItem read FOwner write FOwner;
    {* ԪشһԪ}

    property Items[Index: Integer]: TCnDocBaseItem read GetItem write SetItem; default;
    {* ԪصԪб}
    property Count: Integer read GetCount;
    {* ԪصԪ}
  end;

  TCnDocUnit = class(TCnDocBaseItem)
  {* һĵеĵԪĶ}
  private
    FUnitBrief: string;
  protected
    procedure Sort; override;
    {* ̡}
  public
    constructor Create; override;
    {* 캯}

    procedure ParseBrief;
    {* עнԪ飬Լñעֶ滻 Comment }
    property UnitBrief: string read FUnitBrief write FUnitBrief;
    {* Ԫ飬ҲעͷĵԪֶ}
  end;

  TCnConstDocItem = class(TCnDocBaseItem)
  {* һĵеĳ}
  public
    constructor Create; override;
  end;

  TCnVarDocItem = class(TCnDocBaseItem)
  {* һĵеı}
  public
    constructor Create; override;
  end;

  TCnProcedureDocItem = class(TCnDocBaseItem)
  {* һĵеĺ̶}
  public
    constructor Create; override;
  end;

  TCnTypeDocItem = class(TCnDocBaseItem)
  {* һĵеͶ}
  public
    constructor Create; override;
  end;

  TCnPropertyDocItem = class(TCnDocBaseItem)
  {* һĵеԶ}
  public
    constructor Create; override;
  end;

  TCnFieldDocItem = class(TCnDocBaseItem)
  {* һĵеֶζ}
  public
    constructor Create; override;
  end;

function CnCreateUnitDocFromFileName(const FileName: string): TCnDocUnit;
{* ԴļڲĴעͣ´ĵԪעͶ}

procedure CnScanFileProcDecls(const FileName: string; OnScan: TCnScanProcDeclEvent);
{* ɨ Pascal Դļеḷ́ļеģûص procedure  Leaf Զ崦
  Ŀǰ

һ
  interface
    type
      TYPEDECL 
        TypeName
        =
        RESTRICTTYPE
          class
            CLASSBODY
              CLASSHERITAGE
              public
                procedure/function/constructor/destructor -- 


  interface
    function                                              -- 
    procedure                                             -- 
}

function CnGetCommentLeafFromProcedure(ProcLeaf: TCnPasAstLeaf;
  Last: Boolean = True): TCnPasAstLeaf;
{* ĵ淶ȡ function/procedure ؼֽڵصһע͵Ľڵ
  ڲʵͬԽֺšdirectivesָһעͿһעͿ
  ⲿһעͿǷǵҴжϸעͿǷϹ淶
  úעͣȷδ}

implementation

uses
  mPasLex;

resourcestring
  SCnErrorSkipCommentToNode = 'Skip Comment To Node Error.';
  SCnErrorNoConstSemicolonExists = 'NO Const Semicolon Exists.';
  SCnErrorNoVarSemicolonExists = 'NO Var Semicolon Exists.';
  SCnErrorNoProcedureFunctionIdentExists = 'NO Procedure/Function Ident Exists.';
  SCnErrorNoProcedureFunctionSemicolonExists = 'NO Procedure/Function Semicolon Exists.';
  SCnErrorNoPropertyIdentExists = 'NO Property Ident Exists.';
  SCnErrorNoPropertySemicolonExists = 'NO Property Semicolon Exists.';
  SCnErrorNoClassFieldIdentExists = 'NO Class Field Ident Exists.';
  SCnErrorNoClassFieldSemicolonExists = 'NO Class Field Semicolon Exists.';
  SCnErrorNoClassInterfaceSemicolonExists = 'NO Class/Interface SemiColon Exists.';
  SCnErrorNoTypeSemicolonExists = 'NO Type Semicolon Exists.';
  SCnErrorNoUnitExists = 'NO Unit Exists.';
  SCnErrorNoUnitSemicolonExists = 'NO Unit Semicolon Exists.';
  SCnErrorNoInterfacesectionPartExists = 'NO InterfaceSection Part Exists.';
  SCnBrBr = '<br><br>';

const
  COMMENT_NODE_TYPE = [cntBlockComment, cntCRLFInComment];
  COMMENT_SKIP_NODE_TYPE = [cntBlockComment, cntLineComment, cntCRLFInComment];
  COMMENT_NONE = '<none>';

  SCOPE_STRS: array[TCnDocScope] of string =
    ('', 'private', 'protected', 'public', 'published');

function VisibilityTokenKindToDocScope(Token: TTokenKind): TCnDocScope;
begin
  case Token of
    tkPrivate:   Result := dsPrivate;
    tkProtected: Result := dsProtected;
    tkPublic:    Result := dsPublic;
    tkPublished: Result := dsPublished;
  else
    Result := dsNone;
  end;
end;

//  ParentLeaf ĵ 0 ӽڵ㿪ʼԽעҷϵĽڵ㣬طϵĽڵ㣬׳쳣ҷ nil
function DocSkipCommentToChild(ParentLeaf: TCnPasAstLeaf;
  MatchedNodeTypes: TCnPasNodeTypes; NeedRaise: Boolean = True): TCnPasAstLeaf;
var
  I: Integer;
begin
  Result := nil;
  for I := 0 to ParentLeaf.Count - 1 do
  begin
    if ParentLeaf[I].NodeType in MatchedNodeTypes then
    begin
      Result := ParentLeaf[I];
      Exit;
    end;

    if not (ParentLeaf[I].NodeType in COMMENT_SKIP_NODE_TYPE) then
      if NeedRaise then
        raise ECnPasCodeDocException.Create(SCnErrorSkipCommentToNode);
  end;
end;

//  ParentLeaf ĵ Index ӽڵ㿪ʼҷϵĽڵ㣬طϵĽڵԼº Index򷵻 nilIndex Ჽ
function DocSkipToChild(ParentLeaf: TCnPasAstLeaf; var Index: Integer;
  MatchedNodeTypes: TCnPasNodeTypes; MatchedTokenKinds: TTokenKinds): TCnPasAstLeaf;
begin
  Result := nil;
  if Index >= ParentLeaf.Count then
    Exit;

  while Index < ParentLeaf.Count do
  begin
    if (ParentLeaf[Index].NodeType in MatchedNodeTypes) and
      (ParentLeaf[Index].TokenKind in MatchedTokenKinds) then
    begin
      Result := ParentLeaf[Index];
      Exit;
    end;
    Inc(Index);
  end;
end;

//  ParentLeaf ĵ Index ӽڵǷֺŻ Directiveֱ Directive ҷǷֺŵĵطٻһ
// ʱ Index Ӧָ Directive ֮ǰķֺ
procedure DocSkipDirective(ParentLeaf: TCnPasAstLeaf; var Index: Integer);
begin
  Inc(Index);
  while Index < ParentLeaf.Count do
  begin
    if not (ParentLeaf[Index].NodeType in [cntCompDirective, cntSemiColon, cntDirective, cntDefault]) then
      Break;    // ܻ cntDirective еĹؼֻ IFDEF ȱָ

    Inc(Index);
  end;
  Dec(Index);
end;

//  ParentLeaf ĵ Index ӽڵռעͲƴһ顣
//  Index עʹ Index Ჽһעʹ Index һ
function DocCollectComments(ParentLeaf: TCnPasAstLeaf; var Index: Integer): string;
var
  S: string;
  SL: TStrings;
  PrevType: TCnPasNodeType;
begin
  if (Index < ParentLeaf.Count) and (ParentLeaf[Index].NodeType in COMMENT_NODE_TYPE) then
  begin
    S := ParentLeaf[Index].Text;
    if (Length(S) > 2) and (S[1] = '{') and (S[2] = '*') then
    begin
      // ʾзҪעͣӵһ
      SL := TStringList.Create;
      try
        PrevType := cntInvalid;
        repeat
          if (PrevType = cntCRLFInComment) and (ParentLeaf[Index].NodeType = cntCRLFInComment) then // ǿעͺĻУһҲǣһ
            SL.Add('')
          else if ParentLeaf[Index].NodeType <> cntCRLFInComment then //  cntCRLFInComment ӿҲӻسб
            SL.Add(ParentLeaf[Index].Text);

          PrevType := ParentLeaf[Index].NodeType;
          Inc(Index);
        until (Index >= ParentLeaf.Count) or not (ParentLeaf[Index].NodeType in COMMENT_NODE_TYPE);
        Dec(Index); // صһעʹ

        Result := Trim(SL.Text);
        Exit;
      finally
        SL.Free;
      end;
    end;
  end;

  Result := '';
  if Index > 0 then
    Dec(Index);
end;

//  const ڵ㣬ӽڵһУCONSTDECLӽڵƣֺšעͿ
procedure DocFindConsts(ParentLeaf: TCnPasAstLeaf; OwnerItem: TCnDocBaseItem);
var
  K: Integer;
  Leaf: TCnPasAstLeaf;
  Item: TCnConstDocItem;
begin
  K := 0;
  while K < ParentLeaf.Count do
  begin
    Leaf := DocSkipToChild(ParentLeaf, K, [cntConstDecl], [tkNone]);
    if Leaf = nil then
    begin
      Inc(K);
      Continue;
    end;
    //  raise ECnPasCodeDocException.Create('NO Const Decl Exists.');

    Item := TCnConstDocItem.Create;
    if Leaf.Count > 0 then
    begin
      Item.DeclareName := Leaf[0].Text; // 
      Item.DeclareType := Leaf.GetPascalCode; // óͺ
    end;

    Leaf := DocSkipToChild(ParentLeaf, K, [cntSemiColon], [tkSemiColon]);
    if Leaf = nil then
      raise ECnPasCodeDocException.Create(SCnErrorNoConstSemicolonExists);

    Inc(K); // һע͵ĵطעͣK ָעĩβǣK һԵ˴β
    Item.Comment := DocCollectComments(ParentLeaf, K);
    OwnerItem.AddItem(Item);
    Inc(K);
  end;
end;

// var ӽڵһУVARDECLӽڵƣֺšעͿ
procedure DocFindVars(ParentLeaf: TCnPasAstLeaf; OwnerItem: TCnDocBaseItem);
var
  K: Integer;
  Leaf: TCnPasAstLeaf;
  Item: TCnVarDocItem;
begin
  K := 0;
  while K < ParentLeaf.Count do
  begin
    Leaf := DocSkipToChild(ParentLeaf, K, [cntVarDecl], [tkNone]);
    if Leaf = nil then
    begin
      Inc(K);
      Continue;
    end;
    // raise ECnPasCodeDocException.Create('NO Var Decl Exists.');

    Item := TCnVarDocItem.Create;
    if Leaf.Count > 0 then
    begin
      if Leaf[0].Count > 0 then
        Item.DeclareName := Leaf[0][0].Text; // IDENTList ĵһ
      Item.DeclareType := Leaf.GetPascalCode; // 
    end;

    Leaf := DocSkipToChild(ParentLeaf, K, [cntSemiColon], [tkSemiColon]);
    if Leaf = nil then
      raise ECnPasCodeDocException.Create(SCnErrorNoVarSemicolonExists);

    Inc(K); // һע͵ĵطעͣK ָעĩβǣK һԵ˴β
    Item.Comment := DocCollectComments(ParentLeaf, K);
    OwnerItem.AddItem(Item);
    Inc(K);
  end;
end;

// ͬڵһ飺procedure/functionӽڵƣֺšעͿ
// ע ParentLeaf  procedure/function ڵ㣬Index Ǹýڵڸڵе
procedure DocFindProcedure(ParentLeaf: TCnPasAstLeaf; var Index: Integer;
  OwnerItem: TCnDocBaseItem; AScope: TCnDocScope = dsNone);
var
  K: Integer;
  Leaf, P: TCnPasAstLeaf;
  Item: TCnProcedureDocItem;
begin
  K := 0;
  Leaf := DocSkipToChild(ParentLeaf, K, [cntIdent], [tkIdentifier]);
  if Leaf = nil then
    raise ECnPasCodeDocException.Create(SCnErrorNoProcedureFunctionIdentExists);

  Item := TCnProcedureDocItem.Create;
  Item.DeclareName := Leaf.Text; // 
  Item.Scope := AScope;
  Item.DeclareType := ParentLeaf.GetPascalCode; // ȡ Directives

  // һȥҷֺע
  P := ParentLeaf.Parent;
  Leaf := DocSkipToChild(P, Index, [cntSemiColon], [tkSemiColon]);
  if Leaf = nil then
    raise ECnPasCodeDocException.Create(SCnErrorNoProcedureFunctionSemicolonExists);

  // ˴ܴڵ Directives һֺ
  DocSkipDirective(P, Index);

  Inc(Index); // һע͵ĵطעͣIndex ָעĩβǣIndex һԵ˴β
  Item.Comment := DocCollectComments(P, Index);
  OwnerItem.AddItem(Item);
end;

// һ propertyParentLeaf  Property ڵ㣬Index  ParentLeaf 丸ڵе
// Property ڵ沢зֺź default ȣӽڵ
procedure DocFindProperty(ParentLeaf: TCnPasAstLeaf; Index: Integer; OwnerItem: TCnDocBaseItem;
  AScope: TCnDocScope = dsNone);
var
  K: Integer;
  Leaf, P: TCnPasAstLeaf;
  Item: TCnPropertyDocItem;
begin
  K := 0;
  Leaf := DocSkipToChild(ParentLeaf, K, [cntIdent], [tkIdentifier]);
  if Leaf = nil then
    raise ECnPasCodeDocException.Create(SCnErrorNoPropertyIdentExists);

  Item := TCnPropertyDocItem.Create;
  Item.DeclareName := Leaf.Text;   // 
  Item.Scope := AScope;
  Item.DeclareType := ParentLeaf.GetPascalCode; // 

  // һȥҷֺע
  P := ParentLeaf.Parent;
  Leaf := DocSkipToChild(P, Index, [cntSemiColon], [tkSemiColon]);
  if Leaf = nil then
    raise ECnPasCodeDocException.Create(SCnErrorNoPropertySemicolonExists);

  // ˴ܴڵ Directives һֺ
  DocSkipDirective(P, Index);

  Inc(Index);
  Item.Comment := DocCollectComments(P, Index);
  OwnerItem.AddItem(Item);
end;

// ParentLeaf  Class ڵ ClassField ֶνڵ㣬ռ䵥 Field ע͡Index  ParentLeaf  Parent е
procedure DocFindField(ParentLeaf: TCnPasAstLeaf; Index: Integer; OwnerItem: TCnDocBaseItem; AScope: TCnDocScope = dsPublic);
var
  Leaf, P: TCnPasAstLeaf;
  Item: TCnFieldDocItem;
begin
  Leaf := nil;
  if (ParentLeaf.Count > 0) and (ParentLeaf[0].Count > 0) then
    Leaf := ParentLeaf[0][0];
  if (Leaf = nil) or (Leaf.NodeType <> cntIdent) then
    raise ECnPasCodeDocException.Create(SCnErrorNoClassFieldIdentExists);

  Item := TCnFieldDocItem.Create;
  Item.DeclareName := Leaf.Text; // ֶ
  Item.Scope := AScope;
  Item.DeclareType := ParentLeaf.GetPascalCode; // ֶ

  // һȥҷֺע
  P := ParentLeaf.Parent;
  Leaf := DocSkipToChild(P, Index, [cntSemiColon], [tkSemiColon]);
  if Leaf = nil then
    raise ECnPasCodeDocException.Create(SCnErrorNoClassFieldSemicolonExists);

  Inc(Index); // һע͵ĵطעͣIndex ָעĩβǣIndex һԵ˴β
  Item.Comment := DocCollectComments(P, Index);
  OwnerItem.AddItem(Item);
end;

// record ڵӽڵ㣬ռ Field ע
procedure DocFindRecordFields(ParentLeaf: TCnPasAstLeaf; OwnerItem: TCnDocBaseItem; AScope: TCnDocScope = dsPublic);
var
  K: Integer;
  Leaf: TCnPasAstLeaf;
begin
  if ParentLeaf.Count > 0 then
  begin
    ParentLeaf := DocSkipCommentToChild(ParentLeaf, [cntFieldList]); // record  FieldList

    K := 0;
    while K < ParentLeaf.Count do
    begin
      Leaf := ParentLeaf[K];
      if Leaf.NodeType = cntFieldDecl then
        DocFindField(Leaf, K, OwnerItem, AScope);
      Inc(K);
    end;
  end;
end;

//  interface  class ĳԱ/̡FieldԵȡParentLeaf  ClassBody  interface
procedure DocFindMembers(ParentLeaf: TCnPasAstLeaf; OwnerItem: TCnDocBaseItem; AScope: TCnDocScope = dsNone);
var
  K: Integer;
  Leaf: TCnPasAstLeaf;
  MyScope: TCnDocScope;
begin
  K := 0;
  while K < ParentLeaf.Count do
  begin
    Leaf := ParentLeaf[K];
    if Leaf.NodeType in [cntProcedure, cntFunction] then
    begin
      DocFindProcedure(Leaf, K, OwnerItem, AScope);
      Inc(K);
    end
    else if Leaf.NodeType = cntProperty then
    begin
      DocFindProperty(Leaf, K, OwnerItem, AScope);
      Inc(K);
    end
    else if Leaf.NodeType = cntClassField then
    begin
      DocFindField(Leaf, K, OwnerItem, AScope);
      Inc(K);
    end
    else if (Leaf.NodeType = cntVisibility) and (Leaf.TokenKind in [tkProtected, tkPublic, tkPublished]) then
    begin
      MyScope := VisibilityTokenKindToDocScope(Leaf.TokenKind);
      DocFindMembers(Leaf, OwnerItem, MyScope);
      Inc(K);
    end
    else
    begin
      Inc(K);
    end;
  end;
end;

// ݹãȱעʱֹڻȡעǰĲ
function InternalGetPascalCodeFromLeafUntilComment(ALeaf: TCnPasAstLeaf; var ToAbort: Boolean): string;
var
  I: Integer;
  S: string;
  Son: TTokenKind;
begin
  if ToAbort then
  begin
    Result := '';
    Exit;
  end;

  Result := ALeaf.Text;
  for I := 0 to ALeaf.Count - 1 do
  begin
    Son := ALeaf.Items[I].TokenKind;
    if Son in [tkBorComment, tkAnsiComment, tkSlashesComment] then
    begin
      ToAbort := True;
      Exit;
    end;

    S := InternalGetPascalCodeFromLeafUntilComment(ALeaf.Items[I], ToAbort);
    if Result = '' then
      Result := S
    else if S <> '' then
    begin
      if ALeaf.NoSpaceBehind or ALeaf.Items[I].NoSpaceBefore or    // ڵ治Ҫո񣬻ӽڵǰ治Ҫո
        (ALeaf.TokenKind in [tkRoundOpen, tkSquareOpen, tkPoint]) or       // ڵЩ治Ҫո
        (Son in [tkPoint, tkDotdot, tkPointerSymbol, tkSemiColon, tkColon, // ӽڵЩǰ治Ҫո
        tkRoundClose, tkSquareOpen, tkSquareClose, tkComma]) then
        Result := Result + S
      else
        Result := Result + ' ' + S;
    end;
  end;
end;

function GetPascalCodeFromLeafUntilComment(ALeaf: TCnPasAstLeaf): string;
var
  ToAbort: Boolean;
begin
  ToAbort := False;
  Result := InternalGetPascalCodeFromLeafUntilComment(ALeaf, ToAbort);
end;

// ȡӿעͣParentLeaf ָ߲ TYPEDECL
procedure DocGetClassIntfNameComments(ParentLeaf: TCnPasAstLeaf; IsClass: Boolean;
  var Comment: string; var FullType: string);
var
  I: Integer;
  Leaf, TmpLeaf: TCnPasAstLeaf;
begin
  //  end ģʽѰע
{
  Class ʽ      Class ʽ        Interface ʽ   Interface ʽ

  TYPEDECL              TYPEDECL                TYPEDECL               TYPEDECL
    Ident                 Ident                   Ident                  Ident
    =                     =                       =                      =
    RESTRICTEDTYPE        RESTRICTEDTYPE          RESTRICTEDTYPE         RESTRICTEDTYPE
      class                 class                   interface              interface
        ע                  CLASSBODY               ע                   INTERFACEHERITAGE
                                CLASSHERITAGE                                  (
                                  (                                            )
                                  )                                            ע
                                  ע
}

  Comment := '';
  FullType := GetPascalCodeFromLeafUntilComment(ParentLeaf);

  if ParentLeaf.Count > 2 then
  begin
    Leaf := ParentLeaf[2];
    if Leaf.Count > 0 then
    begin
      Leaf := Leaf[0]; // class/interface
      if (Leaf.Count > 0) and (Leaf[0].NodeType in COMMENT_NODE_TYPE) then
      begin
        I := 0;
        Comment := DocCollectComments(Leaf, I); // ʽĴ
      end
      else // ʽ
      begin
        if IsClass then
        begin
          if Leaf.Count > 0 then // class ǰʱû
          begin
            Leaf := Leaf[0]; // ClassBody
            if Leaf.Count > 0 then
              Leaf := Leaf[0]; // CLASSHERITAGE
          end;
        end
        else if Leaf.Count > 0 then // interface ǰʱû
        begin
          Leaf := Leaf[0]; // INTERFACEHERITAGE
        end;

        I := 0; // Ѱ
        TmpLeaf := DocSkipToChild(Leaf, I, [cntRoundClose], [tkRoundClose]);
        if TmpLeaf <> nil then //
        begin
          Inc(I);
          Comment := DocCollectComments(Leaf, I);
        end;
      end;
    end;
  end;

  if Comment <> '' then
    Exit;

  //  end ģʽֱѰע
  Leaf := ParentLeaf.Parent;
  I := ParentLeaf.Index;
  TmpLeaf := DocSkipToChild(Leaf, I, [cntSemiColon], [tkSemiColon]);
  if TmpLeaf = nil then
    raise ECnPasCodeDocException.Create(SCnErrorNoClassInterfaceSemicolonExists);

  Inc(I);
  Comment := DocCollectComments(Leaf, I);
end;

// ParentLeaf  typeӽڵһУTYPEDECLӽڵƣֺšеĵעͿ
procedure DocFindTypes(ParentLeaf: TCnPasAstLeaf; OwnerItem: TCnDocBaseItem);
var
  K, M: Integer;
  Leaf, DeclLeaf, CIRRoot, Tmp: TCnPasAstLeaf;
  Item: TCnTypeDocItem;
  IsIntf, IsClass, IsRecord: Boolean;
begin
  K := 0;
  while K < ParentLeaf.Count do
  begin
    Leaf := DocSkipToChild(ParentLeaf, K, [cntTypeDecl], [tkNone]);
    if Leaf = nil then // ûҵ˵β˿עˣ
    begin
      Inc(K);
      Continue;
    end;
    // raise ECnPasCodeDocException.Create('NO Type Decl Exists.');

    DeclLeaf := Leaf;
    Item := TCnTypeDocItem.Create;
    if Leaf.Count > 0 then
      Item.DeclareName := Leaf[0].Text; // 

    // ж Leaf ±Ϊ 2 ӽڵͣ RESTRICTEDTYPEʾ interfaceclassҪ⴦
    //  COMMMONTYPE ٺӽڵ packed record һ recordҲҪ⴦
    IsIntf := False;
    IsClass := False;
    IsRecord := False;
    CIRRoot := nil;

    if (Leaf.Count >= 2) and (Leaf[2].NodeType = cntRestrictedType) then
    begin
      if Leaf[2].Count > 0 then
      begin
        CIRRoot := Leaf[2][0];
        if CIRRoot.NodeType = cntInterfaceType then
          IsIntf := True
        else if CIRRoot.NodeType = cntClassType then
        begin
          IsClass := True;
          if CIRRoot.Count > 0 then
          begin
            Tmp := DocSkipCommentToChild(CIRRoot, [cntClassBody], False);
            if Tmp <> nil then
              CIRRoot := Tmp
            else
            begin
              //  nil ʾ class of xxxx ֣ƺҲɶ
            end;
          end;
        end;

        if IsIntf or IsClass then
          DocGetClassIntfNameComments(Leaf, IsClass, Item.FComment, Item.FDeclareType);
      end;
    end
    else if (Leaf.Count >= 2) and (Leaf[2].NodeType = cntCommonType) then
    begin
      Leaf := Leaf[2]; // Ҫж Leaf[2] ӽڵǷ record
      M := 0;
      Leaf := DocSkipToChild(Leaf, M, [cntRecord], [tkRecord]);
      if Leaf <> nil then
      begin
        IsRecord := True;
        CIRRoot := Leaf;
        M := 0;
        Item.Comment := DocCollectComments(Leaf, M);
        Item.DeclareType := GetPascalCodeFromLeafUntilComment(DeclLeaf); // Record ͵
      end;
    end;

    // ˴ӦжϺ IsIntf  IsClass ClassIntfRoot ָȽͨõһڵ
    if (CIRRoot <> nil) and (IsIntf or IsClass or IsRecord) then
    begin
      // CIRRoot ָȽͨõһڵ㣬ClassBody  interface  record
      // ݣ K ϵλ
      if IsIntf or IsClass then
      begin
        DocFindMembers(CIRRoot, Item);
        OwnerItem.AddItem(Item);
      end
      else
      begin
        DocFindRecordFields(CIRRoot, Item);
        OwnerItem.AddItem(Item);
      end;

      Leaf := DocSkipToChild(ParentLeaf, K, [cntSemiColon], [tkSemiColon]);
      if Leaf = nil then
        raise ECnPasCodeDocException.Create(SCnErrorNoTypeSemicolonExists);
      // ҷֺţûע
      Inc(K);
    end
    else // ͨ
    begin
      Leaf := DocSkipToChild(ParentLeaf, K, [cntSemiColon], [tkSemiColon]);
      if Leaf = nil then
        raise ECnPasCodeDocException.Create(SCnErrorNoTypeSemicolonExists);

      Item.DeclareType := DeclLeaf.GetPascalCode; // ͵

      Inc(K); // һע͵ĵطעͣK ָעĩβǣK һԵ˴β
      Item.Comment := DocCollectComments(ParentLeaf, K);
      OwnerItem.AddItem(Item);
      Inc(K);
    end;
  end;
end;

function CnCreateUnitDocFromFileName(const FileName: string): TCnDocUnit;
var
  AST: TCnPasAstGenerator;
  SL: TStrings;
  TempLeaf, UnitLeaf, IntfLeaf: TCnPasAstLeaf;
  I: Integer;
begin
  Result := nil;
  if not FileExists(FileName) then
    Exit;

  AST := nil;
  SL := nil;

  try
    SL := TStringList.Create;
    SL.LoadFromFile(FileName);

    AST := TCnPasAstGenerator.Create(SL.Text);
    AST.Build;

    // Root ֱ Unit ڵ㣬Unit ӽڵǷֺš֮֡עƴע͡
    // ֮ interface ڵ㡣 interface ڵΪڵֱֱ consttypevarprocedurefunction ֱڵ
    // ÿڵ㣬ӽڵ㲢ע͡
    UnitLeaf := nil;
    for I := 0 to AST.Tree.Root.Count - 1 do
    begin
      if (AST.Tree.Root.Items[I].NodeType = cntUnit) and (AST.Tree.Root.Items[I].TokenKind = tkUnit) then
      begin
        UnitLeaf := AST.Tree.Root.Items[I];
        Break;
      end;
    end;

    if UnitLeaf = nil then
      raise ECnPasCodeDocException.Create(SCnErrorNoUnitExists);

    Result := TCnDocUnit.Create;

    //  Unit 
    I := 0;
    TempLeaf := DocSkipToChild(UnitLeaf, I, [cntIdent], [tkIdentifier]);
    if TempLeaf <> nil then
      Result.DeclareName := TempLeaf.Text;

    // ҷֺ
    TempLeaf := DocSkipToChild(UnitLeaf, I, [cntSemiColon], [tkSemiColon]);
    if TempLeaf = nil then
      raise ECnPasCodeDocException.Create(SCnErrorNoUnitSemicolonExists);

    // ҷֺźһע
    Inc(I);
    Result.Comment := DocCollectComments(UnitLeaf, I);

    //  interface ڵ
    IntfLeaf := DocSkipToChild(UnitLeaf, I, [cntInterfaceSection], [tkInterface]);
    if IntfLeaf = nil then
      raise ECnPasCodeDocException.Create(SCnErrorNoInterfacesectionPartExists);

    //  interface ڵµֱڵǲ
    I := 0;
    while I < IntfLeaf.Count do
    begin
      case IntfLeaf[I].NodeType of
        cntConstSection: //  const  resourcestring
          begin
            DocFindConsts(IntfLeaf[I], Result);
          end;
        cntVarSection:   // var 
          begin
            DocFindVars(IntfLeaf[I], Result);
          end;
        cntTypeSection:  // 
          begin
            // ӽڵ
            // ͣһУTYPEDECLӽڵƣֺšעͿ
            //  class/record/interface ȵ TYPEDECLעͿڲ
            DocFindTypes(IntfLeaf[I], Result);
          end;
        cntProcedure, cntFunction:
          begin
            DocFindProcedure(IntfLeaf[I], I, Result);
          end;
      end;
      Inc(I);
    end;

    Result.Sort;
    Result.ParseBrief;
  finally
    SL.Free;
    AST.Free;
  end;
end;

procedure DocTypeBubbleSort(RootItem: TCnDocUnit);
var
  I, J: Integer;
begin
  for I := 0 to RootItem.Count - 1 do
    for J := 0 to RootItem.Count - I - 2 do
      if Ord(RootItem[J].DocType) > Ord(RootItem[J + 1].DocType) then
        RootItem.Exchange(J, J + 1);
end;

procedure DocScopeBubbleSort(RootItem: TCnDocBaseItem);
var
  I, J: Integer;
begin
  for I := 0 to RootItem.Count - 1 do
    for J := 0 to RootItem.Count - I - 2 do
      if Ord(RootItem[J].Scope) > Ord(RootItem[J + 1].Scope) then
        RootItem.Exchange(J, J + 1);
end;

procedure SortDocUnit(RootItem: TCnDocUnit);
var
  I: Integer;
begin
  // Unit һ0  Count - 1  consttypeprocedurevar ˳ϲ
  DocTypeBubbleSort(RootItem); // ðݶÿΪҪԭλȶ

  // ÿӿڣİ Scope 
  for I := 0 to RootItem.Count - 1 do
  begin
    if RootItem[I].Count > 1 then
      DocScopeBubbleSort(RootItem[I]);
  end;
end;

procedure CnScanFileProcDecls(const FileName: string; OnScan: TCnScanProcDeclEvent);
var
  AST: TCnPasAstGenerator;
  SL, Pars: TStringList;
  UnitLeaf, IntfLeaf, TypeLeaf, ClassLeaf, VisibilityLeaf: TCnPasAstLeaf;
  I, I1, I2, I3, I4: Integer;
  CurrTypeName: string;
begin
  SL := nil;
  AST := nil;
  Pars := nil;

  try
    SL := TStringList.Create;
    SL.LoadFromFile(FileName);

    AST := TCnPasAstGenerator.Create(SL.Text);
    AST.Build;

    UnitLeaf := nil;
    Pars := TStringList.Create;
    for I := 0 to AST.Tree.Root.Count - 1 do
    begin
      if (AST.Tree.Root.Items[I].NodeType = cntUnit) and (AST.Tree.Root.Items[I].TokenKind = tkUnit) then
      begin
        UnitLeaf := AST.Tree.Root.Items[I];
        Break;
      end;
    end;

    if UnitLeaf = nil then
      Exit;

    //  interface ڵ
    IntfLeaf := nil;
    I := 0;
    while I < UnitLeaf.Count do
    begin
      if (UnitLeaf[I].NodeType in [cntInterfaceSection]) and
        (UnitLeaf[I].TokenKind in [tkInterface]) then
      begin
        IntfLeaf := UnitLeaf[I];
        Break;
      end;
      Inc(I);
    end;

    if IntfLeaf = nil then
      Exit;

    //  interface ڵµֱڵǲ
    I := 0;
    while I < IntfLeaf.Count do
    begin
      case IntfLeaf[I].NodeType of
        cntTypeSection:  // 
          begin
            TypeLeaf := IntfLeaf[I];
            for I1 := 0 to TypeLeaf.Count - 1 do
            begin
              if (TypeLeaf[I1].NodeType = cntTypeDecl) and (TypeLeaf[I1].Count >= 3) then
              begin
                // ¼ TypeName
                CurrTypeName := TypeLeaf[I1][0].Text;
                for I2 := 0 to TypeLeaf[I1].Count - 1 do
                begin
                  if (TypeLeaf[I1][I2].NodeType = cntRestrictedType) and (TypeLeaf[I1][I2].Count >= 1)
                    and (TypeLeaf[I1][I2][0].NodeType = cntClassType) then
                  begin
                    ClassLeaf := TypeLeaf[I1][I2][0]; // ʱ ClassLeaf  classӽڵܵĶע ClassBody

                    I3 := 0;
                    while (I3 < ClassLeaf.Count) and (ClassLeaf[I3].NodeType <> cntClassBody) do
                      Inc(I3);

                    if I3 < ClassLeaf.Count then // ˵ҵ ClassBody 
                    begin
                      ClassLeaf := ClassLeaf[I3];

                      for I3 := 0 to ClassLeaf.Count - 1 do //  ClassBody ӽڵ
                      begin
                        if (ClassLeaf[I3].NodeType = cntVisibility) {and (ClassLeaf[I3].TokenKind = tkPublic)} then
                        begin
                          VisibilityLeaf := ClassLeaf[I3];
                          for I4 := 0 to VisibilityLeaf.Count - 1 do
                          begin
                            if VisibilityLeaf[I4].NodeType in [cntProcedure, cntFunction] then
                              OnScan(VisibilityLeaf[I4], VisibilityTokenKindToDocScope(VisibilityLeaf.TokenKind), CurrTypeName);
                          end;
                        end;
                      end;
                    end;
                  end;
                end;
              end;
            end;
          end;
        cntProcedure, cntFunction:
          begin
            OnScan(IntfLeaf[I], dsNone, '');
          end;
      end;
      Inc(I);
    end;
  finally
    Pars.Free;
    AST.Free;
    SL.Free;
  end;
end;

function CnGetCommentLeafFromProcedure(ProcLeaf: TCnPasAstLeaf;
  Last: Boolean): TCnPasAstLeaf;
var
  Prev, Leaf: TCnPasAstLeaf;
  Comm: Boolean;
begin
  Result := nil;
  Leaf := ProcLeaf;
  Comm := False;

  while True do
  begin
    Prev := Leaf;
    Leaf := TCnPasAstLeaf(Leaf.GetNextSibling);

    if Leaf = nil then
    begin
      if Last and Comm then // һעͣôԾһ
      begin
        Result := Prev;
        Exit;
      end;
      Break;
    end;

    if Leaf.NodeType in COMMENT_NODE_TYPE then
    begin
      if not Last then // һʱͻ
      begin
        Result := Leaf;
        Exit;
      end;
      Comm := True;
    end
    else // ǰעʱ
    begin
      if Last and Comm then // һעͣôһ
      begin
        Result := Prev;
        Exit;
      end;
      Comm := False;
    end;
  end;
end;

{ TCnDocBaseItem }

function TCnDocBaseItem.AddItem(Item: TCnDocBaseItem): Integer;
begin
  FItems.Add(Item);
  Item.Owner := Self;
  Result := FItems.Count;
end;

constructor TCnDocBaseItem.Create;
begin
  FItems := TObjectList.Create(True);
end;

procedure TCnDocBaseItem.Delete(Index: Integer);
begin
  FItems.Delete(Index);
end;

destructor TCnDocBaseItem.Destroy;
begin
  inherited;
  FItems.Free;
end;

procedure TCnDocBaseItem.DumpToStrings(Strs: TStrings; Indent: Integer);
var
  I: Integer;

  function Spcs(Cnt: Integer): string;
  begin
    if Cnt < 0 then
      Result := ''
    else
    begin
      SetLength(Result, Cnt);
      FillChar(Result[1], Cnt, 32);
    end;
  end;

begin
  if Indent < 0 then
    Indent := 0;

  Strs.Add(Spcs(Indent * 2) + FDeclareName);
  if FScope <> dsNone then
    Strs.Add(Spcs(Indent * 2) + SCOPE_STRS[FScope]);
  Strs.Add(Spcs(Indent * 2) + FDeclareType);
  Strs.Add(Spcs(Indent * 2) + FComment);
  Strs.Add('');

  for I := 0 to FItems.Count - 1 do
    Items[I].DumpToStrings(Strs, Indent + 1);
end;

procedure TCnDocBaseItem.Exchange(Index1, Index2: Integer);
begin
  FItems.Exchange(Index1, Index2);
end;

function TCnDocBaseItem.Extract(Item: TCnDocBaseItem): TCnDocBaseItem;
begin
  Result := TCnDocBaseItem(FItems.Extract(Item));
end;

function TCnDocBaseItem.GetCount: Integer;
begin
  Result := FItems.Count;
end;

function TCnDocBaseItem.GetItem(Index: Integer): TCnDocBaseItem;
begin
  Result := TCnDocBaseItem(FItems[Index]);
end;

function TCnDocBaseItem.GetScopeStr: string;
begin
  Result := SCOPE_STRS[FScope];
end;

procedure TCnDocBaseItem.SetItem(Index: Integer;
  const Value: TCnDocBaseItem);
begin
  FItems[Index] := Value;
end;

procedure TCnDocBaseItem.Sort;
begin
  // ɶ
end;

{ TCnDocUnit }

constructor TCnDocUnit.Create;
begin
  inherited;
  FDocType := dtUnit;
end;

procedure TCnDocUnit.ParseBrief;
const
  UNIT_NAME = '* Ԫƣ';
  MEMO_START = '*     ע';
  MEMO_BODY = '*   ';
var
  I: Integer;
  SL, MO: TStringList;
  MF: Boolean;
begin
  // Comment Һʵ
  SL := TStringList.Create;
  MO := TStringList.Create;

  try
    SL.Text := FComment;
    MF := False;

    for I := 0 to SL.Count - 1 do
    begin
      if Pos(UNIT_NAME, SL[I]) = 1 then
        FDeclareType := Copy(SL[I], Length(UNIT_NAME) + 1, MaxInt)
      else if Pos(MEMO_START, SL[I]) = 1 then
      begin
        MO.Add(Copy(SL[I], Length(MEMO_START) + 1, MaxInt));
        MF := True;
      end
      else if MF then
      begin
        if Pos(MEMO_BODY, SL[I]) = 1 then
          MO.Add(Copy(SL[I], Length(MEMO_BODY) + 1, MaxInt))
        else if Trim(SL[I]) = '*' then // עеĿУӲس
          MO.Add('')
        else
          Break;
      end;
    end;

    FComment := MO.Text;
    FComment := StringReplace(FComment, #13#10#13#10, SCnBrBr, [rfReplaceAll]);
  finally
    MO.Free;
    SL.Free;
  end;
end;

procedure TCnDocUnit.Sort;
begin
  SortDocUnit(Self);
end;

{ TCnConstDocItem }

constructor TCnConstDocItem.Create;
begin
  inherited;
  FDocType := dtConst;
end;

{ TCnVarDocItem }

constructor TCnVarDocItem.Create;
begin
  inherited;
  FDocType := dtVar;
end;

{ TCnProcedureDocItem }

constructor TCnProcedureDocItem.Create;
begin
  inherited;
  FDocType := dtProcedure;
end;

{ TCnTypeDocItem }

constructor TCnTypeDocItem.Create;
begin
  inherited;
  FDocType := dtType;
end;

{ TCnPropertyDocItem }

constructor TCnPropertyDocItem.Create;
begin
  inherited;
  FDocType := dtProperty;
end;

{ TCnFieldDocItem }

constructor TCnFieldDocItem.Create;
begin
  inherited;
  FDocType := dtField;
end;

end.
