{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnZipWrapper;
{ |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣĿݹܶ CnZip ܵķװ
* ԪߣCnPack  (master@cnpack.org)
*     ע
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеַϱػʽ
* ޸ļ¼2018.08.26 V1.0 by liuxiao
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  System.SysUtils,
  System.Classes,
  CnZip;

procedure CnWizStartZip(const SaveFileName: PAnsiChar; const Password: PAnsiChar;
  RemovePath: Boolean); stdcall;
{* ʼһ Zipڲָļ}

procedure CnWizZipAddFile(FileName, ArchiveFileName: PAnsiChar); stdcall;
{* ļ ZipΪʵļԼҪд Zip ļļ
   ArchiveFileName  nilʹ FileName  RemovePath ѡ}

procedure CnWizZipSetComment(Comment: PAnsiChar); stdcall;
{*  Zip ļע}

function CnWizZipSaveAndClose: Boolean; stdcall;
{* ѹ Zip ļͷڲ}

exports
  CnWizStartZip,
  CnWizZipAddFile,
  CnWizZipSetComment,
  CnWizZipSaveAndClose;

implementation

var
  FWriter: TCnZipWriter = nil;

procedure CnWizStartZip(const SaveFileName: PAnsiChar; const Password: PAnsiChar;
  RemovePath: Boolean); stdcall;
begin
  FreeAndNil(FWriter);
  FWriter := TCnZipWriter.Create;
  FWriter.RemovePath := RemovePath;
  FWriter.Password := Password;
  FWriter.CreateZipFile(SaveFileName);
end;

procedure CnWizZipAddFile(FileName, ArchiveFileName: PAnsiChar); stdcall;
begin
  if FWriter <> nil then
    FWriter.AddFile(FileName, ArchiveFileName);
end;

procedure CnWizZipSetComment(Comment: PAnsiChar); stdcall;
begin
  if FWriter <> nil then
    FWriter.Comment := Comment;
end;

function CnWizZipSaveAndClose: Boolean; stdcall;
begin
  Result := False;
  if FWriter <> nil then
  begin
    FWriter.Save;
    FWriter.Close;
    FreeAndNil(FWriter);
    Result := True;
  end;
end;

end.
