{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnVclToFmxImpl;
{* |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣVCL  FMX תܵĽӿʵ
* ԪߣCnPack
*     עõԪ VCL  FMX תܵĽӿʵ
* ƽ̨Win7 + Delphi 5.0
* ݲԣƽ̨
*   Ҫ
* ޸ļ¼2022.05.11 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  System.SysUtils, System.Classes, CnVclToFmxIntf;

type
  TCnVclToFmxImpl = class(TInterfacedObject, ICnVclToFmxIntf)
  private
    FFmx: string;
    FPas: string;
  public
    function OpenAndConvertFile(InDfmFile: PWideChar): Boolean;
    function SaveNewFile(InNewFile: PWideChar): Boolean;
  end;

function GetVclToFmxConverter: ICnVclToFmxIntf; stdcall;

exports
  GetVclToFmxConverter;

implementation

uses
  CnVclToFmxConverter;

var
  FImpl: ICnVclToFmxIntf = nil;

function GetVclToFmxConverter: ICnVclToFmxIntf;
begin
  if FImpl = nil then
    FImpl := TCnVclToFmxImpl.Create;
  Result := FImpl;
end;

{ TCnVclToFmxImpl }

function TCnVclToFmxImpl.OpenAndConvertFile(InDfmFile: PWideChar): Boolean;
begin
  FFmx := '';
  FPas := '';
  Result := CnVclToFmxConvert(InDfmFile, FFmx, FPas);
end;

function TCnVclToFmxImpl.SaveNewFile(InNewFile: PWideChar): Boolean;
var
  F: string;
begin
  if (FFmx <> '') and (InNewFile <> nil) then
  begin
    F := InNewFile;
    Result := CnVclToFmxSaveContent(ChangeFileExt(F, '.fmx'), FFmx);
    if Result and (FPas <> '') then
    begin
      FPas := CnVclToFmxReplaceUnitName(F, FPas);
      Result := CnVclToFmxSaveContent(ChangeFileExt(F, '.pas'), FPas);
    end;
  end;
end;

initialization

finalization
  FImpl := nil;

end.
