{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CleanClass;
{ |<PRE>
================================================================================
* ƣCnPack IDE רҸ/ָ
* Ԫƣ IDE ļʷ¼Ԫ
* ԪߣCnPack  (master@cnpack.org)
*     ע
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеַϱػʽ
* ޸ļ¼2006.08.23 V1.1
*               ֲµԪ
*           2005.02.20 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

uses
  Classes, SysUtils, CnWizCompilerConst;

type
  TCnHisEntry = class(TCollectionItem)
  {* һɾļ}
  private
    FToDelete: Boolean;
    FEntryName: string;
    FEntryValue: string;
  published
    property EntryName: string read FEntryName write FEntryName;
    property EntryValue: string read FEntryValue write FEntryValue;
    property ToDelete: Boolean read FToDelete write FToDelete;
  end;

  TCnHisEntries = class(TCollection)
  {* һʷ¼б}
  private
    function GetItem(Index: Integer): TCnHisEntry;
    procedure SetItem(Index: Integer; const Value: TCnHisEntry);
  public
    constructor Create(ItemClass: TCollectionItemClass);
    function Add: TCnHisEntry;
    property Items[Index: Integer]: TCnHisEntry read GetItem write SetItem;
  end;

  TCnIDEHistory = class(TObject)
  {* һ IDE ʷ¼}
  private
    FProjects: TCnHisEntries;
    FFiles: TCnHisEntries;
    FIDEName: string;
    FExists: Boolean;
  public
    constructor Create;
    destructor Destroy; override;

    property IDEName: string read FIDEName write FIDEName;
    property Exists: Boolean read FExists write FExists;
    property Projects: TCnHisEntries read FProjects;
    property Files: TCnHisEntries read FFiles;
  end;

var
  IDEHistories: array[TCnCompiler] of TCnIDEHistory;

procedure CreateIDEHistories;

procedure FreeIDEHistories;

implementation

procedure CreateIDEHistories;
var
  IDE: TCnCompiler;
begin
  for IDE := Low(TCnCompiler) to High(TCnCompiler) do
  begin
    IDEHistories[IDE] := TCnIDEHistory.Create;
    IDEHistories[IDE].IDEName := SCnCompilerNames[IDE];
  end;
end;

procedure FreeIDEHistories;
var
  IDE: TCnCompiler;
begin
  for IDE := Low(TCnCompiler) to High(TCnCompiler) do
    FreeAndNil(IDEHistories[IDE]);
end;

{ TCnHisEntries }

function TCnHisEntries.Add: TCnHisEntry;
begin
  Result := TCnHisEntry(inherited Add);
end;

constructor TCnHisEntries.Create(ItemClass: TCollectionItemClass);
begin
  Assert(ItemClass.InheritsFrom(TCnHisEntry));
  inherited;
end;

function TCnHisEntries.GetItem(Index: Integer): TCnHisEntry;
begin
  Result := TCnHisEntry(inherited GetItem(Index));
end;

procedure TCnHisEntries.SetItem(Index: Integer; const Value: TCnHisEntry);
begin
  inherited SetItem(Index, Value);
end;

{ TCnIDEHistory }

constructor TCnIDEHistory.Create;
begin
  FProjects := TCnHisEntries.Create(TCnHisEntry);
  FFiles := TCnHisEntries.Create(TCnHisEntry);
end;

destructor TCnIDEHistory.Destroy;
begin
  FProjects.Free;
  FFiles.Free;
  inherited;
end;

end.
