{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnDebugIntf;
{ |<PRE>
================================================================================
* ƣCnDebugViewer
* ԪƣCnDebug ӿڵԪ
* ԪߣCnPack  (master@cnpack.org)
*     ע
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7
*   õԪеֱַ֧ػʽ
* ޸ļ¼2008.07.16
*               ڿַ֧
*           2005.01.01
*               Ԫʵֹ
================================================================================
|</PRE>}

interface

uses
  SysUtils, Classes, Windows;

const
  CnDefLevel = 3;
  CnMaxTagLength = 8; // ɸı
  CnMaxMsgLength = 4096;
  CnDebugMagicLength = 8;
  CnDebugMapEnabled = $7F3D92E0; // 㶨һֵʾ MapEnable
{$IFDEF UNICODE}
  CnDebugMagicName: AnsiString = 'CNDEBUG';
{$ELSE}
  CnDebugMagicName = 'CNDEBUG';
{$ENDIF}

  SCnDebugPrefix = 'Global\';

var
  SCnDebugMapName: string = SCnDebugPrefix + 'CnDebugMap';
  SCnDebugQueueEventName: string = SCnDebugPrefix + 'CnDebugQueueEvent';
  SCnDebugQueueMutexName: string = SCnDebugPrefix + 'CnDebugQueueMutex';
  SCnDebugStartEventName: string = SCnDebugPrefix + 'CnDebugStartEvent';
  SCnDebugFlushEventName: string = SCnDebugPrefix + 'CnDebugFlushEvent';

type
  // ===================== ½ṹҪ Viewer  ======================

  // Ϣ
  TCnMsgType = (cmtInformation, cmtWarning, cmtError, cmtSeparator, cmtEnterProc,
    cmtLeaveProc, cmtTimeMarkStart, cmtTimeMarkStop, cmtMemoryDump, cmtException,
    cmtObject, cmtComponent, cmtCustom, cmtSystem, cmtUDPMsg, cmtWatch,
    cmtClearWatch);
  TCnMsgTypes = set of TCnMsgType;

  // ʱʽ
  TCnTimeStampType = (ttNone, ttDateTime, ttTickCount, ttCPUPeriod);

  {$NODEFINE TCnMsgAnnex}
  TCnMsgAnnex = packed record
  {* ÿϢͷṹ }
    Level:     Integer;                            // Զ Level û
    Indent:    Integer;                            // Ŀ Enter  Leave 
    ProcessId: Cardinal;                           // ߵĽ ID
    ThreadId:  Cardinal;                           // ߵ߳ ID
    Tag: array[0..CnMaxTagLength - 1] of AnsiChar; // Զ Tag ֵû
    MsgType:   Cardinal;                           // Ϣ
    MsgCPInterval: Int64;                          // ʱʱ CPU 
    TimeStampType: Cardinal;                       // Ϣʱ
    case Integer of
      1: (MsgDateTime:   TDateTime);               // Ϣʱֵ DateTime
      2: (MsgTickCount:  Cardinal);                // Ϣʱֵ TickCount
      3: (MsgCPUPeriod:  Int64);                   // Ϣʱֵ CPU 
  end;

  {$NODEFINE TCnMsgDesc}
  {$NODEFINE PCnMsgDesc}
  TCnMsgDesc = packed record
  {* ÿϢṹһϢͷ}
    Length: Integer;                               // ܳȣϢͷ
    Annex: TCnMsgAnnex;                            // һϢͷ
    Msg: array[0..CnMaxMsgLength - 1] of AnsiChar; // Ҫ¼Ϣ
  end;
  PCnMsgDesc = ^TCnMsgDesc;

  {$NODEFINE TCnMapFilter}
  {$NODEFINE PCnMapFilter}
  TCnMapFilter = packed record
  {* ڴӳļʱڴͷеĹʽ}
    NeedRefresh: Cardinal;                         //  0 ʱҪ
    Enabled: Integer;                              //  0 ʱʾʹ
    Level: Integer;                                // ޶ Level
    Tag: array[0..CnMaxTagLength - 1] of AnsiChar; // ޶ Tag
    case Integer of
      0: (MsgTypes: TCnMsgTypes);                  // ޶ MsgTypes
      1: (DummyPlace: Cardinal);
  end;
  PCnMapFilter = ^TCnMapFilter;

  {$NODEFINE TCnMapHeader}
  {$NODEFINE PCnMapHeader}
  TCnMapHeader = packed record
  {* ڴӳļʱڴͷʽ}
    MagicName:  array[0..CnDebugMagicLength - 1] of AnsiChar;  // 'CNDEBUG'
    MapEnabled: Cardinal;           // Ϊһ CnDebugMapEnabled ʱʾ
    MapSize:    Cardinal;           //  Map ĴСβ
    DataOffset: Integer;            // ͷƫĿǰΪ 64
    QueueFront: Integer;            // ͷָ룬ƫ
    QueueTail:  Integer;            // βָ룬ƫ
    Filter: TCnMapFilter;           // Viewer õĹ
  end;
  PCnMapHeader = ^TCnMapHeader;

  // ===================== ϽṹҪ Viewer  ======================

procedure ReInitLocalConsts;

implementation

procedure ReInitLocalConsts;
const
  SCnDebugLocalPrefix = 'Local\';
begin
  SCnDebugMapName := SCnDebugLocalPrefix + 'CnDebugMap';
  SCnDebugQueueEventName := SCnDebugLocalPrefix + 'CnDebugQueueEvent';
  SCnDebugQueueMutexName := SCnDebugLocalPrefix + 'CnDebugQueueMutex';
  SCnDebugStartEventName := SCnDebugLocalPrefix + 'CnDebugStartEvent';
  SCnDebugFlushEventName := SCnDebugLocalPrefix + 'CnDebugFlushEvent';
end;

end.
