{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnTestHighLightWizard;
{ |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣֹܲԵԪ
* ԪߣCnPack 
*     עõԪʵ˴ֹܵĲԣʱֵֻ֧Ͱ汾 Unicodeδ Unicode
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   ôеַݲֱ֧ػʽ
* ޸ļ¼2002.11.07 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ToolsAPI, IniFiles, CnWizClasses, CnWizUtils, CnWizConsts, CnPasCodeParser,
  mPasLex;

type

//==============================================================================
// ṹԲ˵ר
//==============================================================================

{ TCnTestHighLightWizard }

  TCnTestHighLightWizard = class(TCnMenuWizard)
  private
    FParser: TCnPasStructureParser;
  protected
    function GetHasConfig: Boolean; override;
  public
    constructor Create; override;
    destructor Destroy; override;

    function GetState: TWizardState; override;
    procedure Config; override;
    procedure LoadSettings(Ini: TCustomIniFile); override;
    procedure SaveSettings(Ini: TCustomIniFile); override;
    class procedure GetWizardInfo(var Name, Author, Email, Comment: string); override;
    function GetCaption: string; override;
    function GetHint: string; override;
    function GetDefShortCut: TShortCut; override;
    procedure Execute; override;

    property Parser: TCnPasStructureParser read FParser;
  end;

implementation

uses
  CnDebug;

//==============================================================================
// ṹԲ˵ר
//==============================================================================

{ TCnTestHighLightWizard }

procedure TCnTestHighLightWizard.Config;
begin
  ShowMessage('Test option.');
  { TODO -oAnyone : ڴʾô }
end;

constructor TCnTestHighLightWizard.Create;
begin
  inherited;
  FParser := TCnPasStructureParser.Create;
end;

destructor TCnTestHighLightWizard.Destroy;
begin
  FParser.Free;
  inherited;
end;

procedure TCnTestHighLightWizard.Execute;
{$IFNDEF UNICODE}
const
  csKeyTokens: set of TTokenKind = [
    tkIf, tkThen, tkRecord, tkClass,
    tkFor, tkWith, tkOn, tkWhile, tkDo,
    tkAsm, tkBegin, tkEnd,
    tkTry, tkExcept, tkFinally,
    tkCase,
    tkRepeat, tkUntil];
var
  EditView: IOTAEditView;
  Stream: TMemoryStream;
  CharPos: TOTACharPos;
  EditPos: TOTAEditPos;
  I, Sum: Integer;
{$ENDIF}
begin
{$IFNDEF UNICODE}
  EditView := CnOtaGetTopMostEditView;
  if EditView = nil then Exit;

  Stream := TMemoryStream.Create;
  try
    CnOtaSaveEditorToStream(EditView.Buffer, Stream);
    // ǰʾԴļ
    Parser.ParseSource(PChar(Stream.Memory),
      IsDpr(EditView.Buffer.FileName), True);
  finally
    Stream.Free;
  end;

  // ٲҵǰڵĿ
  EditPos := EditView.CursorPos;
  EditView.ConvertPos(True, EditPos, CharPos);
  Parser.FindCurrentBlock(CharPos.Line, CharPos.CharIndex);

  CnDebugger.TraceFmt('CharPos.Line %d, CharPos.CharIndex %d.',
    [CharPos.Line, CharPos.CharIndex]);

  if Parser.Count > 0 then
  begin
    for I := 0 to Parser.Count - 1 do
    begin
      CharPos := OTACharPos(Parser.Tokens[I].CharIndex, Parser.Tokens[I].LineNumber + 1);
      EditView.ConvertPos(False, EditPos, CharPos);
      Parser.Tokens[I].EditCol := EditPos.Col;
      Parser.Tokens[I].EditLine := EditPos.Line;
    end;
  end;

  Sum := 0;
  for I := 0 to Parser.Count - 1 do
  begin
    if Parser.Tokens[I].TokenID in csKeyTokens then
    begin
      // Ҫ Token Ϣ
      CnDebugger.TraceObject(Parser.Tokens[I]);
      Inc(Sum);
    end;
  end;
  CnDebugger.TraceInteger(Sum, 'All Tokens: ');

  CnDebugger.TraceObject(Parser.MethodStartToken);
  CnDebugger.TraceObject(Parser.MethodCloseToken);
  CnDebugger.TraceObject(Parser.BlockStartToken);
  CnDebugger.TraceObject(Parser.BlockCloseToken);
  CnDebugger.TraceObject(Parser.InnerBlockStartToken);
  CnDebugger.TraceObject(Parser.InnerBlockCloseToken);

  CnDebugger.TraceSeparator;
{$ENDIF}
end;

function TCnTestHighLightWizard.GetCaption: string;
begin
  Result := 'Test Highight';
  { TODO -oAnyone : רҲ˵ı⣬ַбػ }
end;

function TCnTestHighLightWizard.GetDefShortCut: TShortCut;
begin
  Result := 0;
  { TODO -oAnyone : ĬϵĿݼ }
end;

function TCnTestHighLightWizard.GetHasConfig: Boolean;
begin
  Result := False;
  { TODO -oAnyone : רǷô }
end;

function TCnTestHighLightWizard.GetHint: string;
begin
  Result := 'Test HighLight. Parse Current Pascal Source File.';
  { TODO -oAnyone : רҲ˵ʾϢַбػ }
end;

function TCnTestHighLightWizard.GetState: TWizardState;
begin
  Result := [wsEnabled];
  { TODO -oAnyone : רҲ˵״̬ɸָ趨 }
end;

class procedure TCnTestHighLightWizard.GetWizardInfo(var Name, Author, Email, Comment: string);
begin
  Name := 'Test Highlight Structure';
  Author := 'CnPack Team';
  Email := 'master@cnpack.org';
  Comment := 'Test HighLight. Parse Current Pascal Source File.';
  { TODO -oAnyone : רҵơߡ估עַбػ }
end;

procedure TCnTestHighLightWizard.LoadSettings(Ini: TCustomIniFile);
begin
  { TODO -oAnyone : ڴװרڲõĲרҴʱԶ }
end;

procedure TCnTestHighLightWizard.SaveSettings(Ini: TCustomIniFile);
begin
  { TODO -oAnyone : ڴ˱רڲõĲרͷʱԶ }
end;

initialization
  RegisterCnWizard(TCnTestHighLightWizard); // ער

end.
