{*******************************************************}
{                                                       }
{       Pascal Script Source File                       }
{       Run by RemObjects Pascal Script in CnWizards    }
{                                                       }
{       Generated by CnPack IDE Wizards                 }
{                                                       }
{*******************************************************}

program CnTestBuildConfigValueScript;

// This Script should run under XE2 or above.

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

var
  Project: IOTAProject;
  POCS: IOTAProjectOptionsConfigurations;
  BC: IOTABuildConfiguration;
  CurrPs: string;
  I, J: Integer;
  List: TStrings;
  PlatformConfig: IOTABuildConfiguration;
begin
  Project := CnOtaGetCurrentProject;
  if Project = nil then
    Exit;

  BC := nil;
  POCS := CnOtaGetActiveProjectOptionsConfigurations(Project);
  if POCS <> nil then
  begin
    for I := 0 to POCS.GetConfigurationCount - 1 do
    begin
      if POCS.GetConfiguration(I).GetName = POCS.GetActiveConfiguration.GetName then
      begin
        BC := POCS.GetConfiguration(I);
        Break;
      end;
    end;

    if BC = nil then
      Exit;

    CurrPs := Project.GetPlatform;
    List := TStringList.Create;
    CnOtaGetPlatformsFromBuildConfiguration(BC, List);
    for I := 0 to List.Count - 1 do
    begin
      PlatformConfig := BC.GetPlatformConfiguration(List[I]);
      if List[I] = CurrPs then
      begin
        for J := 0 to PlatformConfig.GetPropertyCount - 1 do
        begin
          Writeln(PlatformConfig.GetPropertyName(J) + ': ' +
            PlatformConfig.GetValue(PlatformConfig.GetPropertyName(J), True));
        end;
      end;
    end;
    List.Free;
  end;
end.

