{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnWizMethodHook;
{ |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* Ԫƣ󷽷ҽӵԪ
* Ԫߣܾ (zjy@cnpack.org)
*     עõԪҽ IDE ڲķ
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣ
*   õԪеֱַ֧ػʽ
* ޸ļ¼2018.01.12
*               ʼʱԶҽӵĿƣӿںʵַȡ
*           2014.10.01
*                DDetours øΪ̬
*           2014.08.28
*               DDetoursʵֵ
*           2003.10.27
*               ʵԱ༭ҽӺļ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

uses
  Windows, SysUtils, Classes{$IFDEF USE_DDETOURS_HOOK}, DDetours{$ENDIF};

type
  PLongJump = ^TLongJump;
  TLongJump = packed record
    JmpOp: Byte;        // Jmp תָΪ $E9
    Addr: Pointer;      // תԵַ
  end;

  TCnMethodHook = class
  {* ̬ dynamic ҽ࣬ڹҽо̬Ϊ dynamic Ķ̬
     ͨ޸ԭǰ 5ֽڣΪתָʵַҽӲʹʱ
     뱣֤ԭִ 5ֽڣܻغ}
  private
    FUseDDteours: Boolean;
    FHooked: Boolean;
    FOldMethod: Pointer;
    FNewMethod: Pointer;
    FTrampoline: Pointer;
    FSaveData: TLongJump;
  public
    constructor Create(const AOldMethod, ANewMethod: Pointer; UseDDteoursHook: Boolean = False;
      DefaultHook: Boolean = True);
    {* Ϊԭַ·ַערҰʹãԭַ
        GetBplMethodAddress תʵַúԶҽӴķ
     |<PRE>
       Ҫҽ TTest.Abc(const A: Integer) Զ·Ϊ
       procedure MyAbc(ASelf: TTest; const A: Integer);
       ˴ MyAbc Ϊ̣ͨΪһΪ Selfʴ˴һ
       ASelf: TTest ֮ԣʵִп԰ʵʡ
     |</PRE>}
    destructor Destroy; override;
    {* ȡҽ}

    property Hooked: Boolean read FHooked;
    {* Ƿѹҽ}
    procedure HookMethod; virtual;
    {* ¹ҽӣҪִԭ̣ʹ UnhookMethodִɺ¹ҽ}
    procedure UnhookMethod; virtual;
    {* ȡҽӣҪִԭ̣ʹ UnhookMethodٵԭ̣}
    property Trampoline: Pointer read FTrampoline;
    {* DDetours ҽӺľɷַ粻лҽ״ֱ̬ӵá
       粻ʹ DDetoursΪ nil}
    property UseDDteours: Boolean read FUseDDteours;
    {* Ƿʹ UseDDteours йҽ}
  end;

function GetBplMethodAddress(Method: Pointer): Pointer;
{*  BPL ʵʵķַרҰ @TPersistent.Assign صʵ
   һ Jmp תַúԷ BPL зʵַ}

function GetInterfaceMethodAddress(const AIntf: IUnknown;
  MethodIndex: Integer): Pointer;
{*  Delphi ֧ @AIntf.Proc ķʽؽӿڵĺڵַ Self ָҲ
   ƫ⡣ڷ AIntf ĵ MethodIndex ڵַ
   Self ָƫ⡣
   MethodIndex  0 ʼ012 ֱ QueryInterface_AddRef_Release
   ע MethodIndex ߽飬˸ Interface ķ}

implementation

type
  TJmpCode = packed record
    Code: Word;                 // תָΪ $25FF
    Addr: ^Pointer;             // תַָָ򱣴Ŀַָ
  end;
  PJmpCode = ^TJmpCode;

resourcestring
  SMemoryWriteError = 'Error writing method memory (%s).';

const
  csJmpCode = $E9;              // תָ
  csJmp32Code = $25FF;

//  BPL ʵʵķַ
function GetBplMethodAddress(Method: Pointer): Pointer;
begin
  if PJmpCode(Method)^.Code = csJmp32Code then
    Result := PJmpCode(Method)^.Addr^
  else
    Result := Method;
end;

//  Interface ĳŷʵʵַ Self ƫ
function GetInterfaceMethodAddress(const AIntf: IUnknown;
  MethodIndex: Integer): Pointer;
type
  TIntfMethodEntry = packed record
    case Integer of
      0: (ByteOpCode: Byte);        // $05 ֽ
      1: (WordOpCode: Word);        // $C083 һֽ
      2: (DWordOpCode: DWORD);      // $04244483 һֽڻ $04244481 ֽ
  end;
  PIntfMethodEntry = ^TIntfMethodEntry;

  // תʵϵͬ TJmpCode  TLongJmp ṹ
  TIntfJumpEntry = packed record
    case Integer of
      0: (ByteOpCode: Byte; Offset: LongInt);         // $E9 ֽ
      1: (WordOpCode: Word; Addr: ^Pointer);        // $25FF ֽ
  end;
  PIntfJumpEntry = ^TIntfJumpEntry;
  PPointer = ^Pointer;

var
  OffsetStubPtr: Pointer;
  IntfPtr: PIntfMethodEntry;
  JmpPtr: PIntfJumpEntry;
begin
  Result := nil;
  if (AIntf = nil) or (MethodIndex < 0) then
    Exit;

  OffsetStubPtr := PPointer(Integer(PPointer(AIntf)^) + SizeOf(Pointer) * MethodIndex)^;

  // õ interface Աתڣڻ Self ָ
  // IUnknown ׼ھ add dword ptr [esp+$04],-$xx xx Ϊ ShortInt  LongIntΪ stdcall
  // stdcall/safecall/cdecl ĴΪ $04244483 һֽڵ ShortInt $04244481 ֽڵ LongInt
  // ÷ʽпĬ register  add eax -$xx xx Ϊ ShortInt  LongInt
  // stdcall/safecall/cdecl ĴΪ $C083 һֽڵ ShortInt $05 ֽڵ LongInt
  // pascal ջʽƺԺ stdcall һ
  IntfPtr := PIntfMethodEntry(OffsetStubPtr);

  JmpPtr := nil;
  if IntfPtr^.ByteOpCode = $05 then
    JmpPtr := PIntfJumpEntry(Integer(IntfPtr) + 1 + 4)
  else if IntfPtr^.DWordOpCode = $04244481 then
    JmpPtr := PIntfJumpEntry(Integer(IntfPtr) + 4 + 4)
  else if IntfPtr^.WordOpCode = $C083 then
    JmpPtr := PIntfJumpEntry(Integer(IntfPtr) + 2 + 1)
  else if IntfPtr^.DWordOpCode = $04244483 then
    JmpPtr := PIntfJumpEntry(Integer(IntfPtr) + 4 + 1);

  if JmpPtr <> nil then
  begin
    // Ҫֲָͬת E9 ֽƫƣԼ 25FF ֽھԵַĵַ
    if JmpPtr^.ByteOpCode = csJmpCode then
    begin
      Result := Pointer(Integer(JmpPtr) + JmpPtr^.Offset + 5); // 5 ʾ Jmp ָĳ
    end
    else if JmpPtr^.WordOpCode = csJmp32Code then
    begin
      Result := JmpPtr^.Addr^;
    end;
  end;
end;

//==============================================================================
// ̬ dynamic ҽ
//==============================================================================

{ TCnMethodHook }

constructor TCnMethodHook.Create(const AOldMethod, ANewMethod: Pointer;
  UseDDteoursHook, DefaultHook: Boolean);
begin
  inherited Create;
{$IFNDEF USE_DDETOURS_HOOK}
  if UseDDteoursHook then
    raise Exception.Create('DDetours NOT Included. Can NOT Hook.');
{$ENDIF}
  FUseDDteours := UseDDteoursHook;
  FHooked := False;
  FOldMethod := AOldMethod;
  FNewMethod := ANewMethod;
  FTrampoline := nil;

  if DefaultHook then
    HookMethod;
end;

destructor TCnMethodHook.Destroy;
begin
  UnHookMethod;
  inherited;
end;

procedure TCnMethodHook.HookMethod;
var
  DummyProtection: DWORD;
  OldProtection: DWORD;
begin
  if FHooked then Exit;

  if FUseDDteours then
  begin
{$IFDEF USE_DDETOURS_HOOK}
    FTrampoline := DDetours.InterceptCreate(FOldMethod, FNewMethod);
    if not Assigned(FTrampoline) then
      raise Exception.Create('Failed to install method hook');
{$ENDIF}
  end
  else
  begin
    // ôҳдȨ
    if not VirtualProtect(FOldMethod, SizeOf(TLongJump), PAGE_EXECUTE_READWRITE, @OldProtection) then
      raise Exception.CreateFmt(SMemoryWriteError, [SysErrorMessage(GetLastError)]);

    try
      // ԭĴ
      FSaveData := PLongJump(FOldMethod)^;

      // תָ滻ԭǰ 5 ֽڴ
      PLongJump(FOldMethod)^.JmpOp := csJmpCode;
      PLongJump(FOldMethod)^.Addr := Pointer(Integer(FNewMethod) -
        Integer(FOldMethod) - SizeOf(TLongJump)); // ʹ 32 λԵַ

      // ദָͬ
      FlushInstructionCache(GetCurrentProcess, FOldMethod, SizeOf(TLongJump));
    finally
      // ָҳȨ
      if not VirtualProtect(FOldMethod, SizeOf(TLongJump), OldProtection, @DummyProtection) then
        raise Exception.CreateFmt(SMemoryWriteError, [SysErrorMessage(GetLastError)]);
    end;
  end;

  FHooked := True;
end;

procedure TCnMethodHook.UnhookMethod;
var
  DummyProtection: DWORD;
  OldProtection: DWORD;
begin
  if not FHooked then Exit;

  if FUseDDteours then
  begin
{$IFDEF USE_DDETOURS_HOOK}
    if not DDetours.InterceptRemove(FTrampoline) then
      raise Exception.Create('Failed to release method hook');
{$ENDIF}
    FTrampoline := nil;
  end
  else
  begin
    // ôҳдȨ
    if not VirtualProtect(FOldMethod, SizeOf(TLongJump), PAGE_READWRITE, @OldProtection) then
      raise Exception.CreateFmt(SMemoryWriteError, [SysErrorMessage(GetLastError)]);

    try
      // ָԭĴ
      PLongJump(FOldMethod)^ := FSaveData;
    finally
      // ָҳȨ
      if not VirtualProtect(FOldMethod, SizeOf(TLongJump), OldProtection, @DummyProtection) then
        raise Exception.CreateFmt(SMemoryWriteError, [SysErrorMessage(GetLastError)]);
    end;

    // ദָͬ
    FlushInstructionCache(GetCurrentProcess, FOldMethod, SizeOf(TLongJump));
  end;

  FHooked := False;
end;

end.
