{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnWizIdeHooks;
{* |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣImageList  Hook Ԫ
* Ԫߣܾ (zjy@cnpack.org)
*     עVCL  TCustomImageList ṩ BeginUpdate  EndUpdate  private
*            IDE ҪͼƬÿӶܶؼˢ£
*           Ӱٶȡر Delphi7 £һͼƬҪ 70msר
*           Ӱܴ󣬹ʱд Hookṩ BeginUpdate  EndUpdate ܡ
*           ⣬ActionList ҲƵ⣬ͬ
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеַϱػʽ
* ޸ļ¼2004.12.25 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

uses
  Windows, Classes, SysUtils, Controls, ImgList, ActnList, CnWizMethodHook,
  CnWizUtils, CnWizIdeUtils;

// ʼ ImageList  ActionList
procedure CnListBeginUpdate;

// 
procedure CnListEndUpdate;

implementation

{$IFDEF DEBUG}
uses
  CnDebug;
{$ENDIF}

type
  TImageListAccess = class(TCustomImageList);
  TActionListAccess = class(TCustomActionList);
  TListChangeProc = procedure(Self: TCustomImageList);
  TListChangeMethod = procedure of object;

  TCnListComponent = class(TComponent)
  protected
    procedure Notification(AComponent: TComponent;
      Operation: TOperation); override;
  end;
  
var
  FImageLists: TThreadList = nil;
  FActionLists: TThreadList = nil;
  FImageListHook: TCnMethodHook = nil;
  FActionListHook: TCnMethodHook = nil;
  FCnListComponent: TCnListComponent = nil;
  FUpdateCount: Integer = 0;

procedure TCnListComponent.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited;
  FImageLists.Remove(AComponent);
  FActionLists.Remove(AComponent);
end;

procedure MyImageListChange(Self: TCustomImageList);
begin
  if (Self <> nil) and (Self is TCustomImageList) then
  begin
    Self.FreeNotification(FCnListComponent);
    FImageLists.Add(Self);

// ֪ͨȥIDE  ImageList £ò֪ͨ
//    if Self = GetIDEImageList then
//      ClearIDEBigImageList;
  end;
end;

procedure MyActionListChange(Self: TCustomActionList);
begin
  if (Self <> nil) and (Self is TCustomActionList) then
  begin
    Self.FreeNotification(FCnListComponent);
    FActionLists.Add(Self);
  end;
end;

procedure CnListBeginUpdate;
var
  Method: TListChangeMethod;
begin
  if FUpdateCount = 0 then
  begin
    FImageLists := TThreadList.Create;
    FImageLists.Duplicates := dupIgnore;

    FActionLists := TThreadList.Create;
    FActionLists.Duplicates := dupIgnore;

    FCnListComponent := TCnListComponent.Create(nil);

    Method := TImageListAccess(GetIDEImageList).Change;
    FImageListHook := TCnMethodHook.Create(GetBplMethodAddress(TMethod(Method).Code),
      @MyImageListChange);
      
    Method := TActionListAccess(GetIDEActionList).Change;
    FActionListHook := TCnMethodHook.Create(GetBplMethodAddress(TMethod(Method).Code),
      @MyActionListChange);
  end;
  
  Inc(FUpdateCount);
end;

procedure CnListEndUpdate;
var
  I: Integer;
begin
  Dec(FUpdateCount);

  if FUpdateCount = 0 then
  begin
    FreeAndNil(FImageListHook);
    FreeAndNil(FActionListHook);
    FreeAndNil(FCnListComponent);

    with FImageLists.LockList do
    try
      for I := Count - 1 downto 0 do
        TImageListAccess(Items[I]).Change;
    finally
      FImageLists.UnlockList;
    end;

    with FActionLists.LockList do
    try
      for I := Count - 1 downto 0 do
        TActionListAccess(Items[I]).Change;
    finally
      FActionLists.UnlockList;
    end;
    
    FreeAndNil(FImageLists);
    FreeAndNil(FActionLists);
  end;
end;

end.
