{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnWizHelperIntf;

interface
{ |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣCnWizHelper.dll Ľӿ
* Ԫߣܾ (zjy@cnpack.org)
*     ע
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеַϱػʽ
* ޸ļ¼2010.05.1 V1.0 by zjy
*               Ԫ
================================================================================
|</PRE>}

uses
  Windows, SysUtils, CnCommon;

const
  SCnWizHelperDllName = 'CnWizHelper.Dll';
  SCnWizZipDllName = 'CnZipUtils.Dll';

function CnWizHelperLoaded: Boolean;

function CnWizZipUtilsLoaded: Boolean;

//------------------------------------------------------------------------------
// ZIP 
//------------------------------------------------------------------------------

function CnWizHelperZipValid: Boolean;

procedure CnWizStartZip(const SaveFileName: PAnsiChar; const Password: PAnsiChar;
  RemovePath: Boolean); stdcall;
{* ʼһ Zipڲָļ}

procedure CnWizZipAddFile(FileName, ArchiveFileName: PAnsiChar); stdcall;
{* ļ ZipΪʵļԼҪд Zip ļļ
   ArchiveFileName  nilʹ FileName  RemovePath ѡ}

procedure CnWizZipSetComment(Comment: PAnsiChar); stdcall;
{*  Zip ļע}

function CnWizZipSaveAndClose: Boolean; stdcall;
{* ѹ Zip ļͷڲ}

//------------------------------------------------------------------------------
// InetUtils 
//------------------------------------------------------------------------------

function CnWizHelperInetValid: Boolean;

function CnWiz_Inet_GetFile(AURL, FileName: PAnsiChar): Boolean; stdcall;

implementation

{$IFDEF DEBUG}
uses
  CnDebug;
{$ENDIF}

type
  TProcCnWizStartZip = procedure(const SaveFileName: PAnsiChar; const Password: PAnsiChar;
    RemovePath: Boolean); stdcall;
  {* ʼһ Zipڲָļ}

  TProcCnWizZipAddFile = procedure(FileName, ArchiveFileName: PAnsiChar); stdcall;
  {* ļ ZipΪʵļԼҪд Zip ļļ
     ArchiveFileName  nilʹ FileName  RemovePath ѡ}

  TProcCnWizZipSetComment = procedure(Comment: PAnsiChar); stdcall;
  {*  Zip ļע}

  TFuncCnWizZipSaveAndClose = function: Boolean; stdcall;
  {* ѹ Zip ļͷڲ}

  TFuncCnWizInetGetFile = function(AURL, FileName: PAnsiChar): Boolean; stdcall;

var
  HelperDllHandle: HMODULE = 0;
  ZipDllHandle: HMODULE = 0;

  FCnWizStartZip: TProcCnWizStartZip;
  FCnWizZipAddFile: TProcCnWizZipAddFile;
  FCnWizZipSetComment: TProcCnWizZipSetComment;
  FCnWizZipSaveAndClose: TFuncCnWizZipSaveAndClose;
  FCnWizInetGetFile: TFuncCnWizInetGetFile;

procedure LoadWizHelperDll;
var
  ModuleName: array[0..MAX_Path - 1] of Char;
begin
  GetModuleFileName(hInstance, ModuleName, MAX_PATH);
  HelperDllHandle := LoadLibrary(PChar(_CnExtractFilePath(ModuleName) + SCnWizHelperDllName));
  ZipDllHandle := LoadLibrary(PChar(_CnExtractFilePath(ModuleName) + SCnWizZipDllName));
  
  if HelperDllHandle <> 0 then
  begin
    FCnWizInetGetFile := TFuncCnWizInetGetFile(GetProcAddress(HelperDllHandle, 'CnWiz_Inet_GetFile'));
  end
  else
  begin
{$IFDEF DEBUG}
    CnDebugger.LogMsg('Load CnWizHelper.dll failed.');
{$ENDIF}
  end;

  if ZipDllHandle <> 0 then
  begin
    FCnWizStartZip := TProcCnWizStartZip(GetProcAddress(ZipDllHandle, 'CnWizStartZip'));
    FCnWizZipAddFile := TProcCnWizZipAddFile(GetProcAddress(ZipDllHandle, 'CnWizZipAddFile'));
    FCnWizZipSetComment := TProcCnWizZipSetComment(GetProcAddress(ZipDllHandle, 'CnWizZipSetComment'));
    FCnWizZipSaveAndClose := TFuncCnWizZipSaveAndClose(GetProcAddress(ZipDllHandle, 'CnWizZipSaveAndClose'));
  end
  else
  begin
{$IFDEF DEBUG}
    CnDebugger.LogMsg('Load CnZipUtils.dll failed.');
{$ENDIF}
  end;

{$IFDEF DEBUG}
  CnDebugger.LogBoolean(CnWizHelperZipValid, 'CnWizHelperZipValid');
  CnDebugger.LogBoolean(CnWizHelperInetValid, 'CnWizHelperInetValid');
{$ENDIF}
end;

procedure FreeWizHelperDll;
begin
  if HelperDllHandle <> 0 then
  begin
    FreeLibrary(HelperDllHandle);
    HelperDllHandle := 0;
  end;

  if ZipDllHandle <> 0 then
  begin
    FreeLibrary(ZipDllHandle);
    ZipDllHandle := 0;
  end;
end;  

function CnWizHelperLoaded: Boolean;
begin
  Result := HelperDllHandle <> 0;
end;

function CnWizZipUtilsLoaded: Boolean;
begin
  Result := ZipDllHandle <> 0;
end;

//------------------------------------------------------------------------------
// ZIP 
//------------------------------------------------------------------------------

function CnWizHelperZipValid: Boolean;
begin
  Result := CnWizZipUtilsLoaded and Assigned(FCnWizStartZip) and
    Assigned(FCnWizZipAddFile) and Assigned(FCnWizZipSetComment)
    and Assigned(FCnWizZipSaveAndClose);
end;  

procedure CnWizStartZip(const SaveFileName: PAnsiChar; const Password: PAnsiChar;
  RemovePath: Boolean); stdcall;
begin
  if CnWizHelperZipValid then
    FCnWizStartZip(SaveFileName, Password, RemovePath);
end;  

procedure CnWizZipAddFile(FileName, ArchiveFileName: PAnsiChar); stdcall;
begin
  if CnWizHelperZipValid then
    FCnWizZipAddFile(FileName, ArchiveFileName);
end;

procedure CnWizZipSetComment(Comment: PAnsiChar); stdcall;
begin
  if CnWizHelperZipValid then
    FCnWizZipSetComment(Comment);
end;

function CnWizZipSaveAndClose: Boolean; stdcall;
begin
  if CnWizHelperZipValid then
    Result := FCnWizZipSaveAndClose
  else
    Result := False;
end;

//------------------------------------------------------------------------------
// InetUtils 
//------------------------------------------------------------------------------

function CnWizHelperInetValid: Boolean;
begin
  Result := CnWizHelperLoaded and Assigned(FCnWizInetGetFile);
end;

function CnWiz_Inet_GetFile(AURL, FileName: PAnsiChar): Boolean; stdcall;
begin
  if CnWizHelperInetValid then
    Result := FCnWizInetGetFile(AURL, FileName)
  else
    Result := False;
end;  

initialization
  LoadWizHelperDll;

finalization
  FreeWizHelperDll;

end.
