{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnWizHelp;
{* |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* Ԫƣʾ̿ⵥԪ
* ԪߣCnPack 
*     ע
* ƽ̨PWinXP SP3 + Delphi 5.01
* ݲԣ
*   õԪеַϱػʽ
* ޸ļ¼2010.02.21 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

uses
  Windows, Messages, SysUtils, IniFiles, ShellAPI,
  CnCommon, CnLangMgr, CnWideStrings;

const
  csSection = 'CnWizards';

function GetFileFromLang(const FileName: string): string;

function ShowHelp(const Topic: string; const Section: string = csSection): Boolean;

implementation

const
  csCnWizOnlineHelpUrl = 'http://help.cnpack.org/cnwizards/';
  csLangPath = 'Lang\';
  csHelpPath = 'Help\';
  csWizHelpIniFile = 'Help.ini';

// ǰִģڵ·
function ModulePath: string;
var
  ModName: array[0..MAX_PATH] of Char;
begin
  SetString(Result, ModName, GetModuleFileName(HInstance, ModName, SizeOf(ModName)));
  Result := _CnExtractFilePath(Result);
end;

// ȡļ
function GetFileFromLang(const FileName: string): string;
begin
  if (CnLanguageManager.LanguageStorage <> nil) and
    (CnLanguageManager.LanguageStorage.CurrentLanguage <> nil) then
  begin
    Result := IncludeTrailingBackslash(ModulePath + csLangPath +
      CnLanguageManager.LanguageStorage.CurrentLanguage.LanguageDirName)
      + FileName;
  end
  else
  begin
    // Գʼʧܣ򷵻ӢĵݣΪĬϵĽӢĵ
    Result := ModulePath + csLangPath + '1033\' + FileName;
  end;
end;

// ȡ
function GetTopicHelpUrl(const Topic: string; const Section: string): string;
var
  FileName: string;
begin
  Result := '';
  FileName := GetFileFromLang(csWizHelpIniFile);

  if not FileExists(FileName) then
    Exit;
  with TCnWideMemIniFile.Create(FileName) do
  try
    Result := ReadString(Section, Topic, '');
  finally
    Free;
  end;
end;

// ȡǷ
function TopicHelpFileExists(Url: string): Boolean;
var
  I: Integer;
begin
  I := AnsiPos('::/', Url);
  if I > 0 then
  begin
    Delete(Url, I, MaxInt);
    Result := FileExists(ModulePath + csHelpPath + Url);
  end
  else
    Result := True;  
end;  

// ʾָİ
function ShowHelp(const Topic: string; const Section: string): Boolean;
var
  Url: string;
  Si: TStartupInfo;
  Pi: TProcessInformation;
begin
  Result := False;
  Url := GetTopicHelpUrl(Topic, Section);
  if Url <> '' then
  begin
    if TopicHelpFileExists(Url) then
    begin
      Url := 'mk:@MSITStore:' + ModulePath + csHelpPath + Url;
      ZeroMemory(@Si, SizeOf(Si));
      Si.cb := SizeOf(Si);
      ZeroMemory(@Pi, SizeOf(Pi));
      CreateProcess(nil, PChar('hh ' + Url),
        nil, nil, False, 0, nil, nil, Si, Pi);
      if Pi.hProcess <> 0 then CloseHandle(Pi.hProcess);
      if Pi.hThread <> 0 then CloseHandle(Pi.hThread);
    end
    else
      ShellExecute(0, nil, PChar(csCnWizOnlineHelpUrl + Url), nil, nil, SW_SHOWNORMAL);
    Result := True;
  end;
end;

end.
