{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnWidePasParser;
{* |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣPas Դ Unicode 汾
* Ԫߣܾ zjy@cnpack.org
*     עд CnPasCodeParserȥһĺ
* ƽ̨Win7 + Delphi 2009
* ݲԣ
*   õԪеַϱػʽ
* ޸ļ¼2022.02.06 V1.3
*               عֺӶԽַ Token ķ
*           2019.03.16 V1.2
*               ŻԻкĵŵ֧Լźǡǹؼʱ֧
*           2015.04.25 V1.1
*                WideString ʵ
*           2015.04.10
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

uses
  Windows, SysUtils, Classes, mPasLex, CnPasWideLex, mwBCBTokenList,
  Contnrs, CnFastList, CnPasCodeParser, CnContainers, CnIDEStrings;

type
  TCnWidePasToken = class(TPersistent)
  {* һ Token ĽṹϢ}
  private
    FEditAnsiCol: Integer;
    FTag: Integer;
    FBracketLayer: Integer;
    FTokenLength: Integer;
    function GetToken: PWideChar;
    function GetEditEndCol: Integer;
  protected
    FCppTokenKind: TCTokenKind;
    FCompDirectiveType: TCnCompDirectiveType;
    FCharIndex: Integer;
    FAnsiIndex: Integer;
    FEditCol: Integer;
    FEditLine: Integer;
    FItemIndex: Integer;
    FItemLayer: Integer;
    FLineNumber: Integer;
    FMethodLayer: Integer;
    FToken: array[0..CN_TOKEN_MAX_SIZE] of WideChar;
    FTokenID: TTokenKind;
    FTokenPos: Integer;
    FIsMethodStart: Boolean;
    FIsMethodClose: Boolean;
    FMethodStartAfterParentBegin: Boolean;
    FIsBlockStart: Boolean;
    FIsBlockClose: Boolean;
    FUseAsC: Boolean;
  public
    procedure Clear; virtual;

    property UseAsC: Boolean read FUseAsC;
    {* Ƿ C ʽĽĬϲ}
    property LineNumber: Integer read FLineNumber; // Start 0
    {* кţ㿪ʼ ParseSource }
    property CharIndex: Integer read FCharIndex;   // Start 0
    {* ӱпʼַλã㿪ʼ ParseSource ھչ Tab }
    property AnsiIndex: Integer read FAnsiIndex;   // Start 0
    {* ӱпʼ Ansi ַλã㿪ʼ}

    property EditCol: Integer read FEditCol write FEditCol;
    {* Token ʼλУһʼתһӦ EditPos}
    property EditLine: Integer read FEditLine write FEditLine;
    {* УһʼתһӦ EditPos}
    property EditAnsiCol: Integer read FEditAnsiCol write FEditAnsiCol;
    {* Token ʼλ Ansi УһʼתڻƵĳ}
    property EditEndCol: Integer read GetEditEndCol;
    {* Token λУEditCol תɹ}

    property ItemIndex: Integer read FItemIndex;
    {*  Parser е}
    property ItemLayer: Integer read FItemLayer;
    {* ڸĲΣ̡Լ飬ֱƸΣκοʱ㣩Ϊ 0}
    property MethodLayer: Integer read FMethodLayer;
    {* ںǶײΣĺΪ 1}
    property BracketLayer: Integer read FBracketLayer;
    {* ڵԲŵĲΣΪ 0ԲűӦһ㣨δʵ֣}
    property Token: PWideChar read GetToken;
    {*  Token ַ}
    property TokenLength: Integer read FTokenLength write FTokenLength;
    {*  Token ʵַȣעܴ Token ݳ}
    property TokenID: TTokenKind read FTokenID;
    {* Token ﷨}
    property CppTokenKind: TCTokenKind read FCppTokenKind;
    {* Ϊ C  Token ʹʱ CToken }
    property TokenPos: Integer read FTokenPos;
    {* Token ļеλãλΪַ}
    property IsBlockStart: Boolean read FIsBlockStart;
    {* ǷһƥĿʼ}
    property IsBlockClose: Boolean read FIsBlockClose;
    {* ǷһƥĽ}
    property IsMethodStart: Boolean read FIsMethodStart;
    {* ǷǺ̵Ŀʼ function  begin/asm }
    property IsMethodClose: Boolean read FIsMethodClose;
    {* ǷǺ̵Ľֻ end ˺ MethodStart }
    property MethodStartAfterParentBegin: Boolean read FMethodStartAfterParentBegin;
    {*  IsMethodStart  True  function/procedure  begin/asm ʱ
       Ƿλһ function/procedure  begin ʵֲ֡
       һ㣬һ begin ֮ǰʱΪ FalseʾǶ壬
       䲿еԴΪ True Դ}
    property CompDirectiveType: TCnCompDirectiveType read FCompDirectiveType write FCompDirectiveType;
    {*  Pascal ָʱϸͣⲿ}
    property Tag: Integer read FTag write FTag;
    {* Tag ǣⳡʹ}
  end;

//==============================================================================
// Pascal Unicode ļṹ
//==============================================================================

  { TCnPasStructureParser }

  TCnWidePasStructParser = class(TObject)
  {*  TCnPasWideLex ﷨õ Token λϢ}
  private
    FSupportUnicodeIdent: Boolean;
    FBlockCloseToken: TCnWidePasToken;
    FBlockStartToken: TCnWidePasToken;
    FChildMethodCloseToken: TCnWidePasToken;
    FChildMethodStartToken: TCnWidePasToken;
    FCurrentChildMethod: CnWideString;
    FCurrentMethod: CnWideString;
    FKeyOnly: Boolean;
    FList: TCnList;
    FMethodCloseToken: TCnWidePasToken;
    FMethodStartToken: TCnWidePasToken;
    FSource: CnWideString;
    FInnerBlockCloseToken: TCnWidePasToken;
    FInnerBlockStartToken: TCnWidePasToken;
    FUseTabKey: Boolean;
    FTabWidth: Integer;
    FMethodStack: TCnObjectStack;
    FBlockStack: TCnObjectStack;
    FMidBlockStack: TCnObjectStack;
    FProcStack: TCnObjectStack;
    FIfStack: TCnObjectStack;
    function GetCount: Integer;
    function GetToken(Index: Integer): TCnWidePasToken;
  protected
    procedure CalcCharIndexes(out ACharIndex: Integer; out AnAnsiIndex: Integer;
      Lex: TCnPasWideLex; Source: PWideChar);
    function NewToken(Lex: TCnPasWideLex; Source: PWideChar; CurrBlock: TCnWidePasToken = nil;
      CurrMethod: TCnWidePasToken = nil; CurrBracketLevel: Integer = 0): TCnWidePasToken;
  public
    constructor Create(SupportUnicodeIdent: Boolean = True);
    destructor Destroy; override;
    procedure Clear;

    procedure ParseSource(ASource: PWideChar; AIsDpr, AKeyOnly: Boolean);
    {* Դгɹؼʶ֮}
    function FindCurrentDeclaration(LineNumber, WideCharIndex: Integer): CnWideString;
    {* ָλڵLineNumber 1 ʼWideCharIndex 0 ʼ CharPos
       Ҫ WideChar ƫơD2005~2007 £CursorPos.Col  ConverPos õ
       Utf8  CharPos ƫƣ2009  ConverPos õҵ Ansi ƫƣֱá
       ǰҪת WideChar ƫƣֻܰ CursorPos.Col - 1  Ansi  CharIndex
       ת WideChar ƫ}
    procedure FindCurrentBlock(LineNumber, WideCharIndex: Integer);
    {* ָλڵĿ飬LineNumber 1 ʼWideCharIndex 0 ʼ CharPos
       Ҫ WideChar ƫơD2005~2007 £CursorPos.Col  ConverPos õ
       Utf8  CharPos ƫƣ2009  ConverPos õҵ Ansi ƫƣֱá
       ǰҪת WideChar ƫƣֻܰ CursorPos.Col - 1  Ansi  CharIndex
       ת WideChar ƫ}

    procedure ParseString(ASource: PWideChar);
    {* ԴַĽַֻ}

    function IndexOfToken(Token: TCnWidePasToken): Integer;
    property Count: Integer read GetCount;
    property Tokens[Index: Integer]: TCnWidePasToken read GetToken;
    property MethodStartToken: TCnWidePasToken read FMethodStartToken;
    {* ǰĹ̻}
    property MethodCloseToken: TCnWidePasToken read FMethodCloseToken;
    {* ǰĹ̻}
    property ChildMethodStartToken: TCnWidePasToken read FChildMethodStartToken;
    {* ǰڲĹ̻Ƕ׹̻}
    property ChildMethodCloseToken: TCnWidePasToken read FChildMethodCloseToken;
    {* ǰڲĹ̻Ƕ׹̻}
    property BlockStartToken: TCnWidePasToken read FBlockStartToken;
    {* ǰ}
    property BlockCloseToken: TCnWidePasToken read FBlockCloseToken;
    {* ǰ}
    property InnerBlockStartToken: TCnWidePasToken read FInnerBlockStartToken;
    {* ǰڲ}
    property InnerBlockCloseToken: TCnWidePasToken read FInnerBlockCloseToken;
    {* ǰڲ}
    property CurrentMethod: CnWideString read FCurrentMethod;
    {* ǰĹ̻}
    property CurrentChildMethod: CnWideString read FCurrentChildMethod;
    {* ǰڲĹ̻Ƕ׹̻}
    property Source: CnWideString read FSource;
    property KeyOnly: Boolean read FKeyOnly;
    {* Ƿֻؼ}

    property UseTabKey: Boolean read FUseTabKey write FUseTabKey;
    {* ǷŰ洦 Tab Ŀȣ粻 Tab Ϊ 1 
      עⲻܰ IDE ༭ "Use Tab Character" ֵֵ
      IDE ֻƴǷڰ Tab ʱ Tab ַÿոȫ}
    property TabWidth: Integer read FTabWidth write FTabWidth;
    {* Tab Ŀ}
  end;

procedure ParsePasCodePosInfoW(const Source: CnWideString; Line, Col: Integer;
  var PosInfo: TCodePosInfo; TabWidth: Integer = 2; FullSource: Boolean = True);
{* UNICODE µĽڴλãֻ D2009 
   Unicode òҲУLine/Col Ӧ View  CursorPosΪ 1 ʼ}

procedure ParseUnitUsesW(const Source: CnWideString; UsesList: TStrings;
  SupportUnicodeIdent: Boolean = False);
{* ԴõĵԪSoure  UTF16 ʽļݣδʹ}

implementation

type
  TCnProcObj = class
  {* һ procedure/function 壬}
  private
    FToken: TCnWidePasToken;
    FBeginToken: TCnWidePasToken;
    FNestCount: Integer;
    function GetIsNested: Boolean;
    function GetBeginMatched: Boolean;
    function GetLayer: Integer;
  public
    property Token: TCnWidePasToken read FToken write FToken;
    {* procedure/function ڵ Token}
    property Layer: Integer read GetLayer;
    {* procedure/function ڵ Token Ĳ}
    property BeginMatched: Boolean read GetBeginMatched;
    {*  procedure/function Ƿҵʵ begin}
    property BeginToken: TCnWidePasToken read FBeginToken write FBeginToken;
    {*  procedure/function ʵ begin}
    property IsNested: Boolean read GetIsNested;
    {*  procedure/function ǷǱǶ׶ģҲǷһ
       procedure/function ֣ʵ begin ֮ǰ}
    property NestCount: Integer read FNestCount write FNestCount;
    {*  procedure/function Ƕ׶ҲһǶ procedure/function Ĳ}
  end;

  TCnIfStatement = class
  {* һ If 䣬ܴ else if Լһ 0  elseڻ begin end}
  private
    FLevel: Integer;
    FIfStart: TCnWidePasToken;     // 洢 if 
    FIfBegin: TCnWidePasToken;     // 洢 if Ӧͬ begin
    FIfEnded: Boolean;             //  if Ƿ if 䣩
    FElseToken: TCnWidePasToken;   // 洢 else 
    FElseBegin: TCnWidePasToken;   // 洢 else Ӧͬ begin
    FElseEnded: Boolean;           //  else Ƿ
    FElseList: TObjectList;        // 洢 else if е else 
    FIfList: TObjectList;          // 洢 else if е if 
    FElseIfBeginList: TObjectList; // 洢 else if ĶӦ beginΪ
    FElseIfEnded: TList;           // 洢 else if Ƿıǣ1  0
    FIfAllEnded: Boolean;          //  if Ƿ
    function GetElseIfCount: Integer;
    function GetElseIfElse(Index: Integer): TCnWidePasToken;
    function GetElseIfIf(Index: Integer): TCnWidePasToken;
    function GetLastElseIfElse: TCnWidePasToken;
    function GetLastElseIfIf: TCnWidePasToken;
    procedure SetIfStart(const Value: TCnWidePasToken);
    function GetLastElseIfBegin: TCnWidePasToken;
    procedure SetFIfBegin(const Value: TCnWidePasToken);
    procedure SetElseBegin(const Value: TCnWidePasToken);
  public
    constructor Create; virtual;
    destructor Destroy; override;

    function HasElse: Boolean;
    {*  if Ƿе else}

    procedure ChangeElseToElseIf(AIf: TCnWidePasToken);
    {* һ else Ϊһ else if else ܵ if ʱ}
    procedure AddBegin(ABegin: TCnWidePasToken);
    {* жϺ󣬽 begin  Ifʵ else if » if ͷ}

    // ǰӿǣ
    // 1. ӿнӵ beginжӦε end
    // 2. ӿ޽ӵ beginͬεķֺţжϲףõǰǰжϹ򣩣
    // 3. ӿ޽ӵ beginһε endǰ޷ֺţ if then begin if then Close end; е Close 
    procedure EndLastElseIfBlock;
    {* һ else if Դ end ֺ}
    procedure EndElseBlock;
    {*  else Դ end ֺ}
    procedure EndIfBlock;
    {*  if  if 䣩Դ end ֺ}
    procedure EndIfAll;
    {*  if Դ end ֺ}

    property Level: Integer read FLevel write FLevel;
    {* if ĲΣҪ if Ĳ}
    property IfStart: TCnWidePasToken read FIfStart write SetIfStart;
    {* ȡ if ʼ Token Լһ Token Ϊ if ʼ Token}
    property IfBegin: TCnWidePasToken read FIfBegin write SetFIfBegin;
    {* ȡ if Ӧ begin  Token Լһ begin Ϊ if Ӧ begin}
    property ElseToken: TCnWidePasToken read FElseToken write FElseToken;
    {* ȡ if  else  Token Լһ Token Ϊ if  else  Token}
    property ElseBegin: TCnWidePasToken read FElseBegin write SetElseBegin;
    {* ȡ if  else Ӧ begin Լһ Token Ϊ else Ӧ begin  Token}
    property ElseIfCount: Integer read GetElseIfCount;
    {* ظ if  else if }
    property ElseIfElse[Index: Integer]: TCnWidePasToken read GetElseIfElse;
    {* ظ if  else if  else  Token 0  ElseIfCount - 1}
    property ElseIfIf[Index: Integer]: TCnWidePasToken read GetElseIfIf;
    {* ظ if  else if    Token 0  ElseIfCount - 1}
    property LastElseIfElse: TCnWidePasToken read GetLastElseIfElse;
    {* ظ if һ else if  else}
    property LastElseIfIf: TCnWidePasToken read GetLastElseIfIf;
    {* ظ if һ else if  if}
    property LastElseIfBegin: TCnWidePasToken read GetLastElseIfBegin;
    {* ظ if һ else if  beginеĻ}
    property IfAllEnded: Boolean read FIfAllEnded;
    {* ظ if ǷȫжϲӶջе}
  end;

var
  TokenPool: TCnList = nil;

function WideTrim(const S: CnWideString): CnWideString;
{$IFNDEF UNICODE}
var
  I, L: Integer;
{$ENDIF}
begin
{$IFDEF UNICODE}
  Result := Trim(S);
{$ELSE}
  L := Length(S);
  I := 1;
  while (I <= L) and (S[I] <= ' ') do Inc(I);
  if I > L then Result := '' else
  begin
    while S[L] <= ' ' do Dec(L);
    Result := Copy(S, I, L - I + 1);
  end;
{$ENDIF}
end;

// óطʽ PasTokens 
function CreatePasToken: TCnWidePasToken;
begin
  if TokenPool.Count > 0 then
  begin
    Result := TCnWidePasToken(TokenPool.Last);
    TokenPool.Delete(TokenPool.Count - 1);
  end
  else
    Result := TCnWidePasToken.Create;
end;

procedure FreePasToken(Token: TCnWidePasToken);
begin
  if Token <> nil then
  begin
    Token.Clear;
    TokenPool.Add(Token);
  end;
end;

procedure ClearTokenPool;
var
  I: Integer;
begin
  for I := 0 to TokenPool.Count - 1 do
    TObject(TokenPool[I]).Free;
end;

// NextNoJunk ֻעͣûָӴ˺ɹָ
procedure LexNextNoJunkWithoutCompDirect(Lex: TCnPasWideLex);
begin
  repeat
    Lex.Next;
  until not (Lex.TokenID in [tkSlashesComment, tkAnsiComment, tkBorComment, tkCRLF,
    tkCRLFCo, tkSpace, tkCompDirect]);
end;

//==============================================================================
// ṹ
//==============================================================================

{ TCnPasStructureParser }

constructor TCnWidePasStructParser.Create(SupportUnicodeIdent: Boolean);
begin
  inherited Create;
  FList := TCnList.Create;
  FTabWidth := 2;
  FSupportUnicodeIdent := SupportUnicodeIdent;

  FMethodStack := TCnObjectStack.Create;
  FBlockStack := TCnObjectStack.Create;
  FMidBlockStack := TCnObjectStack.Create;
  FProcStack := TCnObjectStack.Create;
  FIfStack := TCnObjectStack.Create;
end;

destructor TCnWidePasStructParser.Destroy;
begin
  Clear;
  FMethodStack.Free;
  FBlockStack.Free;
  FMidBlockStack.Free;
  FProcStack.Free;
  FIfStack.Free;
  FList.Free;
  inherited;
end;

procedure TCnWidePasStructParser.Clear;
var
  I: Integer;
begin
  for I := 0 to FList.Count - 1 do
    FreePasToken(TCnWidePasToken(FList[I]));
  FList.Clear;

  FMethodStartToken := nil;
  FMethodCloseToken := nil;
  FChildMethodStartToken := nil;
  FChildMethodCloseToken := nil;
  FBlockStartToken := nil;
  FBlockCloseToken := nil;
  FCurrentMethod := '';
  FCurrentChildMethod := '';
  FSource := '';
end;

function TCnWidePasStructParser.GetCount: Integer;
begin
  Result := FList.Count;
end;

function TCnWidePasStructParser.GetToken(Index: Integer): TCnWidePasToken;
begin
  Result := TCnWidePasToken(FList[Index]);
end;

procedure TCnWidePasStructParser.CalcCharIndexes(out ACharIndex: Integer;
  out AnAnsiIndex: Integer; Lex: TCnPasWideLex; Source: PWideChar);
var
  I, AnsiLen, WideLen: Integer;
begin
  if FUseTabKey and (FTabWidth >= 2) then
  begin
    // ǰݽ Tab չ
    I := Lex.LineStartOffset;
    AnsiLen := 0;
    WideLen := 0;
    while I < Lex.TokenPos do
    begin
      if (Source[I] = #09) then
      begin
        AnsiLen := ((AnsiLen div FTabWidth) + 1) * FTabWidth;
        WideLen := ((WideLen div FTabWidth) + 1) * FTabWidth;
        // TODO: Wide ַ Tab չǷ
      end
      else
      begin
        Inc(WideLen);
        if IDEWideCharIsWideLength(Source[I]) then
          Inc(AnsiLen, SizeOf(WideChar))
        else
          Inc(AnsiLen, SizeOf(AnsiChar));
      end;
      Inc(I);
    end;
    ACharIndex := WideLen;
    AnAnsiIndex := AnsiLen;
  end
  else
  begin
    ACharIndex := Lex.TokenPos - Lex.LineStartOffset;
    AnAnsiIndex := Lex.ColumnNumber - 1;
  end;
end;

function TCnWidePasStructParser.NewToken(Lex: TCnPasWideLex; Source: PWideChar;
  CurrBlock, CurrMethod: TCnWidePasToken; CurrBracketLevel: Integer): TCnWidePasToken;
var
  Len: Integer;
begin
  Result := CreatePasToken;
  Result.FTokenPos := Lex.TokenPos;

  Len := Lex.TokenLength;        
  Result.FTokenLength := Len;
  if Len > CN_TOKEN_MAX_SIZE then
    Len := CN_TOKEN_MAX_SIZE;

  Move(Lex.TokenAddr^, Result.FToken[0], Len * SizeOf(WideChar));
  Result.FToken[Len] := #0;

  Result.FLineNumber := Lex.LineNumber - 1;              // 1 ʼ 0 ʼ
  CalcCharIndexes(Result.FCharIndex, Result.FAnsiIndex, Lex, Source);
  // ֱʹ Column ֱкԣǾ Tab չҲ 1 ʼ 0 ʼ

  Result.FTokenID := Lex.TokenID;
  Result.FItemIndex := FList.Count;
  Result.Tag := 0;
  if CurrBlock <> nil then
    Result.FItemLayer := CurrBlock.FItemLayer;

  // CurrBlock  ItemLayer  MethodLayerû CurrBlock
  // ͵ÿ CurrMethod  MethodLayer ʼ Token  ItemLayer
  if CurrMethod <> nil then
  begin
    Result.FMethodLayer := CurrMethod.FMethodLayer;
    if CurrBlock = nil then
      Result.FItemLayer := CurrMethod.FMethodLayer;
  end;
  Result.FBracketLayer := CurrBracketLevel;
  FList.Add(Result);
end;

procedure TCnWidePasStructParser.ParseSource(ASource: PWideChar; AIsDpr, AKeyOnly:
  Boolean);
var
  Lex: TCnPasWideLex;
  Token, CurrMethod, CurrBlock, CurrMidBlock, CurrIfStart: TCnWidePasToken;
  Bookmark: TCnPasWideBookmark;
  IsClassOpen, IsClassDef, IsImpl, IsHelper, IsElseIf, ExpectElse: Boolean;
  IsRecordHelper, IsSealed, IsAbstract, IsRecord, IsObjectRecord, IsForFunc: Boolean;
  SameBlockMethod, CanEndBlock, CanEndMethod: Boolean;
  DeclareWithEndLevel, CurrBracketLevel: Integer;
  PrevTokenID: TTokenKind;
  PrevTokenStr: CnWideString;
  AProcObj, PrevProcObj: TCnProcObj;
  AIfObj: TCnIfStatement;

  procedure DiscardToken(Forced: Boolean = False);
  begin
    if (AKeyOnly or Forced) and (FList.Count > 0) then
    begin
      FreePasToken(FList[FList.Count - 1]);
      FList.Delete(FList.Count - 1);
    end;
  end;

  procedure ClearStackAndFreeObject(AStack: TCnObjectStack);
  begin
    if AStack = nil then
      Exit;

    while AStack.Count > 0 do
      AStack.Pop.Free;
  end;

begin
  Clear;
  Lex := nil;
  PrevTokenID := tkProgram;

  try
    FSource := ASource;
    FKeyOnly := AKeyOnly;

    FMethodStack.Clear;
    FBlockStack.Clear;
    FMidBlockStack.Clear;
    FProcStack.Clear;  // 洢 procedure/function ʵֵĹؼԼǶײ
    FIfStack.Clear;    // 洢 if ǶϢ

    Lex := TCnPasWideLex.Create(FSupportUnicodeIdent);
    Lex.Origin := PWideChar(ASource);

    DeclareWithEndLevel := 0; // Ƕ׵Ҫ end Ķ
    CurrMethod := nil;        // ǰ Token ڵķ procedure/function 
    CurrBlock := nil;         // ǰ Token ڵĿ
    CurrMidBlock := nil;
    CurrBracketLevel := 0;
    IsImpl := AIsDpr;
    IsHelper := False;
    IsRecordHelper := False;
    ExpectElse := False;

    while Lex.TokenID <> tkNull do
    begin
      // һֵĽжǷܽ if 䣬עָ
      if ExpectElse and not (Lex.TokenID in [tkElse, tkCompDirect]) and not FIfStack.IsEmpty then
        FIfStack.Pop.Free;
      ExpectElse := False;

      if {IsImpl and } (Lex.TokenID in [tkCompDirect]) or // Allow CompDirect
        ((not (PrevTokenID in [tkAmpersand, tkAddressOp])) and (Lex.TokenID in
        [tkProcedure, tkFunction, tkConstructor, tkDestructor, tkOperator,
        tkInitialization, tkFinalization,
        tkBegin, tkAsm,
        tkCase, tkTry, tkRepeat, tkIf, tkFor, tkWith, tkOn, tkWhile,
        tkRecord, tkObject, tkOf, tkEqual,
        tkClass, tkInterface, tkDispinterface,
        tkExcept, tkFinally, tkElse,
        tkEnd, tkUntil, tkThen, tkDo])) then
      begin
        Token := NewToken(Lex, ASource, CurrBlock, CurrMethod, CurrBracketLevel);
        case Lex.TokenID of
          tkProcedure, tkFunction, tkConstructor, tkDestructor, tkOperator:
            begin
              //  procedure/function Ͷ壬ǰ = 
              // Ҳ procedure/function ǰ : 
              // Ҳǰ to
              // һҪʵ֣ǰ := ֵ ( , ܲȫ
              if IsImpl and ((not (Lex.TokenID in [tkProcedure, tkFunction]))
                or (not (PrevTokenID in [tkEqual, tkColon, tkTo{, tkAssign, tkRoundOpen, tkComma}])))
                and (DeclareWithEndLevel <= 0) then
              begin
                // DeclareWithEndLevel <= 0 ʾֻ class/record ڲ
                if CurrBlock = nil then
                  Token.FItemLayer := 0
                else
                  Token.FItemLayer := CurrBlock.ItemLayer;
                Token.FIsMethodStart := True;

                if CurrMethod <> nil then
                begin
                  Token.FMethodLayer := CurrMethod.FMethodLayer + 1;
                  FMethodStack.Push(CurrMethod);
                end
                else
                  Token.FMethodLayer := 1;
                CurrMethod := Token;

                //  procedure/function ʵʱջ¼Σ Layer ɼ¼
                if FProcStack.IsEmpty then
                  PrevProcObj := nil
                else
                  PrevProcObj := TCnProcObj(FProcStack.Peek);

                AProcObj := TCnProcObj.Create;
                AProcObj.Token := Token;
                FProcStack.Push(AProcObj);

                // ǰ procedure  procedure  begin Ƕ
                // û procedureǶףĬ 0
                if PrevProcObj <> nil then
                begin
                  if PrevProcObj.BeginMatched then
                    Token.FMethodStartAfterParentBegin := True
                  else
                    AProcObj.NestCount := PrevProcObj.NestCount + 1;
                end;
              end;
            end;
          tkInitialization, tkFinalization:
            begin
              while FBlockStack.Count > 0 do
                FBlockStack.Pop;
              CurrBlock := nil;
              while FMethodStack.Count > 0 do
                FMethodStack.Pop;
              CurrMethod := nil;
            end;
          tkBegin, tkAsm:
            begin
              Token.FIsBlockStart := True;
              // ᵼ CurrBlock  CurrMethod ϵȷ
              //  CurrBlock ڣҪȷԶ CurrMethod begin  MethodStart
              if (CurrMethod <> nil) and ((CurrBlock = nil) or
                (CurrBlock.ItemIndex < CurrMethod.ItemIndex)) then
                Token.FIsMethodStart := True;

              // ҵ CurrBlock  CurrMethod ܸ CurrBlock һ
              // Ҫ Method һ
              if (CurrBlock <> nil) and ((CurrMethod = nil) or (CurrMethod.ItemIndex < CurrBlock.ItemIndex)) then
                Token.FItemLayer := CurrBlock.FItemLayer + 1
              else if CurrMethod <> nil then //  Block  Block  Method ⣬Ƚһ
                Token.FItemLayer := CurrMethod.FItemLayer + 1
              else // Ƿں
                Token.FItemLayer := 0;

              FBlockStack.Push(CurrBlock);
              CurrBlock := Token; // begin/asm ȿ CurrBlockҲ CurrMethod ĶӦ begin/asm

              //  begin/asm  procedure/function ͬʱĽ
              if FProcStack.Count > 0 then
              begin
                AProcObj := TCnProcObj(FProcStack.Peek);
                if (AProcObj.Token <> nil) and Token.FIsMethodStart then
                begin
                  //  Proc  begin 󣩣 begin ҲҪ¼
                  Token.FMethodStartAfterParentBegin := AProcObj.Token.FMethodStartAfterParentBegin;
                end;

                if not AProcObj.BeginMatched then
                begin
                  // ǰ Proc Ƕ׺ʱbegin Ҫ procedure/function ֱǶײ
                  if AProcObj.IsNested then
                    Inc(Token.FItemLayer, AProcObj.NestCount);

                  // ¼׵ begin/asm 
                  AProcObj.BeginToken := Token;
                end;
              end;

              // ж begin Ƿ֮ǰ if  else if
              if (Lex.TokenID = tkBegin) and (PrevTokenID in [tkThen, tkElse]) and not FIfStack.IsEmpty then
              begin
                AIfObj := TCnIfStatement(FIfStack.Peek);
                if AIfObj.Level = Token.ItemLayer then
                  AIfObj.AddBegin(Token);
              end;
            end;
          tkCase:
            begin
              if (CurrBlock = nil) or (CurrBlock.TokenID <> tkRecord) then
              begin
                Token.FIsBlockStart := True;
                if CurrBlock <> nil then
                begin
                  Token.FItemLayer := CurrBlock.FItemLayer + 1;
                  FBlockStack.Push(CurrBlock);
                end
                else
                  Token.FItemLayer := 0;
                CurrBlock := Token;
              end
              else
                DiscardToken(True);
            end;
          tkTry, tkRepeat, tkIf, tkFor, tkWith, tkOn, tkWhile,
          tkRecord, tkObject:
            begin
              IsRecord := Lex.TokenID = tkRecord;
              IsObjectRecord := Lex.TokenID = tkObject;
              IsForFunc := (PrevTokenID in [tkPoint]) or
                ((PrevTokenID = tkSymbol) and (PrevTokenStr = '&'));
              if IsRecord then
              begin
                //  record helper for Σimplementationendᱻ
                // record ڲ function/procedure ɵ޽
                Lex.SaveToBookmark(Bookmark);

                LexNextNoJunkWithoutCompDirect(Lex);
                IsRecordHelper := Lex.TokenID = tkHelper;

                Lex.LoadFromBookmark(Bookmark);
              end;

              // of object  object Ӧøڴ˴޳

              //  of object ǰ @@ ͵ label 
              //  IsRecord Ϊ Lex.RunPos ָTokenID ܻ
              if ((Lex.TokenID <> tkObject) or (PrevTokenID <> tkOf))
                and not (PrevTokenID in [tkAt, tkDoubleAddressOp])
                and not IsForFunc        //  TParalle.For Լ .&For ֺ
                and not ((Lex.TokenID = tkFor) and (IsHelper or IsRecordHelper)) then
                //  helper е for
              begin
                Token.FIsBlockStart := True;
                if CurrBlock <> nil then
                begin
                  Token.FItemLayer := CurrBlock.FItemLayer + 1;
                  FBlockStack.Push(CurrBlock);
                  if (CurrBlock.TokenID = tkTry) and (Token.TokenID = tkTry)
                    and (CurrMidBlock <> nil) then
                  begin
                    FMidBlockStack.Push(CurrMidBlock);
                    CurrMidBlock := nil;
                  end;
                end
                else
                  Token.FItemLayer := 0;

                CurrBlock := Token;

                if IsRecord or IsObjectRecord then
                begin
                  // ¼ recordΪ record ں begin end ֮ end
                  // IsInDeclareWithEnd := True;
                  Inc(DeclareWithEndLevel);
                end;
              end;

              if Lex.TokenID = tkFor then
              begin
                if IsHelper then
                  IsHelper := False;
                if IsRecordHelper then
                  IsRecordHelper := False;
              end;

              //  if  else if 
              if Lex.TokenID = tkIf then
              begin
                IsElseIf := False;
                if PrevTokenID = tkElse then
                begin
                  //  else ifҵ AIfObj else ĳ else if
                  if not FIfStack.IsEmpty then
                  begin
                    AIfObj := TCnIfStatement(FIfStack.Peek);
                    //  if  if ͬԤ case else if then end 
                    if AIfObj.Level = Token.ItemLayer then
                    begin
                      AIfObj.ChangeElseToElseIf(Token);
                      IsElseIf := True;
                    end;
                  end;
                end;

                if not IsElseIf then // ǵ if¼ if ʼλòջ
                begin
                  AIfObj := TCnIfStatement.Create;
                  AIfObj.IfStart := Token;
                  FIfStack.Push(AIfObj);
                end;
              end;
            end;
          tkClass, tkInterface, tkDispInterface:
            begin
              IsHelper := False;
              IsSealed := False;
              IsAbstract := False;
              IsClassDef := ((Lex.TokenID = tkClass) and Lex.IsClass)
                or ((Lex.TokenID = tkInterface) and Lex.IsInterface) or
                (Lex.TokenID = tkDispInterface);

              //  classdef  class helper for TObject 
              if not IsClassDef and (Lex.TokenID = tkClass) and not Lex.IsClass then
              begin
                Lex.SaveToBookmark(Bookmark);

                LexNextNoJunkWithoutCompDirect(Lex);
                if Lex.TokenID in [tkHelper, tkSealed, tkAbstract] then
                begin
                  IsClassDef := True;
                  IsHelper := Lex.TokenID = tkHelper;
                  IsSealed := Lex.TokenID = tkSealed;
                  IsAbstract := Lex.TokenID = tkAbstract;
                end;

                Lex.LoadFromBookmark(Bookmark);
              end;

              IsClassOpen := False;
              if IsClassDef then
              begin
                IsClassOpen := True;
                Lex.SaveToBookmark(Bookmark);

                LexNextNoJunkWithoutCompDirect(Lex);
                if Lex.TokenID = tkSemiColon then // Ǹ class; Ҫ end;
                  IsClassOpen := False
                else if IsHelper or IsSealed or IsAbstract then
                  LexNextNoJunkWithoutCompDirect(Lex);

                if Lex.TokenID = tkRoundOpen then // ţǲ();
                begin
                  while not (Lex.TokenID in [tkNull, tkRoundClose]) do
                    LexNextNoJunkWithoutCompDirect(Lex);
                  if Lex.TokenID = tkRoundClose then
                    LexNextNoJunkWithoutCompDirect(Lex);
                end;

                if Lex.TokenID = tkSemiColon then
                  IsClassOpen := False
                else if Lex.TokenID = tkFor then
                  IsClassOpen := True;

                Lex.LoadFromBookmark(Bookmark);
              end;

              if IsClassOpen then // кݣҪһ end
              begin
                Token.FIsBlockStart := True;
                if CurrBlock <> nil then
                begin
                  Token.FItemLayer := CurrBlock.FItemLayer + 1;
                  FBlockStack.Push(CurrBlock);
                end
                else
                  Token.FItemLayer := 0;

                CurrBlock := Token;
                // ֲҪ end β
                // IsInDeclareWithEnd := True;
                Inc(DeclareWithEndLevel);
              end
              else // Ӳ޲ unit  interface Լ class procedure ȱ
                DiscardToken(Token.TokenID in [tkClass, tkInterface, tkDispinterface]);
            end;
          tkExcept, tkFinally:
            begin
              if (CurrBlock = nil) or (CurrBlock.TokenID <> tkTry) then
                DiscardToken
              else if CurrMidBlock = nil then
              begin
                CurrMidBlock := Token;
              end
              else
                DiscardToken;
            end;
          tkElse:
            begin
              // ж else ڽϽ if 黹ǽ case ȿǸ⡣
              //  else ʱ if then ѾCurrBlock ifԵöһ CurrIfStart
              CurrIfStart := nil;
              if not FIfStack.IsEmpty then
              begin
                AIfObj := TCnIfStatement(FIfStack.Peek);
                if AIfObj.IfStart <> nil then
                  CurrIfStart := AIfObj.IfStart;
              end;

              // else ǰԲǷֺţж PrevToken Ƿֺ
              if (CurrBlock = nil) or (PrevTokenID in [tkAt, tkDoubleAddressOp]) then
                DiscardToken
              else if (CurrBlock.TokenID = tkTry) and (CurrMidBlock <> nil) and
                (CurrMidBlock.TokenID = tkExcept) and
                ((CurrIfStart = nil) or (CurrIfStart.ItemIndex <= CurrBlock.ItemIndex)) then
                Token.FItemLayer := CurrBlock.FItemLayer    // try except else end  if һ
              else if (CurrBlock.TokenID = tkCase) and
                ((CurrIfStart = nil) or (CurrIfStart.ItemIndex <= CurrBlock.ItemIndex))then
                Token.FItemLayer := CurrBlock.FItemLayer    // case of е else  if һ
              else if not FIfStack.IsEmpty then // ԣ else Ӧڵǰ if 
              begin
                AIfObj := TCnIfStatement(FIfStack.Peek);
                Token.FItemLayer := AIfObj.Level;
                if not AIfObj.HasElse then
                  AIfObj.ElseToken := Token;
              end;
            end;
          tkEnd, tkUntil, tkThen, tkDo:
            begin
              if (CurrBlock <> nil) and not (PrevTokenID in [tkPoint, tkAt, tkDoubleAddressOp]) then
              begin
                if ((Lex.TokenID = tkUntil) and (CurrBlock.TokenID <> tkRepeat))
                  or ((Lex.TokenID = tkThen) and (CurrBlock.TokenID <> tkIf))
                  or ((Lex.TokenID = tkDo) and not (CurrBlock.TokenID in
                  [tkOn, tkWhile, tkWith, tkFor])) then
                begin
                  DiscardToken;
                end
                else
                begin
                  // ⲿֹؼΣֻһС patch
                  Token.FItemLayer := CurrBlock.FItemLayer;
                  Token.FIsBlockClose := True;
                  if (CurrBlock.TokenID = tkTry) and (CurrMidBlock <> nil) then
                  begin
                    if FMidBlockStack.Count > 0 then
                      CurrMidBlock := TCnWidePasToken(FMidBlockStack.Pop)
                    else
                      CurrMidBlock := nil;
                  end;

                  // End ȿԽ Block ҲԽ procedureûбȻȺ˳Ҫĸ
                  // ң CurrBlock  CurrMethod  begin/asm End Ҫͬʱ
                  CanEndBlock := False;
                  CanEndMethod := False;
                  if (CurrBlock = nil) and (CurrMethod = nil) then
                  begin
                    CanEndBlock := False;
                    CanEndMethod := False;
                  end
                  else if (CurrBlock = nil) and (CurrMethod <> nil) then
                  begin
                    CanEndBlock := False;
                    CanEndMethod := True;
                  end
                  else if (CurrBlock <> nil) and (CurrMethod = nil) then
                  begin
                    CanEndBlock := True;
                    CanEndMethod := False;
                  end
                  else if (CurrBlock <> nil) and (CurrMethod <> nil) then
                  begin
                    // ж CurrBlock ǲ CurrMethod Ӧ beginܽ
                    SameBlockMethod := False;
                    if not FProcStack.IsEmpty then
                    begin
                      AProcObj := TCnProcObj(FProcStack.Peek);
                      if (AProcObj.Token = CurrMethod) and (AProcObj.BeginToken = CurrBlock) then
                        SameBlockMethod := True;
                    end;

                    if SameBlockMethod then
                    begin
                      CanEndMethod := True;
                      CanEndBlock := True;
                    end
                    else
                    begin
                      CanEndBlock := CurrBlock.ItemIndex >= CurrMethod.ItemIndex;
                      CanEndMethod := CurrMethod.ItemIndex >= CurrBlock.ItemIndex;
                    end;
                  end;

                  if CanEndBlock or (Lex.TokenID <> tkEnd) then // ֱӽ CurrBlockEnd ҪҲ CurrBlock
                  begin
                  if FBlockStack.Count > 0 then
                  begin
                    CurrBlock := TCnWidePasToken(FBlockStack.Pop);
                  end
                  else
                  begin
                    CurrBlock := nil;
                    end;
                  end;

                  if CanEndMethod and (Lex.TokenID = tkEnd) then  //  End Ҫ CurrMethod
                  begin
                    if (CurrMethod <> nil) and (DeclareWithEndLevel <= 0) then
                    begin
                      Token.FIsMethodClose := True;
                      Token.FMethodStartAfterParentBegin := CurrMethod.MethodStartAfterParentBegin;
                      if FMethodStack.Count > 0 then
                        CurrMethod := TCnWidePasToken(FMethodStack.Pop)
                      else
                        CurrMethod := nil;
                    end;
                  end;
                end;
              end
              else // Ӳ޲ unit  End Ҳ
                DiscardToken(Token.TokenID = tkEnd);

              if (DeclareWithEndLevel > 0) and (Lex.TokenID = tkEnd) then // ˾ֲ
                Dec(DeclareWithEndLevel);

              if Lex.TokenID = tkEnd then
              begin
                //  end  procedure/function Ԫͬ
                if FProcStack.Count > 0 then
                begin
                  AProcObj := TCnProcObj(FProcStack.Peek);
                  if AProcObj.BeginMatched and (AProcObj.Layer = Token.ItemLayer) then
                    FProcStack.Pop.Free;
                end;

                //  if Ӧϵ begin end Ĺϵ
                if not FIfStack.IsEmpty then
                begin
                  AIfObj := TCnIfStatement(FIfStack.Peek);
                  if (AIfObj.LastElseIfBegin <> nil) and
                    (AIfObj.LastElseIfBegin.ItemLayer = Token.ItemLayer) then
                  begin
                    //  end  if һ else if  begin ԣʾ else if 
                    AIfObj.EndLastElseIfBlock;
                    ExpectElse := True;
                    // һ else if 
                  end
                  else if (AIfObj.ElseBegin <> nil) and (AIfObj.ElseBegin.ItemLayer = Token.ItemLayer) then
                  begin
                    //  end  if еĶ else е begin ԣʾ else ͬʱ if 
                    AIfObj.EndElseBlock;
                    AIfObj.EndIfAll;
                  end
                  else if (AIfObj.IfBegin <> nil) and (AIfObj.IfBegin.ItemLayer = Token.ItemLayer) then
                  begin
                    //  end  if е begin ԣʾ if  if 䣩
                    AIfObj.EndIfBlock;
                    ExpectElse := True;
                    // һ else if 
                  end
                  else if (AIfObj.LastElseIfBegin = nil) and (AIfObj.LastElseIfIf <> nil) and
                    (AIfObj.LastElseIfIf.ItemLayer > Token.ItemLayer) then
                  begin
                    //  end  if һ begin  else if end֮ǰ޷ֺţͬʱ if
                    AIfObj.EndLastElseIfBlock;
                    AIfObj.EndIfAll;
                  end
                  else if (AIfObj.ElseBegin = nil) and (AIfObj.ElseToken <> nil) and
                    (AIfObj.ElseToken.ItemLayer > Token.ItemLayer) then
                  begin
                    //  end  if  begin  else end֮ǰ޷ֺţͬʱ if
                    AIfObj.EndElseBlock;
                    AIfObj.EndIfAll;
                  end
                  else if (AIfObj.IfBegin = nil) and (AIfObj.IfStart.ItemLayer > Token.ItemLayer) then
                  begin
                    //  end  if  begin  if end֮ǰ޷ֺţͬʱ if
                    AIfObj.EndIfBlock;
                    AIfObj.EndIfAll;
                  end;

                  if AIfObj.FIfAllEnded then
                    FIfStack.Pop.Free;
                end;
              end;
            end;
        end;
      end
      else
      begin
        if not IsImpl and (Lex.TokenID = tkImplementation) then
          IsImpl := True;

        if (Lex.TokenID = tkSemicolon) and not FIfStack.IsEmpty then
        begin
          repeat
            if FIfStack.Count <= 0 then
               Break;
            AIfObj := TCnIfStatement(FIfStack.Peek);
            if AIfObj = nil then
              Break;

            // ֺţ˭עⲻ TokenΪûԷֺŴ Token
            // ֺŵ ItemLayer Ŀǰûпֵ˲ ItemLayer  if  Level Ƚϡ
            // ֺڶԲͷ˵Ϊã˼ CurrBracketLevel ж
            // FList.Count Ϊֺż ItemIndex
            // һ CurrBlock ڣûк if  else  else  begin˵ֺŽ else ͬ
            //  CurrBlock ڣûкһ else if  if begin˵ֺŽһ else if ͬ
            //  CurrBlock ڣûк if if û begin˵ֺŽ if ͬ
            if CurrBlock <> nil then
            begin
              if AIfObj.HasElse and (AIfObj.ElseBegin = nil) and
                (CurrBlock.ItemIndex <= AIfObj.ElseToken.ItemIndex) and
                (CurrBracketLevel = AIfObj.ElseToken.BracketLayer) then  // ֺŽ begin  else
              begin
                AIfObj.EndElseBlock;
                AIfObj.EndIfAll;
              end
              else if (AIfObj.ElseIfCount > 0) and (AIfObj.LastElseIfBegin = nil)
                and (AIfObj.LastElseIfIf <> nil) and
                (CurrBlock.ItemIndex <= AIfObj.LastElseIfIf.ItemIndex) and
                (CurrBracketLevel = AIfObj.LastElseIfIf.BracketLayer) then
              begin
                AIfObj.EndLastElseIfBlock;       // ֺŽ begin һ else if
                AIfObj.EndIfAll;
              end
              else if (AIfObj.IfBegin = nil) and
                (CurrBlock.ItemIndex <= AIfObj.IfStart.ItemIndex) and
                (CurrBracketLevel = AIfObj.IfStart.BracketLayer) then  // ֺŽ begin  if 
              begin
                AIfObj.EndIfBlock;
                AIfObj.EndIfAll;
              end;

              // ֺŽ if 䣬ԴӶջе
              if AIfObj.IfAllEnded then
                FIfStack.Pop.Free
              else // ֺδܽǰ if 䣬˵ǽģѭ
                Break;

              // ע⣬ֺŽ if һ if βͣҲһ if 
              // ͵Ӿ if True then if True then Test; ķֺʵϽ if
              // ʱѭķʽȷö
            end
            else
              Break;
          until False;
        end;

        if (CurrMethod <> nil) and // forward, external ʵֲ֣ǰǷֺ
          (Lex.TokenID in [tkForward, tkExternal]) and (PrevTokenID = tkSemicolon) then
        begin
          CurrMethod.FIsMethodStart := False;
          if AKeyOnly and (CurrMethod.FItemIndex = FList.Count - 1) then
          begin
            FreePasToken(FList[FList.Count - 1]);
            FList.Delete(FList.Count - 1);
          end;
          if FMethodStack.Count > 0 then
            CurrMethod := TCnWidePasToken(FMethodStack.Pop)
          else
            CurrMethod := nil;

          if FProcStack.Count > 0 then
          begin
            AProcObj := TCnProcObj(FProcStack.Pop);
            AProcObj.Free;
          end;
        end;

        // Ҫʱͨʶӣ& ıʶҲ
        if not AKeyOnly and ((PrevTokenID <> tkAmpersand) or (Lex.TokenID = tkIdentifier)) then
          NewToken(Lex, ASource, CurrBlock, CurrMethod, CurrBracketLevel);
      end;

      if Lex.TokenID = tkRoundOpen then
        Inc(CurrBracketLevel)
      else if Lex.TokenID = tkRoundClose then
        Dec(CurrBracketLevel);

      if Lex.TokenID <> tkCompDirect then // ָӦɱָӰĽ
      begin
        PrevTokenID := Lex.TokenID;
        PrevTokenStr := Lex.Token;
      end;

      Lex.NextNoJunk;
    end;
  finally
    Lex.Free;
    FMethodStack.Clear;
    FBlockStack.Clear;
    FMidBlockStack.Clear;
    ClearStackAndFreeObject(FProcStack);
    ClearStackAndFreeObject(FIfStack);
  end;
end;

procedure TCnWidePasStructParser.FindCurrentBlock(LineNumber, WideCharIndex:
  Integer);
var
  Token: TCnWidePasToken;
  CurrIndex: Integer;

  procedure _BackwardFindDeclarePos;
  var
    Level: Integer;
    I, NestedProcs: Integer;
    StartInner: Boolean;
  begin
    Level := 0;
    StartInner := True;
    NestedProcs := 1;
    for I := CurrIndex - 1 downto 0 do
    begin
      Token := Tokens[I];
      if Token.IsBlockStart then
      begin
        if StartInner and (Level = 0) then
        begin
          FInnerBlockStartToken := Token;
          StartInner := False;
        end;

        if Level = 0 then
          FBlockStartToken := Token
        else
          Dec(Level);
      end
      else if Token.IsBlockClose then
      begin
        Inc(Level);
      end;

      if Token.IsMethodStart then
      begin
        if Token.TokenID in [tkProcedure, tkFunction, tkConstructor, tkDestructor] then
        begin
          //  procedure Ӧ begin  MethodStartҪ
          Dec(NestedProcs);
          if (NestedProcs = 0) and (FChildMethodStartToken = nil) then
            FChildMethodStartToken := Token;
          if Token.MethodLayer = 1 then
          begin
            FMethodStartToken := Token;
            Exit;
          end;
        end
        else if Token.TokenID in [tkBegin, tkAsm] then
        begin
          // ڿǶ̵ĵʱ
        end;
      end
      else if Token.IsMethodClose then
        Inc(NestedProcs);

      if Token.TokenID in [tkImplementation] then
      begin
        Exit;
      end;
    end;
  end;

  procedure _ForwardFindDeclarePos;
  var
    Level: Integer;
    I, NestedProcs: Integer;
    EndInner: Boolean;
  begin
    Level := 0;
    EndInner := True;
    NestedProcs := 1;
    for I := CurrIndex to Count - 1 do
    begin
      Token := Tokens[I];
      if Token.IsBlockClose then
      begin
        if EndInner and (Level = 0) then
        begin
          FInnerBlockCloseToken := Token;
          EndInner := False;
        end;

        if Level = 0 then
          FBlockCloseToken := Token
        else
          Dec(Level);
      end
      else if Token.IsBlockStart then
      begin
        Inc(Level);
      end;

      if Token.IsMethodClose then
      begin
        Dec(NestedProcs);
        if Token.MethodLayer = 1 then //  Layer Ϊ 1 ģȻ
        begin
          FMethodCloseToken := Token;
          Exit;
        end
        else if (NestedProcs = 0) and (FChildMethodCloseToken = nil) then
          FChildMethodCloseToken := Token;
          // ͬεģ ChildMethodClose
      end
      else if Token.IsMethodStart and (Token.TokenID in [tkProcedure, tkFunction,
        tkConstructor, tkDestructor]) then
      begin
        Inc(NestedProcs);
      end;

      if Token.TokenID in [tkInitialization, tkFinalization] then
      begin
        Exit;
      end;
    end;
  end;

  procedure _FindInnerBlockPos;
  var
    I, Level: Integer;
  begin
    // ˺ _ForwardFindDeclarePos  _BackwardFindDeclarePos 
    if (FInnerBlockStartToken <> nil) and (FInnerBlockCloseToken <> nil) then
    begin
      // һ˳
      if FInnerBlockStartToken.ItemLayer = FInnerBlockCloseToken.ItemLayer then
        Exit;
      // ·ٽ Block ܲβһҪҸһεģΪ׼

      if FInnerBlockStartToken.ItemLayer > FInnerBlockCloseToken.ItemLayer then
        Level := FInnerBlockCloseToken.ItemLayer
      else
        Level := FInnerBlockStartToken.ItemLayer;

      for I := CurrIndex - 1 downto 0 do
      begin
        Token := Tokens[I];
        if Token.IsBlockStart and (Token.ItemLayer = Level) then
          FInnerBlockStartToken := Token;
      end;
      for i := CurrIndex to Count - 1 do
      begin
        Token := Tokens[i];
        if Token.IsBlockClose and (Token.ItemLayer = Level) then
          FInnerBlockCloseToken := Token;
      end;
    end;
  end;

  function _GetMethodName(StartToken, CloseToken: TCnWidePasToken): CnWideString;
  var
    I: Integer;
  begin
    Result := '';
    if Assigned(StartToken) and Assigned(CloseToken) then
      for I := StartToken.ItemIndex + 1 to CloseToken.ItemIndex do
      begin
        Token := Tokens[I];
        if I = StartToken.ItemIndex + 1 then
        begin
          // ж procedure/function һǷ ( var begin asm ;֮ģǣ˵
          if Token.TokenID in [tkVar, tkBegin, tkAsm, tkRoundOpen, tkSemiColon] then
          begin
            Result := '<anonymous>';
            Exit;
          end;
        end;

        if (Token.Token^ = '(') or (Token.Token^ = ':') or (Token.Token^ = ';') then
          Break;
        Result := Result + WideTrim(Token.Token);
      end;
  end;

begin
  FMethodStartToken := nil;
  FMethodCloseToken := nil;
  FChildMethodStartToken := nil;
  FChildMethodCloseToken := nil;
  FBlockStartToken := nil;
  FBlockCloseToken := nil;
  FInnerBlockCloseToken := nil;
  FInnerBlockStartToken := nil;
  FCurrentMethod := '';
  FCurrentChildMethod := '';

  CurrIndex := 0;
  while CurrIndex < Count do
  begin
    // ǰߴ 0 ʼߴ 1 ʼҪ 1
    if (Tokens[CurrIndex].LineNumber > LineNumber - 1) then
      Break;

    // ݲͬʼ TokenжҲͬ
    if Tokens[CurrIndex].LineNumber = LineNumber - 1 then
    begin
      if (Tokens[CurrIndex].TokenID in [tkBegin, tkAsm, tkTry, tkRepeat, tkIf,
        tkFor, tkWith, tkOn, tkWhile, tkCase, tkRecord, tkObject, tkClass,
        tkInterface, tkDispInterface]) and
        (Tokens[CurrIndex].CharIndex > WideCharIndex ) then // ʼж
        Break
      else if (Tokens[CurrIndex].TokenID in [tkEnd, tkUntil, tkThen, tkDo]) and
        (Tokens[CurrIndex].CharIndex + Length(Tokens[CurrIndex].Token) > WideCharIndex ) then
        Break;  //ж
    end;

    Inc(CurrIndex);
  end;

  if (CurrIndex > 0) and (CurrIndex < Count) then
  begin
    _BackwardFindDeclarePos;
    _ForwardFindDeclarePos;

    _FindInnerBlockPos;
    if not FKeyOnly then
    begin
      FCurrentMethod := _GetMethodName(FMethodStartToken, FMethodCloseToken);
      FCurrentChildMethod := _GetMethodName(FChildMethodStartToken, FChildMethodCloseToken);
    end;
  end;
end;

function TCnWidePasStructParser.IndexOfToken(Token: TCnWidePasToken): Integer;
begin
  Result := FList.IndexOf(Token);
end;

function TCnWidePasStructParser.FindCurrentDeclaration(LineNumber,
  WideCharIndex: Integer): CnWideString;
var
  Idx: Integer;
begin
  Result := '';
  FindCurrentBlock(LineNumber, WideCharIndex);

  if InnerBlockStartToken <> nil then
  begin
    if InnerBlockStartToken.TokenID in [tkClass, tkInterface, tkRecord,
      tkDispInterface, tkObject] then
    begin
      // ǰҵȺǰıʶ
      Idx := IndexOfToken(InnerBlockStartToken);
      if Idx > 3 then
      begin
        if (InnerBlockStartToken.TokenID = tkRecord)
          and (Tokens[Idx - 1].TokenID = tkPacked) then
          Dec(Idx);
        if Tokens[Idx - 1].TokenID = tkEqual then
          Dec(Idx);
        if Tokens[Idx - 1].TokenID = tkIdentifier then
          Result := Tokens[Idx - 1].Token;
      end;
    end;
  end;
end;

procedure TCnWidePasStructParser.ParseString(ASource: PWideChar);
var
  Lex: TCnPasWideLex;
begin
  Clear;
  Lex := nil;

  try
    FSource := ASource;

    Lex := TCnPasWideLex.Create(FSupportUnicodeIdent);
    Lex.Origin := PWideChar(ASource);

    while Lex.TokenID <> tkNull do
    begin
      if Lex.TokenID in [tkString] then
        NewToken(Lex, ASource);

      Lex.NextNoJunk;
    end;
  finally
    Lex.Free;
  end;
end;

procedure ParsePasCodePosInfoW(const Source: CnWideString; Line, Col: Integer;
  var PosInfo: TCodePosInfo; TabWidth: Integer; FullSource: Boolean);
var
  IsProgram: Boolean;
  InClass: Boolean;
  IsAfterProcBegin: Boolean;
  ProcStack: TStack;
  ProcIndent: Integer;
  SavePos: TCodePosKind;
  Lex: TCnPasWideLex;
  ExpandCol: Integer;
  MyTokenID: TTokenKind;
  Bookmark: TCnPasWideBookmark;

  function LexStillBeforeCursor: Boolean;
  begin
    if Lex.LineNumber < Line then
      Result := True
    else if Lex.LineNumber > Line then
      Result := False
    else if Lex.LineNumber = Line then
      Result := ExpandCol < Col
    else
      Result := False;
  end;

  procedure DoNext(NoJunk: Boolean = False);
  begin
    PosInfo.LastIdentPos := Lex.LastIdentPos;
    PosInfo.LastNoSpace := Lex.LastNoSpace;
    PosInfo.LastNoSpacePos := Lex.LastNoSpacePos;
    PosInfo.LineNumber := Lex.LineNumber - 1; //  1 ʼɴ 0 ʼ
    PosInfo.LinePos := Lex.LineStartOffset;
    PosInfo.TokenPos := Lex.TokenPos;
    PosInfo.Token := AnsiString(Lex.Token);
    PosInfo.TokenID := Lex.TokenID;
    if NoJunk then
      Lex.NextNoJunk
    else
      Lex.Next;

    if Lex.LineNumber = Line then
    begin
      if Lex.TokenID = tkCRLF then
        ExpandCol := 1  // Lex  ColumnNumber ڻʱ
      else
      begin
        // TODO: ǵǰУչ Tab
        // ѵǰ Token չ Col  ExpandCol

        ExpandCol := Lex.ColumnNumber;
      end;
    end
    else
    begin
      if Lex.TokenID = tkCRLF then // Lex  ColumnNumber ڻʱ
        ExpandCol := 1
      else
        ExpandCol := Lex.ColumnNumber;
    end;
  end;

begin
  Lex := nil;
  ProcStack := nil;
  Bookmark := nil;
  PosInfo.IsPascal := True;

  try
    Lex := TCnPasWideLex.Create;
    ProcStack := TStack.Create;
    Lex.Origin := PWideChar(Source);

    if FullSource then
    begin
      PosInfo.AreaKind := akHead;
      PosInfo.PosKind := pkUnknown;
    end
    else
    begin
      PosInfo.AreaKind := akImplementation;
      PosInfo.PosKind := pkUnknown;
    end;
    SavePos := pkUnknown;
    IsProgram := False;
    InClass := False;
    IsAfterProcBegin := False;
    ProcIndent := 0;
    ExpandCol := Lex.ColumnNumber;

    // ༭ڵ Line/Col  1 ʼ
    // ɺ Lex  1 ʼ LineNumber/ColumnNumber Ƚ
    // ͬʱLex Ҫȶһн Tab չ
    while (Lex.TokenID <> tkNull) and LexStillBeforeCursor do
    begin
      MyTokenID := Lex.TokenID;

      // С޲źĶ̹ؼҪͨʶܱ pkField
      if (Lex.LastNoSpace = tkPoint) and (Lex.TokenID in [tkTo, tkIn, tkOf, tkOn, tkIs, tkDo]) then
        MyTokenID := tkIdentifier;

      // С޲ (.  .) ᱻ﷨ţ߶ԵӰ
      if (Lex.TokenID = tkSquareClose) and (Lex.Token = '.)') then
        MyTokenID := tkPoint;

      case MyTokenID of
        tkUnit:
          begin
            IsProgram := False;
            PosInfo.AreaKind := akUnit;
            PosInfo.PosKind := pkFlat;
          end;
        tkProgram, tkLibrary:
          begin
            IsProgram := True;
            PosInfo.AreaKind := akProgram;
            PosInfo.PosKind := pkFlat;
          end;
        tkInterface:
          begin
            if (PosInfo.AreaKind in [akUnit, akProgram]) and not IsProgram then
            begin
              PosInfo.AreaKind := akInterface;
              PosInfo.PosKind := pkFlat;
            end
            else if Lex.IsInterface then
            begin
              PosInfo.PosKind := pkInterface;
              DoNext(True);
              if LexStillBeforeCursor and (Lex.TokenID = tkSemiColon) then
                PosInfo.PosKind := pkTypeDecl
              else if LexStillBeforeCursor and (Lex.TokenID = tkRoundOpen) then
              begin
                while LexStillBeforeCursor and not (Lex.TokenID in
                  [tkNull, tkRoundClose]) do
                  DoNext;
                if LexStillBeforeCursor and (Lex.TokenID = tkRoundClose) then
                begin
                  DoNext(True);
                  if LexStillBeforeCursor and (Lex.TokenID = tkSemiColon) then
                    PosInfo.PosKind := pkTypeDecl;
                end;
              end;
              if PosInfo.PosKind = pkInterface then
                InClass := True;
            end;
          end;
        tkUses:
          begin
            if PosInfo.AreaKind in [akProgram, akInterface] then
            begin
              PosInfo.AreaKind := akIntfUses;
              PosInfo.PosKind := pkIntfUses;
            end
            else if PosInfo.AreaKind = akImplementation then
            begin
              PosInfo.AreaKind := akImplUses;
              PosInfo.PosKind := pkIntfUses;
            end;
            if PosInfo.AreaKind in [akIntfUses, akImplUses] then
            begin
              while LexStillBeforeCursor and not (Lex.TokenID in [tkNull, tkSemiColon]) do
                DoNext;
              if LexStillBeforeCursor and (Lex.TokenID = tkSemiColon) then
              begin
                if PosInfo.AreaKind = akIntfUses then
                  PosInfo.AreaKind := akInterface
                else
                  PosInfo.AreaKind := akImplementation;
                PosInfo.PosKind := pkFlat;
              end;
            end;
          end;
        tkImplementation:
          if not IsProgram then
          begin
            PosInfo.AreaKind := akImplementation;
            PosInfo.PosKind := pkFlat;
          end;
        tkInitialization:
          begin
            PosInfo.AreaKind := akInitialization;
            PosInfo.PosKind := pkFlat;
          end;
        tkFinalization:
          begin
            PosInfo.AreaKind := akFinalization;
            PosInfo.PosKind := pkFlat;
          end;
// ´ F[''].All; ֺźλôر pkStringע͵δ֪
//        tkSquareClose:
//          if (Lex.Token = '.)') and (Lex.LastNoSpace in [tkIdentifier,
//            tkPointerSymbol, tkSquareClose, tkRoundClose]) then
//          begin
//            if not (PosInfo.PosKind in [pkFieldDot, pkField]) then
//              SavePos := PosInfo.PosKind;
//            PosInfo.PosKind := pkFieldDot;
//          end;
        tkPoint:
          if Lex.LastNoSpace = tkEnd then
          begin
            PosInfo.AreaKind := akEnd;
            PosInfo.PosKind := pkUnknown;
          end
          else if Lex.LastNoSpaceCRLF in [tkIdentifier, tkPointerSymbol, {$IFDEF DelphiXE3_UP} tkString, {$ENDIF} // Delphi XE3 Supports function invoke on string
            tkSquareClose, tkRoundClose] then
          begin
            //  LastNoSpaceCRLF жϣΪ˱⼶еĵ㱻Ϊ pkProcedure֤ pkField
            //  GetObject()
            //      .Hide()
            //      .Show() 
            if not (PosInfo.PosKind in [pkFieldDot, pkField]) then
              SavePos := PosInfo.PosKind;
            PosInfo.PosKind := pkFieldDot;
          end;
        tkAnsiComment, tkBorComment, tkSlashesComment:
          begin
            if PosInfo.PosKind <> pkComment then
            begin
              SavePos := PosInfo.PosKind;
              PosInfo.PosKind := pkComment;
            end;
          end;
        tkClass:
          begin
            if Lex.IsClass then
            begin
              PosInfo.PosKind := pkClass;
              DoNext(True);
              if LexStillBeforeCursor and (Lex.TokenID = tkSemiColon) then
                PosInfo.PosKind := pkTypeDecl
              else if LexStillBeforeCursor and (Lex.TokenID = tkRoundOpen) then
              begin
                while LexStillBeforeCursor and not (Lex.TokenID in
                  [tkNull, tkRoundClose]) do
                  DoNext;
                if LexStillBeforeCursor and (Lex.TokenID = tkRoundClose) then
                begin
                  DoNext(True);
                  if LexStillBeforeCursor and (Lex.TokenID = tkSemiColon) then
                    PosInfo.PosKind := pkTypeDecl
                  else
                  begin
                    InClass := True;
                    Continue;
                  end;
                end;
              end
              else
              begin
                InClass := True;
                Continue;
              end;
            end
            else
            begin
              Lex.SaveToBookmark(Bookmark);
              DoNext(True);
              if LexStillBeforeCursor and (Lex.TokenID in [tkSealed, tkStrict,
                tkPrivate, tkProtected, tkPublic, tkPublished, tkHelper, tkClass,
                tkVar, tkConst, tkType, tkProperty]) then
              begin
                PosInfo.PosKind := pkClass;
                InClass := True;
                Continue;
              end
              else
              begin
                // ǣҪָö DoNext һ
                Lex.LoadFromBookmark(Bookmark);
              end;
            end;
          end;
        tkType:
          PosInfo.PosKind := pkType;
        tkConst:
          if not InClass then
            PosInfo.PosKind := pkConst;
        tkResourceString:
          PosInfo.PosKind := pkResourceString;
        tkVar:
          if not InClass then
            PosInfo.PosKind := pkVar;
        tkCompDirect:
          begin
            if PosInfo.PosKind <> pkCompDirect then
            begin
              SavePos := PosInfo.PosKind;
              PosInfo.PosKind := pkCompDirect;
            end;
          end;
        tkString, tkMultiLineString:
          begin
            if PosInfo.PosKind <> pkString then
            begin
              SavePos := PosInfo.PosKind;
              PosInfo.PosKind := pkString;
            end;
          end;
        tkIdentifier, tkMessage, tkRead, tkWrite, tkDefault, tkIndex:
          if (Lex.LastNoSpace = tkPoint) and (PosInfo.PosKind = pkFieldDot) then
          begin
            PosInfo.PosKind := pkField;
          end;
        tkProcedure, tkFunction, tkConstructor, tkDestructor:
          begin
            if not InClass and (PosInfo.AreaKind in [akProgram, akImplementation]) then
            begin
              ProcIndent := 0;
              if Lex.TokenID = tkProcedure then
                PosInfo.PosKind := pkProcedure
              else if Lex.TokenID = tkFunction then
                PosInfo.PosKind := pkFunction
              else if Lex.TokenID = tkConstructor then
                PosInfo.PosKind := pkConstructor
              else
                PosInfo.PosKind := pkDestructor;
              ProcStack.Push(Pointer(PosInfo.PosKind));
              IsAfterProcBegin := False;
            end;
            // todo: ĺ
          end;
        tkBegin, tkTry, tkCase, tkAsm, tkRecord:
          begin
            if (ProcStack.Count > 0) or ((ProcStack.Count = 0) and IsProgram and (MyTokenID = tkBegin)) then
            begin
              Inc(ProcIndent);
              if ProcStack.Count = 0 then // ʾ program  library  begin
                PosInfo.PosKind := pkProcedure
              else
                PosInfo.PosKind := TCodePosKind(ProcStack.Peek);
              IsAfterProcBegin := True;
            end;

            if MyTokenID = tkRecord then
            begin
              PosInfo.PosKind := pkClass; // Record Ҳ class ǣж class
              DoNext(True);
              if LexStillBeforeCursor and (Lex.TokenID = tkSemiColon) then
                PosInfo.PosKind := pkTypeDecl
              else if LexStillBeforeCursor and (Lex.TokenID = tkRoundOpen) then
              begin
                while LexStillBeforeCursor and not (Lex.TokenID in
                  [tkNull, tkRoundClose]) do
                  DoNext;
                if LexStillBeforeCursor and (Lex.TokenID = tkRoundClose) then
                begin
                  DoNext(True);
                  if LexStillBeforeCursor and (Lex.TokenID = tkSemiColon) then
                    PosInfo.PosKind := pkTypeDecl
                  else
                  begin
                    InClass := True;
                    Continue;
                  end;
                end;
              end
              else
              begin
                InClass := True;
                Continue;
              end;
            end;
          end;
        tkEnd:
          begin
            if InClass then
            begin
              PosInfo.PosKind := pkType;
              InClass := False;
            end
            else if ProcStack.Count > 0 then
            begin
              Dec(ProcIndent);
              if ProcIndent <= 0 then
              begin
                ProcStack.Pop;
                PosInfo.PosKind := pkFlat;
                IsAfterProcBegin := False;
              end;
            end;
          end;
        tkColon:
          begin
            if PosInfo.PosKind = pkVar then    // жǷ͵ var Str: string 
              PosInfo.PosKind := pkVarType
            else if PosInfo.PosKind = pkConst then
              PosInfo.PosKind := pkConstTypeValue;
          end;
        tkEqual:
          begin
            if PosInfo.PosKind = pkConst then
              PosInfo.PosKind := pkConstTypeValue
            else if PosInfo.PosKind = pkType then
              PosInfo.PosKind := pkTypeDecl
            else if PosInfo.PosKind = pkField then // ȺŽ Field
              PosInfo.PosKind := SavePos;
          end;
        tkAssign:
          begin
            if PosInfo.PosKind = pkVar then    // жǷ͵ var K := 1 ƶ
              PosInfo.PosKind := pkVarType;

            // Field ֵҲҪ
            if PosInfo.PosKind in [pkCompDirect, pkComment, pkField] then
              PosInfo.PosKind := SavePos;
          end;
        tkSemiColon:
          begin
            if PosInfo.PosKind in [pkString, pkCompDirect, pkComment] then // Ȼԭ
              PosInfo.PosKind := SavePos;

            if PosInfo.PosKind = pkVarType then
            begin
              // жǷ procedure Ӧ begin ָ pkProcedure 
              if IsAfterProcBegin and (ProcStack.Count > 0) then
                PosInfo.PosKind := TCodePosKind(ProcStack.Peek)
              else
                PosInfo.PosKind := pkVar;
            end
            else if PosInfo.PosKind = pkConstTypeValue then
              PosInfo.PosKind := pkConst
            else if PosInfo.PosKind = pkTypeDecl then
              PosInfo.PosKind := pkType;
          end;
      else
        if PosInfo.PosKind in [pkCompDirect, pkComment, pkString, pkField,
          pkFieldDot] then
          PosInfo.PosKind := SavePos;
      end;

      DoNext;
    end;
  finally
    Lex.Free;
    Bookmark.Free; // ѱ LoadΪ nilˣظ Free
    ProcStack.Free;
  end;
end;

// ԴõĵԪ
procedure ParseUnitUsesW(const Source: CnWideString; UsesList: TStrings;
  SupportUnicodeIdent: Boolean);
var
  Lex: TCnPasWideLex;
  Flag: Integer;
  S: CnWideString;
begin
  UsesList.Clear;
  Lex := TCnPasWideLex.Create(SupportUnicodeIdent);

  Flag := 0;
  S := '';
  try
    Lex.Origin := PWideChar(Source);
    while Lex.TokenID <> tkNull do
    begin
      if Lex.TokenID in [tkUses, tkContains] then
      begin
        while not (Lex.TokenID in [tkNull, tkSemiColon]) do
        begin
          Lex.Next;
          if Lex.TokenID = tkIdentifier then
          begin
            S := S + CnWideString(Lex.Token);
          end
          else if Lex.TokenID = tkPoint then
          begin
            S := S + '.';
          end
          else if Trim(S) <> '' then
          begin
            UsesList.AddObject(S, TObject(Flag));
            S := '';
          end;
        end;
      end
      else if Lex.TokenID = tkImplementation then
      begin
        Flag := 1;
        //  Flag ʾ interface  implementation
      end;
      Lex.Next;
    end;
  finally
    Lex.Free;
  end;
end;

{ TCnWidePasToken }

procedure TCnWidePasToken.Clear;
begin
  FCppTokenKind := TCTokenKind(0);
  FCompDirectiveType := TCnCompDirectiveType(0);
  FCharIndex := 0;
  FAnsiIndex := 0;
  FEditCol := 0;
  FEditLine := 0;
  FItemIndex := 0;
  FItemLayer := 0;
  FLineNumber := 0;
  FMethodLayer := 0;
  FToken[0]:= #0;
  FTokenID := TTokenKind(0);
  FTokenPos := 0;
  FIsMethodStart := False;
  FIsMethodClose := False;
  FIsBlockStart := False;
  FIsBlockClose := False;
  FTag := 0;
end;

function TCnWidePasToken.GetEditEndCol: Integer;
begin
  Result := EditCol + Length(Token); // TODO: Ҫ Ansi/Utf8/Ansi ģֱ Wide 
end;

function TCnWidePasToken.GetToken: PWideChar;
begin
  Result := @FToken[0];
end;

{ TCnIfStatement }

procedure TCnIfStatement.AddBegin(ABegin: TCnWidePasToken);
begin
  if ABegin = nil then
    Exit;

  if HasElse then                         //  else ˵ else Ӧ begin
    FElseBegin := ABegin
  else if FElseIfBeginList.Count > 0 then //  else if ˵һ else if Ӧ begin
    FElseIfBeginList[FElseIfBeginList.Count - 1] := ABegin
  else
    FIfBegin := ABegin;                   //  if Ӧ begin
end;

procedure TCnIfStatement.ChangeElseToElseIf(AIf: TCnWidePasToken);
begin
  if (FElseToken = nil) or (AIf = nil) then
    Exit;

  FElseList.Add(FElseToken);
  FIfList.Add(AIf);
  FElseIfBeginList.Add(nil);
  FElseIfEnded.Add(nil);
  FElseToken := nil;
end;

constructor TCnIfStatement.Create;
begin
  inherited;
  FLevel := -1;
  FElseList := TObjectList.Create(False);
  FIfList := TObjectList.Create(False);
  FElseIfBeginList := TObjectList.Create(False);
  FElseIfEnded := TList.Create;
end;

destructor TCnIfStatement.Destroy;
begin
  FElseIfEnded.Free;
  FElseIfBeginList.Free;
  FIfList.Free;
  FElseList.Free;
  inherited;
end;

procedure TCnIfStatement.EndElseBlock;
begin
  if FElseToken <> nil then
    FElseEnded := True;
end;

procedure TCnIfStatement.EndIfAll;
begin
  if FIfStart <> nil then
    FIfAllEnded := True;
end;

procedure TCnIfStatement.EndIfBlock;
begin
  if FIfStart <> nil then
    FIfEnded := True;
end;

procedure TCnIfStatement.EndLastElseIfBlock;
begin
  if ElseIfCount > 0 then
    FElseIfEnded[FElseIfEnded.Count - 1] := Pointer(Ord(True));
end;

function TCnIfStatement.GetElseIfCount: Integer;
begin
  Result := FElseList.Count;
end;

function TCnIfStatement.GetElseIfElse(Index: Integer): TCnWidePasToken;
begin
  Result := TCnWidePasToken(FElseList[Index]);
end;

function TCnIfStatement.GetElseIfIf(Index: Integer): TCnWidePasToken;
begin
  Result := TCnWidePasToken(FIfList[Index]);
end;

function TCnIfStatement.GetLastElseIfBegin: TCnWidePasToken;
begin
  Result := nil;
  if FElseIfBeginList.Count > 0 then
    Result := TCnWidePasToken(FElseIfBeginList[FElseIfBeginList.Count - 1]);
end;

function TCnIfStatement.GetLastElseIfElse: TCnWidePasToken;
begin
  Result := nil;
  if FElseList.Count > 0 then
    Result := TCnWidePasToken(FElseList[FElseList.Count - 1]);
end;

function TCnIfStatement.GetLastElseIfIf: TCnWidePasToken;
begin
  Result := nil;
  if FIfList.Count > 0 then
    Result := TCnWidePasToken(FIfList[FIfList.Count - 1]);
end;

function TCnIfStatement.HasElse: Boolean;
begin
  Result := FElseToken <> nil;
end;

procedure TCnIfStatement.SetElseBegin(const Value: TCnWidePasToken);
begin
  FElseBegin := Value;
end;

procedure TCnIfStatement.SetFIfBegin(const Value: TCnWidePasToken);
begin
  FIfBegin := Value;
end;

procedure TCnIfStatement.SetIfStart(const Value: TCnWidePasToken);
begin
  FIfStart := Value;
  if Value <> nil then
    FLevel := Value.ItemLayer
  else
    FLevel := -1;
end;

{ TCnProcObj }

function TCnProcObj.GetIsNested: Boolean;
begin
  Result := FNestCount > 0;
end;

function TCnProcObj.GetBeginMatched: Boolean;
begin
  Result := FBeginToken <> nil;
end;

function TCnProcObj.GetLayer: Integer;
begin
  if FBeginToken <> nil then
    Result := FBeginToken.ItemLayer
  else
    Result := -1;
end;

initialization
  TokenPool := TCnList.Create;

finalization
  ClearTokenPool;
  FreeAndNil(TokenPool);

end.
