{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnSourceCropper;
{ |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣԴעɾģ
* ԪߣCnPack  master@cnpack.org
*     עԴעͽģ
* ƽ̨Windows 2000 + Delphi 5
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеֱַ֧ػʽ
* ޸ļ¼2022.02.28 V1.2
*               עǰûհףԶһո
*           2003.07.29 V1.1
*               ӱԶʽע͵Ĺ
*           2003.06.15 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

{$IFDEF CNWIZARDS_CNCOMMENTCROPPERWIZARD}

uses
  Classes, SysUtils;

type
  TCnCropSourceTokenKind = (skUndefined, skCode, skBlockComment, skLineComment,
    skQuoteString, skDittoString, skDirective, skTodoList, skToReserve);

  TCnCropOption = (coAll, coExAscii);

type
  TCnSourceCropper = class
  private
    FCurTokenKind: TCnCropSourceTokenKind;
    FCurChar: AnsiChar;

    FCropTodoList: Boolean;
    FCropDirective: Boolean;
    FCropOption: TCnCropOption;
    FInStream: TStream;
    FOutStream: TStream;
    FReserve: Boolean;
    FReserveItems: TStringList;
    FRemoveSingleLineSlashes: Boolean;
    procedure SetInStream(const Value: TStream);
    procedure SetOutStream(const Value: TStream);
    procedure SetReserveItems(const Value: TStringList);
  protected
    procedure DoParse; virtual; abstract;
    procedure ProcessToBlockEnd; virtual; abstract;

    function IsTodoList: Boolean;
    function IsReserved: Boolean;
    function IsBlank(AChar: AnsiChar): Boolean;

    function GetCurChar: AnsiChar;
    function NextChar(Value: Integer = 1): AnsiChar;
    function PrevChar(Value: Integer = 1): AnsiChar;
    procedure WriteChar(Value: AnsiChar);
    procedure BackspaceChars(Values: Integer = 1); // ˸ɾе n ַ
    procedure BackspaceOneCRLF; // еĩַ CRLF ɾ

    procedure ProcessToLineEnd(SpCount: Integer = 0; IsWholeLineSpace: Boolean = False); // ĲǸעǰո
    procedure DoDefaultProcess;
    procedure DoBlockEndProcess;
  public
    procedure Parse;
    constructor Create; virtual;
    destructor Destroy; override;
  published
    property InStream: TStream read FInStream write SetInStream;
    {* Ҫ Ansi  Utf8 ʽ AnsiString}
    property OutStream: TStream read FOutStream write SetOutStream;
    {* ǶӦ Ansi  Utf8 ʽ AnsiString}
    property CropOption: TCnCropOption read FCropOption write FCropOption;
    property CropDirective: Boolean read FCropDirective write FCropDirective;
    property CropTodoList: Boolean read FCropTodoList write FCropTodoList;
    property RemoveSingleLineSlashes: Boolean read FRemoveSingleLineSlashes write FRemoveSingleLineSlashes;
    {*  // עռʱǷ񽫸һɾֻȫɾʱЧ}
    property Reserve: Boolean read FReserve write FReserve;
    property ReserveItems: TStringList read FReserveItems write SetReserveItems;
    {* Ƿضʽע }
  end;

type
  TCnPasCropper = class(TCnSourceCropper)
  private

  protected
    procedure DoParse; override;
    procedure ProcessToBlockEnd; override;
    procedure ProcessToBracketBlockEnd;
  public

  published

  end;

type
  TCnCppCropper = class(TCnSourceCropper)
  private

  protected
    procedure DoParse; override;
    procedure ProcessToBlockEnd; override;
  public

  published

  end;

{$ENDIF CNWIZARDS_CNCOMMENTCROPPERWIZARD}

implementation

{$IFDEF CNWIZARDS_CNCOMMENTCROPPERWIZARD}

{ TCnSourceCropper }

const
  SCnToDo = 'TODO';
  SCnToDoDone = 'DONE';
  SCnCRLFSpacesChars: set of AnsiChar = [#0, #9, ' ', #13, #10];
  SCnSpacesChars: set of AnsiChar = [#9, ' '];
  SCnCRLFChars: set of AnsiChar = [#13, #10];

constructor TCnSourceCropper.Create;
begin
  inherited;
  FReserveItems := TStringList.Create;
end;

procedure TCnSourceCropper.BackspaceChars(Values: Integer);
begin
  if (OutStream <> nil) and (Values > 0) then
    if OutStream.Size > Values then
      OutStream.Size := OutStream.Size - Values;
end;

destructor TCnSourceCropper.Destroy;
begin
  FReserveItems.Free;
  inherited;
end;

procedure TCnSourceCropper.DoBlockEndProcess;
begin
  case FCurTokenKind of
  skBlockComment: // עֻͣɾչ ASCII ַС 128 ʱд
    if (FCropOption = coExAscii) and (FCurChar < #128) then
      WriteChar(FCurChar);
  skDirective: // ڱָֻвָʱдʱע
    if not CropDirective or
      ((FCropOption = coExAscii) and (FCurChar < #128)) then
      WriteChar(FCurChar);
  skTodoList: //  todoֻв todo ʱдʱע
     if not CropTodoList or
      ((FCropOption = coExAscii) and (FCurChar < #128)) then
      WriteChar(FCurChar);
  skToReserve:
    if FReserve then
      WriteChar(FCurChar);
  else
    DoDefaultProcess;
  end;
end;

procedure TCnSourceCropper.DoDefaultProcess;
begin
  if (FCropOption = coAll) or (FCurChar < #128) then
    WriteChar(FCurChar);
end;

// һַָָһ
function TCnSourceCropper.GetCurChar: AnsiChar;
begin
  Result := #0;
  if Assigned(FInStream) then
  begin
    try
      FInStream.Read(Result, SizeOf(AnsiChar));
    except
      Exit;
    end;
  end;
end;

function TCnSourceCropper.IsBlank(AChar: AnsiChar): Boolean;
begin
  Result := AChar in [' ', #13, #10, #7, #9];
end;

function TCnSourceCropper.IsReserved: Boolean;
var
  I: Integer;
  OldChar: AnsiChar;
  OldPos: Integer;
  MaxLen: Integer;
  PBuf: PChar;
  SToCompare: String;
begin
  // жǷڱбеĶҲжǷӦñ
  Result := False;
  if FInStream = nil then Exit;

  PBuf := nil;
  OldChar := FCurChar;
  OldPos := FInStream.Position;

  MaxLen := 0;
  for I := FReserveItems.Count - 1 downto 0 do
  begin
    if MaxLen < Length(FReserveItems.Strings[I]) then
      MaxLen := Length(FReserveItems.Strings[I]);
    if FReserveItems.Strings[I] = '' then
      FReserveItems.Delete(I);
  end;

  if (FCurChar = '/') or (FCurChar = '(') then
  begin
    FCurChar := GetCurChar;
    if FCurChar <> '*' then
      Exit;
  end;
  // ʱ FCurChar ָעͿʼŵһֽڣ{  /*  *  (*  *

  try
    PBuf := StrAlloc(MaxLen + 1);
    FillChar(PBuf^, Length(PBuf), 0);
    FInStream.Read(PBuf^, MaxLen);

    for I := 0 to FReserveItems.Count - 1 do
    begin
      SToCompare := Copy(StrPas(PBuf), 1, Length(FReserveItems.Strings[I]));
      if SToCompare = FReserveItems.Strings[I] then
      begin
        Result := True;
        Exit;
      end;
    end;
  finally
    FCurChar := OldChar;
    FInStream.Position := OldPos;
    if PBuf <> nil then
      StrDispose(PBuf);
  end;
end;

function TCnSourceCropper.IsTodoList: Boolean;
var
  OldPos: Integer;
  OldChar: AnsiChar;
  PTodo: PChar;
  STodo: String;
begin
  // (*  {  // ޿հ Todo  Done޿ոðţǺϷ TodoList.
  // ʱFCurChar  '{' '(*'  '(' '/*' е '/' '//' еĵһ '/'

  Result := False;
  if FInStream = nil then Exit;

  PTodo := nil;
  OldChar := FCurChar;
  OldPos := FInStream.Position;
  try
    if (FCurChar = '/') or (FCurChar = '(') then
    begin
      FCurChar := GetCurChar;
      if (FCurChar <> '*') and (FCurChar <> '/') then
        Exit;
    end;
    // ʱ FCurChar ָעͿʼŵһֽڣ{  /*  *  (*  *  // ĵڶ /

    while IsBlank(NextChar) do
      FCurChar := GetCurChar;
    // ʱ FCurChar ָעвΪյĵһַǰһַ{*

    PTodo := StrAlloc(Length(SCnToDo) + 1);
    FillChar(PTodo^, Length(PTodo), 0);
    FInStream.Read(PTodo^, Length(SCnToDo));
    STodo := Copy(UpperCase(StrPas(PTodo)), 1, 4);

    if (STodo = SCnTodo) or (STodo = SCnTodoDone) then
    begin
      // ʱָָ todo һַ
      while IsBlank(NextChar) do
        FCurChar := GetCurChar;
        
      if NextChar = ':' then
      begin
        Result := True;
        Exit;
      end
    end;

  finally
    FCurChar := OldChar;
    FInStream.Position := OldPos;
    if PTodo <> nil then
      StrDispose(PTodo);
  end;
end;

// һַָλò䣬Ȼڵǰַĺһλá
function TCnSourceCropper.NextChar(Value: Integer): AnsiChar;
begin
  Result := #0;
  if Assigned(FInStream) then
  begin
    try
      FInStream.Seek(Value - 1, soFromCurrent);
      FInStream.Read(Result, SizeOf(AnsiChar));
      FInStream.Seek(-Value, soFromCurrent);
    except
      Exit;
    end;
  end;
end;

procedure TCnSourceCropper.Parse;
begin
  if (FInStream <> nil) and (FOutStream <> nil) then
  begin
    if (FInStream.Size > 0) then
    begin
      FInStream.Position := 0;
      FCurTokenKind := skUndefined;
      DoParse;
    end;
  end;
end;

function TCnSourceCropper.PrevChar(Value: Integer): AnsiChar;
begin
  Result := #0;
  if Assigned(FInStream) then
  begin
    try
      if FInStream.Position - Value - 1 >= 0 then // ǰ㹻λ
      begin
        FInStream.Seek(- Value - 1, soFromCurrent);
        FInStream.Read(Result, SizeOf(AnsiChar));
        FInStream.Seek(Value, soFromCurrent);
      end;
    except
      Exit;
    end;
  end;
end;

procedure TCnSourceCropper.ProcessToLineEnd(SpCount: Integer; IsWholeLineSpace: Boolean);
begin
  if (FCropOption = coAll) and (FCurTokenKind <> skTodoList) then
  begin
    BackspaceChars(SpCount);
    if IsWholeLineSpace and FRemoveSingleLineSlashes then
      BackspaceOneCRLF;

    while not (FCurChar in [#0, #13, #10]) do
      FCurChar := GetCurChar;
  end
  else
  begin
    while not (FCurChar in [#0, #13, #10]) do
    begin
      if ((FCropOption = coExAscii) and (FCurChar < #128))
        or (FCurTokenKind = skTodoList) then
          WriteChar(FCurChar);
      FCurChar := GetCurChar;
    end;
  end;

  // ǰ #13  #10
  if FCurChar = #13 then
  begin
    repeat
      WriteChar(FCurChar);   // سҪдġ
      FCurChar := GetCurChar;
    until FCurChar in [#0, #10];
  end;

  if FCurChar = #10 then
    WriteChar(FCurChar);

  // غFCurChar ָ #10  #0Ҳһַ
  FCurTokenKind := skUndefined;
end;

procedure TCnSourceCropper.SetInStream(const Value: TStream);
begin
  FInStream := Value;
end;

procedure TCnSourceCropper.SetOutStream(const Value: TStream);
begin
  FOutStream := Value;
end;

procedure TCnSourceCropper.SetReserveItems(const Value: TStringList);
begin
  if Value <> nil then
    FReserveItems.Assign(Value);
end;

procedure TCnSourceCropper.WriteChar(Value: AnsiChar);
begin
  if Assigned(FOutStream) then
  begin
    try
      OutStream.Write(Value, SizeOf(Value));
    except
      Exit;
    end;
  end;
end;

procedure TCnSourceCropper.BackspaceOneCRLF;
var
  C: AnsiChar;
begin
  if (OutStream.Size <= 0) or (OutStream.Position <= 0) then // ǰû
    Exit;

  OutStream.Seek(-1, soFromCurrent);
  OutStream.Read(C, SizeOf(AnsiChar));
  OutStream.Seek(1, soFromCurrent);

  if C = #10 then
  begin
    OutStream.Size := OutStream.Size - 1;
    if (OutStream.Size <= 0) or (OutStream.Position <= 0) then // ǰû
      Exit;

    OutStream.Seek(-1, soFromCurrent);
    OutStream.Read(C, SizeOf(AnsiChar));
    OutStream.Seek(1, soFromCurrent);
    if C = #13 then
      OutStream.Size := OutStream.Size - 1;
  end;
end;

{ TCnCppCropper }

procedure TCnCppCropper.DoParse;
var
  IsSpace, WholeLineSpace: Boolean;
  SpCount: Integer;
begin
  FCurChar := GetCurChar;
  SpCount := 0;
  WholeLineSpace := True;

  while FCurChar <> #0 do
  begin
    case FCurChar of
    '/':
      begin
        if (FCurTokenKind in [skCode, skUndefined]) and (NextChar = '/') then
        begin
          if IsTodoList then
            FCurTokenKind := skTodoList
          else
            FCurTokenKind := skLineComment;
          // Ŵβ
          ProcessToLineEnd(SpCount, WholeLineSpace);
        end
        else
        if (FCurTokenKind in [skCode, skUndefined]) and (NextChar = '*') then
        begin
          // Ƿ TodoList
          if IsTodoList then
            FCurTokenKind := skTodoList
          else if FReserve and IsReserved then  // (NextChar(2) = '#')
            FCurTokenKind := skToReserve
          else
            FCurTokenKind := skBlockComment;
          //  '*/'
          ProcessToBlockEnd;
        end
        else
          DoDefaultProcess;
      end;
    '''':
      begin
        if FCurTokenKind in [skCode, skUndefined] then
          FCurTokenKind := skQuoteString
        else if FCurTokenKind = skQuoteString then
           FCurTokenKind := skCode;

        DoDefaultProcess;       
      end;
    '"':
      begin
        if FCurTokenKind in [skCode, skUndefined] then
          FCurTokenKind := skDittoString
        else if FCurTokenKind = skDittoString then
           FCurTokenKind := skCode;

        DoDefaultProcess;
      end;
    else
      DoDefaultProcess;
    end;

    IsSpace := FCurChar in SCnSpacesChars;
    if IsSpace then
      Inc(SpCount)
    else
    begin
      SpCount := 0;
      if not (FCurChar in SCnCRLFSpacesChars) then
        WholeLineSpace := False;
    end;

    if FCurChar in SCnCRLFChars then
      WholeLineSpace := True;

    FCurChar := GetCurChar;
  end;
  WriteChar(#0);
end;

procedure TCnCppCropper.ProcessToBlockEnd;
var
  NeedSep: Boolean;
begin
  NeedSep := not (PrevChar in SCnCRLFSpacesChars);    // ¼ǰ޿հ

  while ((FCurChar <> '*') or (NextChar <> '/')) and (FCurChar <> #0) do
  begin
    DoBlockEndProcess;
    FCurChar := GetCurChar;
  end;

  // ʱ FCurChar Ѿָ '*'Һ '/'
  if FCurChar = '*' then
  begin
    DoBlockEndProcess;   // д *
    FCurChar := GetCurChar;
    DoBlockEndProcess;   // д /
  end;

  FCurTokenKind := skUndefined;
  // ַѾд

  if NeedSep and not (FCurChar in SCnCRLFSpacesChars) then // ǰûհףдո
    WriteChar(' ');
end;

{ TCnPasCropper }

procedure TCnPasCropper.DoParse;
var
  IsSpace, WholeLineSpace: Boolean;
  SpCount: Integer;
begin
  FCurChar := GetCurChar;
  SpCount := 0;
  WholeLineSpace := True;

  while FCurChar <> #0 do
  begin
    case FCurChar of
    '/':
      begin
        if (FCurTokenKind in [skCode, skUndefined]) and (NextChar = '/') then
        begin
          if IsTodoList then
            FCurTokenKind := skTodoList
          else
            FCurTokenKind := skLineComment;
          // Ŵβ
          ProcessToLineEnd(SpCount, WholeLineSpace);
        end
        else
          DoDefaultProcess;
      end;
    '{':
      begin
        if FCurTokenKind in [skCode, skUndefined] then
        begin
          if NextChar <> '$' then
          begin
            // Ƿ TodoList
            if IsTodoList then
              FCurTokenKind := skTodoList
            else if FReserve and IsReserved then      // (NextChar = '*')
              FCurTokenKind := skToReserve
            else
              FCurTokenKind := skBlockComment
          end
          else
            FCurTokenKind := skDirective;
          //  '}' š
          ProcessToBlockEnd;
        end
        else
          DoDefaultProcess;
      end;
    '(':
      begin
        if (FCurTokenKind in [skCode, skUndefined]) and (NextChar = '*') then
        begin
          // Ƿ TodoList
          if IsTodoList then
            FCurTokenKind := skTodoList
          else if NextChar(2) = '$' then
            FCurTokenKind := skDirective
          else
            FCurTokenKind := skBlockComment;
          //  '*)'
          ProcessToBracketBlockEnd;
        end
        else
          DoDefaultProcess;
      end;
    '''':
      begin
        if FCurTokenKind in [skCode, skUndefined] then
          FCurTokenKind := skQuoteString
        else if FCurTokenKind = skQuoteString then
           FCurTokenKind := skCode;

        DoDefaultProcess;
      end;
    else
      DoDefaultProcess;
    end;

    IsSpace := FCurChar in SCnSpacesChars;
    if IsSpace then
      Inc(SpCount)
    else
    begin
      SpCount := 0;
      if not (FCurChar in SCnCRLFSpacesChars) then
        WholeLineSpace := False;
    end;

    if FCurChar in SCnCRLFChars then
      WholeLineSpace := True;

    FCurChar := GetCurChar;
  end;
  WriteChar(#0);
end;

procedure TCnPasCropper.ProcessToBlockEnd;
var
  NeedSep: Boolean;
begin
  NeedSep := not (PrevChar in SCnCRLFSpacesChars);  // ¼ǰ޿հ

  while not (FCurChar in [#0, '}']) do
  begin
    DoBlockEndProcess;
    FCurChar := GetCurChar;
  end;

  // ʱ FCurChar Ѿָ '}'Ҳһַ
  DoBlockEndProcess;
  FCurTokenKind := skUndefined;
  // ַѾд

  if NeedSep and not (FCurChar in SCnCRLFSpacesChars) then // ǰûհףдո
    WriteChar(' ');
end;

procedure TCnPasCropper.ProcessToBracketBlockEnd;
var
  NeedSep: Boolean;
begin
  NeedSep := not (PrevChar in SCnCRLFSpacesChars);  // ¼ǰ޿հ

  while ((FCurChar <> '*') or (NextChar <> ')')) and (FCurChar <> #0) do
  begin
    DoBlockEndProcess;
    FCurChar := GetCurChar;
  end;

  // ʱ FCurChar Ѿָ '*'Һ ')'
  if FCurChar = '*' then
  begin
    DoBlockEndProcess;   // д *
    FCurChar := GetCurChar;
    DoBlockEndProcess;   // д )
  end;

  FCurTokenKind := skUndefined;
  // ַѾд

  if NeedSep and not (FCurChar in SCnCRLFSpacesChars) then // ǰûհףдո
    WriteChar(' ');
end;

{$ENDIF CNWIZARDS_CNCOMMENTCROPPERWIZARD}
end.
