{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnPngUtilsIntf;
{* |<PRE>
================================================================================
* ƣCnWizards 
* ԪƣPng ʽֵ֧Ԫ
* Ԫߣܾ zjy@cnpack.org
*     ע pngimage Ѿ Embarcadero չµЭƺĿ
*           ԴΪ˱Ȩ⣬˴ D2010 ʹùٷ pngimage һ
*           DLL Ͱ汾 IDE ʹá
* ƽ̨Win7 + Delphi 2010
* ݲԣ
*   õԪʹеַѾػʽ
* ޸ļ¼2011.07.05 V1.0
*               Ԫ
================================================================================
|</PRE>}

{$I CnWizards.inc}

interface

function CnPngLibLoaded: LongBool;
function CnConvertPngToBmp(PngFile, BmpFile: string): LongBool; stdcall;
function CnConvertBmpToPng(BmpFile, PngFile: string): LongBool; stdcall;

implementation

uses
  Windows, SysUtils, CnCommon;

type
  TCnConvertPngToBmpProc = function (PngFile, BmpFile: PAnsiChar): LongBool; stdcall;
  TCnConvertBmpToPngProc = function (BmpFile, PngFile: PAnsiChar): LongBool; stdcall;

var
  _hMod: HMODULE;
  _CnConvertPngToBmpProc: TCnConvertPngToBmpProc = nil;
  _CnConvertBmpToPngProc: TCnConvertBmpToPngProc = nil;

function ModulePath: string;
var
  ModName: array[0..MAX_PATH] of Char;
begin
  SetString(Result, ModName, GetModuleFileName(HInstance, ModName, SizeOf(ModName)));
  Result := _CnExtractFilePath(Result);
end;

procedure LoadCnPngLib;
var
  DllName: string;
begin
  DllName := ModulePath + 'CnPngLib.dll';
  _hMod := LoadLibrary(PChar(DllName));
  if _hMod <> 0 then
  begin
    _CnConvertPngToBmpProc := TCnConvertPngToBmpProc(GetProcAddress(_hMod, 'CnConvertPngToBmp'));
    _CnConvertBmpToPngProc := TCnConvertBmpToPngProc(GetProcAddress(_hMod, 'CnConvertBmpToPng'));
  end;
end;

procedure FreeCnPngLib;
begin
  if _hMod <> 0 then
  begin
    FreeLibrary(_hMod);
    _CnConvertPngToBmpProc := nil;
    _CnConvertBmpToPngProc := nil;
    _hMod := 0;
  end;
end;

function CnPngLibLoaded: LongBool;
begin
  Result := Assigned(_CnConvertPngToBmpProc) and Assigned(_CnConvertBmpToPngProc);
end;

function CnConvertPngToBmp(PngFile, BmpFile: string): LongBool; stdcall;
var
  P, B: AnsiString;
begin
  P := AnsiString(PngFile);
  B := AnsiString(BmpFile);
  if Assigned(_CnConvertPngToBmpProc) then
    Result := _CnConvertPngToBmpProc(PAnsiChar(P), PAnsiChar(B))
  else
    Result := False;
end;

function CnConvertBmpToPng(BmpFile, PngFile: string): LongBool; stdcall;
var
  P, B: AnsiString;
begin
  P := AnsiString(PngFile);
  B := AnsiString(BmpFile);
  if Assigned(_CnConvertBmpToPngProc) then
    Result := _CnConvertBmpToPngProc(PAnsiChar(B), PAnsiChar(P))
  else
    Result := False;
end;

initialization
  LoadCnPngLib;

finalization
  FreeCnPngLib;

end.
