{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnIDEMirrorIntf;
{* |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣIDE ӿھԪڶ̬ IDE ӿڵĳ
* ԪߣCnPack  (master@cnpack.org)
*     עõԪṩ IDE Ĳ ToolsAPI ӿڵľ
* ƽ̨PWin2000Pro + Delphi 5.0
* ݲԣPWin9X/2000/XP + Delphi 5/6
*   õԪеַϱػʽ
* ޸ļ¼2018.06.09
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

uses
  SysUtils, Classes, Windows, Forms, ToolsAPI {$IFDEF DELPHI102_TOKYO}, Themes {$ENDIF};

{
  Delphi 10.2.2  IDE ʼ֧⣬ 10.2.3 в ToolsAPI ṩӿڣ
  ˷ѽ 10.2.2  10.2.3 ṩ֣רҰҪ֧⡢
   10.2.3 ʱʹ 10.2.3 ToolsAPI еصĽӿڣרҰ
   10.2.0/1/2 ʹʱֶ̬ӿеĺҲ⡣

  Ϊ˶⣬Ԫ³ֵĽӿڶдһͬĶ壬ڲѯʱ
  ʹ 10.2.3 ӿڵ GUIDܲѯӿڣȻ󰵵ǿת
  Ľӿڣճˡ 10.2.0/1/2 °汾Щӿǲѯġ

  ⣬½ӿãǷ Service ͷ Notifier ֪ͨ
  Ҫ޸ķдĽӿеýӿͬɷдĽӿڡ

   IDE ڲ Notifier ʱ鴫 Notifier Ƿָӿڣ
  ǷдӿڣԸд˸ ChangeIntfGUIDԽ
  ĳʵֵָӿڵ GUID 滻ָ GUIDƭ IDE ļ顣
}

const
  GUID_INTAIDETHEMINGSERVICESNOTIFIER = '{4CBFAA40-89E6-412C-B667-9034666E2931}';
  GUID_IOTAIDETHEMINGSERVICES = '{DEAD2647-9B2C-4084-A61E-1E69A9179637}';
  GUID_IOTAIDETHEMINGSERVICES250 = '{DEAD2648-9B21-4084-771E-1E69A9176637}';

{$IFDEF DELPHI102_TOKYO}

type
  ICnNTAIDEThemingServicesNotifier = interface(IOTANotifier)
  {* Ӧ INTAIDEThemingServicesNotifier}
  ['{46949416-FD06-4B49-A43F-1C7A4A760B32}']
    procedure ChangingTheme();
    procedure ChangedTheme();
  end;

  ICnOTAIDEThemingServices = interface(IInterface)
  {* Ӧ IOTAIDEThemingServices}
    function AddNotifier(const ANotifier: ICnNTAIDEThemingServicesNotifier): Integer;
    procedure RemoveNotifier(Index: Integer);
    function GetActiveThemeName: string;
    function GetIDEStyleServices: TCustomStyleServices;
    function GetIDEThemingEnabled: Boolean;
    procedure ApplyTheme(AComponent: TComponent);
    function GetEditorColorSpeedSetting(const ThemeName: string): string;
    function GetOIColorSpeedSetting(const ThemeName: string): string;
    property StyleServices: TCustomStyleServices read GetIDEStyleServices;
    property ActiveTheme: string read GetActiveThemeName;
    property IDEThemingEnabled: Boolean read GetIDEThemingEnabled;
  end;

  ICnOTAIDEThemingServices250 = interface(ICnOTAIDEThemingServices)
  {* Ӧ IOTAIDEThemingServices250}
    procedure RegisterFormClass(AFormClass : TCustomFormClass);
  end;

{$ENDIF}

function ChangeIntfGUID(AClass: TClass; const OldGUID, NewGUID: TGUID): Boolean;

implementation

resourcestring
  SMemoryWriteError = 'Error Writing Interface Table Memory (%s).';

function ChangeIntfGUID(AClass: TClass; const OldGUID, NewGUID: TGUID): Boolean;
var
  I: Integer;
  IntfTable: PInterfaceTable;
  IntfEntry: PInterfaceEntry;
  OldProtection, DummyProtection: DWORD;
begin
  Result := False;
  IntfTable := AClass.GetInterfaceTable;
  if IntfTable <> nil then
  begin
    for I := 0 to IntfTable.EntryCount-1 do
    begin
      IntfEntry := @IntfTable.Entries[I];
      if CompareMem(@IntfEntry^.IID, @OldGUID, SizeOf(TGUID)) then
      begin
        if not VirtualProtect(@IntfEntry^.IID, SizeOf(TGUID), PAGE_EXECUTE_READWRITE, @OldProtection) then
          raise Exception.CreateFmt(SMemoryWriteError, [SysErrorMessage(GetLastError)]);

        try
          IntfEntry^.IID := NewGUID;
        finally
          if not VirtualProtect(@IntfEntry^.IID, SizeOf(TGUID), OldProtection, @DummyProtection) then
            raise Exception.CreateFmt(SMemoryWriteError, [SysErrorMessage(GetLastError)]);
        end;

        Result := True;
        Exit;
      end;
    end;
  end;
end;

end.
