{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnIdentRenameFrm;
{ |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* Ԫƣʶʾ嵥Ԫ
* ԪߣCnPack  (master@cnpack.org)
*     ע
* ƽ̨PWinXpPro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеֱַ֧ػʽ
* ޸ļ¼2015.12.01
*               Cpp/H ļѡ
*           2009.01.15
*             Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

{$IFDEF CNWIZARDS_CNSRCEDITORENHANCE}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CnWizMultiLang;

type
  TCnIdentRenameForm = class(TCnTranslateForm)
    grpBrowse: TGroupBox;
    rbCurrentProc: TRadioButton;
    rbCurrentInnerProc: TRadioButton;
    rbUnit: TRadioButton;
    lblReplacePromt: TLabel;
    edtRename: TEdit;
    btnOK: TButton;
    btnCancel: TButton;
    rbCppHPair: TRadioButton;
    rbCurrentBlock: TRadioButton;
    procedure FormShow(Sender: TObject);
    procedure edtRenameKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  protected
    function GetHelpTopic: string; override;
  public
    { Public declarations }
  end;

{$ENDIF CNWIZARDS_CNSRCEDITORENHANCE}

implementation

{$IFDEF CNWIZARDS_CNSRCEDITORENHANCE}

{$R *.DFM}

procedure TCnIdentRenameForm.FormShow(Sender: TObject);
begin
  edtRename.SetFocus;
end;

function TCnIdentRenameForm.GetHelpTopic: string;
begin
  Result := 'CnSrcEditorIdentRename';
end;

procedure TCnIdentRenameForm.edtRenameKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
var
  NextRadioButton: TRadioButton;
begin
  NextRadioButton := nil;
  if (Key = VK_UP) and (Shift = []) then
  begin
    if rbUnit.Checked then
    begin
      if rbCurrentInnerProc.Enabled then
        NextRadioButton := rbCurrentInnerProc
      else
        NextRadioButton := rbCurrentProc;
    end
    else if rbCurrentInnerProc.Checked then
      NextRadioButton := rbCurrentProc
    else if rbCppHPair.Checked and rbCppHPair.Enabled then
      NextRadioButton := rbUnit
    else if rbCurrentBlock.Checked then
    begin
      if rbCppHPair.Enabled then
        NextRadioButton := rbCppHPair
      else
        NextRadioButton := rbUnit;
    end;

    Key := 0;
  end
  else if (Key = VK_DOWN) and (Shift = []) then
  begin
    if rbCurrentProc.Checked then
    begin
      if rbCurrentInnerProc.Enabled then
        NextRadioButton := rbCurrentInnerProc
      else
        NextRadioButton := rbUnit;
    end
    else if rbCurrentInnerProc.Checked then
      NextRadioButton := rbUnit
    else if rbUnit.Checked and rbCppHPair.Enabled then
      NextRadioButton := rbCppHPair
    else if rbUnit.Checked and rbCurrentBlock.Enabled then
      NextRadioButton := rbCurrentBlock;

    Key := 0;
  end
  else if (Key = VK_UP) and (Shift = [ssAlt]) then
  begin
    // Change Case to Upper
    edtRename.Text := UpperCase(edtRename.Text);
  end
  else if (Key = VK_DOWN) and (Shift = [ssAlt]) then
  begin
    // Change Case to Lower
    edtRename.Text := LowerCase(edtRename.Text);
  end;

  if NextRadioButton <> nil then
    if NextRadioButton.Enabled then
      NextRadioButton.Checked := True;
end;

{$ENDIF CNWIZARDS_CNSRCEDITORENHANCE}
end.
