{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnScript_IdeInstComp;
{ |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* Ԫƣűչע
* Ԫߣܾ (zjy@cnpack.org)
*     עõԪע IDE аװ
* ƽ̨PWinXP SP2 + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7
*   ôеֱַ֧ػʽ
* ޸ļ¼2006.12.30 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

uses
  Windows, SysUtils, Classes, CnWizIdeUtils, CnScriptClasses,
  uPSComponent, uPSRuntime, uPSCompiler;

type

  TPSImport_IdeInstComp = class(TCnPSPlugin)
  public
    procedure CompileImport1(CompExec: TPSScript); override;
    procedure ExecImport1(CompExec: TPSScript; const ri: TPSRuntimeClassImporter); override;
    procedure CompOnUses1(CompExec: TPSScript); override;
  end;

  { compile-time registration functions }
procedure SIRegister_IdeInstComp(CL: TPSPascalCompiler);

{ run-time registration functions }
procedure RIRegister_IdeInstComp(CL: TPSRuntimeClassImporter);

implementation

{$IFDEF DEBUG}
uses
  CnDebug;
{$ENDIF}  

(* === compile-time registration functions === *)

procedure SIRegister_IdeInstComp(CL: TPSPascalCompiler);
var
  List: TStringList;
  i: Integer;

  function DoRegisterClass(AClass: TClass): TPSCompileTimeClass;
  begin
    Result := nil;
    if AClass <> nil then
    begin
      Result := CL.FindClass(AnsiString(UpperCase(AClass.ClassName)));
      if Result = nil then
      begin
        Result := CL.AddClass(DoRegisterClass(AClass.ClassParent), AClass);
        Result.RegisterPublishedProperties;
      end;
    end;
  end;
begin
{$IFDEF DEBUG}
  CnDebugger.LogEnter('SIRegister_IdeInstComp');
{$ENDIF}
  List := TStringList.Create;
  try
  {$IFDEF DEBUG}
    CnDebugger.LogMsg('GetInstalledComponents');
  {$ENDIF}
    GetInstalledComponents(nil, List);
  {$IFDEF DEBUG}
    CnDebugger.LogMsg(List.Text);
  {$ENDIF}
    for i := 0 to List.Count - 1 do
    begin
      DoRegisterClass(GetClass(List[i]));
    end;
  finally
    List.Free;
  end;
{$IFDEF DEBUG}
  CnDebugger.LogLeave('SIRegister_IdeInstComp');
{$ENDIF}
end;

(* === run-time registration functions === *)

procedure RIRegister_IdeInstComp(CL: TPSRuntimeClassImporter);
var
  List: TStringList;
  i: Integer;

  function DoRegisterClass(AClass: TClass): TPSRuntimeClass;
  begin
    Result := nil;
    if AClass <> nil then
    begin
      Result := CL.FindClass(AnsiString(UpperCase(AClass.ClassName)));
      if Result = nil then
      begin
        DoRegisterClass(AClass.ClassParent);
        Result := CL.Add(AClass);
      end;
    end;
  end;
begin
{$IFDEF DEBUG}
  CnDebugger.LogEnter('RIRegister_IdeInstComp');
{$ENDIF}
  List := TStringList.Create;
  try
  {$IFDEF DEBUG}
    CnDebugger.LogMsg('GetInstalledComponents');
  {$ENDIF}
    GetInstalledComponents(nil, List);
  {$IFDEF DEBUG}
    CnDebugger.LogMsg(List.Text);
  {$ENDIF}
    for i := 0 to List.Count - 1 do
    begin
      DoRegisterClass(GetClass(List[i]));
    end;  
  finally
    List.Free;
  end;
{$IFDEF DEBUG}
  CnDebugger.LogLeave('RIRegister_IdeInstComp');
{$ENDIF}
end;

{ TPSImport_IdeInstComp }

procedure TPSImport_IdeInstComp.CompileImport1(CompExec: TPSScript);
begin

end;

procedure TPSImport_IdeInstComp.CompOnUses1(CompExec: TPSScript);
begin
  // ڸòֻûʵʹ uses IdeInstComp ʱע
  SIRegister_IdeInstComp(CompExec.Comp);
end;

procedure TPSImport_IdeInstComp.ExecImport1(CompExec: TPSScript; const ri: TPSRuntimeClassImporter);
begin
  RIRegister_IdeInstComp(ri);
end;

end.



