{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnTestWizard;
{ |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣCnPack IDE רҰרɵԪ
* ԪߣLiuXiao master@cnpack.org
*     עCnPack IDE רҰרɵԪ
* ƽ̨Windows XP + Delphi 5
* ݲԣPWin9X/2000/XP + Delphi 5/6/7
*   ôеַϱػʽ
* ޸ļ¼2016.04.23 V1.0
*               LiuXiao Ԫʵֹ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ToolsAPI, CnWizMultiLang, CnCommon, CnConsts, CnWizConsts,
  CnWizClasses, CnWizOptions, CnOTACreators;

type
  TCnTestWizardForm = class(TCnTranslateForm)
    grpTestWizard: TGroupBox;
    lblClassName: TLabel;
    lblMenuCaption: TLabel;
    lblComment: TLabel;
    edtMenuCaption: TEdit;
    lblCnTest: TLabel;
    edtClassName: TEdit;
    lblWizard: TLabel;
    edtComment: TEdit;
    btnOK: TButton;
    btnCancel: TButton;
    lblTest: TLabel;
    dlgSave: TSaveDialog;
  private

  public

  end;

  TCnTestWizard = class(TCnUnitWizard)
  private
    FWizardClassName: string;
    FWizardMenuCaption: string;
    FWizardComment: string;
  public
    constructor Create; override;
    destructor Destroy; override;
    class procedure GetWizardInfo(var Name, Author, Email, Comment: string); override;
    procedure Execute; override;

    property WizardClassName: string read FWizardClassName write FWizardClassName;
    property WizardMenuCaption: string read FWizardMenuCaption write FWizardMenuCaption;
    property WizardComment: string read FWizardComment write FWizardComment;
  end;

  TCnTestWizardCreator = class(TCnTemplateModuleCreator)
  private
    FTestWizard: TCnTestWizard;
{$IFDEF BDS}
    FFileName: string;
{$ENDIF}

  protected
    function GetTemplateFile(FileType: TCnSourceType): string; override;
    procedure DoReplaceTagsSource(const TagString: string; TagParams: TStrings;
      var ReplaceText: string; ASourceType: TCnSourceType; ModuleIdent, FormIdent,
      AncestorIdent: string); override;

  public
    function GetShowSource: Boolean; override;

{$IFDEF BDS}
    function GetUnnamed: Boolean; override;
    {* BDS · FALSEʾѾ }
    function GetImplFileName: string; override;
    {* BDS ʵʵļ }
    function GetIntfFileName: string; override;
    {* BDS ʵʵļ }
{$ENDIF}

    property TestWizard: TCnTestWizard read FTestWizard write FTestWizard;

{$IFDEF BDS}
    property FileName: string read FFileName write FFileName;
{$ENDIF}
  end;

implementation

{$R *.DFM}

const
  SCnTestWizardModuleTemplatePasFile = 'CnTestWizard.pas';

  csClassName = 'ClassName';
  csWizardCaption = 'WizardCaption';
  csWizardComment = 'WizardComment';
  csCreateTime = 'CreateTime';

var
  SCnTestWizardWizardName: string = 'CnPack Test Wizard';
  SCnTestWizardWizardComment: string = 'Generate a Test Wizard for CnPack IDE Wizard.';

{ TCnTestWizard }

constructor TCnTestWizard.Create;
begin
  inherited;

end;

destructor TCnTestWizard.Destroy;
begin
  inherited;

end;

procedure TCnTestWizard.Execute;
var
  ModuleCreator: TCnTestWizardCreator;
begin
  with TCnTestWizardForm.Create(nil) do
  begin
    if ShowModal = mrOK then
    begin
      WizardClassName := Trim(edtClassName.Text);
      WizardMenuCaption := 'Test ' + Trim(edtMenuCaption.Text);
      WizardComment := Trim(edtComment.Text);

      ModuleCreator := TCnTestWizardCreator.Create;
      ModuleCreator.TestWizard := Self;

{$IFDEF BDS}
      if dlgSave.Execute then
        ModuleCreator.FileName := dlgSave.FileName
      else
        Exit;
{$ENDIF}

      (BorlandIDEServices as IOTAModuleServices).CreateModule(ModuleCreator);
    end;
    Free;
  end;

end;

class procedure TCnTestWizard.GetWizardInfo(var Name, Author, Email,
  Comment: string);
begin
  Name := SCnTestWizardWizardName;
  Author := SCnPack_LiuXiao;
  Email := SCnPack_LiuXiaoEmail;
  Comment := SCnTestWizardWizardComment;
end;

{ TCnTestWizardCreator }

procedure TCnTestWizardCreator.DoReplaceTagsSource(const TagString: string;
  TagParams: TStrings; var ReplaceText: string; ASourceType: TCnSourceType;
  ModuleIdent, FormIdent, AncestorIdent: string);
begin
  if ASourceType = stImplSource then
  begin
    if TagString = csClassName then
    begin
      ReplaceText := FTestWizard.WizardClassName;
    end
    else if TagString = csWizardCaption then
    begin
      ReplaceText := FTestWizard.WizardMenuCaption;
    end
    else if TagString = csWizardComment then
    begin
      ReplaceText := FTestWizard.WizardComment;
    end
    else if TagString = csCreateTime then
    begin
      ReplaceText := FormatDateTime('yyyy.MM.dd', Now);
    end;
  end;
end;

{$IFDEF BDS}

function TCnTestWizardCreator.GetUnnamed: Boolean;
begin
  Result := (FFileName = '');
end;

function TCnTestWizardCreator.GetImplFileName: string;
begin
  Result := _CnChangeFileExt(FFileName, '.pas')
end;

function TCnTestWizardCreator.GetIntfFileName: string;
begin
  Result := '';
end;

{$ENDIF}

function TCnTestWizardCreator.GetShowSource: Boolean;
begin
  Result := True;
end;

function TCnTestWizardCreator.GetTemplateFile(FileType: TCnSourceType): string;
begin
  if FileType = stImplSource then
    Result := MakePath(WizOptions.TemplatePath) + SCnTestWizardModuleTemplatePasFile
  else
    Result := '';
end;

{$IFDEF DEBUG}
initialization
  RegisterCnWizard(TCnTestWizard);
{$ENDIF}

end.
