{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnWizShareImages;
{* |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* Ԫƣ ImageList Ԫ
* ԪߣCnPack 
*     עõԪ CnPack IDE רҰĹ ImageList
*           ע⣺D11 Լ֮֮ IDE ֧ HDPIֱ ImageList 
*          Ϊߴ̶Ϊزɱ䵼»̫Сͨߴģʽȫ
*            HDPI ŴشС VirtualImageListߴģʽ¸
*            HDPI ŴĴߴشС VirtualImageList
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеַϱػʽ
* ޸ļ¼2021.09.15 V1.1
*               ֧ HDPI ɱֱ
*           2003.04.18 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

uses
  SysUtils, Windows, Classes, Graphics, Forms, ImgList, Buttons, Controls,
  {$IFDEF IDE_SUPPORT_HDPI} Vcl.VirtualImageList, Vcl.ImageCollection, {$ENDIF}
  {$IFDEF SUPPORT_GDIPLUS} WinApi.GDIPOBJ, WinApi.GDIPAPI, {$ENDIF}
  {$IFNDEF STAND_ALONE} CnWizUtils, CnWizOptions, CnWizIdeUtils, {$ENDIF}
  CnGraphUtils;

type
  TdmCnSharedImages = class(TDataModule)
    Images: TImageList;
    DisabledImages: TImageList;
    SymbolImages: TImageList;
    ilBackForward: TImageList;
    ilInputHelper: TImageList;
    ilProcToolBar: TImageList;
    ilBackForwardBDS: TImageList;
    ilProcToolbarLarge: TImageList;
    ilColumnHeader: TImageList;
    LargeImages: TImageList;
    DisabledLargeImages: TImageList;
    IDELargeImages: TImageList;
    procedure DataModuleCreate(Sender: TObject);
  private
    FIdxUnknown: Integer;
{$IFDEF IDE_SUPPORT_HDPI}
    FIdxUnknownLargeInIDE: Integer;
    FImageCollection: TImageCollection;       // ͨߴߴ Images Ӧ Collection
    FVirtualImages: TVirtualImageList;        // Ӧͨߴ Images
    FLargeVirtualImages: TVirtualImageList;   // Ӧߴ ImagesǷŴʱ
    FDisabledImageCollection: TImageCollection;       // ͨߴߴ DisabledImages Ӧ Collection
    FDisabledVirtualImages: TVirtualImageList;        // Ӧͨߴ DisabledImages
    FDisabledLargeVirtualImages: TVirtualImageList;   // Ӧߴ DisabledImagesǷŴʱ
    FProcToolbarImageCollection: TImageCollection;      // ͨߴߴ ilProcToolbarLarge Ӧ Collection
    FProcToolbarVirtualImages: TVirtualImageList;       // Ӧͨߴ ilProcToolbar
    FLargeProcToolbarVirtualImages: TVirtualImageList;  // Ӧߴ ilProcToolbarǷŴʱ

    FIDELargeVirtualImages: TVirtualImageList;   // Ӧ IDELargeImages  IDELargeDisabledImagesǷŴʱ
    FLargeIDEOffset: Integer; // D110A ֮ͼƫֵͬ
{$ENDIF}
{$IFNDEF STAND_ALONE}
    FIdxUnknownInIDE: Integer;
    FIDEOffset: Integer;      // D110A ֮ǰǷͼ궼ֵ
    FCopied: Boolean;         // ¼ǵ ImageList  IDE  ImageList 
    FLargeCopied: Boolean;    // ¼ IDE  ImageList ޸һݴ
    FLargeCopiedCount: Integer; // ¼ IDE  ImageList һݴ
    function GetIdxUnknownInIDE: Integer;
{$ENDIF}
  public
    property IdxUnknown: Integer read FIdxUnknown;
{$IFNDEF STAND_ALONE}
    property IdxUnknownInIDE: Integer read GetIdxUnknownInIDE;
{$ENDIF}

    procedure StretchCopyToLarge(SrcImageList, DstImageList: TCustomImageList);
    {* ⶼʹãСߴ ImageList Ƶ ImageList }
    procedure CenterCopyTo(SrcImageList, DstImageList: TCustomImageList);
    {* Сߴ ImageList ԭߴлƵ ImageList }

{$IFNDEF STAND_ALONE}
    procedure GetSpeedButtonGlyph(Button: TSpeedButton; ImageList: TImageList; 
      EmptyIdx: Integer);
    procedure CopyToIDEMainImageList;
    // Images ᱻƽ IDE  ImageList ͼ걻ͬʱʹõĳϣFIDEOffset ʾƫ
    procedure CopyLargeIDEImageList(Force: Boolean = False);
    // רȫز˵ã IDE  ImageList ٸһݴ
    // עᱻظΣһοǰԳʼרҹأһ IDE Էӳͼ
    // Force Ϊ True ʱʾ FLargeCopied Ϊ True ʱжٽһθ

    function GetMixedImageList(ForceSmall: Boolean = False): TCustomImageList;
    function CalcMixedImageIndex(ImageIndex: Integer): Integer;

{$IFDEF IDE_SUPPORT_HDPI}
    property VirtualImages: TVirtualImageList read FVirtualImages;
    property LargeVirtualImages: TVirtualImageList read FLargeVirtualImages;
    {* D110A ϣΪ IDE ûУͨͨߴʹߴ}
    property DisabledVirtualImages: TVirtualImageList read FDisabledVirtualImages;
    property DisabledLargeVirtualImages: TVirtualImageList read FDisabledLargeVirtualImages;
    {* D110A ϣΪ IDE ûУͨ״̬ͨߴʹߴ}
    property ProcToolbarVirtualImages: TVirtualImageList read FProcToolbarVirtualImages;
    property LargeProcToolbarVirtualImages: TVirtualImageList read FLargeProcToolbarVirtualImages;
    {* D110A ϣΪ IDE ûУʺбҪͨߴʹߴ}

    property IDELargeVirtualImages: TVirtualImageList read FIDELargeVirtualImages;
    {* ߴµ D110A ϣ༭Ҫ IDE }
{$ENDIF}
{$ENDIF}
  end;

var
  dmCnSharedImages: TdmCnSharedImages;

implementation

{$IFDEF DEBUG}
uses
  CnDebug;
{$ENDIF}

{$R *.DFM}

const
  MaskColor = clBtnFace;

procedure TdmCnSharedImages.StretchCopyToLarge(SrcImageList,
  DstImageList: TCustomImageList);
var
  Src, Dst: TBitmap;
  Rs, Rd: TRect;
  I: Integer;
begin
  // С ImageList ƣ 16*16 չ 24* 24
  Src := nil;
  Dst := nil;

{$IFNDEF SUPPORT_GDIPLUS}
  CnStartUpGdiPlus;
{$ENDIF}

  try
    Src := CreateEmptyBmp24(16, 16, MaskColor);
    Dst := CreateEmptyBmp24(24, 24, MaskColor);

    Rs := Rect(0, 0, Src.Width, Src.Height);
    Rd := Rect(0, 0, Dst.Width, Dst.Height);

    Src.Canvas.Brush.Color := MaskColor;
    Src.Canvas.Brush.Style := bsSolid;
    Dst.Canvas.Brush.Color := clFuchsia;
    Dst.Canvas.Brush.Style := bsSolid;

    for I := 0 to SrcImageList.Count - 1 do
    begin
      Src.Canvas.FillRect(Rs);
      SrcImageList.GetBitmap(I, Src);

      StretchDrawBmp(Src, Dst);
      DstImageList.AddMasked(Dst, MaskColor);
    end;
  finally
{$IFNDEF SUPPORT_GDIPLUS}
    CnShutDownGdiPlus;
{$ENDIF}
    Src.Free;
    Dst.Free;
  end;
end;

procedure TdmCnSharedImages.CenterCopyTo(SrcImageList,
  DstImageList: TCustomImageList);
var
  Src, Dst: TBitmap;
  Rs, Rd: TRect;
  I: Integer;
begin
  // С ImageList ƣСͼл
  Src := nil;
  Dst := nil;
  try
    Src := TBitmap.Create;
    Src.Width := SrcImageList.Width;
    Src.Height := SrcImageList.Height;
    Src.PixelFormat := pf24bit;

    Dst := TBitmap.Create;
    Dst.Width := DstImageList.Width;
    Dst.Height := DstImageList.Height;
    Dst.PixelFormat := pf24bit;

    Rs := Rect(0, 0, Src.Width, Src.Height);
    Rd := Rect(0, 0, Dst.Width, Dst.Height);

    Src.Canvas.Brush.Color := MaskColor;
    Src.Canvas.Brush.Style := bsSolid;
    Dst.Canvas.Brush.Color := clFuchsia;
    Dst.Canvas.Brush.Style := bsSolid;

    for I := 0 to SrcImageList.Count - 1 do
    begin
      Src.Canvas.FillRect(Rs);
      SrcImageList.GetBitmap(I, Src);
      Dst.Canvas.FillRect(Rd);
      Dst.Canvas.Draw((Dst.Width - Src.Width) div 2, (Dst.Height - Src.Height) div 2, Src);
      DstImageList.AddMasked(Dst, MaskColor);
    end;
  finally
    Src.Free;
    Dst.Free;
  end;
end;

procedure TdmCnSharedImages.DataModuleCreate(Sender: TObject);
{$IFNDEF STAND_ALONE}
var
  ImgLst: TCustomImageList;
{$IFDEF IDE_SUPPORT_HDPI}
  Ico: TIcon;
{$ELSE}
  Bmp: TBitmap;
  Save: TColor;
{$ENDIF}
{$ENDIF}
begin
{$IFNDEF STAND_ALONE}
  FIdxUnknown := 66;
  ImgLst := GetIDEImageList;

{$IFDEF IDE_SUPPORT_HDPI}
  Ico := TIcon.Create;
  try
    Images.GetIcon(IdxUnknown, Ico);
    FIdxUnknownInIDE := AddGraphicToVirtualImageList(Ico,
      ImgLst as TVirtualImageList, 'CnWizardsUnknown');
  finally
    Ico.Free;
  end;
{$ELSE}
  Bmp := TBitmap.Create;        //  IDE  List Ӹ Unknown ͼ
  try
    Bmp.PixelFormat := pf24bit;
    Save := Images.BkColor;
    Images.BkColor := clFuchsia;
    Images.GetBitmap(IdxUnknown, Bmp);
    FIdxUnknownInIDE := ImgLst.AddMasked(Bmp, clFuchsia);
    Images.BkColor := Save;
  finally
    Bmp.Free;
  end;
{$ENDIF}

{$IFDEF IDE_SUPPORT_HDPI}
  FVirtualImages := TVirtualImageList.Create(Self);
  FVirtualImages.Name := 'CnVirtualImages';
  FImageCollection := TImageCollection.Create(Self);
  FImageCollection.Name := 'CnImageCollection';
  FVirtualImages.ImageCollection := FImageCollection;
  FVirtualImages.Width := IdeGetScaledPixelsFromOrigin(Images.Width);
  FVirtualImages.Height := IdeGetScaledPixelsFromOrigin(Images.Height);

  FDisabledVirtualImages := TVirtualImageList.Create(Self);
  FDisabledVirtualImages.Name := 'CnDisabledVirtualImages';
  FDisabledImageCollection := TImageCollection.Create(Self);
  FDisabledImageCollection.Name := 'CnDisabledImageCollection';
  FDisabledVirtualImages.ImageCollection := FDisabledImageCollection;
  FDisabledVirtualImages.Width := IdeGetScaledPixelsFromOrigin(DisabledImages.Width);
  FDisabledVirtualImages.Height := IdeGetScaledPixelsFromOrigin(DisabledImages.Height);

  FProcToolbarVirtualImages := TVirtualImageList.Create(Self);
  FProcToolbarVirtualImages.Name := 'CnProcToolbarVirtualImages';
  FProcToolbarImageCollection := TImageCollection.Create(Self);
  FProcToolbarImageCollection.Name := 'CnProcToolbarImageCollection';
  FProcToolbarVirtualImages.ImageCollection := FProcToolbarImageCollection;
  FProcToolbarVirtualImages.Width := IdeGetScaledPixelsFromOrigin(ilProcToolbar.Width);
  FProcToolbarVirtualImages.Height := IdeGetScaledPixelsFromOrigin(ilProcToolbar.Height);

  CopyImageListToVirtual(Images, FVirtualImages);
  CopyImageListToVirtual(DisabledImages, FDisabledVirtualImages);
  CopyImageListToVirtual(ilProcToolbar, FProcToolbarVirtualImages);
{$ENDIF}

  if WizOptions.UseLargeIcon then
  begin
    // Ϊͼ׼
{$IFDEF IDE_SUPPORT_HDPI}
    FIDELargeVirtualImages := TVirtualImageList.Create(Self);
    FIDELargeVirtualImages.Name := 'CnIDELargeVirtualImages';
    FIDELargeVirtualImages.ImageCollection := GetIDEImagecollection;
    FIDELargeVirtualImages.Width := IdeGetScaledPixelsFromOrigin(csLargeImageListWidth);
    FIDELargeVirtualImages.Height := IdeGetScaledPixelsFromOrigin(csLargeImageListHeight);

    FLargeVirtualImages := TVirtualImageList.Create(Self);
    FLargeVirtualImages.Name := 'CnLargeVirtualImages';
    FLargeVirtualImages.ImageCollection := FImageCollection;
    FLargeVirtualImages.Width := IdeGetScaledPixelsFromOrigin(csLargeImageListWidth);
    FLargeVirtualImages.Height := IdeGetScaledPixelsFromOrigin(csLargeImageListHeight);

    FDisabledLargeVirtualImages := TVirtualImageList.Create(Self);
    FDisabledLargeVirtualImages.Name := 'CnDisabledLargeVirtualImages';
    FDisabledLargeVirtualImages.ImageCollection := FDisabledImageCollection;
    FDisabledLargeVirtualImages.Width := IdeGetScaledPixelsFromOrigin(csLargeImageListWidth);
    FDisabledLargeVirtualImages.Height := IdeGetScaledPixelsFromOrigin(csLargeImageListHeight);

    FLargeProcToolbarVirtualImages := TVirtualImageList.Create(Self);
    FLargeProcToolbarVirtualImages.Name := 'CnLargeProcToolbarVirtualImages';
    FLargeProcToolbarVirtualImages.ImageCollection := FProcToolbarImageCollection;
    FLargeProcToolbarVirtualImages.Width := IdeGetScaledPixelsFromOrigin(csLargeImageListWidth);
    FLargeProcToolbarVirtualImages.Height := IdeGetScaledPixelsFromOrigin(csLargeImageListHeight);

    // ߴģʽ£´ ImageCollecitonԭʼģֻǷŴ VirtualImageList
    FLargeVirtualImages.Add('', -1, -1, False);
    FDisabledLargeVirtualImages.Add('', -1, -1, False);
    FLargeProcToolbarVirtualImages.Add('', -1, -1, False);
{$ELSE}
    StretchCopyToLarge(ilProcToolbar, ilProcToolbarLarge);
    StretchCopyToLarge(Images, LargeImages);
    StretchCopyToLarge(DisabledImages, DisabledLargeImages);
{$ENDIF}
  end;

{$ENDIF}
end;

{$IFNDEF STAND_ALONE}

function TdmCnSharedImages.CalcMixedImageIndex(
  ImageIndex: Integer): Integer;
begin
  if FCopied and (ImageIndex >= 0) then
  begin
    Result := ImageIndex + FIDEOffset;
{$IFDEF IDE_SUPPORT_HDPI}
    if WizOptions.UseLargeIcon then
      Result := ImageIndex + FLargeIDEOffset;
{$ENDIF}
  end
  else
    Result := ImageIndex;
end;

function TdmCnSharedImages.GetMixedImageList(ForceSmall: Boolean): TCustomImageList;
begin
  if FCopied then
  begin
    if WizOptions.UseLargeIcon and not ForceSmall and FLargeCopied then
    begin
{$IFDEF IDE_SUPPORT_HDPI}
      Result := FIDELargeVirtualImages;
{$ELSE}
      Result := IDELargeImages;
{$ENDIF}
    end
    else
      Result := GetIDEImageList;
  end
  else
    Result := Images;
end;

procedure TdmCnSharedImages.CopyToIDEMainImageList;
var
  IDEs: TCustomImageList;
  Cnt: Integer;
begin
  if FCopied then
    Exit;

  IDEs := GetIDEImageList;
  if IDEs <> nil then
  begin
    Cnt := IDEs.Count;
{$IFDEF IDE_SUPPORT_HDPI}
    if WizOptions.UseLargeIcon then
    begin
      // D11 ԺIDE  ImageList  VirtualImageList ˣڷֱʱ仯FLargeOffset 
      CopyVirtualImageList(IDEs as TVirtualImageList, FIDELargeVirtualImages);
      FLargeIDEOffset := FIDELargeVirtualImages.Count;
      FIDELargeVirtualImages.Clear;   // ֻ FIDELargeOffset
    end;
    CopyImageListToVirtual(Images, IDEs as TVirtualImageList, 'CnWizardsItem');
{$IFDEF DEBUG}
    CnDebugger.LogFmt('Add %d Images to IDE Main VirtualImageList. Offset %d. LargeOffset %d', [Images.Count, Cnt, FLargeIDEOffset]);
{$ENDIF}
{$ELSE}
    if (IDEs.Width = Images.Width) and (IDEs.Height = Images.Height) then
    begin
      IDEs.AddImages(Images);
{$IFDEF DEBUG}
      CnDebugger.LogFmt('Add %d Images to IDE Main 16x16 ImageList. Offset %d.', [Images.Count, Cnt]);
{$ENDIF}
    end;
{$ENDIF}

    FIDEOffset := Cnt;
    FCopied := True;
  end;
end;

procedure TdmCnSharedImages.GetSpeedButtonGlyph(Button: TSpeedButton;
  ImageList: TImageList; EmptyIdx: Integer);
var
  Save: TColor;
begin
  Button.Glyph.TransparentMode := tmFixed; // ǿ͸
  Button.Glyph.TransparentColor := clFuchsia;
  if Button.Glyph.Empty then
  begin
    Save := dmCnSharedImages.Images.BkColor;
    ImageList.BkColor := clFuchsia;
    ImageList.GetBitmap(EmptyIdx, Button.Glyph);
    ImageList.BkColor := Save;
  end;

  // ťλͼԽЩť Disabled ʱͼ
  AdjustButtonGlyph(Button.Glyph);
  Button.NumGlyphs := 2;
end;

procedure TdmCnSharedImages.CopyLargeIDEImageList(Force: Boolean);
var
  IDEs: TCustomImageList;
{$IFDEF IDE_SUPPORT_HDPI}
  Ico: TIcon;
{$ENDIF}
begin
  if not WizOptions.UseLargeIcon then
    Exit;

  if FLargeCopied and not Force then // Ѿˣ Force ʱ˳
    Exit;

  IDEs := GetIDEImageList;
  if IDEs = nil then
    Exit;

  //  Force ʱж IDE  ImageList Ƿȣ򲻸
  if Force and (FLargeCopiedCount = IDEs.Count) then
    Exit;

  //  IDE  ImageList һ͵Ĺߴʹ
{$IFDEF IDE_SUPPORT_HDPI}
  FIDELargeVirtualImages.Clear;
  CopyVirtualImageList(IDEs as TVirtualImageList, FIDELargeVirtualImages);
{$IFDEF DEBUG}
  CnDebugger.LogFmt('Copy IDE ImageList %d to a Large Virtual ImageList %d',
    [IDEs.Count, FIDELargeVirtualImages.Count]);
{$ENDIF}

  Ico := TIcon.Create;
  try
    Images.GetIcon(IdxUnknown, Ico);
    FIdxUnknownLargeInIDE := AddGraphicToVirtualImageList(Ico,
      FIDELargeVirtualImages, 'CnWizardsLargeUnknown');
{$IFDEF DEBUG}
    CnDebugger.LogFmt('Add an Unknown Icon to IDE Large Index %d',
      [FIdxUnknownLargeInIDE]);
{$ENDIF}
  finally
    Ico.Free;
  end;
{$ENDIF}

  IDELargeImages.Clear;
  StretchCopyToLarge(IDEs, IDELargeImages);
{$IFDEF DEBUG}
  CnDebugger.LogFmt('Copy IDE ImageList %d to a Large ImageList %d',
    [IDEs.Count, IDELargeImages.Count]);
{$ENDIF}
  FLargeCopiedCount := IDEs.Count;
  FLargeCopied := True;
end;

function TdmCnSharedImages.GetIdxUnknownInIDE: Integer;
begin
  Result := FIdxUnknownInIDE;
{$IFDEF IDE_SUPPORT_HDPI}
  if WizOptions.UseLargeIcon then
    Result := FIdxUnknownLargeInIDE;
{$ENDIF}
end;

{$ENDIF}
end.
