{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnInputHelperEditFrm;
{* |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* Ԫƣרҷű༭
* Ԫߣܾ zjy@cnpack.org
*     ע
* ƽ̨PWinXP XP2 + Delphi 5.01
* ݲԣ
*   õԪеַϱػʽ
* ޸ļ¼2005.06.03
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

{$IFDEF CNWIZARDS_CNINPUTHELPER}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  CnWizMultiLang, CnWizConsts, StdCtrls, CnCommon, CnInputSymbolList,
  CnSpin;

type
  TCnInputHelperEditForm = class(TCnTranslateForm)
    grp1: TGroupBox;
    lbl1: TLabel;
    edtName: TEdit;
    lbl2: TLabel;
    edtDesc: TEdit;
    lbl3: TLabel;
    cbbKind: TComboBox;
    btnHelp: TButton;
    btnOK: TButton;
    btnCancel: TButton;
    chkAutoIndent: TCheckBox;
    lbl4: TLabel;
    seScope: TCnSpinEdit;
    lbl5: TLabel;
    chkAlwaysDisp: TCheckBox;
    chkForPascal: TCheckBox;
    chkForCpp: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure btnHelpClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure cbbKindChange(Sender: TObject);
  private

  protected
    function GetHelpTopic: string; override;
  public

  end;

function CnShowInputHelperEditForm(var AName, ADesc: string;
  var AKind: TCnSymbolKind; var Scope: Integer; var AutoIndent,
  AlwaysDisp, ForPascal, ForCpp: Boolean): Boolean;

{$ENDIF CNWIZARDS_CNINPUTHELPER}

implementation

{$IFDEF CNWIZARDS_CNINPUTHELPER}

{$R *.DFM}

function CnShowInputHelperEditForm(var AName, ADesc: string;
  var AKind: TCnSymbolKind; var Scope: Integer; var AutoIndent,
  AlwaysDisp, ForPascal, ForCpp: Boolean): Boolean;
begin
  with TCnInputHelperEditForm.Create(Application) do
  try
    edtName.Text := AName;
    edtDesc.Text := ADesc;
    cbbKind.ItemIndex := Ord(AKind);
    seScope.Value := Scope;
    chkAutoIndent.Checked := AutoIndent;
    chkAlwaysDisp.Checked := AlwaysDisp;
    chkForPascal.Checked := ForPascal;
    chkForCpp.Checked := ForCpp;
    cbbKindChange(nil);

    Result := ShowModal = mrOk;
    if Result then
    begin
      AName := Trim(edtName.Text);
      ADesc := Trim(edtDesc.Text);
      AKind := TCnSymbolKind(cbbKind.ItemIndex);
      Scope := seScope.Value;
      AutoIndent := chkAutoIndent.Checked;
      AlwaysDisp := chkAlwaysDisp.Checked;
      ForPascal := chkForPascal.Checked;
      ForCpp := chkForCpp.Checked;
    end;
  finally
    Free;
  end;
end;

procedure TCnInputHelperEditForm.FormCreate(Sender: TObject);
var
  Kind: TCnSymbolKind;
begin
  inherited;
  for Kind := Low(Kind) to High(Kind) do
    cbbKind.Items.Add(GetSymbolKindName(Kind));
end;

function TCnInputHelperEditForm.GetHelpTopic: string;
begin
  Result := SCnInputHelperHelpStr;
end;

procedure TCnInputHelperEditForm.btnHelpClick(Sender: TObject);
begin
  ShowFormHelp;
end;

procedure TCnInputHelperEditForm.btnOKClick(Sender: TObject);
begin
  if Trim(edtName.Text) = '' then
  begin
    ErrorDlg(SCnInputHelperSymbolNameIsEmpty);
    Exit;
  end;

  if cbbKind.ItemIndex < 0 then
  begin
    ErrorDlg(SCnInputHelperSymbolKindError);
    Exit;
  end;

  ModalResult := mrOk;
end;

procedure TCnInputHelperEditForm.cbbKindChange(Sender: TObject);
begin
  chkAutoIndent.Enabled := TCnSymbolKind(cbbKind.ItemIndex) in
    [skTemplate, skComment];
end;

{$ENDIF CNWIZARDS_CNINPUTHELPER}
end.
