{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnWizClasses;
{* |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣCnWizards ඨ嵥Ԫ
* Ԫߣܾ (zjy@cnpack.org)
*     עõԪΪ CnWizards ܵһ֣רҵĻࡣ
*           ҪעһʵֵרңʵָרҵĵԪ initialization ڵ
*           RegisterCnWizard עһרá
*         - TCnBaseWizard
*            CnWizard ײĳࡣ
*           - TCnIconWizard
*             ͼĳࡣ
*             - TCnIDEEnhanceWizard
*               IDE չרһࡣ
*             - TCnActionWizard
*                IDE Action ĳ࣬пݼרҡ
*               - TCnMenuWizard
*                 ˵ĵĳ࣬ͨ˵õרҡ
*                 - TCnSubMenuWizard
*                   Ӳ˵ĳ࣬ͨӲ˵õרҡ
*             - TCnRepositoryWizard
*                Repository רһࡣ
*               - TCnFormWizard
*                 嵥Ԫļģ򵼻࣬ Pas Ԫ
*               - TCnProjectWizard
*                 Ӧó򹤳̵ģ򵼻ࡣ
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеַϱػʽ
* ޸ļ¼2015.05.19 V2.0
*               LiuXiao Ҽ˵ࡣ
*           2015.01.03 V1.9
*               LiuXiao  ResetSettings ء
*           2004.06.01 V1.8
*               LiuXiao  TCnSubMenuWizard.OnPopup ڵ˵мӲ˵
*           2004.04.27 V1.7
*               beta  TCnSubMenuWizard һAddSubMenuWizard
*               ӦķṩԶ༶Ӳ˵רҵ֧֡
*           2003.12.12 V1.6
*                TCnUnitWizard  IOTAFormWizard ӿڡ
*           2003.06.22 V1.5
*               ӳ TCnIconWizardԴͼרҡ
*               ӻ TCnIDEEnhanceWizardԴ IDE չࡣ
*           2003.05.02 V1.4
*               ʵ TCnSubMenuWizard.ShowShortCutDialog 
*           2003.04.15 V1.3
*               Ӳ˵רҲİť״̬Զµ
*           2003.02.27 V1.2
*               ΪӲ˵רӹť֧֣ʱ
*           2002.10.26 V1.1
*                CnSubMenuWizard 
*           2002.09.17 V1.0
*               Ԫʵֻ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

uses
  Windows, Classes, Sysutils, Graphics, Menus, ActnList, IniFiles, ToolsAPI,
  Registry, ComCtrls, Forms, CnHashMap, CnWizIni,
  CnWizShortCut, CnWizMenuAction, CnIni, CnWizConsts, CnPopupMenu;

type

//==============================================================================
// רҰרҳ
//==============================================================================

{ TCnBaseWizard }

{$M+}

  TCnBaseWizard = class(TNotifierObject, IOTAWizard)
  {* CnWizard רҳ࣬רĹ }
  private
    FActive: Boolean;
    FWizardIndex: Integer;
    FDefaultsMap: TCnStrToVariantHashMap;
  protected
    procedure SetActive(Value: Boolean); virtual;
    {* Active дظ÷ Active Ա¼
       ʱ÷ LoadSettings ֮ãȷݺٱ״̬ }
    function GetHasConfig: Boolean; virtual;
    {* HasConfig Զظ÷Ƿڿ }
    function GetIcon: TIcon; virtual; abstract;
    {* Icon Զظ÷طרͼ꣬ûרͨԼ }
    function GetBigIcon: TIcon; virtual; abstract;
    {* ߴ Icon Զظ÷طרͼ꣬ûרͨԼ }

    // IOTAWizard methods
    function GetIDString: string;
    function GetName: string; virtual;
  public
    constructor Create; virtual;
    {* ๹ }
    destructor Destroy; override;
    {*  }
    class function WizardName: string;
    {* ȡרƣֱ֧ػַ }
    function GetAuthor: string; virtual;
    {* }
    function GetComment: string; virtual;
    {* ע}
    function GetSearchContent: string; virtual;
    {* عַ԰ǶŷָӢĹؼʣҪСд}
    procedure DebugComand(Cmds: TStrings; Results: TStrings); virtual;
    {*  Debug  Results Уڲ}

    // IOTAWizard methods
    function GetState: TWizardState; virtual;
    {* ר״̬IOTAWizard ظ÷ר״̬ }
    procedure Execute; virtual; abstract;
    {* רִ巽IOTAWizard 󷽷ʵ֡
       ûִһרʱø÷ }

    procedure Loaded; virtual;
    {* IDE ɺø÷}

    procedure LaterLoaded; virtual;
    {* IDE ɸһЩø÷ڸ߰汾 IDE д IDE ˵̫ٵĳ}

    class function IsInternalWizard: Boolean; virtual;
    {* רǷڲרңʾ }

    class procedure GetWizardInfo(var Name, Author, Email, Comment: string);
      virtual; {$IFNDEF BCB}abstract;{$ENDIF BCB}
    {* ȡרϢṩרҵ˵ͰȨϢ󷽷ʵ֡
     |<PRE>
       var AName: string      - רƣֱ֧ػַ
       var Author: string     - רߣжߣ÷ֺŷָ
       var Email: string      - ר䣬жߣ÷ֺŷָ
       var Comment: string    - ר˵ֱ֧ػзַ
     |</PRE> }
    procedure Config; virtual;
    {* ר÷רҹרýеã HasConfig ΪʱЧ }
    procedure LanguageChanged(Sender: TObject); virtual;
    {* רڶԷıʱĴش˹̴ַ }
    procedure LoadSettings(Ini: TCustomIniFile); virtual;
    {* װר÷ش˷ INI жȡרҲ
       ע˷רһбöΣҪ
       ֹظص¶ݵ⡣ }
    procedure SaveSettings(Ini: TCustomIniFile); virtual;
    {* ר÷ش˷רҲ浽 INI  }
    procedure ResetSettings(Ini: TCustomIniFile); virtual;
    {* ר÷ INI ֮ı涯Ҫش˷ }

    class function GetIDStr: string;
    {* רΨһʶʹ }
    function CreateIniFile(CompilerSection: Boolean = False): TCustomIniFile;
    {* һڴȡרò INI ûʹúԼͷ }
    procedure DoLoadSettings;
    {* װר }
    procedure DoSaveSettings;
    {* ר }
    procedure DoResetSettings;
    {* ר}

    property Active: Boolean read FActive write SetActive;
    {* ԾԣרҵǰǷ }
    property HasConfig: Boolean read GetHasConfig;
    {* ʾרǷý }
    property WizardIndex: Integer read FWizardIndex write FWizardIndex;
    {* רע IDE صţͷרʱʹã벻Ҫ޸ĸֵ }
    property Icon: TIcon read GetIcon;
    {* רͼԣС ActionWizard  16x16 IconWizard Ĭ 32x32 }
    property BigIcon: TIcon read GetBigIcon;
    {* רҴͼ꣬еĻ}
  end;

{$M-}

type
  TCnWizardClass = class of TCnBaseWizard;

//==============================================================================
// ͼԵĻ
//==============================================================================

{ TCnIconWizard }

  TCnIconWizard = class(TCnBaseWizard)
  {* IDE ͼԵĻ }
  private
    FIcon: TIcon;
  protected
    function GetIcon: TIcon; override;
    {* ظרҵͼ꣬ش˹̷ Icon 
       FIcon ʹϵͳĬϳߴ磬һ 32 * 32 }
    function GetBigIcon: TIcon; override;
    {* ظרҵĴͼ꣬32 * 32 }
    procedure InitIcon(AIcon, ASmallIcon: TIcon); virtual;
    {* ʼͼ꣬󴴽ʱãش˹´ FIcon }
    class function GetIconName: string; virtual;
    {* ͼļ }
  public
    constructor Create; override;
    {* ๹ }
    destructor Destroy; override;
    {*  }
  end;

//==============================================================================
// IDE չ
//==============================================================================

{ TCnIDEEnhanceWizard }

  TCnIDEEnhanceWizard = class(TCnIconWizard);
  {* IDE չ }

//==============================================================================
//  Action Ϳݼĳר
//==============================================================================

{ TCnActionWizard }

  TCnActionWizard = class(TCnIDEEnhanceWizard)
  {*  Action Ϳݼ CnWizard רҳ࣬ӸIcon  16x16 }
  private
    FAction: TCnWizAction;
    function GetImageIndex: Integer;
  protected
    function GetIcon: TIcon; override;
    procedure OnActionUpdate(Sender: TObject); virtual;
    function CreateAction: TCnWizAction; virtual;
    procedure Click(Sender: TObject); virtual;
    function GetCaption: string; virtual; abstract;
    {* רҵı }
    function GetHint: string; virtual;
    {* רҵ Hint ʾ }
    function GetDefShortCut: TShortCut; virtual;
    {* רҵĬϿݼʵʹʱרҵĿݼɹ趨
       ֻҪĬϵľˡ }
  public
    constructor Create; override;
    {* ๹ }
    destructor Destroy; override;
    {*  }
    function GetSearchContent: string; override;
    {* عַѱ Hint ȥ }
    property ImageIndex: Integer read GetImageIndex;
    {* רͼ IDE  ImageList е }
    property Action: TCnWizAction read FAction;
    {* ר Action  }
    function EnableShortCut: Boolean; virtual;
    {* רǷÿݼ }
    procedure RefreshAction; virtual;
    {* ¸ Action  }
  end;

//==============================================================================
// ˵ĳר
//==============================================================================

{ TCnMenuWizard }

type
  TCnMenuWizard = class(TCnActionWizard)
  {* ˵ CnWizard רҳ }
  private
    FMenuOrder: Integer;
    function GetAction: TCnWizMenuAction;
    function GetMenu: TMenuItem;
    procedure SetMenuOrder(const Value: Integer);
  protected
    function CreateAction: TCnWizAction; override;
  public
    constructor Create; override;

    function EnableShortCut: Boolean; override;
    {* רǷÿݼ }
    property Menu: TMenuItem read GetMenu;
    {* רҵĲ˵ }
    property Action: TCnWizMenuAction read GetAction;
    {* ר Action  }
    property MenuOrder: Integer read FMenuOrder write SetMenuOrder;
  end;

//==============================================================================
// Ӳ˵ĳר
//==============================================================================

{ TCnSubMenuWizard }

  TCnSubMenuWizard = class(TCnMenuWizard)
  {* Ӳ˵ CnWizard רҳ }
  private
    FList: TList;
    FPopupMenu: TPopupMenu;
    FPopupAction: TCnWizAction; // ڷõʱİťӦ Action Action ͼظ
    FExecuting: Boolean;
    FRefreshing: Boolean;
    procedure FreeSubMenus;
    procedure OnExecute(Sender: TObject);
    procedure OnUpdate(Sender: TObject);
    procedure OnPopup(Sender: TObject);
    function GetSubActions(Index: Integer): TCnWizMenuAction;
    function GetSubActionCount: Integer;
    function GetSubMenus(Index: Integer): TMenuItem;
  protected
    procedure SetActive(Value: Boolean); override;
    procedure OnActionUpdate(Sender: TObject); override;
    function CreateAction: TCnWizAction; override;
    procedure Click(Sender: TObject); override;
    function IndexOf(SubAction: TCnWizMenuAction): Integer;
    {* ָ Action бе }
    function RegisterASubAction(const ACommand, ACaption: string;
      AShortCut: TShortCut = 0; const AHint: string = '';
      const AIconName: string = ''): Integer;
    {* עһ Actionš
     |<PRE>
       ACommand: string         - Action ֣ΪһΨһֵַ
       ACaption: string         - Action ı
       AShortCut: TShortCut     - Action ĬϿݼʵʹõļֵעжȡ
       AHint: string            - Action ʾϢ
       Result: Integer          - бе
     |</PRE> }
    procedure AddSubMenuWizard(SubMenuWiz: TCnSubMenuWizard);
    {* ΪרҹҽһӲ˵ר }
    procedure AddSepMenu;
    {* һָ˵ }
    procedure DeleteSubAction(Index: Integer);
    {* ɾָ Action }

    function ShowShortCutDialog(const HelpStr: string): Boolean;
    {* ʾ Action ݼöԻ }

    procedure SubActionExecute(Index: Integer); virtual;
    {* Ӳ˵ִзΪӲ˵ţרظ÷ Action ִ¼ }
    procedure SubActionUpdate(Index: Integer); virtual;
    {* Ӳ˵·ΪӲ˵ţרظ÷ Action ״̬ }
  public
    constructor Create; override;
    {* ๹ }
    destructor Destroy; override;
    {*  }
    function GetSearchContent: string; override;
    {* عַӲ˵ı Hint ȥ }
    procedure DebugComand(Cmds: TStrings; Results: TStrings); override;
    {* ʱӡӲ˵Լ Action ȵϢ}
    procedure Execute; override;
    {* ִʲô }
    function EnableShortCut: Boolean; override;
    {* Ƿÿݼ False }
    procedure AcquireSubActions; virtual;
    {* ش˹̣ڲ RegisterASubAction Ӳ˵
        ˹ڶлʱᱻظá }
    procedure ClearSubActions; virtual;
    {* ɾе ActionӲ˵еķָ }
    procedure RefreshAction; override;
    {* صˢ Action ķ˼̳ˢ²˵⣬ˢӲ˵ Action }
    procedure RefreshSubActions; virtual;
    {*  Actionش˷ֹ Action  }
    property SubActionCount: Integer read GetSubActionCount;
    {* ר Action  }
    property SubMenus[Index: Integer]: TMenuItem read GetSubMenus;
    {* רҵӲ˵ }
    property SubActions[Index: Integer]: TCnWizMenuAction read GetSubActions;
    {* רҵ Action  }
    function ActionByCommand(const ACommand: string): TCnWizAction;
    {* ֲָ Action򷵻 nil}
  end;

//==============================================================================
//  Repository רһ
//==============================================================================

{ TCnRepositoryWizard }

  TCnRepositoryWizard = class(TCnIconWizard, IOTARepositoryWizard)
  {* CnWizard ģ򵼳 }
  protected
    FIconHandle: HICON;
    function GetName: string; override;
    {*  GetName  WizardName Ϊʾַ  }
  public
    constructor Create; override;
    {* ๹ }
    destructor Destroy; override;
    {*  }

    // IOTARepositoryWizard methods
    function GetPage: string;
    {$IFDEF COMPILER6_UP}
    function GetGlyph: Cardinal;
    {$ELSE}
    function GetGlyph: HICON;
    {$ENDIF}
  end;

//==============================================================================
// Ԫģ򵼻
//==============================================================================

{ TCnUnitWizard }

  TCnUnitWizard = class(TCnRepositoryWizard, {$IFDEF DELPHI10_UP}IOTAProjectWizard{$ELSE}IOTAFormWizard{$ENDIF});
  {* ʵ IOTAFormWizard  New Իг, BDS2006 Ҫ IOTAProjectWizard}

//==============================================================================
// ģ򵼻
//==============================================================================

{ TCnFormWizard }

  TCnFormWizard = class(TCnRepositoryWizard, IOTAFormWizard);

//==============================================================================
// ģ򵼻
//==============================================================================

{ TCnProjectWizard }

  TCnProjectWizard = class(TCnRepositoryWizard, IOTAProjectWizard);

//==============================================================================
// ༭Ҽ˵ִĿĻ࣬Ӧʵֹ
//==============================================================================

{ TCnBaseMenuExecutor }

  TCnBaseMenuExecutor = class(TObject)
  {* ༭Ҽ˵ִĿĻ࣬ɴĳһרʵ}
  private
    FTag: Integer;
    FWizard: TCnBaseWizard;
  public
    constructor Create(OwnWizard: TCnBaseWizard); virtual;
    {* ๹ }
    destructor Destroy; override;
    {*  }

    function GetActive: Boolean; virtual;
    {* ĿǷʾ˳ŵ}
    function GetCaption: string; virtual;
    {* Ŀʾı⣬˳ŵһ}
    function GetHint: string; virtual;
    {* Ŀʾ}
    function GetEnabled: Boolean; virtual;
    {* ĿǷʹܣ˳ŵ}
    procedure Prepare; virtual;
    {* PrepareItem ʱã˳ŵڶ}
    function Execute: Boolean; virtual;
    {* ĿִзĬʲô}

    property Wizard: TCnBaseWizard read FWizard;
    {*  Wizard ʵ}
    property Tag: Integer read FTag write FTag;
    {* һ Tag}
  end;

//==============================================================================
// ༭Ҽ˵ִĿһʽĻ࣬¼ִָв
//==============================================================================

{ TCnContextMenuExecutor }

  TCnContextMenuExecutor = class(TCnBaseMenuExecutor)
  {* ༭Ҽ˵ִĿһʽĻ࣬¼ִָв}
  private
    FActive: Boolean;
    FEnabled: Boolean;
    FCaption: string;
    FHint: string;
    FOnExecute: TNotifyEvent;
  protected
    procedure DoExecute; virtual;
  public
    constructor Create; reintroduce; virtual;

    function GetActive: Boolean; override;
    function GetCaption: string; override;
    function GetHint: string; override;
    function GetEnabled: Boolean; override;
    function Execute: Boolean; override;

    property Caption: string read FCaption write FCaption;
    {* Ŀʾı}
    property Hint: string read FHint write FHint;
    {* Ŀʾʾ}
    property Active: Boolean read FActive write FActive;
    {* ĿǷʾ}
    property Enabled: Boolean read FEnabled write FEnabled;
    {* ĿǷʹ}
    property OnExecute: TNotifyEvent read FOnExecute write FOnExecute;
    {* Ŀִзִʱ}
  end;

//==============================================================================
// רбع
//==============================================================================

procedure RegisterCnWizard(const AClass: TCnWizardClass);
{* עһ CnBaseWizard רãÿרʵֵԪӦڸõԪ initialization
   ڵøùער }

function GetCnWizardClass(const ClassName: string): TCnWizardClass;
{* רȡָר }

function GetCnWizardClassCount: Integer;
{* ער }

function GetCnWizardClassByIndex(const Index: Integer): TCnWizardClass;
{* ȡָר }

function GetCnWizardTypeNameFromClass(AClass: TClass): string;
{* רȡר }

function GetCnWizardTypeName(AWizard: TCnBaseWizard): string;
{* רʵȡָר }

procedure GetCnWizardInfoStrs(AWizard: TCnBaseWizard; Infos: TStrings);
{* ȡרʵַбϢ}

procedure AdjustCnWizardsClassOrder;
{* רҹʱער˳ԱŻĲ˵˳}

implementation

uses
  CnWizUtils, CnWizOptions, CnCommon
{$IFNDEF CNWIZARDS_MINIMUM}
  , CnWizCommentFrm, CnWizSubActionShortCutFrm
{$ENDIF}
  {$IFDEF DEBUG}, CnDebug{$ENDIF};

//==============================================================================
// רбع
//==============================================================================

var
  CnWizardClassList: TList = nil; // רб

// עһ CnBaseWizard ר
procedure RegisterCnWizard(const AClass: TCnWizardClass);
begin
  Assert(CnWizardClassList <> nil, 'CnWizardClassList is nil!');
  if CnWizardClassList.IndexOf(AClass) < 0 then
    CnWizardClassList.Add(AClass);
end;

// רȡָר
function GetCnWizardClass(const ClassName: string): TCnWizardClass;
var
  I: Integer;
begin
  for I := 0 to CnWizardClassList.Count - 1 do
  begin
    Result := CnWizardClassList[I];
    if Result.ClassNameIs(ClassName) then
      Exit;
  end;
  Result := nil;
end;

// ער
function GetCnWizardClassCount: Integer;
begin
  Result := CnWizardClassList.Count;
end;

// ȡָר
function GetCnWizardClassByIndex(const Index: Integer): TCnWizardClass;
begin
  Result := nil;
  if (Index >= 0) and (Index <= CnWizardClassList.Count - 1) then
    Result := CnWizardClassList[Index];
end;

// רȡר
function GetCnWizardTypeNameFromClass(AClass: TClass): string;
begin
  if AClass.InheritsFrom(TCnProjectWizard) then
    Result := SCnProjectWizardName
  else if AClass.InheritsFrom(TCnFormWizard) then
    Result := SCnFormWizardName
  else if AClass.InheritsFrom(TCnUnitWizard) then
    Result := SCnUnitWizardName
  else if AClass.InheritsFrom(TCnRepositoryWizard) then
    Result := SCnRepositoryWizardName
  else if AClass.InheritsFrom(TCnSubMenuWizard) then
    Result := SCnSubMenuWizardName
  else if AClass.InheritsFrom(TCnMenuWizard) then
    Result := SCnMenuWizardName
  else if AClass.InheritsFrom(TCnActionWizard) then
    Result := SCnActionWizardName
  else if AClass.InheritsFrom(TCnIDEEnhanceWizard) then
    Result := SCnIDEEnhanceWizardName
  else
    Result := SCnBaseWizardName;
end;

// רʵȡָר
function GetCnWizardTypeName(AWizard: TCnBaseWizard): string;
begin
  Result := GetCnWizardTypeNameFromClass(AWizard.ClassType);
end;

procedure GetCnWizardInfoStrs(AWizard: TCnBaseWizard; Infos: TStrings);
begin
  if (AWizard <> nil) and (Infos <> nil) then
  begin
    Infos.Add('ClassName: ' + AWizard.ClassName);
    Infos.Add('IDString: ' + AWizard.GetIDString);
    Infos.Add('WizardName: ' + AWizard.WizardName);
    Infos.Add('Comment: ' + AWizard.GetComment);

    if AWizard is TCnIconWizard then
    begin
      // ӡ Icon Ϣ
    end;
    if AWizard is TCnActionWizard then
    begin
      Infos.Add('Action Caption: ' + (AWizard as TCnActionWizard).Action.Caption);
      Infos.Add('Action Hint: ' + (AWizard as TCnActionWizard).Action.Hint);
      Infos.Add('Action ImageIndex: ' + IntToStr((AWizard as TCnActionWizard).Action.ImageIndex));
      Infos.Add('Action ShortCut: ' + ShortCutToText((AWizard as TCnActionWizard).Action.ShortCut));
    end;
  end;
end;

procedure AdjustCnWizardsClassOrder;
var
  I: Integer;
  W: TCnWizardClass;
begin
  // 빤߼ȸ
  for I := 0 to CnWizardClassList.Count - 1 do
  begin
    W := TCnWizardClass(CnWizardClassList[I]);
    if W.ClassNameIs('TCnCodingToolsetWizard') then
    begin
      CnWizardClassList.Delete(I);
      CnWizardClassList.Insert(0, W);
      Break;
    end;
  end;

  // רҸ棬±빤߼
  for I := 0 to CnWizardClassList.Count - 1 do
  begin
    W := TCnWizardClass(CnWizardClassList[I]);
    if W.ClassNameIs('TCnAlignSizeWizard') then
    begin
      CnWizardClassList.Delete(I);
      CnWizardClassList.Insert(0, W);
      Break;
    end;
  end;

  // AI ȸ
  for I := 0 to CnWizardClassList.Count - 1 do
  begin
    W := TCnWizardClass(CnWizardClassList[I]);
    if W.ClassNameIs('TCnAICoderWizard') then
    begin
      CnWizardClassList.Delete(I);
      CnWizardClassList.Add(W);
      Break;
    end;
  end;

  // űרҸ󣬼 AI 
  for I := 0 to CnWizardClassList.Count - 1 do
  begin
    W := TCnWizardClass(CnWizardClassList[I]);
    if W.ClassNameIs('TCnScriptWizard') then
    begin
      CnWizardClassList.Delete(I);
      CnWizardClassList.Add(W);
      Break;
    end;
  end;
end;

//==============================================================================
// רҰרһ
//==============================================================================

{ TCnBaseWizard }

// ๹
constructor TCnBaseWizard.Create;
begin
  inherited Create;
  FWizardIndex := -1;
end;

// 
destructor TCnBaseWizard.Destroy;
begin
  FDefaultsMap.Free;
  inherited Destroy;
end;

{$IFDEF BCB}
class procedure TCnBaseWizard.GetWizardInfo(var Name, Author, Email,
  Comment: string);
begin

end;
{$ENDIF BCB}

// ȡר
class function TCnBaseWizard.WizardName: string;
var
  Author, Email, Comment: string;
begin
  GetWizardInfo(Result, Author, Email, Comment);
end;

// רΨһʶʹ
class function TCnBaseWizard.GetIDStr: string;
begin
  Result := RemoveClassPrefix(ClassName);
end;

// ר
function TCnBaseWizard.GetAuthor: string;
var
  Name, Email, Comment: string;
begin
  GetWizardInfo(Name, Result, Email, Comment);
end;

// רע
function TCnBaseWizard.GetComment: string;
var
  Name, Author, Email: string;
begin
  GetWizardInfo(Name, Author, Email, Result);
end;

// عַ԰ǶŷָӢĹؼʣҪСд
function TCnBaseWizard.GetSearchContent: string;
begin
  Result := '';
end;

// רǷڲרңʾ
class function TCnBaseWizard.IsInternalWizard: Boolean;
begin
  Result := False;
end;

//  Debug  Results Уڲ
procedure TCnBaseWizard.DebugComand(Cmds: TStrings; Results: TStrings);
begin
  if Results <> nil then
    Results.Add(ClassName + ' Debug Command Not Implemented.');
end;

//------------------------------------------------------------------------------
// ÷
//------------------------------------------------------------------------------

// һڴȡרò INI ûʹúԼͷ
function TCnBaseWizard.CreateIniFile(CompilerSection: Boolean): TCustomIniFile;
var
  Path: string;
begin
  if FDefaultsMap = nil then
    FDefaultsMap := TCnStrToVariantHashMap.Create;

  if CompilerSection then
    Path := MakePath(MakePath(WizOptions.RegPath) + GetIDStr) + WizOptions.CompilerID
  else
    Path := MakePath(WizOptions.RegPath) + GetIDStr;
  Result := TCnWizIniFile.Create(Path, KEY_ALL_ACCESS, FDefaultsMap);
end;

procedure TCnBaseWizard.DoLoadSettings;
var
  Ini: TCustomIniFile;
begin
  Ini := CreateIniFile;
  try
  {$IFDEF DEBUG}
    CnDebugger.LogMsg('Loading settings: ' + ClassName);
  {$ENDIF}
    LoadSettings(Ini);
  finally
    Ini.Free;
  end;
end;

procedure TCnBaseWizard.DoSaveSettings;
var
  Ini: TCustomIniFile;
begin
  Ini := CreateIniFile;
  try
  {$IFDEF DEBUG}
    CnDebugger.LogMsg('Saving settings: ' + ClassName);
  {$ENDIF}
    SaveSettings(Ini);
  finally
    Ini.Free;
  end;
end;

procedure TCnBaseWizard.DoResetSettings;
var
  Ini: TCustomIniFile;
  List: TStrings;
  Reg: TRegistry;
begin
  Ini := CreateIniFile;
  List := TStringList.Create;
  try
  {$IFDEF DEBUG}
    CnDebugger.LogMsg('Reset settings: ' + ClassName);
  {$ENDIF}

    if Ini is TRegistryIniFile then
    begin
      with (Ini as TRegistryIniFile).RegIniFile do
      begin
  {$IFDEF DEBUG}
        CnDebugger.LogMsg('Remove Registry entry: ' + FileName);
  {$ENDIF}

        Reg := TRegistry.Create;
        try
          Reg.DeleteKey(FileName);
        finally
          Reg.Free;
        end;
      end;
    end;
    
    ResetSettings(Ini);

    DoLoadSettings; // ʹרʹĬ
  finally
    Ini.Free;
    List.Free;
  end;
end;

procedure TCnBaseWizard.Config;
begin
  // do nothing
end;

procedure TCnBaseWizard.LanguageChanged(Sender: TObject);
begin
  // do nothing
end;

procedure TCnBaseWizard.LoadSettings(Ini: TCustomIniFile);
begin
  with TCnIniFile.Create(Ini) do
  try
    ReadObject('', Self);
  finally
    Free;
  end;   
end;

procedure TCnBaseWizard.SaveSettings(Ini: TCustomIniFile);
begin
  with TCnIniFile.Create(Ini) do
  try
    WriteObject('', Self);
  finally
    Free;
  end;   
end;

procedure TCnBaseWizard.ResetSettings(Ini: TCustomIniFile);
begin
// do nothing
end;

procedure TCnBaseWizard.Loaded;
begin
  // do nothing
end;

procedure TCnBaseWizard.LaterLoaded;
begin
  // do nothing
end;

//------------------------------------------------------------------------------
// Զд
//------------------------------------------------------------------------------

// HasConfig Զ
function TCnBaseWizard.GetHasConfig: Boolean;
begin
  Result := False;
end;

// Active  д
procedure TCnBaseWizard.SetActive(Value: Boolean);
begin
  FActive := Value;
{$IFDEF DEBUG}
  CnDebugger.LogMsg(ClassName + ' SetActive to ' + IntToStr(Integer(Value)));
{$ENDIF}
end;

//------------------------------------------------------------------------------
// ʵֵ IOTAWizard 
//------------------------------------------------------------------------------

{ TCnBaseWizard.IOTAWizard }

function TCnBaseWizard.GetIDString: string;
begin
  Result := SCnWizardsNamePrefix + '.' + GetIDStr;
end;

function TCnBaseWizard.GetName: string;
begin
  Result := SCnWizardsNamePrefix + ' ' + GetIDStr;
end;

function TCnBaseWizard.GetState: TWizardState;
begin
  Result := [wsEnabled];
end;

//==============================================================================
// ͼԵĻ
//==============================================================================

{ TCnIconWizard }

constructor TCnIconWizard.Create;
begin
  inherited;
  FActive := True;
  FIcon := TIcon.Create;
  InitIcon(FIcon, nil);
end;

destructor TCnIconWizard.Destroy;
begin
  inherited;
  FIcon.Free;
end;

//  Icon ԣʹͼ꣬
function TCnIconWizard.GetIcon: TIcon;
begin
  Result := FIcon;
end;

// ش Icon ԣ
function TCnIconWizard.GetBigIcon: TIcon;
begin
  Result := FIcon;
end;

// ͼļ
class function TCnIconWizard.GetIconName: string;
begin
  Result := ClassName;
end;

// ʼͼ꣬
procedure TCnIconWizard.InitIcon(AIcon, ASmallIcon: TIcon);
begin
  if AIcon <> nil then
    CnWizLoadIcon(AIcon, ASmallIcon, GetIconName, True);
end;

//==============================================================================
//  Action Ϳݼĳר
//==============================================================================

{ TCnActionWizard }

// ๹
constructor TCnActionWizard.Create;
begin
  inherited Create;
  FActive := True;
  FAction := CreateAction;
  FAction.OnUpdate := OnActionUpdate;
end;

// 
destructor TCnActionWizard.Destroy;
begin
  if Assigned(FAction) then
    WizActionMgr.DeleteAction(FAction);
  inherited Destroy;
end;

// ¸ Action 
procedure TCnActionWizard.RefreshAction;
begin
  if FAction <> nil then
  begin
    FAction.Caption := GetCaption;
    FAction.Hint := GetHint;
  end;
end;

//------------------------------------------------------------------------------
// ⷽ
//------------------------------------------------------------------------------

// Action ¼
procedure TCnActionWizard.Click(Sender: TObject);
begin
  try
    if Active and Action.Enabled and (IsInternalWizard {$IFNDEF CNWIZARDS_MINIMUM} or
      ShowCnWizCommentForm(Self) {$ENDIF} ) then
      Execute;
  except
    on E: Exception do
      DoHandleException(Format('%s Click Error. %s - %s',
        [ClassName, E.ClassName, E.Message]));
  end;
end;

// ״̬¼
procedure TCnActionWizard.OnActionUpdate(Sender: TObject);
var
  State: TWizardState;
begin
  State := GetState;
  FAction.Visible := FActive;
  FAction.Enabled := FActive and (wsEnabled in State);
  FAction.Checked := wsChecked in State;
  // ĳЩ²ڿݼӲ˵Ĳ˵
  if not EnableShortCut then
    FAction.ShortCut := 0;
end;

//  Action
function TCnActionWizard.CreateAction: TCnWizAction;
begin
  Result := WizActionMgr.AddAction(GetIDStr, GetCaption, GetDefShortCut, Click,
    GetIconName, GetHint, True);
end;

// ȡĬϿݼ
function TCnActionWizard.GetDefShortCut: TShortCut;
begin
  Result := 0;
end;

// ȡרǷÿݼ
function TCnActionWizard.EnableShortCut: Boolean;
begin
  Result := True;
end;

// ȡ Hint ʾ
function TCnActionWizard.GetHint: string;
begin
  Result := '';
end;

function TCnActionWizard.GetSearchContent: string;
begin
  Result := GetCaption + ',' + GetHint + ',';
end;

//------------------------------------------------------------------------------
// Զд
//------------------------------------------------------------------------------

// Icon Զ
function TCnActionWizard.GetIcon: TIcon;
begin
  Assert(Assigned(FAction));
  Result := FAction.Icon;
end;

// ImageIndex Զ
function TCnActionWizard.GetImageIndex: Integer;
begin
  Assert(Assigned(FAction));
  Result := FAction.ImageIndex;
end;

//==============================================================================
// ˵ĳר
//==============================================================================

{ TCnMenuWizard }

// 췽
constructor TCnMenuWizard.Create;
begin
  inherited;
  FMenuOrder := -1;
end;

//  MenuOrder 
procedure TCnMenuWizard.SetMenuOrder(const Value: Integer);
begin
  FMenuOrder := Value;
end;

// ˵ Action
function TCnMenuWizard.CreateAction: TCnWizAction;
begin
  Result := WizActionMgr.AddMenuAction(GetIDStr, GetCaption, GetIDStr, GetDefShortCut, Click,
    GetIconName, GetHint, True);
end;

// Action Զ
function TCnMenuWizard.GetAction: TCnWizMenuAction;
begin
  Assert(inherited Action is TCnWizMenuAction);
  Result := TCnWizMenuAction(inherited Action);
end;

// Menu Զ
function TCnMenuWizard.GetMenu: TMenuItem;
begin
  Assert(Assigned(Action));
  Result := Action.Menu;
end;

// Ƿпݼ
function TCnMenuWizard.EnableShortCut: Boolean;
begin
  Result := (Menu = nil) or (Menu.Count = 0); // Ӳ˵ʱÿݼ
end;

//==============================================================================
// Ӳ˵ĳר
//==============================================================================

{ TCnSubMenuWizard }

// ๹
constructor TCnSubMenuWizard.Create;
var
  Svcs40: INTAServices40;
begin
  inherited;
  FList := TList.Create;
  // רұŵʱťĲ˵
  FPopupMenu := TPopupMenu.Create(nil);
  QuerySvcs(BorlandIDEServices, INTAServices40, Svcs40);
  FPopupMenu.Images := Svcs40.ImageList;

  // ڹϰť ActionͼӦ Action ͼһΪظ
  FPopupAction := WizActionMgr.AddAction(GetIDStr + '1', GetCaption, 0, OnPopup,
    '', GetHint);
  // ȴյͼٸ ImageIndex ֵʡ SubMenuWizard еÿһ Icon
  FPopupAction.ImageIndex := Action.ImageIndex;
  FPopupAction.OnUpdate := OnActionUpdate;
end;

// 
destructor TCnSubMenuWizard.Destroy;
begin
  ClearSubActions;
  FreeSubMenus;
  WizActionMgr.DeleteAction(FPopupAction);
  FPopupMenu.Free;
  FList.Free;
  inherited;
end;

function TCnSubMenuWizard.GetSearchContent: string;
var
  I: Integer;
  Act: TCnWizAction;
begin
  Result := inherited GetSearchContent;
  for I := 0 to SubActionCount - 1 do
  begin
    Act := SubActions[I];
    Result := Result + Act.Caption + ',' + Act.Hint + ',';
  end;
end;

procedure TCnSubMenuWizard.DebugComand(Cmds: TStrings; Results: TStrings);
var
  I: Integer;
  Act: TCnWizAction;
begin
  for I := 0 to SubActionCount - 1 do
  begin
    Act := SubActions[I];
    Results.Add(IntToStr(I) + '. ' + Act.Command + ': ' + Act.Caption);
  end;
end;

procedure TCnSubMenuWizard.AcquireSubActions;
begin
// ಻Ӳ˵
end;

// ר Action 
function TCnSubMenuWizard.CreateAction: TCnWizAction;
begin
  Result := inherited CreateAction;  //  Action ͼ FPopupAction ظӰ첻
  Assert(Result is TCnWizMenuAction);
  Result.ActionList := nil; // ֹ Action Զص ToolBar 
  TCnWizMenuAction(Result).Menu.ImageIndex := -1; // Ӳ˵ʾλͼ
end;

// ִ
procedure TCnSubMenuWizard.Execute;
begin
// ִʲô
end;

// Ӳ˵רҲÿݼñ
function TCnSubMenuWizard.EnableShortCut: Boolean;
begin
  Result := False;
end;

// Ӳ˵רˢ Action ʱأ˳ Action Ҳˢһ¡
procedure TCnSubMenuWizard.RefreshAction;
begin
  inherited;
  // ˢڹϰť Action
  FRefreshing := True;
  try
    if FPopupAction <> nil then
    begin
      FPopupAction.Caption := GetCaption;
      FPopupAction.Hint := GetHint;
    end;
    RefreshSubActions;
  finally
    FRefreshing := False;
  end;
end;

// ˢ Action 类أɲ inherited ֹˢ¡
procedure TCnSubMenuWizard.RefreshSubActions;
begin
{$IFDEF DEBUG}
  CnDebugger.LogMsg(ClassName + ' to RefreshSubActions.');
{$ENDIF}
  if FActive then
  begin
    AcquireSubActions;
    WizActionMgr.ArrangeMenuItems(Menu);
  end
  else
    ClearSubActions;
end;

// Ǽһ Action
function TCnSubMenuWizard.RegisterASubAction(const ACommand, ACaption: string;
  AShortCut: TShortCut; const AHint: string; const AIconName: string): Integer;
var
  NewAction: TCnWizMenuAction;
  IconName: string;
  I: Integer;
begin
  if AIconName = '' then
    IconName := ACommand
  else
    IconName := AIconName;

  if FRefreshing then
  begin
    for I := 0 to FList.Count - 1 do
    begin
      if TCnWizMenuAction(FList[I]).Command = ACommand then
      begin
        TCnWizMenuAction(FList[I]).Caption := ACaption;
        TCnWizMenuAction(FList[I]).Hint := AHint;
        Result := I;
        Exit;
      end;
    end;
  end;

  NewAction := WizActionMgr.AddMenuAction(ACommand, ACaption, ACommand, AShortCut,
    OnExecute, IconName, AHint);
  NewAction.OnUpdate := OnUpdate;
  Menu.Add(NewAction.Menu);
  Result := FList.Add(NewAction);
end;

// ΪרҹҽһӲ˵רң Action бе
procedure TCnSubMenuWizard.AddSubMenuWizard(SubMenuWiz: TCnSubMenuWizard);
begin
  // Ӳ˵רҵĲ˵뱾רҲ˵
  Menu.Add(SubMenuWiz.Action.Menu);
  // һҪӲ˵רҵ Actionμ ClearSubActions е˵
  FList.Add(SubMenuWiz.Action);
end;

// һָ˵
procedure TCnSubMenuWizard.AddSepMenu;
var
  SepMenu: TMenuItem;
begin
  if not FRefreshing then
  begin
    SepMenu := TMenuItem.Create(Menu);
    SepMenu.Caption := '-';
    Menu.Add(SepMenu);
  end;
end;

//  Action бӲ˵еķָ
procedure TCnSubMenuWizard.ClearSubActions;
var
  WizAction: TCnWizAction;
begin
{$IFDEF DEBUG}
  CnDebugger.LogMsg(ClassName + ' to ClearSubActions.');
{$ENDIF}
  while FList.Count > 0 do
  begin
    WizAction := SubActions[0];
    //  Action Ĳ˵Ӳ˵˵ Action һӲ˵רҵ Action
    // ɾ Action ĹӦӲ˵רңӲ˵ר
    // 뱾רҲ˵֮ĹӲ˵רҵ Menu.Parent ʼղΪ nil´
    // ٽӲ˵רҹκרʱֲ˵ظ쳣ұ
    //  Menu.Clear ɾӲ˵רҵĲ˵Ӳ˵רͷʱͨɾ
    //  Action ɾӲ˵ʱӲ˵ѱɾ AV 쳣
    // LiuXiao: Ӳ˵רһͷ Actionظͷ´
    try
      if Assigned(WizAction) and (WizAction is TCnWizMenuAction) and
        (TCnWizMenuAction(WizAction).Menu.Count > 0) then
        Menu.Remove(TCnWizMenuAction(WizAction).Menu)
      else
        WizActionMgr.DeleteAction(WizAction);
    except
      ;
    end;
    FList.Delete(0);
  end;
  Menu.Clear; // ɾӲ˵еķָ
end;

// ɾһ Action
procedure TCnSubMenuWizard.DeleteSubAction(Index: Integer);
var
  WizAction: TCnWizAction;
begin
  if (Index >= 0) and (Index < FList.Count) then
  begin
    WizAction := SubActions[Index];
    //  Action Ĳ˵Ӳ˵˵ Action һӲ˵רҵ Action
    // ɾ Action ĹӦӲ˵רңӲ˵ר
    // 뱾רҲ˵֮ĹӲ˵רҵ Menu.Parent ʼղΪ nil´
    // ٽӲ˵רҹκרʱֲ˵ظ쳣
    if Assigned(WizAction) and (WizAction is TCnWizMenuAction) and
      (TCnWizMenuAction(WizAction).Menu.Count > 0) then
      Menu.Remove(TCnWizMenuAction(WizAction).Menu)
    else
      WizActionMgr.DeleteAction(WizAction);
    FList.Delete(Index);
  end;
end;

// ͷŲ˵
procedure TCnSubMenuWizard.FreeSubMenus;
begin
  Menu.Clear;
end;

// ָ Action бе
function TCnSubMenuWizard.IndexOf(SubAction: TCnWizMenuAction): Integer;
var
  I: Integer;
begin
  Result := -1;
  for I := 0 to FList.Count - 1 do
  begin
    if SubActions[I] = SubAction then
    begin
      Result := I;
      Exit;
    end;
  end;
end;

function TCnSubMenuWizard.ActionByCommand(const ACommand: string): TCnWizAction;
var
  I: Integer;
begin
  Result := nil;
  for I := 0 to FList.Count - 1 do
  begin
    if SubActions[I].Command = ACommand then
    begin
      Result := SubActions[I];
      Exit;
    end;
  end;
end;

// רҵ÷
procedure TCnSubMenuWizard.Click(Sender: TObject);
begin
  // ̳еñʾʾԻ
end;

// Action ִ
procedure TCnSubMenuWizard.OnExecute(Sender: TObject);
var
  I: Integer;
begin
  if not Active or FExecuting then
    Exit;

  FExecuting := True;
  try
    for I := 0 to FList.Count - 1 do
    begin
      if TObject(FList[I]) = Sender then
      begin
        // ֹͨݼЧĹ
        SubActions[I].Update;
        if SubActions[I].Enabled then
        begin
          try
            // ڲרҲʾ
            if IsInternalWizard {$IFNDEF CNWIZARDS_MINIMUM} or ShowCnWizCommentForm(WizardName + ' - ' +
              GetCaptionOrgStr(SubActions[I].Caption), SubActions[I].Icon,
              SubActions[I].Command) {$ENDIF} then
              SubActionExecute(I);
          except
            on E: Exception do
            begin
              DoHandleException(Format('%s.SubActions[%d].Execute: %s - %s',
                [ClassName, I, E.ClassName, E.Message]));
            end;
          end;
        end;

        Exit;
      end;
    end;
  finally
    FExecuting := False;
  end;
end;

// Action 
procedure TCnSubMenuWizard.OnUpdate(Sender: TObject);
var
  I: Integer;
begin
  OnActionUpdate(nil);
  for I := 0 to FList.Count - 1 do
  begin
    if TObject(FList[I]) = Sender then
    begin
      SubActionUpdate(I);
      Exit;
    end;
  end;
end;

// ʾݼöԻ
function TCnSubMenuWizard.ShowShortCutDialog(const HelpStr: string): Boolean;
begin
{$IFNDEF CNWIZARDS_MINIMUM}
  Result := SubActionShortCutConfig(Self, HelpStr);
{$ELSE}
  Result := False;
{$ENDIF}
end;

procedure TCnSubMenuWizard.SetActive(Value: Boolean);
var
  Old: Boolean;
begin
  Old := FActive;
  inherited;             // ȷǷı䣬Ҳ
  if Old <> Value then
    RefreshSubActions;
end;

procedure TCnSubMenuWizard.OnActionUpdate(Sender: TObject);
begin
  inherited;
  FPopupAction.Visible := Action.Visible;
  FPopupAction.Enabled := Action.Enabled;
  FPopupAction.Checked := Action.Checked;
end;

procedure TCnSubMenuWizard.OnPopup(Sender: TObject);
var
  Point: TPoint;

  procedure AddMenuSubItems(SrcItem, DstItem: TMenuItem);
  var
    MenuItem, SubItem: TMenuItem;
    I, J: Integer;
  begin
    for I := 0 to SrcItem.Count - 1 do
    begin
      MenuItem := TMenuItem.Create(FPopupMenu);
      MenuItem.Action := SrcItem.Items[I].Action;
      if not Assigned(MenuItem.Action) then
        MenuItem.Caption := SrcItem.Items[I].Caption
      else if MenuItem.Action is TCnWizMenuAction then
      begin  // ӶӲ˵
        for J := 0 to TCnWizMenuAction(MenuItem.Action).Menu.Count - 1 do
        begin
          SubItem := TMenuItem.Create(FPopupMenu);
          SubItem.Action := TCnWizMenuAction(MenuItem.Action).Menu.Items[J].Action;
          if not Assigned(SubItem.Action) then
            SubItem.Caption := TCnWizMenuAction(MenuItem.Action).Menu.Items[J].Caption;
          MenuItem.Add(SubItem);
        end;
      end;
      AddMenuSubItems(SrcItem.Items[I], MenuItem);
      DstItem.Add(MenuItem);
    end;
  end;
begin
  FPopupMenu.Items.Clear;
  AddMenuSubItems(Menu, FPopupMenu.Items);
  GetCursorPos(Point);
  FPopupMenu.Popup(Point.x, Point.y);
end;

//------------------------------------------------------------------------------
// ⷽ
//------------------------------------------------------------------------------

// Ӳ˵ִзΪӲ˵
procedure TCnSubMenuWizard.SubActionExecute(Index: Integer);
begin

end;

// Ӳ˵·ΪӲ˵
procedure TCnSubMenuWizard.SubActionUpdate(Index: Integer);
begin
  SubActions[Index].Visible := Active;
  SubActions[Index].Enabled := Active and Action.Enabled;
end;

//------------------------------------------------------------------------------
// Զд
//------------------------------------------------------------------------------

// SubActionCount Զ
function TCnSubMenuWizard.GetSubActionCount: Integer;
begin
  Result := FList.Count;
end;

// SubActions Զ
function TCnSubMenuWizard.GetSubActions(Index: Integer): TCnWizMenuAction;
begin
  Result := nil;
  if (Index >= 0) and (Index < FList.Count) then
    Result := TCnWizMenuAction(FList[Index]);
end;

// SubMenus Զ
function TCnSubMenuWizard.GetSubMenus(Index: Integer): TMenuItem;
begin
  Result := nil;
  if (Index >= 0) and (Index < FList.Count) then
    Result := TCnWizMenuAction(FList[Index]).Menu; 
end;

//==============================================================================
// Repositoryרһ
//==============================================================================

{ TCnRepositoryWizard }

// 
constructor TCnRepositoryWizard.Create;
begin
  inherited;
  FIconHandle := 0;
end;

// 
destructor TCnRepositoryWizard.Destroy;
begin
  if FIcon <> nil then
    FreeAndNil(FIcon);
//  if FIconHandle <> 0 then    //  IDE ͷţ˴Ҫͷţл niaoge ļ
//    DestroyIcon(FIconHandle);
  inherited;
end;

//  GetName  WizardName Ϊʾַ
function TCnRepositoryWizard.GetName: string;
begin
  Result := WizardName;
end;

//------------------------------------------------------------------------------
// ʵֵ IOTARepositoryWizard 
//------------------------------------------------------------------------------

{ TCnRepositoryWizard.IOTARepositoryWizard }

// ͼ
{$IFDEF COMPILER6_UP}
function TCnRepositoryWizard.GetGlyph: Cardinal;
{$ELSE}
function TCnRepositoryWizard.GetGlyph: HICON;
{$ENDIF}
begin
  // IDE ͼ꣬ʹ CopyIcon ޷ʾһ
  // ԭеͼ˴Ĵɱ֤ͼʾҲԴй©
  DestroyIcon(FIconHandle);
  FIconHandle := CopyIcon(Icon.Handle);
  Result := FIconHandle;
end;

// ذװҳ
function TCnRepositoryWizard.GetPage: string;
begin
  Result := SCnWizardsPage;
end;

//==============================================================================
// Ҽ˵ִĿĻ
//==============================================================================

{ TCnBaseMenuExecutor }

// ๹
constructor TCnBaseMenuExecutor.Create(OwnWizard: TCnBaseWizard);
begin
  FWizard := OwnWizard;
end;

// 
destructor TCnBaseMenuExecutor.Destroy;
begin

  inherited;
end;

// PrepareItem ʱãĬʲô
procedure TCnBaseMenuExecutor.Prepare;
begin

end;

// ĿִзĬʲô
function TCnBaseMenuExecutor.Execute: Boolean;
begin
  Result := True;
end;

// ĿǷʾ
function TCnBaseMenuExecutor.GetActive: Boolean;
begin
  Result := True;
end;

// Ŀʾı
function TCnBaseMenuExecutor.GetCaption: string;
begin
  Result := '';
end;

// ĿǷʹ
function TCnBaseMenuExecutor.GetEnabled: Boolean;
begin
  Result := True;
end;

// Ŀʾ
function TCnBaseMenuExecutor.GetHint: string;
begin
  Result := '';
end;

{ TCnContextMenuExecutor }

constructor TCnContextMenuExecutor.Create;
begin
  inherited Create(nil);
  FActive := True;
  FEnabled := True;
end;

procedure TCnContextMenuExecutor.DoExecute;
begin
  if Assigned(FOnExecute) then
    FOnExecute(Self);
end;

function TCnContextMenuExecutor.Execute: Boolean;
begin
  DoExecute;
  Result := True;
end;

function TCnContextMenuExecutor.GetActive: Boolean;
begin
  Result := FActive;
end;

function TCnContextMenuExecutor.GetCaption: string;
begin
  Result := FCaption;
end;

function TCnContextMenuExecutor.GetEnabled: Boolean;
begin
  Result := FEnabled;
end;

function TCnContextMenuExecutor.GetHint: string;
begin
  Result := FHint;
end;

initialization
  CnWizardClassList := TList.Create;

{$IFDEF DEBUG}
  CnDebugger.LogMsg('Initialization Done: CnWizClasses.');
{$ENDIF}

finalization
{$IFDEF DEBUG}
  CnDebugger.LogEnter('CnBaseWizard finalization.');
{$ENDIF}

  FreeAndNil(CnWizardClassList);

{$IFDEF DEBUG}
  CnDebugger.LogLeave('CnBaseWizard finalization.');
{$ENDIF}

end.

