{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnPropEditorCustomizeFrm;
{ |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣԱ༭ƴ
* Ԫߣܾ (zjy@cnpack.org)
*     ע
* ƽ̨PWinXP SP2 + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеֱַ֧ػʽ
* ޸ļ¼2006.09.08 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

{$IFDEF CNWIZARDS_DESIGNEDITOR}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CnDesignEditorConsts, CnWizMultiLang;

type
  TCnPropEditorCustomizeForm = class(TCnTranslateForm)
    grp1: TGroupBox;
    mmoProp: TMemo;
    lbl1: TLabel;
    btnOK: TButton;
    btnCancel: TButton;
    btnHelp: TButton;
    procedure btnHelpClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  protected
    function GetHelpTopic: string; override;
  public
    { Public declarations }
  end;

function ShowPropEditorCustomizeForm(List: TStrings; IsComp: Boolean): Boolean;

{$ENDIF CNWIZARDS_DESIGNEDITOR}

implementation

{$IFDEF CNWIZARDS_DESIGNEDITOR}

{$R *.DFM}

function ShowPropEditorCustomizeForm(List: TStrings; IsComp: Boolean): Boolean;
begin
  with TCnPropEditorCustomizeForm.Create(nil) do
  try
    if IsComp then
    begin
      Caption := SCnCompEditorCustomizeCaption;
      grp1.Caption := SCnCompEditorCustomizeCaption1;
      lbl1.Caption := SCnCompEditorCustomizeDesc;
    end;
    mmoProp.Lines.Assign(List);
    Result := ShowModal = mrOk;
    if Result then
      List.Assign(mmoProp.Lines);
  finally
    Free;
  end;   
end;  

procedure TCnPropEditorCustomizeForm.btnHelpClick(Sender: TObject);
begin
  ShowFormHelp;
end;

function TCnPropEditorCustomizeForm.GetHelpTopic: string;
begin
  Result := 'CnPropEditorCustomizeForm';
end;

procedure TCnPropEditorCustomizeForm.FormKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  if (Shift = [ssCtrl]) and (Ord(Key) = VK_RETURN) then
    btnOK.Click;
end;

{$ENDIF CNWIZARDS_DESIGNEDITOR}
end.
 
