{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnNamePropEditor;
{* |<PRE>
================================================================================
* ƣԡ༭
* ԪƣԱ༭
* Ԫߣܾ (zjy@cnpack.org)
*     עǰ׺ר޸
* ƽ̨PWinXP SP2 + Delphi 5.0
* ݲԣPWin9X/2000/XP + Delphi 5/6/7
*   õԪʹеַѾػʽ
* ޸ļ¼2005.04.07
*             Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

{$IFDEF CNWIZARDS_DESIGNEDITOR}
{$IFDEF CNWIZARDS_CNPREFIXWIZARD}

uses
  Windows, SysUtils, Classes, ToolsAPI, StdCtrls, Controls, Forms,
{$IFDEF COMPILER6_UP}
  DesignIntf, DesignEditors,
{$ELSE}
  DsgnIntf,
{$ENDIF}
  CnCommon, CnConsts, CnDesignEditor, CnDesignEditorConsts;

type

{ TCnNamePropEditor }

  TCnNamePropEditor = class(TStringProperty)
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
    class procedure GetInfo(var Name, Author, Email, Comment: String);
    class procedure Register;
  end;

{$ENDIF CNWIZARDS_CNPREFIXWIZARD}
{$ENDIF CNWIZARDS_DESIGNEDITOR}

implementation

{$IFDEF CNWIZARDS_DESIGNEDITOR}
{$IFDEF CNWIZARDS_CNPREFIXWIZARD}

uses
  CnWizManager, CnPrefixWizard {$IFDEF DEBUG}, CnDebug {$ENDIF};

procedure TCnNamePropEditor.Edit;
var
  Wizard: TCnPrefixWizard;
begin
  Wizard := TCnPrefixWizard(CnWizardMgr.WizardByClass(TCnPrefixWizard));
  if Assigned(Wizard) and Wizard.Active then
  begin
    if (GetComponent(0) is TComponent) and
      (Trim(TComponent(GetComponent(0)).Name) <> '') then
    begin
      Wizard.ExecuteRename(TComponent(GetComponent(0)), True);
    end;
  end
  else
  begin
    ErrorDlg(SCnPrefixWizardNotExist);
  end;
end;

function TCnNamePropEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paRevertable, paDialog];
end;

class procedure TCnNamePropEditor.GetInfo(var Name, Author, Email,
  Comment: String);
begin
  Name := SCnNamePropEditorName;
  Author := SCnPack_Zjy;
  Email := SCnPack_ZjyEmail;
  Comment := SCnNamePropEditorComment;
end;

class procedure TCnNamePropEditor.Register;
var
  Wizard: TCnPrefixWizard;
begin
  Wizard := TCnPrefixWizard(CnWizardMgr.WizardByClass(TCnPrefixWizard));
  if Assigned(Wizard) and Wizard.Active then
  begin
    RegisterPropertyEditor(TypeInfo(TComponentName), TControl, 'Name',
      TCnNamePropEditor);
    RegisterPropertyEditor(TypeInfo(TComponentName), TComponent, 'Name',
      TCnNamePropEditor);
  end;
end;

initialization
  CnDesignEditorMgr.RegisterPropEditor(TCnNamePropEditor,
    TCnNamePropEditor.GetInfo, TCnNamePropEditor.Register);

{$IFDEF DEBUG}
  CnDebugger.LogMsg('Initialization Done: CnNamePropEditor.');
{$ENDIF}

{$ENDIF CNWIZARDS_CNPREFIXWIZARD}
{$ENDIF CNWIZARDS_DESIGNEDITOR}
end.
