{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnDesignEditor;
{ |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* Ԫƣԡ༭Ԫ
* Ԫߣܾ (zjy@cnpack.org)
*     עԡ༭Ԫ
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеֱַ֧ػʽ
* ޸ļ¼2003.04.28 V1.1
*               ޸Ա༭ܣʹ PropertyMapper ̬Ա༭
*               ֶ֧̬жͬʱϱ༭֧мԣרҰ
*               Ա༭ȼߡ
*           2003.03.22 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

{$IFDEF CNWIZARDS_DESIGNEDITOR}

uses
  Windows, SysUtils, Classes, Graphics, IniFiles, Registry, TypInfo, Contnrs,
  {$IFDEF COMPILER6_UP}
  DesignIntf, DesignEditors,
  {$ELSE}
  DsgnIntf,
  {$ENDIF}
  ToolsAPI, CnCommon, CnConsts, CnDesignEditorConsts, CnWizOptions, CnWizUtils,
  CnIni, CnWizNotifier, CnEventBus;

type

//==============================================================================
// ԡ༭Ϣ
//==============================================================================

  TCnGetEditorInfoProc = procedure (var Name, Author, Email, Comment: string)
    of object;
  TCnObjectProc = procedure of object;
  TCnCustomRegisterProc = procedure (PropertyType: PTypeInfo; ComponentClass:
    TClass; const PropertyName: string; var Success: Boolean) of object;

{ TCnDesignEditorInfo }

{$M+}

  TCnDesignEditorInfo = class
  private
    FActive: Boolean;
    FIDStr: string;
    FEmail: string;
    FComment: string;
    FAuthor: string;
    FName: string;
    FConfigProc: TCnObjectProc;
    FEditorInfoProc: TCnGetEditorInfoProc;
    FRegEditorProc: TCnObjectProc;
  protected
    function GetHasConfig: Boolean; virtual;
    function GetHasCustomize: Boolean; virtual;
    function GetRegPath: string; virtual; abstract;
    procedure SetActive(const Value: Boolean); virtual;
  public
    constructor Create; virtual;
    {* ๹ }
    procedure Config; virtual;
    {* Ա༭÷ɹýеã HasConfig ΪʱЧ }
    procedure Customize; virtual;
    {* Ա༭Զ巽ɹýеã HasCustomize ΪʱЧ }
    procedure LanguageChanged(Sender: TObject);
    {* ¶Ա༭ַ }
    procedure LoadSettings(Ini: TCustomIniFile); virtual;
    {* װ÷ش˷ INI жȡ }
    procedure SaveSettings(Ini: TCustomIniFile); virtual;
    {* ÷ش˷浽 INI  }
    function CreateIniFile(CompilerSection: Boolean = False): TCustomIniFile;
    {* һڴȡò INI ûʹúԼͷ }
    procedure DoLoadSettings;
    {* װ }
    procedure DoSaveSettings;
    {* װ }
    procedure Loaded; virtual;
    {* IDE ɺø÷}

    property IDStr: string read FIDStr;
    {* ΨһʶԱ༭ }
    property Name: string read FName;
    {* Ա༭ƣֱ֧ػַ }
    property Author: string read FAuthor;
    {* Ա༭ߣжߣ÷ֺŷָ }
    property Email: string read FEmail;
    {* Ա༭䣬жߣ÷ֺŷָ }
    property Comment: string read FComment;
    {* Ա༭˵ֱ֧ػзַ }
    property HasConfig: Boolean read GetHasConfig;
    {* ʾԱ༭Ƿý }
    property HasCustomize: Boolean read GetHasCustomize;
    {* ʾԱ༭Ƿ֧ûע }
    property Active: Boolean read FActive write SetActive;
    {* ԾԣԱ༭ǰǷ }

    property EditorInfoProc: TCnGetEditorInfoProc read FEditorInfoProc write FEditorInfoProc;
    {* ȡ༭Ϣķָ }
    property RegEditorProc: TCnObjectProc read FRegEditorProc write FRegEditorProc;
    {* ȡ༭Ϣķָ }
  end;

{$M-}

{ TCnPropEditorInfo }

  TCnPropEditorInfo = class(TCnDesignEditorInfo)
  private
    FCustomProperties: TStringList;
    FCustomRegProc: TCnCustomRegisterProc;
    procedure CheckCustomProperties;
  protected
    function GetRegPath: string; override;
    function GetHasCustomize: Boolean; override;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure LoadSettings(Ini: TCustomIniFile); override;
    procedure SaveSettings(Ini: TCustomIniFile); override;
    procedure Customize; override;

    property CustomRegProc: TCnCustomRegisterProc read FCustomRegProc write FCustomRegProc;
    {* ûԶע }
    property CustomProperties: TStringList read FCustomProperties;
    {* ûԶעݣÿиʽΪ ClassName.PropName }
  end;

{ TCnCompEditorInfo }

  TCnCompEditorInfo = class(TCnDesignEditorInfo)
  private
    FEditorClass: TComponentEditorClass;
    FCustomClasses: TStringList;
    procedure CheckCustomClasses;
  protected
    function GetRegPath: string; override;
    function GetHasCustomize: Boolean; override;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure LoadSettings(Ini: TCustomIniFile); override;
    procedure SaveSettings(Ini: TCustomIniFile); override;
    function GetEditorClass: TComponentEditorClass;
    procedure Customize; override;

    property CustomClasses: TStringList read FCustomClasses;
    {* ûԶעݣÿиʽΪ ClassName }
  end;

//==============================================================================
// ԡ༭б
//==============================================================================

  TCnDesignEditorMgr = class(TObject)
  private
    FPropEditorList: TObjectList;
    FCompEditorList: TObjectList;
    FGroup: Integer;
    FActive: Boolean;
    FReceiver: ICnEventBusReceiver;

    function GetPropEditorCount: Integer;
    function GetPropEditor(Index: Integer): TCnPropEditorInfo;
    function GetPropEditorByClass(AEditor: TPropertyEditorClass): TCnPropEditorInfo;
    function GetPropEditorActive(AEditor: TPropertyEditorClass): Boolean;

    function GetCompEditorCount: Integer;
    function GetCompEditor(Index: Integer): TCnCompEditorInfo;
    function GetCompEditorByClass(AEditor: TComponentEditorClass): TCnCompEditorInfo;
    function GetCompEditorActive(AEditor: TComponentEditorClass): Boolean;

    procedure SetActive(const Value: Boolean);
  public
    constructor Create; virtual;
    destructor Destroy; override;

    procedure RegisterPropEditor(AEditor: TPropertyEditorClass;
      AEditorInfoProc: TCnGetEditorInfoProc; ARegEditorProc: TCnObjectProc;
      ACustomRegister: TCnCustomRegisterProc = nil; AConfigProc: TCnObjectProc = nil);
    {* עһԱ༭Ϣ }
    procedure RegisterCompEditor(AEditor: TComponentEditorClass;
      AEditorInfoProc: TCnGetEditorInfoProc; ARegEditorProc: TCnObjectProc;
      AConfigProc: TCnObjectProc = nil);
    {* עһ༭Ϣ }

    procedure Register;
    {* עеԡ༭ }
    procedure UnRegister;
    {* ȡע }
    procedure LanguageChanged(Sender: TObject);
    {* Աˢ Editor  Info }

    property PropEditorCount: Integer read GetPropEditorCount;
    {* עԱ༭ }
    property PropEditors[Index: Integer]: TCnPropEditorInfo read GetPropEditor;
    {* ȡָԱ༭Ϣ }
    property PropEditorsByClass[AEditor: TPropertyEditorClass]: TCnPropEditorInfo
      read GetPropEditorByClass;
    {* ݱ༭ȡָԱ༭Ϣ }
    property PropEditorActive[AEditor: TPropertyEditorClass]: Boolean read GetPropEditorActive;
    {* ָı༭ǷЧ }

    property CompEditorCount: Integer read GetCompEditorCount;
    {* עԱ༭ }
    property CompEditors[Index: Integer]: TCnCompEditorInfo read GetCompEditor;
    {* ȡָԱ༭Ϣ }
    property CompEditorsByClass[AEditor: TComponentEditorClass]: TCnCompEditorInfo
      read GetCompEditorByClass;
    {* ݱ༭ȡָԱ༭Ϣ }
    property CompEditorActive[AEditor: TComponentEditorClass]: Boolean read GetCompEditorActive;
    {* ָı༭ǷЧ }

    function IndexOfPropEditor(EditorInfo: TCnPropEditorInfo): Integer;
    {* Ա༭Infoбе}
    function IndexOfCompEditor(EditorInfo: TCnCompEditorInfo): Integer;
    {* Ա༭Infoбе}

    property Active: Boolean read FActive write SetActive;
  end;

function CnDesignEditorMgr: TCnDesignEditorMgr;
{* ر༭ }

{$ENDIF CNWIZARDS_DESIGNEDITOR}

implementation

{$IFDEF CNWIZARDS_DESIGNEDITOR}

uses
  {$IFDEF DEBUG} CnDebug, {$ENDIF}
  CnPropEditorCustomizeFrm;

const
  csCustomProperties = 'CustomProperties';
  csCustomClasses = 'CustomClasses';

var
  FCnDesignEditorMgr: TCnDesignEditorMgr;
{$IFDEF BDS}
  FNeedUnRegister: Boolean = True;
{$ENDIF}

type
  TCnWizardActiveChangedReceiver = class(TInterfacedObject, ICnEventBusReceiver)
  private
    FMgr: TCnDesignEditorMgr;
  public
    constructor Create(AMgr: TCnDesignEditorMgr);
    destructor Destroy; override;

    procedure OnEvent(Event: TCnEvent);
  end;

function CnDesignEditorMgr: TCnDesignEditorMgr;
begin
  if FCnDesignEditorMgr = nil then
    FCnDesignEditorMgr := TCnDesignEditorMgr.Create;
  Result := FCnDesignEditorMgr;
end;

function GetClassIDStr(ClassType: TClass): string;
begin
  Result := RemoveClassPrefix(ClassType.ClassName);
end;

{ TCnDesignEditorInfo }

constructor TCnDesignEditorInfo.Create;
begin
  inherited;
  FActive := True;
end;

//------------------------------------------------------------------------------
// ÷
//------------------------------------------------------------------------------

// һڴȡò INI ûʹúԼͷ
function TCnDesignEditorInfo.CreateIniFile(CompilerSection: Boolean): TCustomIniFile;
var
  Path: string;
begin
  if CompilerSection then
    Path := MakePath(MakePath(GetRegPath) + IDStr) + WizOptions.CompilerID
  else
    Path := MakePath(GetRegPath) + IDStr;
  Result := TRegistryIniFile.Create(Path, KEY_ALL_ACCESS);
end;

procedure TCnDesignEditorInfo.DoLoadSettings;
var
  Ini: TCustomIniFile;
begin
  Ini := CreateIniFile;
  try
{$IFDEF DEBUG}
    CnDebugger.LogMsg('DesignEditorInfo Loading Settings: ' + IDStr);
{$ENDIF}
    LoadSettings(Ini);
  finally
    Ini.Free;
  end;
end;

procedure TCnDesignEditorInfo.DoSaveSettings;
var
  Ini: TCustomIniFile;
begin
  Ini := CreateIniFile;
  try
{$IFDEF DEBUG}
    CnDebugger.LogMsg('DesignEditorInfo Saving Settings: ' + IDStr);
{$ENDIF}
    SaveSettings(Ini);
  finally
    Ini.Free;
  end;
end;

procedure TCnDesignEditorInfo.Config;
begin
  if HasConfig then
  begin
    FConfigProc;
  end;
end;

procedure TCnDesignEditorInfo.Customize;
begin
  // do noting.
end;

procedure TCnDesignEditorInfo.LanguageChanged(Sender: TObject);
begin
  if Assigned(FEditorInfoProc) then
    FEditorInfoProc(FName, FAuthor, FEmail, FComment);
end;

procedure TCnDesignEditorInfo.LoadSettings(Ini: TCustomIniFile);
begin
  with TCnIniFile.Create(Ini) do
  try
    ReadObject('', Self);
  finally
    Free;
  end;   
end;

procedure TCnDesignEditorInfo.SaveSettings(Ini: TCustomIniFile);
begin
  with TCnIniFile.Create(Ini) do
  try
    WriteObject('', Self);
  finally
    Free;
  end;   
end;

procedure TCnDesignEditorInfo.Loaded;
begin
  // do nothing
end;

function TCnDesignEditorInfo.GetHasConfig: Boolean;
begin
  Result := Assigned(FConfigProc);
end;

function TCnDesignEditorInfo.GetHasCustomize: Boolean;
begin
  Result := False;
end;

procedure TCnDesignEditorInfo.SetActive(const Value: Boolean);
begin
  FActive := Value;
end;

{ TCnPropEditorInfo }

procedure TCnPropEditorInfo.CheckCustomProperties;
var
  I: Integer;
begin
  for I := FCustomProperties.Count - 1 downto 0 do
  begin
    FCustomProperties[I] := Trim(FCustomProperties[I]);
    if (FCustomProperties[I] = '') or (Pos('.', FCustomProperties[I]) <= 1) then
      FCustomProperties.Delete(I);
  end;
end;

constructor TCnPropEditorInfo.Create;
begin
  inherited;
  FCustomProperties := TStringList.Create;
end;

procedure TCnPropEditorInfo.Customize;
begin
  inherited;
  if Assigned(FCustomRegProc) then
  begin
    if ShowPropEditorCustomizeForm(FCustomProperties, False) then
    begin
      CheckCustomProperties;
      DoSaveSettings;
    end;
  end;
end;

destructor TCnPropEditorInfo.Destroy;
begin
  FCustomProperties.Free;
  inherited;
end;

function TCnPropEditorInfo.GetHasCustomize: Boolean;
begin
  Result := Assigned(FCustomRegProc);
end;

function TCnPropEditorInfo.GetRegPath: string;
begin
  Result := WizOptions.PropEditorRegPath;
end;

procedure TCnPropEditorInfo.LoadSettings(Ini: TCustomIniFile);
begin
  inherited;
  FCustomProperties.CommaText := Ini.ReadString('', csCustomProperties, '');
  CheckCustomProperties;
end;

procedure TCnPropEditorInfo.SaveSettings(Ini: TCustomIniFile);
begin
  inherited;
  Ini.WriteString('', csCustomProperties, FCustomProperties.CommaText);
end;

{ TCnCompEditorInfo }

procedure TCnCompEditorInfo.CheckCustomClasses;
var
  I: Integer;
begin
  for I := FCustomClasses.Count - 1 downto 0 do
  begin
    FCustomClasses[I] := Trim(FCustomClasses[I]);
    if FCustomClasses[I] = '' then
      FCustomClasses.Delete(I);
  end;
end;

constructor TCnCompEditorInfo.Create;
begin
  inherited;
  FCustomClasses := TStringList.Create;
end;

procedure TCnCompEditorInfo.Customize;
begin
  if ShowPropEditorCustomizeForm(FCustomClasses, True) then
  begin
    CheckCustomClasses;
    DoSaveSettings;
  end;
end;

destructor TCnCompEditorInfo.Destroy;
begin
  FCustomClasses.Free;
  inherited;
end;

function TCnCompEditorInfo.GetEditorClass: TComponentEditorClass;
begin
  Result := FEditorClass;
end;

function TCnCompEditorInfo.GetHasCustomize: Boolean;
begin
  Result := True;
end;

function TCnCompEditorInfo.GetRegPath: string;
begin
  Result := WizOptions.CompEditorRegPath;
end;

procedure TCnCompEditorInfo.LoadSettings(Ini: TCustomIniFile);
begin
  inherited;
  FCustomClasses.CommaText := Ini.ReadString('', csCustomClasses, '');
  CheckCustomClasses;
end;

procedure TCnCompEditorInfo.SaveSettings(Ini: TCustomIniFile);
begin
  inherited;
  Ini.WriteString('', csCustomClasses, FCustomClasses.CommaText);
end;

{ TCnDesignEditorMgr }

constructor TCnDesignEditorMgr.Create;
begin
  inherited;
  FActive := True;
  FGroup := -1;
  FPropEditorList := TObjectList.Create(True);
  FCompEditorList := TObjectList.Create(True);

  FReceiver := TCnWizardActiveChangedReceiver.Create(Self);
end;

destructor TCnDesignEditorMgr.Destroy;
begin
  FReceiver := nil;

  UnRegister;
  FPropEditorList.Free;
  FCompEditorList.Free;
  inherited;
end;

//------------------------------------------------------------------------------
// ༭ע
//------------------------------------------------------------------------------

procedure TCnDesignEditorMgr.RegisterCompEditor(
  AEditor: TComponentEditorClass; AEditorInfoProc: TCnGetEditorInfoProc;
  ARegEditorProc, AConfigProc: TCnObjectProc);
var
  Info: TCnCompEditorInfo;
  IDStr: string;
  I: Integer;
begin
  IDStr := GetClassIDStr(AEditor);
  for I := 0 to CompEditorCount - 1 do
    if SameText(CompEditors[I].IDStr, IDStr) then
      Exit;

  Info := TCnCompEditorInfo.Create;
  Info.FIDStr := IDStr;
  Info.FEditorInfoProc := AEditorInfoProc;
  Info.FRegEditorProc := ARegEditorProc;
  Info.FConfigProc := AConfigProc;
  Info.FEditorClass := AEditor;
  if Assigned(AEditorInfoProc) then
    Info.LanguageChanged(nil);
  FCompEditorList.Add(Info);
end;

procedure TCnDesignEditorMgr.RegisterPropEditor(
  AEditor: TPropertyEditorClass; AEditorInfoProc: TCnGetEditorInfoProc;
  ARegEditorProc: TCnObjectProc; ACustomRegister: TCnCustomRegisterProc;
  AConfigProc: TCnObjectProc);
var
  Info: TCnPropEditorInfo;
  IDStr: string;
  I: Integer;
begin
  IDStr := GetClassIDStr(AEditor);
  for I := 0 to PropEditorCount - 1 do
    if SameText(PropEditors[I].IDStr, IDStr) then
      Exit;

  Info := TCnPropEditorInfo.Create;
  Info.FIDStr := IDStr;
  Info.FEditorInfoProc := AEditorInfoProc;
  Info.FRegEditorProc := ARegEditorProc;
  Info.FCustomRegProc := ACustomRegister;
  Info.FConfigProc := AConfigProc;
  if Assigned(AEditorInfoProc) then
    Info.LanguageChanged(nil);
  FPropEditorList.Add(Info);
end;

procedure TCnDesignEditorMgr.Register;
var
  I, J, Idx: Integer;
  AClass: TClass;
  AName, CName, PName: string;
  AInfo: PPropInfo;
  Success: Boolean;
begin
  UnRegister;

  FGroup := NewEditorGroup;
{$IFDEF DEBUG}
  CnDebugger.LogInteger(FGroup, 'NewEditorGroup');
{$ENDIF}
  for I := 0 to PropEditorCount - 1 do
    if PropEditors[I].Active then
    begin
      if Assigned(PropEditors[I].RegEditorProc) then
      begin
{$IFDEF DEBUG}
        CnDebugger.LogMsg('Register PropEditor: ' + PropEditors[I].IDStr);
{$ENDIF}
        PropEditors[I].RegEditorProc;
      end;

      // עԶ
      if Assigned(PropEditors[I].CustomRegProc) then
      begin
        for J := 0 to PropEditors[I].CustomProperties.Count - 1 do
        begin
          AName := Trim(PropEditors[I].CustomProperties[J]);
          Idx := Pos('.', AName);
          if Idx > 1 then
          begin
            CName := Trim(Copy(AName, 1, Idx - 1));
            PName := Trim(Copy(AName, Idx + 1, MaxInt));
            if (CName <> '') and (PName <> '') then
            begin
              AClass := GetClass(CName);
              if AClass <> nil then
              begin
                Success := False;
                AInfo := GetPropInfo(AClass, PName);
                if (AInfo <> nil) and (AInfo.PropType^ <> nil) then
                  PropEditors[I].CustomRegProc(AInfo.PropType^, AClass, PName, Success)
                else
                  PropEditors[I].CustomRegProc(nil, AClass, PName, Success);
{$IFDEF DEBUG}
                CnDebugger.LogFmt('PropEditor CustomRegister: %s.%s Succ: %s',
                  [CName, PName, BoolToStr(Success, True)]);
{$ENDIF}
              end
            end;
          end;
        end;
      end;
    end;

  for I := 0 to CompEditorCount - 1 do
  begin
    if CompEditors[I].Active and Assigned(CompEditors[I].RegEditorProc) then
    begin
{$IFDEF DEBUG}
      CnDebugger.LogMsg('Register CompEditor: ' + CompEditors[I].IDStr);
{$ENDIF}
      CompEditors[I].RegEditorProc;

      for J := 0 to CompEditors[I].CustomClasses.Count - 1 do
      begin
        AName := Trim(CompEditors[I].CustomClasses[J]);
        if AName <> '' then
        begin
          AClass := GetClass(AName);
          if AClass <> nil then
          begin
            RegisterComponentEditor(TComponentClass(AClass), CompEditors[I].GetEditorClass);
{$IFDEF DEBUG}
            CnDebugger.LogFmt('ComponentEditor CustomRegister: %s Succ: %s',
              [AName, BoolToStr(Success, True)]);
{$ENDIF}
          end
        end;
      end;
    end;
  end;

  // Ϊ˱ⷴעʱģеı༭Ҳעһܵ CodeRush
  // ע༭˴һ顣ȻܵжĿ飬
  // ʹ TBit Ϣ IDE ˵ûʲôӰ졣
  NewEditorGroup;
end;

procedure TCnDesignEditorMgr.UnRegister;
begin
  if FGroup >= 0 then
  begin
{$IFDEF DEBUG}
    CnDebugger.LogInteger(FGroup, 'FreeEditorGroup');
{$ENDIF}

    try
{$IFDEF BDS}
      // D8/D2005  DLL ͷʱÿܻ쳣
      if FNeedUnRegister then
        FreeEditorGroup(FGroup);
{$ELSE}
      FreeEditorGroup(FGroup);
{$ENDIF}
    except
      ;
    end;
    FGroup := -1;
  end;
end;

procedure TCnDesignEditorMgr.LanguageChanged(Sender: TObject);
var
  I: Integer;
begin
  for I := 0 to PropEditorCount - 1 do
    PropEditors[I].LanguageChanged(Sender);

  for I := 0 to CompEditorCount - 1 do
    CompEditors[I].LanguageChanged(Sender);
end;

//------------------------------------------------------------------------------
// Զд
//------------------------------------------------------------------------------

function TCnDesignEditorMgr.GetCompEditor(Index: Integer): TCnCompEditorInfo;
begin
  Result := TCnCompEditorInfo(FCompEditorList[Index]);
end;

function TCnDesignEditorMgr.GetCompEditorActive(
  AEditor: TComponentEditorClass): Boolean;
var
  Info: TCnCompEditorInfo;
begin
  Info := GetCompEditorByClass(AEditor);
  if Assigned(Info) then
    Result := Info.Active
  else
    Result := False;
end;

function TCnDesignEditorMgr.GetCompEditorByClass(
  AEditor: TComponentEditorClass): TCnCompEditorInfo;
var
  IDStr: string;
  I: Integer;
begin
  Result := nil;
  IDStr := GetClassIDStr(AEditor);
  for I := 0 to CompEditorCount - 1 do
  begin
    if SameText(CompEditors[I].IDStr, IDStr) then
    begin
      Result := CompEditors[I];
      Exit;
    end;
  end;
end;

function TCnDesignEditorMgr.GetCompEditorCount: Integer;
begin
  Result := FCompEditorList.Count;
end;

function TCnDesignEditorMgr.GetPropEditor(Index: Integer): TCnPropEditorInfo;
begin
  Result := TCnPropEditorInfo(FPropEditorList[Index]);
end;

function TCnDesignEditorMgr.GetPropEditorActive(
  AEditor: TPropertyEditorClass): Boolean;
var
  Info: TCnPropEditorInfo;
begin
  Info := PropEditorsByClass[AEditor];
  if Assigned(Info) then
    Result := Info.Active
  else
    Result := False;
end;

function TCnDesignEditorMgr.GetPropEditorByClass(
  AEditor: TPropertyEditorClass): TCnPropEditorInfo;
var
  IDStr: string;
  I: Integer;
begin
  Result := nil;
  IDStr := GetClassIDStr(AEditor);
  for I := 0 to PropEditorCount - 1 do
  begin
    if SameText(PropEditors[I].IDStr, IDStr) then
    begin
      Result := PropEditors[I];
      Exit;
    end;
  end;
end;

function TCnDesignEditorMgr.GetPropEditorCount: Integer;
begin
  Result := FPropEditorList.Count;
end;

procedure TCnDesignEditorMgr.SetActive(const Value: Boolean);
begin
  if FActive <> Value then
  begin
    FActive := Value;
    UnRegister;
    if FActive then
      Register;
  end;
end;

function TCnDesignEditorMgr.IndexOfCompEditor(
  EditorInfo: TCnCompEditorInfo): Integer;
var
  I: Integer;
begin
  for I := 0 to CompEditorCount - 1 do
  begin
    if FCompEditorList[I] = EditorInfo then
    begin
      Result := I;
      Exit;
    end;
  end;
  Result := -1;
end;

function TCnDesignEditorMgr.IndexOfPropEditor(
  EditorInfo: TCnPropEditorInfo): Integer;
var
  I: Integer;
begin
  for I := 0 to PropEditorCount - 1 do
  begin
    if FPropEditorList[I] = EditorInfo then
    begin
      Result := I;
      Exit;
    end;
  end;
  Result := -1;
end;

{ TCnWizardActiveChangedReceiver }

constructor TCnWizardActiveChangedReceiver.Create(
  AMgr: TCnDesignEditorMgr);
begin
  inherited Create;
  FMgr := AMgr;
end;

destructor TCnWizardActiveChangedReceiver.Destroy;
begin

  inherited;
end;

procedure TCnWizardActiveChangedReceiver.OnEvent(Event: TCnEvent);
begin
  FMgr.UnRegister;
  if FMgr.Active then
    FMgr.Register;
end;

initialization

finalization
{$IFDEF DEBUG}
  CnDebugger.LogEnter('CnDesignEditor finalization.');
{$ENDIF}

  if FCnDesignEditorMgr <> nil then
  begin
  {$IFDEF BDS}
    FNeedUnRegister := False;
  {$ENDIF}
    FreeAndNil(FCnDesignEditorMgr);
  end;

{$IFDEF DEBUG}
  CnDebugger.LogLeave('CnDesignEditor finalization.');
{$ENDIF}

{$ENDIF CNWIZARDS_DESIGNEDITOR}
end.

