{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnWizCmdSend;
{* |<PRE>
================================================================================
* ƣCnPack IDE רҹ߰
* ԪƣCnWizards ƵķͶ
* ԪߣCnPack CnPack  (master@cnpack.org)
*     עõԪʵ CnWizards ƵķͶ
*           ⲿϢʱҪʹõԪ
* ƽ̨WinXP + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеַϱػʽ
* ޸ļ¼2017.11.14 V1.1
*                Unicode 
*           2008.04.29 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

uses
  Messages, Windows, Classes, SysUtils, CnWizCompilerConst;

function CnWizSendCommand(Command: Cardinal; DestIDESet: TCnCompilers = [];
  const DestID: AnsiString = ''; const SourceID: AnsiString = '';
  const Params: TStrings = nil): Boolean;
{* ݴĲ
   :      Command: Cardinal;             
              DestIDESet: TCnCompilers = []; Ŀ IDE 汾Ҫ
              const DestID: AnsiString = '';     Ŀ ID
              const SourceID: AnsiString = '';   ߵԴ ID
              const Params: TStrings = nil;  ͵Ķݣ
                Ϊַбʽɶ param=value ʽַ

   ֵ:    BooleanǷͳɹ

   ע     δʹ CnWizCmdNotifier.AddCmdNotifier עԼĽ ID
              ˴ SourceID ãԷʹô SourceID ظҲ
              ޷ա SourceID ΪֻϢյļ򵥳ϡ

              ֻѾעԼĽ ID Ҵ˴͵ SourceID ע ID 
              £͵ϢԷ Reply ʱյԷĻӦ}

function CnWizSendCommandFromScript(Command: Cardinal; DestIDESet: TCnCompilers;
  const DestID: AnsiString; const Params: TStrings): Boolean;
{* űרҵõġ׵ķĺ
   :      Command: Cardinal;             
              DestIDESet: TCnCompilers = []; Ŀ IDE 汾Ҫ
              const DestID: AnsiString = '';     Ŀ ID
              const Params: TStrings = nil;  ͵Ķݣ
                Ϊַбʽɶ param=value ʽַ

   ֵ:    BooleanǷͳɹ

   ע     ڽű޷עԼĽ ID˷ʱҲעԴ ID
}

function CnWizReplyCommand(Command: Cardinal; DestIDESet: TCnCompilers = [];
  const SourceID: AnsiString = ''; const Params: TStrings = nil): Boolean;
{* յĴлظٴָĿĶ
   :      Command: Cardinal;             
              DestIDESet: TCnCompilers = [];     Ŀ IDE 汾Ҫ
              const SourceID: AnsiString = '';   ߵԴ ID
              const Params: TStrings = nil;  ͵Ķݣ
                Ϊַбʽɶ param=value ʽַ

   ֵ:    BooleanǷظɹ

   ע     ˺ֻڱ CnWizCmdNotifier.AddCmdNotifier ע֪ͨص
              еãط޷֪ǰķߣ˻
              ֻпͻʱҲǴ SourceID ʱظ

              Ϊ
              Է״η->״ν->ػӦ->ԷջӦ
              ->ػӦ->Է״η
}

implementation

uses
  CnWizCmdMsg, CnWizCmdNotify {$IFDEF DEBUG}, CnDebug {$ENDIF};

// ݴĲǷͳɹ
function CnWizSendCommand(Command: Cardinal; DestIDESet: TCnCompilers;
  const DestID: AnsiString; const SourceID: AnsiString; const Params: TStrings): Boolean;
var
  ASet: TCnCompilers;
  Cds: TCopyDataStruct;
  Cmd: PCnWizMessage;
  HWnd: Cardinal;
  S: AnsiString;
  DataLength, Cnt: Integer;
begin
  Result := False;

  // ˳
  if (Length(DestID) > CN_WIZ_MAX_ID) or (Length(SourceID) > CN_WIZ_MAX_ID) then
    Exit;

  HWnd := FindWindowEx(0, 0, PChar(SCN_WIZ_CMD_WINDOW_NAME), nil);
  if HWnd = 0 then // ĿĴ˳
  begin
{$IFDEF DEBUG}
    CnDebugger.LogMsgError('SendCommand: No Target Found.');
{$ENDIF}
    Exit;
  end;

  // ޲Ϊ
  if Params <> nil then
  begin
    S := AnsiString(Params.Text);
    DataLength := Length(S);
  end
  else
    DataLength := 0;

  Cds.cbData := SizeOf(TCnWizMessage) - SizeOf(Cardinal) + DataLength;

  GetMem(Cds.lpData, Cds.cbData);
  if Cds.lpData = nil then
    Exit;

  Cmd := Cds.lpData;
  FillChar(Cmd^, Cds.cbData, 0);

  Cmd^.Command := Command;

  ASet := DestIDESet;
  Cmd^.IDESets := Cardinal(PInteger(@ASet)^);

  // Unicode  StrCopy  Ansi 汾
  StrCopy(Cmd^.DestID, PAnsiChar(DestID));
  StrCopy(Cmd^.SourceID, PAnsiChar(SourceID));

  Cmd^.DataLength := DataLength;
  CopyMemory(@(Cmd^.Data[0]), @S[1], DataLength);

  try
    Cnt := 0;
    while HWnd <> 0 do
    begin
      Inc(Cnt);
{$IFDEF DEBUG}
      CnDebugger.LogFmt('SendCommand: Found %d Target %8.8x', [Cnt, HWnd]);
{$ENDIF}
      if GetCurrentThreadId <> GetWindowThreadProcessId(HWnd, nil) then
      begin
        // ֻ֮߳Ĵ
        Result := Boolean(SendMessage(HWnd, WM_COPYDATA, 0, LPARAM(@Cds)));
{$IFDEF DEBUG}
        CnDebugger.LogFmt('SendCommand: %d Target %8.8x Sent. Result: %d', [Cnt, HWnd, Integer(Result)]);
{$ENDIF}
      end;
      HWnd := FindWindowEx(0, HWnd, PChar(SCN_WIZ_CMD_WINDOW_NAME), nil);
    end;
  finally
    FreeMem(Cds.lpData);
  end;
end;

// űרҵõġ׵ķĺ
function CnWizSendCommandFromScript(Command: Cardinal; DestIDESet: TCnCompilers;
  const DestID: AnsiString; const Params: TStrings): Boolean;
begin
  Result := CnWizSendCommand(Command, DestIDESet, DestID, '', Params);
end;  

// յĴлظٴָĿĶˣǷظɹ
function CnWizReplyCommand(Command: Cardinal; DestIDESet: TCnCompilers;
  const SourceID: AnsiString; const Params: TStrings): Boolean;
begin
  Result := False;
  if CnWizCmdNotifier.GetCurrentSourceId <> '' then // ֻظĿͻ
    Result := CnWizSendCommand(Command, DestIDESet,
      CnWizCmdNotifier.GetCurrentSourceId, SourceID, Params);
end;

end.
