{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnSelectionCodeTool;
{ |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* Ԫƣѡıı빤߻
* Ԫߣܾ (zjy@cnpack.org)
*     עûѡıı빤߻
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеֱַ֧ػʽ
* ޸ļ¼2005.01.25 V1.2
*               ֲ GetText ܶȡ󳤶ȴȱ
*           2004.08.22 V1.1
*               ӴȫԪļѡ
*           2003.03.23 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

{$IFDEF CNWIZARDS_CNCODINGTOOLSETWIZARD}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, IniFiles, ToolsAPI, CnWizClasses, CnWizUtils, CnConsts, CnCommon,
  CnCodingToolsetWizard, CnWizConsts;

type

//==============================================================================
// ѡıı빤߻
//==============================================================================

{ TCnSelectionCodeTool }

  TCnCodeToolStyle = (csLine, csSelText, csAllText);
  {* ıķʽcsLine ΪѡзʽcsSelText/csAllTextΪѡ/ȫıʽ}

  TCnSelectionCodeTool = class(TCnBaseCodingToolset)
  {* ѡ봦߻ࡣ
     ûûѡıûѡ˴ִиñ༭ߣ
     ѡĴת}
  private
    FValidInSource: Boolean;
    FBlockMustNotEmpty: Boolean;
  protected
    property ValidInSource: Boolean read FValidInSource write FValidInSource;
    {* ֻԴļЧ }
    property BlockMustNotEmpty: Boolean read FBlockMustNotEmpty write
      FBlockMustNotEmpty;
    {* ֻеѡ鲻ΪʱЧ }
    procedure PrePreocessLine(const Str: string); virtual;
    {* ѡ Style Ϊ csLine зʽ÷ᱻãɶÿһнԤ}
    function ProcessLine(const Str: string): string; virtual;
    {* ѡ Style Ϊ csLine зʽʹø÷ÿһд룬
       ʱɲ ProcessText }
    function ProcessText(const Text: string): string; virtual;
    {* ѡ Style Ϊ csSelText/csAllText ȫıʽϣԼ
       Ӧظ÷ʱ ProcessLine 
       D5~D2007 Text 뷵ؽ AnsiString20052007  Text  UTF8 תַܶ
       D2009  Text 뷵ؽ UnicodeString}
    function GetStyle: TCnCodeToolStyle; virtual; abstract;
    {* ʽΪ csLineProcessText  Text ûѡ
       ΪСΪ csSelTextText ֻûʵѡı
       Ϊ csAllTextText ȫ Unit ݡ}
    procedure GetNewPos(var ARow: Integer; var ACol: Integer); virtual;
    {* ִϺͨش˺ȷڵλ}
  public
    constructor Create(AOwner: TCnCodingToolsetWizard); override;
    procedure Execute; override;
    function GetState: TWizardState; override;
  end;

{$ENDIF CNWIZARDS_CNCODINGTOOLSETWIZARD}

implementation

{$IFDEF CNWIZARDS_CNCODINGTOOLSETWIZARD}

{$IFDEF DEBUG}
uses
  CnDebug;
{$ENDIF}

//==============================================================================
// ѡıı빤߻
//==============================================================================

{ TCnSelectionCodeTool }

constructor TCnSelectionCodeTool.Create(AOwner: TCnCodingToolsetWizard);
begin
  inherited;
  ValidInSource := True;
  BlockMustNotEmpty := False;
end;

procedure TCnSelectionCodeTool.PrePreocessLine(const Str: string);
begin
  { do nothing }
end;

function TCnSelectionCodeTool.ProcessLine(const Str: string): string;
begin
  { do nothing }
end;

function TCnSelectionCodeTool.ProcessText(const Text: string): string;
var
  Lines: TStrings;
  I: Integer;
begin
  Lines := TStringList.Create;
  try
    Lines.Text := Text;
{$IFDEF DEBUG}
    CnDebugger.LogFmt('TCnSelectionCodeTool.ProcessText Default %d Lines.', [Lines.Count]);
{$ENDIF}

    for I := 0 to Lines.Count - 1 do  // Ԥһ
      PrePreocessLine(Lines[I]);

    for I := 0 to Lines.Count - 1 do
      Lines[I] := ProcessLine(Lines[I]);
    Result := Lines.Text;
  finally
    Lines.Free;
  end;
end;

procedure TCnSelectionCodeTool.Execute;
const
  SCnOtaBatchSize = $7FFF;
var
  View: IOTAEditView;
  Block: IOTAEditBlock;
  BlockText: string;
  OrigText: AnsiString;
  HasTab: Boolean;
  Text: string;
  Buf: PAnsiChar;
  I, BlockStartLine, BlockEndLine: Integer;
  StartPos, EndPos, ReadStart: Integer;
  Reader: IOTAEditReader;
  Writer: IOTAEditWriter;
  Row, Col, Len, ASize: Integer;
  NewRow, NewCol: Integer;
  Stream: TMemoryStream;
begin
  View := CnOtaGetTopMostEditView;
  if View <> nil then
  begin
    Block := View.Block;
    StartPos := 0;
    EndPos := 0;
    BlockStartLine := 0;
    BlockEndLine := 0;
    NewRow := 0;
    NewCol := 0;
    if GetStyle = csLine then
    begin
{$IFDEF DEBUG}
      if Block = nil then
        CnDebugger.LogMsg('TCnSelectionCodeTool.Execute: Block is nil.')
      else if Block.IsValid then
        CnDebugger.LogMsg('TCnSelectionCodeTool.Execute: Block is Valid.');
{$ENDIF}
      if (Block <> nil) and Block.IsValid then
      begin             // ѡı
        BlockStartLine := Block.StartingRow;
        StartPos := CnOtaEditPosToLinePos(OTAEditPos(1, BlockStartLine), View);
        BlockEndLine := Block.EndingRow;
        // 겻ʱһ
        if Block.EndingColumn > 1 then
        begin
          if BlockEndLine < View.Buffer.GetLinesInBuffer then
          begin
            Inc(BlockEndLine);
            EndPos := CnOtaEditPosToLinePos(OTAEditPos(1, BlockEndLine), View);
          end
          else
            EndPos := CnOtaEditPosToLinePos(OTAEditPos(255, BlockEndLine), View);
        end
        else
          EndPos := CnOtaEditPosToLinePos(OTAEditPos(1, BlockEndLine), View);
      end
      else
      begin    // δѡʾתС
        if CnOtaGetCurSourcePos(Col, Row) then
        begin
          StartPos := CnOtaEditPosToLinePos(OTAEditPos(1, Row), View);
          if Row < View.Buffer.GetLinesInBuffer then
          begin
            EndPos := CnOtaEditPosToLinePos(OTAEditPos(1, Row + 1), View);
            NewRow := Row; 
            NewCol := Col;
            GetNewPos(NewRow, NewCol); // ȷһλñ仯
          end
          else
            EndPos := CnOtaEditPosToLinePos(OTAEditPos(255, Row), View);
        end
        else
        begin
          ErrorDlg(SCnEditorCodeToolNoLine);
          Exit;
        end;
      end;
    end
    else if GetStyle = csSelText then
    begin
      if (Block <> nil) and (Block.IsValid) then
      begin
        // ѡıڴа Tab ַʱвҪƹ
        StartPos := CnOtaEditPosToLinePos(OTAEditPos(Block.StartingColumn,
          Block.StartingRow), View);
        EndPos := CnOtaEditPosToLinePos(OTAEditPos(Block.EndingColumn,
          Block.EndingRow), View);
      end;
    end
    else
    begin
      StartPos := 0;
      Stream := TMemoryStream.Create;
      CnOtaSaveCurrentEditorToStream(Stream, False);
      EndPos := Stream.Size - 1; // ñ취õ༭ĳȣ
      // һΪȥ SaveToStream ʱβӵ #0 һ
      Stream.Free;
    end;

    HasTab := False;
    if (GetStyle = csSelText) and (Block <> nil) and (Block.IsValid) then
    begin
      BlockText := Block.Text;
      if Length(BlockText) > 0 then
      begin
        for I := 0 to Length(BlockText) - 1 do
        begin
          if BlockText[I] = #09 then
          begin
            HasTab := True;
            Break;
          end;
        end;
      end;
    end;

    if HasTab then
    begin
{$IFDEF DEBUG}
      CnDebugger.LogMsg('TCnSelectionCodeTool.Execute has Tab Chars for Selection. Using Block Text.');
{$ENDIF}
      // ֱӵõ Ansi/Utf8/UnicodeString
      OrigText := AnsiString(BlockText);
    end
    else
    begin
      // Reader  Ansi/Utf8/Utf8
      Len := EndPos - StartPos;
{$IFDEF DEBUG}
      CnDebugger.LogFmt('TCnSelectionCodeTool.Execute StartPos %d, EndPos %d.', [StartPos, EndPos]);
{$ENDIF}
      Assert(Len >= 0);
      SetLength(OrigText, Len);
      Buf := Pointer(OrigText);
      ReadStart := StartPos;
      Reader := View.Buffer.CreateReader;
      try
        while Len > SCnOtaBatchSize do // ζȡ
        begin
          ASize := Reader.GetText(ReadStart, Buf, SCnOtaBatchSize);
          Inc(Buf, ASize);
          Inc(ReadStart, ASize);
          Dec(Len, ASize);
        end;
        if Len > 0 then // ʣ
          Reader.GetText(ReadStart, Buf, Len);
      finally
        Reader := nil;
      end;
    end;

    if OrigText <> '' then
    begin
    {$IFDEF UNICODE}
      if HasTab then
        Text := ProcessText(string(OrigText))  //  UnicodeString ı
      else
        Text := ProcessText((ConvertEditorTextToTextW(OrigText))); //  Utf8 ת UnicodeString ı
    {$ELSE}
      Text := ProcessText(ConvertEditorTextToText(OrigText)); //  Ansi / Utf8תɵAnsi ı
    {$ENDIF}

      if not HasTab then
      begin
        Writer := View.Buffer.CreateUndoableWriter;
        try
          Writer.CopyTo(StartPos);
          //  Ansi/Ansi/UnicodeString ת Ansi/Utf8/Utf8  Writer д
          {$IFDEF UNICODE}
          Writer.Insert(PAnsiChar(ConvertTextToEditorTextW(Text)));
          {$ELSE}
          Writer.Insert(PAnsiChar(ConvertTextToEditorText(Text)));
          {$ENDIF}
          Writer.DeleteTo(EndPos);
        finally
          Writer := nil;
        end;
      end
      else
      begin
        //  Tab ʱλòƫ IDE ¶У滻ǰѡ
        CnOtaReplaceCurrentSelection(Text, True, False, False);
      end;
    end;

    if (NewRow > 0) and (NewCol > 0) then
    begin
      View.CursorPos := OTAEditPos(NewCol, NewRow);
    end
    else if (BlockStartLine > 0) and (BlockEndLine > 0) then
    begin
      CnOtaSelectBlock(View.Buffer, OTACharPos(0, BlockStartLine),
        OTACharPos(0, BlockEndLine));
    end;

    View.Paint;
  end
  else
    ErrorDlg(SCnEditorCodeToolSelIsEmpty);
end;

function TCnSelectionCodeTool.GetState: TWizardState;
begin
  Result := inherited GetState;
  if wsEnabled in Result then
  begin
    if ValidInSource and not CurrentIsSource or
      BlockMustNotEmpty and CnOtaCurrBlockEmpty then
      Result := [];
  end;
end;

procedure TCnSelectionCodeTool.GetNewPos(var ARow, ACol: Integer);
begin
// ɶıֵ
end;

{$ENDIF CNWIZARDS_CNCODINGTOOLSETWIZARD}
end.
