{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnEditorFontZoom;
{* |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* Ԫƣ༭ŵԪ
* Ԫߣܾ (zjy@cnpack.org)
*     ע
* ƽ̨PWin XP SP3 + Delphi 5.01
* ݲԣ
*   ôеַϱػʽ
* ޸ļ¼2010.06.10 V1.0
*               Ԫʵֹ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

{$IFDEF CNWIZARDS_CNCODINGTOOLSETWIZARD}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, IniFiles, ToolsAPI, CnWizClasses, CnWizUtils, CnConsts, CnCommon,
  Menus, CnCodingToolsetWizard, CnWizConsts, CnSelectionCodeTool;

type

//==============================================================================
// ༭
//==============================================================================

{ TCnEditorFontInc }

  TCnEditorFontInc = class(TCnSelectionCodeTool)
  public
    constructor Create(AOwner: TCnCodingToolsetWizard); override;
    function GetCaption: string; override;
    function GetHint: string; override;
    procedure GetToolsetInfo(var Name, Author, Email: string); override;
    procedure Execute; override;
  end;

//==============================================================================
// ༭С
//==============================================================================

{ TCnEditorFontDec }

  TCnEditorFontDec = class(TCnSelectionCodeTool)
  public
    constructor Create(AOwner: TCnCodingToolsetWizard); override;
    function GetCaption: string; override;
    function GetHint: string; override;
    procedure GetToolsetInfo(var Name, Author, Email: string); override;
    procedure Execute; override;
  end;

{$ENDIF CNWIZARDS_CNCODINGTOOLSETWIZARD}

implementation

{$IFDEF CNWIZARDS_CNCODINGTOOLSETWIZARD}

{ TCnEditorFontInc }

constructor TCnEditorFontInc.Create(AOwner: TCnCodingToolsetWizard);
begin
  inherited;
  ValidInSource := True;
  BlockMustNotEmpty := False;
end;

function TCnEditorFontInc.GetCaption: string;
begin
  Result := SCnEditorFontIncMenuCaption;
end;

function TCnEditorFontInc.GetHint: string;
begin
  Result := SCnEditorFontIncMenuHint;
end;

procedure TCnEditorFontInc.GetToolsetInfo(var Name, Author, Email: string);
begin
  Name := SCnEditorFontIncName;
  Author := SCnPack_Zjy;
  Email := SCnPack_ZjyEmail;
end;

procedure TCnEditorFontInc.Execute;
var
  Option: IOTAEditOptions;
begin
  Option := CnOtaGetEditOptions;
  if Assigned(Option) then
    Option.FontSize := Round(Option.FontSize * 1.1);
end;

{ TCnEditorFontDec }

constructor TCnEditorFontDec.Create(AOwner: TCnCodingToolsetWizard);
begin
  inherited;
  ValidInSource := True;
  BlockMustNotEmpty := False;
end;

function TCnEditorFontDec.GetCaption: string;
begin
  Result := SCnEditorFontDecMenuCaption;
end;

function TCnEditorFontDec.GetHint: string;
begin
  Result := SCnEditorFontDecMenuHint;
end;

procedure TCnEditorFontDec.GetToolsetInfo(var Name, Author, Email: string);
begin
  Name := SCnEditorFontDecName;
  Author := SCnPack_Zjy;
  Email := SCnPack_ZjyEmail;
end;

procedure TCnEditorFontDec.Execute;
var
  Option: IOTAEditOptions;
begin
  Option := CnOtaGetEditOptions;
  if Assigned(Option) then
    Option.FontSize := Round(Option.FontSize / 1.1);
end;

initialization
  RegisterCnCodingToolset(TCnEditorFontInc);
  RegisterCnCodingToolset(TCnEditorFontDec);

{$ENDIF CNWIZARDS_CNCODINGTOOLSETWIZARD}
end.
