{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnEditorCodeIndent;
{* |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣߵԪ
* ԪߣCnPack  master@cnpack.org
*     ע
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   ôеַϱػʽ
* ޸ļ¼2005.01.22 V1.0
*               Ԫʵֹ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

{$IFDEF CNWIZARDS_CNCODINGTOOLSETWIZARD}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, IniFiles, ToolsAPI, CnWizClasses, CnWizUtils, CnConsts, CnCommon,
  Menus, CnCodingToolsetWizard, CnWizConsts, CnSelectionCodeTool;

type

//==============================================================================
// 
//==============================================================================

{ TCnEditorCodeIndent }

  TCnEditorCodeIndent = class(TCnSelectionCodeTool)
  public
    constructor Create(AOwner: TCnCodingToolsetWizard); override;
    function GetCaption: string; override;
    function GetHint: string; override;
    procedure GetToolsetInfo(var Name, Author, Email: string); override;
    procedure Execute; override;
  end;

//==============================================================================
// 鷴
//==============================================================================

{ TCnEditorCodeUnIndent }

  TCnEditorCodeUnIndent = class(TCnSelectionCodeTool)
  public
    constructor Create(AOwner: TCnCodingToolsetWizard); override;
    function GetCaption: string; override;
    function GetHint: string; override;
    procedure GetToolsetInfo(var Name, Author, Email: string); override;
    procedure Execute; override;
  end;

{$ENDIF CNWIZARDS_CNCODINGTOOLSETWIZARD}

implementation

{$IFDEF CNWIZARDS_CNCODINGTOOLSETWIZARD}

{ TCnEditorCodeIndent }

constructor TCnEditorCodeIndent.Create(AOwner: TCnCodingToolsetWizard);
begin
  inherited;
  ValidInSource := True;
  BlockMustNotEmpty := True;
end;

function TCnEditorCodeIndent.GetCaption: string;
begin
  Result := SCnEditorCodeIndentMenuCaption;
end;

function TCnEditorCodeIndent.GetHint: string;
begin
  Result := SCnEditorCodeIndentMenuHint;
end;

procedure TCnEditorCodeIndent.GetToolsetInfo(var Name, Author, Email: string);
begin
  Name := SCnEditorCodeIndentName;
  Author := SCnPack_LiuXiao;
  Email := SCnPack_LiuXiaoEmail;
end;

procedure TCnEditorCodeIndent.Execute;
var
  EditView: IOTAEditView;
begin
  EditView := CnOtaGetTopMostEditView;
  if Assigned(EditView) and (EditView.Block <> nil) then
  begin
    EditView.Block.Indent(CnOtaGetBlockIndent);
    EditView.Paint;
  end;
end;

{ TCnEditorCodeUnIndent }

constructor TCnEditorCodeUnIndent.Create(AOwner: TCnCodingToolsetWizard);
begin
  inherited;
  ValidInSource := True;
  BlockMustNotEmpty := True;
end;

function TCnEditorCodeUnIndent.GetCaption: string;
begin
  Result := SCnEditorCodeUnIndentMenuCaption;
end;

function TCnEditorCodeUnIndent.GetHint: string;
begin
  Result := SCnEditorCodeUnIndentMenuHint;
end;

procedure TCnEditorCodeUnIndent.GetToolsetInfo(var Name, Author, Email: string);
begin
  Name := SCnEditorCodeUnIndentName;
  Author := SCnPack_LiuXiao;
  Email := SCnPack_LiuXiaoEmail;
end;

procedure TCnEditorCodeUnIndent.Execute;
var
  EditView: IOTAEditView;
begin
  EditView := CnOtaGetTopMostEditView;
  if Assigned(EditView) and (EditView.Block <> nil) then
  begin
    EditView.Block.Indent(-CnOtaGetBlockIndent);
    EditView.Paint;
  end;
end;

initialization
  RegisterCnCodingToolset(TCnEditorCodeIndent);
  RegisterCnCodingToolset(TCnEditorCodeUnIndent);

{$ENDIF CNWIZARDS_CNCODINGTOOLSETWIZARD}
end.
